/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.extension;

import com.ibm.pdp.pacbase.util.EBCDICCompare;
import java.util.Comparator;

public class Ebcdic
implements Comparator<String> {
    private static final String PAC_END_LABEL = "-FN";
    private static final int PAC_END_LABEL_LENGTH = "-FN".length();
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static int stringCompare(String left, String right) {
        char[] rightChars;
        int rightLength;
        char[] leftChars;
        int leftLength = left.length();
        if (Ebcdic.endsWithPacEndLabel(leftLength, leftChars = left.toCharArray())) {
            leftLength -= PAC_END_LABEL_LENGTH;
        }
        if (Ebcdic.endsWithPacEndLabel(rightLength = right.length(), rightChars = right.toCharArray())) {
            rightLength -= PAC_END_LABEL_LENGTH;
        }
        return Ebcdic.ebcdicCompare(leftChars, leftLength, rightChars, rightLength);
    }

    private static boolean endsWithPacEndLabel(int length, char[] chars) {
        if (length < 3) {
            return false;
        }
        char c = chars[length - 3];
        if (c != '-') {
            return false;
        }
        c = chars[length - 2];
        if (c != 'F' && c != 'f') {
            return false;
        }
        c = chars[length - 1];
        return c == 'N' || c == 'n';
    }

    private static int ebcdicCompare(char[] leftChars, int leftLength, char[] rightChars, int rightLength) {
        int minLength = Math.min(leftLength, rightLength);
        int i = 0;
        while (i < minLength) {
            char leftChar = leftChars[i];
            char rightChar = rightChars[i];
            if (leftChar != rightChar && (leftChar = EBCDICCompare.EbcdicTable[leftChar]) != (rightChar = EBCDICCompare.EbcdicTable[rightChar])) {
                return leftChar - rightChar;
            }
            ++i;
        }
        return leftLength - rightLength;
    }

    public static void main(String[] args) {
        int a = Ebcdic.stringCompare("F05OR", "F05-FN");
        System.out.println(a);
        a = Ebcdic.stringCompare("F05OR-FN", "F05OR-BODY");
        System.out.println(a);
        int i = 0;
        while (i < 255) {
            char c = (char)i;
            a = Ebcdic.stringCompare("" + c, "-");
            if (a < 0) {
                System.out.println("- superieur \u00e0 " + c + "(" + i + ")");
            } else if (a > 0) {
                System.err.println("- inf\u00e9rieur \u00e0 " + c + "(" + i + ")");
            } else {
                System.out.println("- \u00e9gal \u00e0 " + c + "(" + i + ")");
            }
            ++i;
        }
    }

    @Override
    public int compare(String s1, String s2) {
        return Ebcdic.stringCompare(s1, s2);
    }
}

