/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.action;

import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.macro.pacbase.nls.PdpMacroPacbaseLabels;
import com.ibm.pdp.macro.pacbase.view.PTCrossReferenceView;
import com.ibm.pdp.macro.pacbase.view.ReferencedEntity;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import com.ibm.pdp.mdl.pacbase.PacbaseFactory;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.util.Util;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;

public class PTModifyParameterAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTCrossReferenceView _crossReferenceView;

    public PTModifyParameterAction() {
        this.setText(PdpMacroPacbaseLabels.MODIFYPARAMETER_ACTION);
        this.setToolTipText(this.getText());
        this.setImageDescriptor(PTExplorerPlugin.getDefault().getImageDescriptor("save"));
    }

    public PTModifyParameterAction(PTCrossReferenceView ptCrossReferenceView) {
        this._crossReferenceView = ptCrossReferenceView;
        this.setText(PdpMacroPacbaseLabels.MODIFYPARAMETER_ACTION);
        this.setToolTipText(this.getText());
        this.setImageDescriptor(PTExplorerPlugin.getDefault().getImageDescriptor("save"));
    }

    public void run() {
        if (!PTCrossReferenceView.IsModificationAuthorized(this._crossReferenceView.getEntitiesList())) {
            PdpTool.error((Shell)this._crossReferenceView.getViewSite().getShell(), (String)PdpMacroPacbaseLabels.WARNING_ON_SAVE, (String)PdpMacroPacbaseLabels.CLOSE_EDITORS_BEFORE_SAVE);
            return;
        }
        this._crossReferenceView.applyCurrentChange();
        HashSet<RadicalEntity> listEntitiesToModifed = new HashSet<RadicalEntity>();
        List<ReferencedEntity> allCalledEntities = this._crossReferenceView.getParamsTable();
        int i = 0;
        while (i < allCalledEntities.size()) {
            ReferencedEntity calledEntity = allCalledEntities.get(i);
            if (calledEntity.isModified()) {
                PacCPLine cpLine = calledEntity.getCPLine(this._crossReferenceView.getMacroName());
                int nbMaxParameter = 10;
                if (cpLine.getParameters().size() < 11) {
                    if (calledEntity.getNbNewParameter() > 10) {
                        String params = "ABCDEFGHIJ";
                        int y = 0;
                        while (y < params.length()) {
                            PacMacroParameter parameter = PacbaseFactory.eINSTANCE.createPacMacroParameter();
                            parameter.setId("$" + params.charAt(y));
                            cpLine.getParameters().add((Object)parameter);
                            parameter.setCallingElement(false);
                            parameter.setDataElement(null);
                            parameter.setDataAggregate(null);
                            parameter.setDataUnit(null);
                            ++y;
                        }
                        nbMaxParameter = 20;
                    }
                } else {
                    nbMaxParameter = 20;
                }
                Iterator parameterForLine = cpLine.getParameters().iterator();
                int j = 0;
                while (j < nbMaxParameter) {
                    if (parameterForLine.hasNext()) {
                        String car0_1;
                        PacMacroParameter paramToModified = (PacMacroParameter)parameterForLine.next();
                        String param = calledEntity.getParameter(j).getValue();
                        if (param.trim().length() > 2 && ((car0_1 = param.substring(0, 2)).equals("E=") || car0_1.equals("e=") || car0_1.equals("D=") || car0_1.equals("d=") || car0_1.equals("S=") || car0_1.equals("s="))) {
                            param = param.trim().toUpperCase();
                        }
                        paramToModified.setValue(param);
                        cpLine.getParameters().set(j, (Object)paramToModified);
                        paramToModified.setCallingElement(false);
                        paramToModified.setDataElement(null);
                        paramToModified.setDataAggregate(null);
                        paramToModified.setDataUnit(null);
                        if (paramToModified.getValue().trim().length() > 2) {
                            RadicalEntity objRA;
                            String caract0_1 = paramToModified.getValue().substring(0, 2);
                            if (caract0_1.equals("E=") || caract0_1.equals("e=")) {
                                String nameOfDataElt = paramToModified.getValue().trim().substring(2).toUpperCase();
                                objRA = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)cpLine.getOwner(), (String)nameOfDataElt, (String)"dataelement");
                                if (objRA instanceof DataElement) {
                                    DataElement de = (DataElement)objRA;
                                    paramToModified.setDataElement(de);
                                    paramToModified.setCallingElement(true);
                                }
                            } else if (caract0_1.equals("D=") || caract0_1.equals("d=")) {
                                String nameOfDataUnit = paramToModified.getValue().trim().substring(2).toUpperCase();
                                objRA = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)cpLine.getOwner(), (String)nameOfDataUnit, (String)"dataunit");
                                if (objRA instanceof DataUnit) {
                                    DataUnit du = (DataUnit)objRA;
                                    paramToModified.setDataUnit(du);
                                    paramToModified.setCallingElement(true);
                                }
                            } else if (caract0_1.equals("S=") || caract0_1.equals("s=")) {
                                String nameOfDataAggregate = paramToModified.getValue().trim().substring(2).toUpperCase();
                                objRA = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)cpLine.getOwner(), (String)nameOfDataAggregate, (String)"dataaggregate");
                                if (objRA instanceof DataAggregate) {
                                    DataAggregate da = (DataAggregate)objRA;
                                    paramToModified.setDataAggregate(da);
                                    paramToModified.setCallingElement(true);
                                }
                            }
                        }
                    }
                    ++j;
                }
                listEntitiesToModifed.add(cpLine.getOwner());
                calledEntity.setModified(false);
            }
            ++i;
        }
        Iterator ra = listEntitiesToModifed.iterator();
        while (ra.hasNext()) {
            try {
                ((RadicalEntity)ra.next()).save();
            }
            catch (IOException e) {
                Util.rethrow((Throwable)e);
            }
        }
        this._crossReferenceView.setModification(false);
        this._crossReferenceView.rebuildViewContent();
    }
}

