/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.action;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTResourceManager;
import com.ibm.pdp.explorer.model.query.PTSearchRefQuery;
import com.ibm.pdp.explorer.model.reference.PTReferenceItem;
import com.ibm.pdp.explorer.model.result.PTSearchRefResult;
import com.ibm.pdp.explorer.model.service.IPTLocation;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.macro.pacbase.view.PTCrossReferenceView;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.editor.page.extension.IPTFlatPageActionContribution;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.explorer.model.PacCrossRefManager;
import com.ibm.pdp.util.Util;
import java.util.List;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;

public class MacroCrossReferenceAction
implements IPTFlatPageActionContribution {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(MacroCrossReferenceAction.class.getName()) + "_ID";
    private Document _metaDocument;
    private String _name;

    public void run() {
        List superReferences = PTModelService.getReferences((String)this._metaDocument.getId(), (int)1);
        PTResourceManager.getPath((Document)this._metaDocument);
        try {
            PTExplorerPlugin.getActivePage().showView(PTCrossReferenceView._VIEW_ID);
        }
        catch (PartInitException e) {
            throw Util.rethrow((Throwable)e);
        }
        PTCrossReferenceView crossReferenceView = (PTCrossReferenceView)PTExplorerPlugin.getActivePage().findView(PTCrossReferenceView._VIEW_ID);
        PTSearchRefQuery searchQuery = new PTSearchRefQuery(crossReferenceView.getContext(), this._metaDocument);
        List results = PacCrossRefManager.getSearchCrossRefResults();
        int i = 0;
        while (i < results.size()) {
            PTReferenceItem result = ((PTSearchRefResult)results.get(i)).getReferenceItem();
            if (result.getPlatformURI().equals(PTElement.getPlatformURI((Document)this._metaDocument))) {
                PacCrossRefManager.getSearchCrossRefResults().remove(i);
                break;
            }
            ++i;
        }
        results.add(0, searchQuery.getSearchResult());
        crossReferenceView.saveCurrentChanges();
        crossReferenceView.setInput(this._metaDocument, superReferences, true);
        crossReferenceView.setModification(false);
    }

    public boolean isEnabled() {
        IPTLocation location;
        boolean enabled = false;
        PTNature nature = PTNature.getNature((String)this._metaDocument.getProject());
        if (nature != null && (location = PTModelService.getLocation((String)nature.getLocation())) != null && location.isOpened()) {
            enabled = true;
        }
        return enabled;
    }

    public boolean isValidFor(RadicalEntity currentEntity) {
        return true;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void initialize(IEditorInput editorInput, String name) {
    }

    public void initialize(RadicalEntity re) {
        IPTLocation location = PTModelService.getLocation((String)re.getLocation());
        if (location != null) {
            PTElement el = (PTElement)location.getElement(re.getDesignId(re.getProject()));
            this._metaDocument = el.getDocument();
        }
    }
}

