/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.pacbase.PdpMacroPacbasePlugin;
import com.ibm.pdp.macro.pacbase.merge.Merge;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTag;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTree;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class InitCblgenFromCbltxt {
    private static String model = null;
    private static boolean lightVersion;
    private static StringBuilder alTexts;
    private static PacbaseNodeTag memoBodyTag;
    private static char[] Idents;
    private static String[] COBOL_STATEMENTS;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        alTexts = new StringBuilder(80);
        memoBodyTag = null;
        Idents = new char[]{'B', 'W', 'F', 'I', 'J'};
        COBOL_STATEMENTS = new String[]{"ORDER", "MOVE", "GO ", "IF ", "ELSE", "PERFORM", "EXEC", "ADD", "COMPUTE", "DIVIDE", "MULTIPLY", "SUBTRACT", "COPY", "CALL", "CLOSE", "DELETE", "DISPLAY", "INITIALIZE", "INSPECT", "GOBACK", "OPEN", "READ", "WRITE", "STRING", "UNSTRING", "ACCEPT", "CANCEL", "COMMIT", "CONTINUE", "DROP", "ENTER", "EVALUATE", "MERGE", "RELEASE", "RETURN", "REWRITE", "ROLLBACK", "SEARCH", "SET", "SORT", "START", "STOP", "EXIT", "ACQUIRE", "ALTER", "XML GENERATE", "XML PARSE", "FROM", "INTO", "FOR BROWSE ACCESS", "FOR UPDATE", "FOR FETCH ONLY", "UNLOCK"};
    }

    public static final PacbaseNodeTree createStringIGIFromSource(String text, String mspName, String mod, String mergePriority) {
        PacbaseNodeTree pnt = InitCblgenFromCbltxt.initializePacbaseNodeTree(mspName, mergePriority, false);
        model = mod;
        lightVersion = true;
        return InitCblgenFromCbltxt.createPnt(mspName, pnt, text, false, false);
    }

    public static final PacbaseNodeTree createStringIGIFromSource(String text, String mspName, boolean isMerge, String mod, String mergePriority) {
        PacbaseNodeTree pnt = InitCblgenFromCbltxt.initializePacbaseNodeTree(mspName, mergePriority, isMerge);
        model = mod;
        lightVersion = false;
        return InitCblgenFromCbltxt.createPnt(mspName, pnt, text, isMerge, false);
    }

    private static final boolean isValidIdent(char c) {
        int i = 0;
        while (i < Idents.length) {
            if (c == Idents[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final PacbaseNodeTree createPnt(String mspName, PacbaseNodeTree pnt, String text, boolean isMerge, boolean isSkeleton) {
        if (text.trim().length() > 0) {
            String[] sText = PdpTool.splitTextIntoArrayLines((String)text);
            boolean endSautLigne = text.endsWith("\r\n");
            String currentNumberLine = null;
            String currentIdent = null;
            String memoNumberLine = null;
            String memoIdent = null;
            int memoIndexLV = -1;
            ArrayList<String> alPartText = new ArrayList<String>();
            boolean isFirst = true;
            int i = 0;
            while (i < sText.length) {
                String line;
                StringBuilder sbLine = new StringBuilder();
                sbLine.append(sText[i]);
                if (i < sText.length - 1 || endSautLigne) {
                    sbLine.append("\r\n");
                }
                if ((line = sbLine.toString()).length() > 0 && line.substring(0, 1).trim().length() > 0) {
                    try {
                        Integer.parseInt(line.substring(0, 1));
                        currentNumberLine = line.trim().length() > 6 ? line.substring(0, 6).trim() : line.trim();
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (line.charAt(0) == '$') {
                            currentNumberLine = line.substring(0, 6).trim();
                        }
                        if (line.trim().length() > 6 && !line.substring(6).trim().equals("*ACTION=R")) {
                            currentNumberLine = line.substring(0, 6).trim();
                        }
                        if (line.trim().length() > 6) {
                            currentIdent = line.substring(0, 6).trim();
                        }
                        if (InitCblgenFromCbltxt.isValidIdent(line.charAt(0))) {
                            currentIdent = line.trim();
                        }
                        currentNumberLine = line.substring(0, 6).trim();
                    }
                }
                if (memoIdent != null && !memoIdent.equals(currentIdent) || memoIdent != null && (memoIdent.charAt(0) == 'I' || memoIdent.charAt(0) == 'J') && memoNumberLine != null || (memoNumberLine != null || InitCblgenFromCbltxt.isProcedure(memoIdent) && alPartText.get(0).trim().length() > 6) && !memoNumberLine.equals(currentNumberLine) || !InitCblgenFromCbltxt.isProcedure(memoIdent) && line.length() > 0 && !InitCblgenFromCbltxt.isValidIdent(line.charAt(0)) && line.trim().length() <= 6) {
                    if (!(memoIdent.charAt(0) != 'I' && memoIdent.charAt(0) != 'J' || line.indexOf(String.valueOf(memoIdent) + "L") == -1 && line.indexOf(String.valueOf(memoIdent) + "R") == -1 && line.indexOf(String.valueOf(memoIdent) + "M") == -1)) {
                        currentIdent = memoIdent;
                        if (memoIdent.charAt(0) == 'J') {
                            memoNumberLine = currentIdent;
                        }
                    }
                    InitCblgenFromCbltxt.transformPartOfText(mspName, pnt, alPartText, memoIdent, memoNumberLine, isMerge, memoIndexLV, isSkeleton, isFirst);
                    isFirst = false;
                    memoIndexLV = -1;
                    if (!memoIdent.equals(currentIdent)) {
                        currentNumberLine = null;
                        isFirst = true;
                        InitCblgenFromCbltxt.specialLightVersion(pnt);
                    }
                    alPartText = new ArrayList();
                }
                alPartText.add(line);
                if (!InitCblgenFromCbltxt.isProcedure(memoIdent) && line.length() > 0 && !InitCblgenFromCbltxt.isValidIdent(line.charAt(0)) && line.trim().length() <= 6) {
                    StringBuilder sb = new StringBuilder(7);
                    sb.append(alPartText.get(0));
                    sb.append(" ");
                    alPartText.set(0, sb.toString());
                }
                memoIdent = currentIdent;
                memoNumberLine = currentNumberLine;
                if (memoIndexLV == -1) {
                    memoIndexLV = line.indexOf("LV=");
                }
                ++i;
            }
            if (memoIdent != null) {
                if ((memoIdent.charAt(0) == 'I' || memoIdent.charAt(0) == 'J') && memoIdent.substring(3).equals(currentIdent.substring(0, 2))) {
                    currentIdent = memoIdent;
                    if (memoIdent.charAt(0) == 'J') {
                        memoNumberLine = currentIdent;
                    }
                }
                InitCblgenFromCbltxt.transformPartOfText(mspName, pnt, alPartText, memoIdent, memoNumberLine, isMerge, memoIndexLV, isSkeleton, isFirst);
                memoIndexLV = -1;
            }
        }
        InitCblgenFromCbltxt.specialLightVersion(pnt);
        pnt.initializeArrays();
        pnt.cleanWithoutSNT();
        return pnt;
    }

    private static final PacbaseNodeTree specialLightVersion(PacbaseNodeTree pnt) {
        if (lightVersion && alTexts.toString().length() > 0) {
            ArrayList<NodeText> aln = new ArrayList<NodeText>();
            NodeText nText = InitCblgenFromCbltxt.createNodeText(alTexts.toString());
            nText.setParentNode((NodeTag)memoBodyTag);
            aln.add(nText);
            memoBodyTag.setChildren(aln);
            alTexts = new StringBuilder(80);
            memoBodyTag = null;
        }
        return pnt;
    }

    private static final String toUpperCase(String ident) {
        StringBuilder sb = new StringBuilder(ident.length());
        int i = 0;
        while (i < ident.length()) {
            if (Character.isLetter(ident.charAt(i)) && ident.charAt(i) != '\u00b5') {
                sb.append(ident.substring(i, i + 1).toUpperCase());
            } else {
                sb.append(ident.substring(i, i + 1));
            }
            ++i;
        }
        return sb.toString();
    }

    private static final void transformPartOfText(String mspName, PacbaseNodeTree pnt, ArrayList<String> alPartText, String ident, String numberLine, boolean isMerge, int indexLV, boolean isSkeleton, boolean isFirst) {
        int i;
        String tagName = null;
        String sort = null;
        StringBuilder sbText = new StringBuilder();
        String tagNameComment = null;
        String sortComment = null;
        StringBuilder sbTextComment = new StringBuilder();
        HashMap<String, String> hmReferences = null;
        String virtualText = null;
        String ref = null;
        String specialIJ = null;
        if (numberLine != null && numberLine.length() < 3) {
            i = numberLine.length();
            while (i < 3) {
                numberLine = String.valueOf(numberLine) + " ";
                ++i;
            }
        }
        if (ident.charAt(0) == 'I' || ident.charAt(0) == 'J') {
            ref = numberLine;
            if (alPartText.get(alPartText.size() - 1).indexOf(String.valueOf(ident) + "L") != -1) {
                specialIJ = "L";
            }
            if (alPartText.get(alPartText.size() - 1).indexOf(String.valueOf(ident) + "M") != -1) {
                specialIJ = "M";
            }
            if (alPartText.get(alPartText.size() - 1).indexOf(String.valueOf(ident) + "R") != -1) {
                specialIJ = "R";
            }
        }
        i = 0;
        while (i < alPartText.size()) {
            block31: {
                String line = alPartText.get(i);
                Boolean isComment = InitCblgenFromCbltxt.isComment(line, indexLV);
                if (line.length() > 0) {
                    if (!(line.substring(0, 1).trim().length() <= 0 && (line.length() <= 7 || !isComment.booleanValue()) || lightVersion && ident.charAt(0) == 'F' && isComment.booleanValue() && numberLine.trim().length() != 3)) {
                        if (isComment.booleanValue()) {
                            tagNameComment = InitCblgenFromCbltxt.computeTagName(ident, numberLine, true, indexLV, isSkeleton, specialIJ, false);
                        } else {
                            tagName = InitCblgenFromCbltxt.computeTagName(InitCblgenFromCbltxt.toUpperCase(ident), numberLine, false, indexLV, isSkeleton, specialIJ, false);
                        }
                        if (tagName != null) {
                            sort = InitCblgenFromCbltxt.computeSort(tagName, ref);
                        }
                        if (tagNameComment != null) {
                            sortComment = InitCblgenFromCbltxt.computeSort(tagNameComment, ref);
                        }
                    }
                    if (line.indexOf("LV=") != -1 || line.indexOf("*ACTION=R") != -1) {
                        hmReferences = InitCblgenFromCbltxt.computeReferences(line.substring(7).trim(), ident);
                        indexLV = -1;
                    }
                    if (Merge.trimRight(line).length() > 6 || !InitCblgenFromCbltxt.isProcedure(tagName) && !InitCblgenFromCbltxt.isValidIdent(line.charAt(0))) {
                        if (InitCblgenFromCbltxt.isComment(line, indexLV)) {
                            sbTextComment.append("      ");
                            sbTextComment.append(line.substring(6));
                        } else {
                            sbText.append(line);
                            if (!InitCblgenFromCbltxt.isProcedure(tagName) && !InitCblgenFromCbltxt.isValidIdent(line.charAt(0)) && Merge.trimRight(line).length() < 6) {
                                sbText = new StringBuilder();
                                sbText.append(line.substring(0, line.length() - 1));
                            }
                        }
                    } else if ("$".equals(line.substring(0, 1)) || " ".equals(line.substring(0, 1)) || line.equals("\r\n")) {
                        sbText.append(line);
                    } else {
                        try {
                            Integer.parseInt(line.substring(0, 1));
                            sbText.append(line);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (isMerge) break block31;
                            virtualText = line;
                        }
                    }
                }
            }
            ++i;
        }
        if (hmReferences != null && !ident.substring(1, 3).equals("80") && hmReferences.get("action") != null && ((String)hmReferences.get("action")).equals("*C") && hmReferences.get("level") != null && !((String)hmReferences.get("level")).equals("05") && hmReferences.get("ref") != null && hmReferences.get("ref").indexOf("USER ") == -1) {
            hmReferences.remove("action");
            hmReferences.remove("ref");
        }
        if (sbText.toString().trim().length() > 6 && (InitCblgenFromCbltxt.IsLinkageSectionStarting(sbText.toString().substring(7)) || sbText.toString().trim().substring(7).startsWith("PROCEDURE DIVISION"))) {
            String l;
            boolean isComment = false;
            int index = sbText.toString().toUpperCase().indexOf("LINKAGE SECTION");
            if (index != -1) {
                int idx = PdpTool.getLineStartOffset((CharSequence)sbText, (int)index);
                l = sbText.substring(idx, index);
                boolean bl = isComment = l.charAt(6) == '*';
            }
            if (!isComment && (index = sbText.toString().toUpperCase().indexOf("PROCEDURE DIVISION")) != -1) {
                int idx = PdpTool.getLineStartOffset((CharSequence)sbText, (int)index);
                l = sbText.substring(idx, index);
                boolean bl = isComment = l.charAt(6) == '*';
            }
            if (!isComment) {
                String specialSort = String.valueOf(sort.substring(0, 6)) + " ";
                String specialTagName = "LINKAGE";
                if (sbText.indexOf("PROCEDURE DIVISION") != -1) {
                    specialTagName = "PROCEDURE-DIVISION";
                }
                HashMap<String, String> specialHmReferences = InitCblgenFromCbltxt.computeHmReference(new HashMap<String, String>(), "REF=" + specialSort, ident);
                InitCblgenFromCbltxt.instanciateNodeTag(mspName, pnt, specialTagName, specialSort, null, specialHmReferences, null, null, null, null, null, isSkeleton, isMerge);
            }
        }
        if (tagName != null && sort != null || tagNameComment != null && sortComment != null) {
            String parentTagName1;
            if (ident.startsWith("B") && isFirst && !tagName.equals(parentTagName1 = InitCblgenFromCbltxt.computeTagName(ident.toUpperCase(), numberLine, false, indexLV, isSkeleton, specialIJ, isFirst))) {
                String sort1 = InitCblgenFromCbltxt.computeSort(parentTagName1, ref);
                InitCblgenFromCbltxt.instanciateNodeTag(mspName, pnt, parentTagName1, sort1, null, null, null, null, null, null, null, isSkeleton, isMerge);
            }
            InitCblgenFromCbltxt.instanciateNodeTag(mspName, pnt, tagName, sort, sbText, hmReferences, tagNameComment, sortComment, sbTextComment, virtualText, numberLine, isSkeleton, isMerge);
        }
    }

    public static final boolean IsLinkageSectionStarting(String cobolContent) {
        String next;
        StringTokenizer st;
        return cobolContent.trim().length() > 0 && (st = new StringTokenizer(cobolContent)).hasMoreTokens() && "LINKAGE".equalsIgnoreCase(st.nextToken()) && st.hasMoreTokens() && ("SECTION".equalsIgnoreCase(next = st.nextToken()) || "SECTION.".equalsIgnoreCase(next));
    }

    private static final void instanciateNodeTag(String mspName, PacbaseNodeTree pnt, String tagName, String sort, StringBuilder sbText, HashMap<String, String> hmReferences, String tagNameComment, String sortComment, StringBuilder sbTextComment, String virtualText, String numberLine, boolean isSkeleton, boolean isMerge) {
        if (InitCblgenFromCbltxt.isProcedure(tagName) && sort.endsWith("A")) {
            InitCblgenFromCbltxt.instanciateNodeTagForFunction(mspName, pnt, tagName, sort, sbText, hmReferences, tagNameComment, sortComment, sbTextComment, virtualText, numberLine, isSkeleton, false, isMerge);
        } else if (!lightVersion || !InitCblgenFromCbltxt.isProcedure(tagName)) {
            NodeTag nTagFS = null;
            if (sbText != null && sbText.indexOf("*ACTION=R") == -1 && tagName.length() > 6 && tagName.substring(0, 7).equals("FILESEC")) {
                nTagFS = InitCblgenFromCbltxt.createNodeTag(mspName, pnt, "FILESEC", "19999  0", false, hmReferences, false, isSkeleton, hmReferences != null && hmReferences.get("action") != null && hmReferences.get("action").equals("R"));
                nTagFS.setParentNode((NodeTag)pnt.getRootTag());
                pnt.updateNode((NodeTag)pnt.getRootTag(), nTagFS, false);
            }
            NodeTag nTag = InitCblgenFromCbltxt.createNodeTag(mspName, pnt, tagName, sort, false, hmReferences, false, isSkeleton, hmReferences != null && hmReferences.get("action") != null && hmReferences.get("action").equals("R"));
            if (sbText != null && sbText.indexOf("FILE SECTION.") != -1) {
                nTag.setParentNode(nTagFS);
            } else {
                nTag.setParentNode((NodeTag)pnt.getRootTag());
            }
            ArrayList<NodeText> aln = new ArrayList<NodeText>();
            if (virtualText != null) {
                NodeText virtualNodeText = InitCblgenFromCbltxt.createNodeText(virtualText);
                virtualNodeText.setParentNode(nTag);
                aln.add(virtualNodeText);
            }
            if (sbText != null) {
                NodeText nText;
                if (sbText.length() > 0) {
                    nText = InitCblgenFromCbltxt.createNodeText(sbText.toString());
                    nText.setParentNode(nTag);
                    aln.add(nText);
                } else if (virtualText == null) {
                    nText = InitCblgenFromCbltxt.createNodeText(tagName.substring(5));
                    nText.setParentNode(nTag);
                    aln.add(nText);
                }
            }
            nTag.setChildren(aln);
            pnt.updateNode((NodeTag)pnt.getRootTag(), nTag, false);
        } else if (memoBodyTag == null) {
            hmReferences = new HashMap();
            String newTagName = null;
            if (sort.substring(4, 6).trim().length() > 0) {
                hmReferences.put("level", "10");
                newTagName = tagName.substring(0, 5);
            } else {
                hmReferences.put("level", "05");
                newTagName = tagName.substring(0, 3);
            }
            StringBuilder sb = new StringBuilder(7);
            sb.append(sort.substring(0, 6));
            sb.append("A");
            InitCblgenFromCbltxt.instanciateNodeTagForFunction(mspName, pnt, newTagName, sb.toString(), sbText, hmReferences, tagNameComment, sortComment, sbTextComment, virtualText, numberLine, isSkeleton, false, isMerge);
            Properties properties = memoBodyTag.getParentNode().getProperties();
            properties.setProperty("LightEditor", "LightEditor");
            memoBodyTag.getParentNode().setProperties(properties);
        } else if (sbText != null) {
            alTexts.append(sbText.toString());
        }
    }

    public static final boolean NextSentenceNecessary(String s, boolean isCol7) {
        if (isCol7) {
            return false;
        }
        int i = 0;
        while (i < COBOL_STATEMENTS.length) {
            if (s.trim().startsWith(COBOL_STATEMENTS[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final NodeTag createNodeTag(String mspName, PacbaseNodeTree pnt, String tagName, String sort, boolean fixedTag, HashMap<String, String> hmReferences, boolean isTechnicTag, boolean isSkeleton, boolean actionR) {
        NodeTag nTag = pnt.instanciateNodeTag();
        String newTagName = tagName;
        int index = newTagName.trim().indexOf(" ");
        if (index != -1) {
            StringBuilder sb = new StringBuilder(newTagName.length() - 1);
            sb.append(newTagName.substring(0, index));
            sb.append(newTagName.substring(index + 1));
            newTagName = sb.toString();
        }
        nTag.setName(newTagName);
        Properties properties = new Properties();
        properties.setProperty("sort", sort);
        if (isTechnicTag) {
            properties.setProperty("technicTag", "true");
        }
        if (!isSkeleton) {
            properties.setProperty("msp", mspName);
        }
        if (hmReferences != null) {
            String level = hmReferences.get("level");
            String action = hmReferences.get("action");
            String ref = hmReferences.get("ref");
            String categ = hmReferences.get("categ");
            if (InitCblgenFromCbltxt.isProcedure(tagName)) {
                if (level != null) {
                    properties.setProperty("level", level);
                } else if (tagName.trim().length() == 3) {
                    properties.setProperty("level", "05");
                } else {
                    properties.setProperty("level", "10");
                }
            }
            if (action != null) {
                String[] refDetail;
                properties.setProperty("action", action);
                if (action.equals("*R") && ref == null) {
                    if (sort.equals("980095A")) {
                        properties.setProperty("ref", "HELP");
                    }
                    if (sort.equals("980098A")) {
                        properties.setProperty("ref", "LE00");
                    }
                    if (sort.equals("980099A")) {
                        properties.setProperty("ref", "OKKO");
                    }
                }
                if (action.equals("*C") && ref != null && ref.trim().indexOf(" ") != -1 && (refDetail = ref.trim().split(" "))[1].length() > 1 && refDetail[1].charAt(0) != '$' && !refDetail[0].equals("USER")) {
                    StringBuilder sb = new StringBuilder(6);
                    sb.append(refDetail[0]);
                    sb.append(" ");
                    sb.append(refDetail[1].substring(0, 1));
                    ref = sb.toString();
                }
            }
            if (ref != null) {
                properties.setProperty("ref", ref);
            }
            if (categ != null) {
                properties.setProperty("categ", categ);
            }
            if (hmReferences.get("functionNotEmpty") != null) {
                properties.setProperty("functionNotEmpty", "true");
            }
        }
        if (actionR) {
            properties.setProperty("action", "R");
        }
        nTag.setFixedTag(fixedTag);
        nTag.setProperties(properties);
        return nTag;
    }

    private static final NodeText createNodeText(String text) {
        NodeText nText = new NodeText();
        if (text.endsWith("\r\n")) {
            nText.setInitContent(String.valueOf(text.replaceAll("\\s+$", "")) + "\r\n");
        } else {
            nText.setInitContent(text);
        }
        return nText;
    }

    private static final StringBuilder TransformCommentWhenLoop(HashMap<String, String> hmReferences, StringBuilder sbTextComment) {
        String type;
        int ind = sbTextComment.lastIndexOf("*.");
        if (ind != -1 && hmReferences != null && ("DO".equals(type = hmReferences.get("type")) || "DU".equals(type) || "DW".equals(type) || "IT".equals(type) || "EL".equals(type))) {
            StringBuilder newSbTextComment = new StringBuilder().append(sbTextComment.toString().substring(0, ind + 2));
            String end = sbTextComment.substring(ind + 4);
            newSbTextComment.append(type);
            newSbTextComment.append(end);
            sbTextComment = newSbTextComment;
        }
        return sbTextComment;
    }

    private static final void instanciateNodeTagForFunction(String mspName, PacbaseNodeTree pnt, String tagName, String sort, StringBuilder sbText, HashMap<String, String> hmReferences, String tagNameComment, String sortComment, StringBuilder sbTextComment, String virtualText, String numberLine, boolean isSkeleton, boolean actionR, boolean isMerge) {
        if (hmReferences != null && hmReferences.containsKey("level")) {
            if (isMerge && sort.substring(4, 6).trim().length() > 0) {
                sbTextComment = InitCblgenFromCbltxt.TransformCommentWhenLoop(hmReferences, sbTextComment);
            }
            StringBuilder sb = new StringBuilder();
            NodeTag nTag = InitCblgenFromCbltxt.createNodeTag(mspName, pnt, tagName, sort, false, hmReferences, false, isSkeleton, actionR);
            nTag.setParentNode((NodeTag)pnt.getRootTag());
            if (sbText.length() > 0 || sbTextComment.length() > 0 || hmReferences != null) {
                ArrayList<Object> aln = new ArrayList<Object>();
                if (isMerge) {
                    if (hmReferences == null || hmReferences.get("type") != null) {
                        int i;
                        String[] sText;
                        if (hmReferences != null && hmReferences.get("type") != null && hmReferences.get("type").equals("EL")) {
                            sb.append("       " + tagName + ".");
                            sText = PdpTool.splitTextIntoArrayLines((String)sbText.toString());
                            i = 1;
                            while (i < sText.length) {
                                sb.append("\r\n");
                                sb.append(sText[i]);
                                ++i;
                            }
                            sbText = sb;
                            pnt.getTreeTagsWithElse().add(nTag);
                        } else if (hmReferences != null && hmReferences.get("type") != null && hmReferences.get("type").equals("DO")) {
                            sb.append("       " + tagName + ".");
                            sText = PdpTool.splitTextIntoArrayLines((String)sbText.toString());
                            i = 1;
                            while (i < sText.length) {
                                sb.append("\r\n");
                                sb.append(sText[i]);
                                ++i;
                            }
                            sbText = sb;
                            pnt.getTreeTagsWithDo().add(nTag);
                        } else if (hmReferences != null && hmReferences.get("type") != null && hmReferences.get("type").equals("DW")) {
                            pnt.getTreeTagsWithIf().add(nTag);
                            sb.append("       " + tagName + ".");
                            sb.append("    IF    ");
                            sText = PdpTool.splitTextIntoArrayLines((String)sbText.toString());
                            i = 1;
                            while (i < sText.length) {
                                if (i == 1) {
                                    sb.append(sText[i].trim());
                                } else {
                                    sb.append("\r\n");
                                    sb.append(sText[i]);
                                }
                                ++i;
                            }
                            sbText = sb;
                            pnt.getTreeTagsWithDw().add(nTag);
                        } else if (hmReferences != null && hmReferences.get("type") != null && hmReferences.get("type").equals("DU")) {
                            sb.append("       " + tagName + ".                       GO TO     " + tagName + "-B.");
                            sText = PdpTool.splitTextIntoArrayLines((String)sbText.toString());
                            i = 1;
                            while (i < sText.length) {
                                sb.append("\r\n");
                                int index = sText[i].indexOf("IF ");
                                if (i == 1 && index == -1) {
                                    StringBuilder sb1 = new StringBuilder(sText[i].length());
                                    sb1.append("                 IF    ");
                                    sb1.append(sText[i].trim());
                                    sb.append(sb1.toString());
                                } else {
                                    sb.append(sText[i]);
                                }
                                ++i;
                            }
                            sbText = sb;
                            pnt.getTreeTagsWithDu().add(nTag);
                        } else {
                            sb.append("       " + tagName + ".");
                            sText = PdpTool.splitTextIntoArrayLines((String)sbText.toString());
                            i = 1;
                            while (i < sText.length) {
                                if (i == 1) {
                                    if (hmReferences != null && hmReferences.get("type") != null && hmReferences.get("type").equals("IT")) {
                                        pnt.getTreeTagsWithIf().add(nTag);
                                        sb.append("    IF    ");
                                    }
                                    sb.append(sText[i].trim());
                                } else {
                                    sb.append("\r\n");
                                    sb.append(sText[i]);
                                }
                                ++i;
                            }
                            sbText = sb;
                        }
                    } else {
                        if (sbText.indexOf("!DCD") != -1 || sbText.indexOf("!DCF") != -1 || sbText.indexOf("!DID") != -1 || sbText.indexOf("!DIF") != -1 || sbText.indexOf("!DVD") != -1 || sbText.indexOf("!DVF") != -1) {
                            pnt.getTreeTagsWithDCDIDV().add(nTag);
                        }
                        sb.append("       " + tagName + ".");
                        if (sbText.indexOf("\r\n") != -1) {
                            sb.append(sbText.substring(sbText.indexOf("\r\n")).toString());
                        }
                        sbText = sb;
                    }
                    if (hmReferences != null && hmReferences.get("action") != null && hmReferences.get("action").equals("*C") && hmReferences.get("ref") != null && hmReferences.get("ref").trim().indexOf("USER ") != -1) {
                        pnt.getUserServices().add(nTag);
                    }
                }
                if (virtualText != null) {
                    NodeText virtualNodeText = InitCblgenFromCbltxt.createNodeText(virtualText);
                    virtualNodeText.setParentNode(nTag);
                    aln.add(virtualNodeText);
                }
                if (tagNameComment != null && tagNameComment.length() > 0) {
                    NodeTag nTagComment = InitCblgenFromCbltxt.createNodeTag(mspName, pnt, tagNameComment, sortComment, true, null, false, isSkeleton, actionR);
                    nTagComment.setParentNode(nTag);
                    ArrayList<NodeText> alnComment = new ArrayList<NodeText>();
                    NodeText nText = InitCblgenFromCbltxt.createNodeText(String.valueOf(numberLine) + sbTextComment.substring(3).toString());
                    nText.setParentNode(nTagComment);
                    alnComment.add(nText);
                    nTagComment.setChildren(alnComment);
                    aln.add(nTagComment);
                }
                NodeTag nTagBody = InitCblgenFromCbltxt.createNodeTag(mspName, pnt, String.valueOf(tagName) + "-BODY", String.valueOf(sort.substring(0, sort.length() - 1)) + "B", true, null, true, isSkeleton, actionR);
                nTagBody.setParentNode(nTag);
                aln.add(nTagBody);
                StringBuilder sortFN = new StringBuilder();
                sortFN.append("9");
                sortFN.append(tagName.substring(1, 3));
                sortFN.append("9");
                if (tagName.length() == 3) {
                    sortFN.append("999");
                } else {
                    sortFN.append(tagName.substring(3, 5));
                }
                NodeTag nTagFn = InitCblgenFromCbltxt.createNodeTag(mspName, pnt, String.valueOf(tagName) + "-FN", sortFN.toString(), true, null, virtualText != null, isSkeleton, actionR);
                nTagFn.setParentNode(nTag);
                if (virtualText == null) {
                    ArrayList<NodeText> alnFn = new ArrayList<NodeText>();
                    NodeText nText = InitCblgenFromCbltxt.createNodeText("       " + tagName + "-FN. EXIT.");
                    nText.setParentNode(nTagFn);
                    alnFn.add(nText);
                    nTagFn.setChildren(alnFn);
                }
                aln.add(nTagFn);
                nTag.setChildren(aln);
                if (lightVersion) {
                    memoBodyTag = (PacbaseNodeTag)nTagBody;
                }
            }
            pnt.updateNode((NodeTag)pnt.getRootTag(), nTag, false);
            if (!(sbText.length() <= 0 && sbTextComment.length() <= 0 && hmReferences == null || tagName.equals("F8099") && "client".equals(model))) {
                InitCblgenFromCbltxt.instanciateNodeTagForFistLineOfFunction(mspName, pnt, tagName, sort, sbText, numberLine, isSkeleton, actionR);
            }
        }
    }

    private static final void instanciateNodeTagForFistLineOfFunction(String mspName, PacbaseNodeTree pnt, String tagName, String sort, StringBuilder sbText, String numberLine, boolean isSkeleton, boolean actionR) {
        if (!lightVersion) {
            NodeTag nTag = InitCblgenFromCbltxt.createNodeTag(mspName, pnt, String.valueOf(tagName) + numberLine, String.valueOf(sort.substring(0, sort.length() - 1)) + numberLine, false, null, false, isSkeleton, actionR);
            nTag.setParentNode((NodeTag)pnt.getRootTag());
            ArrayList<NodeText> aln = new ArrayList<NodeText>();
            NodeText nText = InitCblgenFromCbltxt.createNodeText(sbText.toString());
            nText.setParentNode(nTag);
            aln.add(nText);
            nTag.setChildren(aln);
            pnt.updateNode((NodeTag)pnt.getRootTag(), nTag, false);
        } else {
            alTexts.append(sbText.toString());
        }
    }

    private static final boolean isProcedure(String ident) {
        return ident != null && ident.charAt(0) == 'F' && ident.indexOf("FDCLAUSE") == -1 && ident.indexOf("FILESEC") == -1;
    }

    private static final boolean isComment(String line, int indexLV) {
        return line.length() > 7 && line.substring(6, 7).equals("*") && !line.substring(7, 8).equals("!") && indexLV != -1 && line.indexOf("LV=") == -1;
    }

    private static final StringBuilder initIGI(String macroName, String mergePriority) {
        StringBuilder sb = new StringBuilder();
        sb.append("<GeneratedInfo ignoreCase=\"true\" freeFormatting=\"true\"><Text><tag name=\"Root\"");
        if (macroName != null) {
            sb.append(" cblgencode=\"");
            sb.append(macroName);
            sb.append("\"");
        }
        sb.append(" mergePriority=\"");
        sb.append(mergePriority);
        sb.append("\"");
        sb.append("></tag name=\"Root\"></Text></GeneratedInfo>");
        return sb;
    }

    private static final PacbaseNodeTree initializePacbaseNodeTree(String mspName, String mergePriority, boolean isMerge) {
        ByteArrayInputStream is = new ByteArrayInputStream(InitCblgenFromCbltxt.initIGI(mspName, mergePriority).toString().getBytes());
        IGeneratedInfo iGenInfo = PdpMacroPacbasePlugin.newEnginefactory().readGeneratedInfo((InputStream)is);
        return new PacbaseNodeTree(iGenInfo, isMerge);
    }

    private static final HashMap<String, String> computeReferences(String references, String ident) {
        ArrayList<String> as = new ArrayList<String>();
        boolean isType = false;
        int indSpace = references.indexOf(" ");
        if (indSpace != -1 && references.substring(0, indSpace).indexOf("=") == -1 || indSpace == -1 && references.indexOf("=") == -1) {
            isType = true;
        }
        StringBuilder sbRef = new StringBuilder();
        int i = 0;
        while (i < references.length()) {
            if (references.charAt(i) != ' ') {
                sbRef.append(references.charAt(i));
            } else {
                if (isType) {
                    as.add("type=" + sbRef.toString());
                    isType = false;
                } else {
                    as.add(sbRef.toString());
                }
                sbRef = new StringBuilder();
            }
            ++i;
        }
        if (isType) {
            as.add("type=" + sbRef.toString());
            isType = false;
        } else {
            as.add(sbRef.toString());
        }
        HashMap<String, String> hmReferences = new HashMap<String, String>();
        sbRef = new StringBuilder();
        int i2 = 0;
        while (i2 < as.size()) {
            if (((String)as.get(i2)).indexOf("=") != -1 && sbRef.length() > 0) {
                InitCblgenFromCbltxt.computeHmReference(hmReferences, sbRef.toString(), ident);
                sbRef = new StringBuilder();
                sbRef.append((String)as.get(i2));
            } else {
                if (sbRef.length() > 0) {
                    sbRef.append(" ");
                }
                sbRef.append((String)as.get(i2));
            }
            ++i2;
        }
        InitCblgenFromCbltxt.computeHmReference(hmReferences, sbRef.toString(), ident);
        return hmReferences;
    }

    private static final HashMap<String, String> computeHmReference(HashMap<String, String> hmReferences, String ref, String ident) {
        int indice = ref.indexOf("=");
        if (indice != -1) {
            if (ref.charAt(0) == 't') {
                hmReferences.put("type", ref.substring(indice + 1));
            }
            if (ref.charAt(0) == 'L') {
                hmReferences.put("level", ref.substring(indice + 1));
            }
            if (ref.charAt(0) == 'A') {
                hmReferences.put("action", ref.substring(indice + 1));
            }
            if (ref.charAt(0) == 'R') {
                hmReferences.put("ref", String.valueOf(ref.substring(indice + 1)) + " ");
                String function = ident.substring(1, 3);
                String action = hmReferences.get("action");
                if (action != null && action.charAt(0) == '*' && !action.equals("*C") && !function.equals("20")) {
                    if (ref.trim().indexOf(" ") == -1) {
                        hmReferences.put("categ", ref.substring(4));
                        if (function.equals("65")) {
                            hmReferences.put("categ", ref.substring(4, 5));
                        }
                    } else if (function.equals("30") || function.equals("65")) {
                        hmReferences.put("categ", ref.substring(4, 5));
                    } else {
                        hmReferences.put("categ", ref.substring(ref.trim().indexOf(" ") + 1));
                    }
                }
            }
            if (ref.charAt(0) == 'f') {
                hmReferences.put("functionNotEmpty", "true");
            }
        }
        return hmReferences;
    }

    private static final String computeSort(String tagName, String ref) {
        StringBuilder sb = new StringBuilder();
        if (tagName.startsWith("F")) {
            boolean specialParameters;
            if (tagName.startsWith("FILESEC")) {
                sb.append("19999");
                if (tagName.substring(7).length() > 0) {
                    sb.append(tagName.substring(7));
                } else {
                    sb.append("  0");
                }
                return sb.toString();
            }
            if (tagName.startsWith("FDCLAUSE-")) {
                sb.append("2");
                sb.append(tagName.substring(9, 11));
                if (tagName.length() > 11) {
                    sb.append(tagName.substring(11));
                } else {
                    sb.append("  0");
                }
                return sb.toString();
            }
            if (tagName.length() < 3 || tagName.length() == 4) {
                return null;
            }
            sb.append("9");
            sb.append(tagName.substring(1, 3));
            if (tagName.endsWith("-FN")) {
                sb.append("9");
                if (tagName.length() == 6) {
                    sb.append("999");
                } else {
                    sb.append(tagName.substring(3, 5));
                }
                return sb.toString();
            }
            if (tagName.contains("-900")) {
                sb.append("8");
                sb.append(tagName.substring(3, 5));
                return sb.toString();
            }
            sb.append("0");
            if (tagName.length() == 3) {
                sb.append("  A");
                return sb.toString();
            }
            if (tagName.endsWith("-BODY")) {
                if (tagName.length() == 8) {
                    sb.append("  ");
                } else {
                    sb.append(tagName.substring(3, 5));
                }
                sb.append("B");
                return sb.toString();
            }
            boolean bl = specialParameters = tagName.charAt(tagName.length() - 2) == '$' && tagName.charAt(tagName.length() - 4) == '$';
            if (!(tagName.length() != 6 && tagName.length() != 9 || specialParameters)) {
                sb.append("  ");
                sb.append(tagName.substring(3));
                return sb.toString();
            }
            if (tagName.length() == 5) {
                sb.append(tagName.substring(3));
                sb.append("A");
                return sb.toString();
            }
            sb.append(tagName.substring(3));
            return sb.toString();
        }
        if (tagName.equals("LINKAGE")) {
            sb.append(ref);
            int i = sb.length();
            while (i < 7) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("API-COBOL")) {
            sb.append("I  01");
            sb.append(tagName.substring(9));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("BATCH")) {
            sb.append("I  05");
            sb.append(tagName.substring(5));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("PROGRAM-ID")) {
            sb.append("I  10");
            sb.append(tagName.substring(10));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("AUTHOR")) {
            sb.append("I  20");
            sb.append(tagName.substring(6));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("DATE-COMPILED")) {
            sb.append("I  30");
            if (tagName.length() > 13) {
                sb.append(tagName.substring(13));
            }
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("ENVIRONMENTDIV")) {
            sb.append("I  40");
            if (tagName.length() > 14) {
                sb.append(tagName.substring(14));
            } else {
                sb.append("  0");
            }
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("CONFIGURATION")) {
            sb.append("100  ");
            sb.append(tagName.substring(13));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("SOURCE")) {
            sb.append("10000");
            sb.append(tagName.substring(6));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("OBJECT")) {
            sb.append("10010");
            sb.append(tagName.substring(6));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("SPECIAL-NAMES")) {
            sb.append("10020");
            sb.append(tagName.substring(13));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("IOSEC-FILECTRL")) {
            sb.append("101  ");
            sb.append(tagName.substring(14));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("SELECT-")) {
            sb.append("101");
            if (tagName.length() > 11) {
                sb.append(tagName.substring(7));
            } else {
                sb.append(tagName.substring(7, 8));
                if (tagName.charAt(7) != '$') {
                    sb.append(" ");
                }
                sb.append(tagName.substring(8));
            }
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("IO-CONTROL")) {
            sb.append("10100");
            sb.append(tagName.substring(10));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("RECEIVE-CTRL")) {
            sb.append("10190");
            sb.append(tagName.substring(12));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("DATADIV")) {
            sb.append("160  ");
            if (tagName.length() > 7) {
                sb.append(tagName.substring(7));
            } else {
                sb.append("  0");
            }
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("W-")) {
            String em = tagName.substring(2, 4);
            if (Merge.isBatchModel(model)) {
                if (!Character.isLetter(em.charAt(0)) || !Character.isLetter(em.charAt(1))) {
                    sb.append("7");
                } else {
                    sb.append("3");
                }
            } else if (Character.isDigit(em.charAt(0))) {
                sb.append("7");
            } else {
                sb.append("3");
            }
            sb.append(em);
            sb.append(tagName.substring(4));
            sb.append("D");
            return sb.toString();
        }
        if (tagName.startsWith("PROCEDURE-DIVISION")) {
            sb.append(ref);
            int i = sb.length();
            while (i < 7) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("J")) {
            if (Merge.isBatchModel(model)) {
                sb.append("4");
                sb.append(tagName.substring(1, 5));
                sb.append(" ");
                return sb.toString();
            }
            if ("server".equals(model) || "server_monit".equals(model) || "folder_monit".equals(model)) {
                sb.append("3AA200DE ");
                sb.append(tagName.substring(1, 5));
                return sb.toString();
            }
            sb.append("3AA200DE5");
            sb.append(tagName.substring(1, 5));
            return sb.toString();
        }
        if (tagName.startsWith("I") && tagName.substring(1, 3).trim().length() > 0) {
            String y = "";
            char lastIndex = tagName.charAt(tagName.length() - 1);
            if (lastIndex == 'L') {
                y = "1";
            } else if (lastIndex == 'R') {
                y = "2";
            } else if (lastIndex == 'M') {
                y = "3";
            }
            if (Merge.isBatchModel(model)) {
                sb.append("4");
                sb.append(tagName.substring(1, tagName.length() - 1));
                sb.append(y);
                return sb.toString();
            }
            if ("server".equals(model) || "server_monit".equals(model) || "folder_monit".equals(model)) {
                sb.append("3AA200DE");
                sb.append(String.valueOf(tagName.substring(1, 3)) + ref);
                sb.append(y);
                sb.append(tagName.substring(1, tagName.length() - 1));
                return sb.toString();
            }
            sb.append("3AA200DE ");
            sb.append(ref);
            sb.append(y);
            sb.append(tagName.substring(1, tagName.length() - 1));
            return sb.toString();
        }
        if (tagName.startsWith("N")) {
            sb.append("9");
            sb.append(tagName.substring(1, 3));
            sb.append("0");
            if (tagName.length() > 6) {
                sb.append(tagName.substring(3, 5));
            } else {
                sb.append("  ");
            }
            sb.append("A*");
            if (tagName.length() > 6) {
                sb.append(tagName.substring(5));
            } else {
                sb.append(tagName.substring(3));
            }
            return sb.toString();
        }
        if (ref != null && ref.equals("FILESEC")) {
            sb.append(tagName.substring(0, 5));
            sb.append("  0");
            return sb.toString();
        }
        if (tagName.startsWith("B")) {
            if (tagName.contains("_")) {
                sb.append("I  ").append(tagName.substring(3));
            } else if (tagName.startsWith("B9*")) {
                sb.append("2").append(tagName.substring(1));
            } else {
                sb.append("1").append(tagName.substring(1));
            }
            return sb.toString();
        }
        sb.append(tagName);
        int i = sb.length();
        while (i < 8) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    private static final String computeTagName(String ident, String numberLine, boolean isComment, int indexLV, boolean isSkeleton, String specialIJ, boolean isFirst) {
        if (numberLine == null) {
            numberLine = "";
        }
        if (ident.charAt(0) == 'B') {
            if (ident.equals("B__01")) {
                return isFirst ? "API-COBOL" : "API-COBOL" + numberLine;
            }
            if (ident.equals("B__05")) {
                return isFirst ? "BATCH" : "BATCH" + numberLine;
            }
            if (ident.equals("B__10")) {
                return isFirst ? "PROGRAM-ID" : "PROGRAM-ID" + numberLine;
            }
            if (ident.equals("B__20")) {
                return isFirst ? "AUTHOR-ID" : "AUTHOR-ID" + numberLine;
            }
            if (ident.equals("B__30")) {
                return isFirst ? "DATE-COMPILED" : "DATE-COMPILED" + numberLine;
            }
            if (ident.equals("B__40")) {
                return "ENVIRONMENTDIV";
            }
            if (ident.equals("B400")) {
                return "ENVIRONMENTDIV" + numberLine;
            }
            if (ident.equals("B00")) {
                return isFirst ? "CONFIGURATION" : "CONFIGURATION" + numberLine;
            }
            if (ident.equals("B0000")) {
                return isFirst ? "SOURCE" : "SOURCE" + numberLine;
            }
            if (ident.equals("B0010")) {
                return isFirst ? "OBJECT" : "OBJECT" + numberLine;
            }
            if (ident.equals("B0020")) {
                return isFirst ? "SPECIAL-NAMES" : "SPECIAL-NAMES" + numberLine;
            }
            if (ident.startsWith("B01")) {
                if (ident.trim().length() == 3) {
                    return "IOSEC-FILECTRL" + numberLine;
                }
                return "SELECT-" + ident.substring(3) + numberLine;
            }
            if (ident.equals("B0100")) {
                return isFirst ? "IO-CONTROL" : "IO-CONTROL" + numberLine;
            }
            if (ident.equals("B0190")) {
                return isFirst ? "IO-CONTROL" : "IO-CONTROL" + numberLine;
            }
            if (ident.equals("B60")) {
                return isFirst ? "DATADIV" : "DATADIV" + numberLine;
            }
            if (ident.equals("B9999")) {
                return "FILESEC" + numberLine;
            }
            if (ident.startsWith("B9*")) {
                String name = "FDCLAUSE-" + ident.substring(3);
                return isFirst ? name : String.valueOf(name) + numberLine;
            }
        }
        if (ident.charAt(0) == 'W') {
            return "W-" + ident.substring(1) + numberLine;
        }
        if (ident.charAt(0) == 'F') {
            if (isComment) {
                return "N" + ident.substring(1) + numberLine;
            }
            if (indexLV != -1 || isSkeleton) {
                return ident;
            }
            return String.valueOf(ident) + numberLine;
        }
        if ((ident.charAt(0) == 'I' || ident.charAt(0) == 'J') && numberLine.length() > 0 && specialIJ != null) {
            return String.valueOf(ident) + specialIJ;
        }
        return String.valueOf(ident) + numberLine;
    }
}

