/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase;

import com.ibm.pdp.util.Util;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class InitCblgen {
    private static final String[] paramTable = new String[]{"name", "level", "action", "ref", "ignoreCase", "freeFormatting"};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static final int findPositionInParamTable(String s1) {
        int i = 0;
        while (i < paramTable.length) {
            if (paramTable[i].equals(s1)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static final String paramNameFromIndex(int index) {
        return paramTable[index];
    }

    public static final InputStream createIGI(String fileName, boolean isBatchModel, String separator) {
        ByteArrayInputStream ba = new ByteArrayInputStream(InitCblgen.createStringIGI(fileName, isBatchModel, separator).getBytes());
        return ba;
    }

    public static final InputStream createIGI(InputStream is, boolean isBatchModel, String separator, String mspName) {
        ByteArrayInputStream ba = new ByteArrayInputStream(InitCblgen.createStringIGI(is, isBatchModel, separator, mspName).getBytes());
        return ba;
    }

    public static final String createStringIGI(String fileName, boolean isBatchModel, String separator) {
        String mspName = fileName.substring(fileName.lastIndexOf(separator) + 1, fileName.indexOf("cblmsp") - 1);
        try {
            FileInputStream is = new FileInputStream(fileName);
            return InitCblgen.createStringIGI(is, isBatchModel, separator, mspName);
        }
        catch (FileNotFoundException e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    private static final String createStringIGI(InputStream is, boolean isBatchModel, String separator, String mspName) {
        ArrayList<String> tagNames = new ArrayList<String>();
        boolean actionR = false;
        StringBuilder sb = new StringBuilder();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            boolean finished = false;
            while (xmlReader.hasNext() && !finished) {
                String localName;
                int eventType = xmlReader.next();
                if (eventType == 1) {
                    int iName;
                    String name;
                    if (actionR) {
                        sb.append("\r\n");
                        actionR = false;
                    }
                    sb.append("<");
                    localName = xmlReader.getLocalName();
                    sb.append(localName);
                    int nbOfAtt = xmlReader.getAttributeCount();
                    HashMap<Integer, String> attributes = new HashMap<Integer, String>();
                    boolean isTagName = false;
                    int i = 0;
                    while (i < nbOfAtt) {
                        attributes.put(InitCblgen.findPositionInParamTable(xmlReader.getAttributeLocalName(i)), xmlReader.getAttributeValue(i));
                        ++i;
                    }
                    char action = ' ';
                    int iAction = InitCblgen.findPositionInParamTable("action");
                    if (attributes.get(iAction) != null) {
                        action = ((String)attributes.get(iAction)).charAt(0);
                    }
                    String ref = null;
                    int iRef = InitCblgen.findPositionInParamTable("ref");
                    if (attributes.get(iRef) != null) {
                        ref = ((String)attributes.get(iRef)).trim();
                    }
                    if ((name = (String)attributes.get(iName = InitCblgen.findPositionInParamTable("name"))) != null && action == 'R') {
                        actionR = true;
                    }
                    for (Integer itName : attributes.keySet()) {
                        String attributeName = InitCblgen.paramNameFromIndex(itName);
                        sb.append(" ");
                        sb.append(attributeName);
                        sb.append("=\"");
                        String value = (String)attributes.get(itName);
                        if (attributeName.equals("name")) {
                            tagNames.add(value);
                            isTagName = true;
                        }
                        sb.append(value);
                        sb.append("\"");
                        if (isTagName) {
                            sb.append(" ");
                            sb.append("msp");
                            sb.append("=\"");
                            sb.append(mspName);
                            sb.append("\" ");
                            sb.append("sort");
                            sb.append("=\"");
                            sb.append(InitCblgen.computeSort(value, isBatchModel, action, ref));
                            sb.append("\"");
                            isTagName = false;
                        }
                        if (!attributeName.equals("ref")) continue;
                        String startName = name.substring(0, 3);
                        String categ = "";
                        if (startName.equals("F25") || startName.equals("F30") || startName.equals("F35") || startName.equals("F60") || startName.equals("F65")) {
                            int i2 = value.trim().lastIndexOf(" ") + 1;
                            categ = value.substring(i2, i2 + 1);
                        }
                        if (categ.length() <= 0) continue;
                        sb.append(" categ=\"");
                        sb.append(categ);
                        sb.append("\"");
                    }
                    sb.append(">");
                    if (localName.equals("GeneratedInfo")) {
                        sb.append("<Text><tag name=\"Root\"");
                        sb.append(" cblgencode=\"");
                        sb.append(mspName);
                        sb.append("\">");
                    }
                }
                if (eventType == 12) {
                    String st1 = xmlReader.getText().replaceAll("\n", "\r\n");
                    sb.append(st1);
                }
                if (eventType != 2) continue;
                sb.append("</");
                localName = xmlReader.getLocalName();
                if (localName.equals("GeneratedInfo")) {
                    sb.append("tag name=\"Root\"></Text></GeneratedInfo>");
                    sb.append("\r\n");
                    continue;
                }
                sb.append("tag name=\"");
                int i = tagNames.size() - 1;
                String endTagName = (String)tagNames.get(i);
                sb.append(endTagName);
                tagNames.remove(i);
                sb.append("\">");
            }
        }
        catch (XMLStreamException e) {
            throw Util.rethrow((Throwable)e);
        }
        return sb.toString();
    }

    public static final String computeSort(String tagName, boolean isBatchModel, char action, String ref) {
        StringBuilder sb = new StringBuilder();
        if (tagName.startsWith("F")) {
            if (tagName.startsWith("FILESEC")) {
                sb.append("19999");
                if (tagName.substring(7).length() > 0) {
                    sb.append(tagName.substring(7));
                } else {
                    sb.append("  0");
                }
                return sb.toString();
            }
            if (tagName.startsWith("FDCLAUSE-")) {
                sb.append("2");
                sb.append(tagName.substring(9, 11));
                if (tagName.length() > 11) {
                    sb.append(tagName.substring(11));
                } else {
                    sb.append("  0");
                }
                return sb.toString();
            }
            if (tagName.equals("F9099") && action == 'R') {
                return "99099999";
            }
            sb.append("9");
            sb.append(tagName.substring(1, 3));
            if (tagName.contains("-FN")) {
                sb.append("9");
                if (tagName.length() == 6) {
                    sb.append("999");
                } else {
                    sb.append(tagName.substring(3, 5));
                }
                return sb.toString();
            }
            if (tagName.contains("-900")) {
                sb.append("8");
                sb.append(tagName.substring(3, 5));
                return sb.toString();
            }
            sb.append("0");
            if (tagName.length() == 3) {
                sb.append("  A");
                return sb.toString();
            }
            if (tagName.endsWith("-BODY")) {
                if (tagName.length() == 8) {
                    sb.append("  ");
                } else {
                    sb.append(tagName.substring(3, 5));
                }
                sb.append("B");
                return sb.toString();
            }
            if (tagName.length() == 6 || tagName.length() == 10) {
                sb.append("  ");
                sb.append(tagName.substring(3));
                return sb.toString();
            }
            if (tagName.length() == 5) {
                sb.append(tagName.substring(3));
                sb.append("A");
                return sb.toString();
            }
            sb.append(tagName.substring(3));
            return sb.toString();
        }
        if (tagName.equals("LINKAGE")) {
            sb.append(ref);
            int i = sb.length();
            while (i < 7) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("API-COBOL")) {
            sb.append("I  01");
            sb.append(tagName.substring(9));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("BATCH")) {
            sb.append("I  05");
            sb.append(tagName.substring(5));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("PROGRAM-ID")) {
            sb.append("I  10");
            sb.append(tagName.substring(10));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("AUTHOR")) {
            sb.append("I  20");
            sb.append(tagName.substring(6));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("DATE-COMPILED")) {
            sb.append("I  30");
            if (tagName.length() > 13) {
                sb.append(tagName.substring(13));
            }
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("ENVIRONMENTDIV")) {
            sb.append("I  40");
            if (tagName.length() > 14) {
                sb.append(tagName.substring(14));
            } else {
                sb.append("  0");
            }
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("CONFIGURATION")) {
            sb.append("100  ");
            sb.append(tagName.substring(13));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("SOURCE")) {
            sb.append("10000");
            sb.append(tagName.substring(6));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("OBJECT")) {
            sb.append("10010");
            sb.append(tagName.substring(6));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("SPECIAL-NAMES")) {
            sb.append("10020");
            sb.append(tagName.substring(13));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("IOSEC-FILECTRL")) {
            sb.append("101  ");
            sb.append(tagName.substring(14));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("SELECT-")) {
            sb.append("101");
            sb.append(tagName.substring(7));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("IO-CONTROL")) {
            sb.append("10100");
            sb.append(tagName.substring(10));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("RECEIVE-CTRL")) {
            sb.append("10190");
            sb.append(tagName.substring(12));
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("DATADIV")) {
            sb.append("160  ");
            if (tagName.length() > 7) {
                sb.append(tagName.substring(7));
            } else {
                sb.append("  0");
            }
            int i = sb.length();
            while (i < 8) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("W-")) {
            String em = tagName.substring(2, 4);
            if (isBatchModel) {
                if (!Character.isLetter(em.charAt(0)) || !Character.isLetter(em.charAt(1))) {
                    sb.append("7");
                } else {
                    sb.append("3");
                }
            } else if (!Character.isLetter(em.charAt(0))) {
                sb.append("7");
            } else {
                sb.append("3");
            }
            sb.append(em);
            sb.append(tagName.substring(4));
            sb.append("D");
            return sb.toString();
        }
        if (tagName.startsWith("PROCEDURE-DIVISION")) {
            sb.append(ref);
            int i = sb.length();
            while (i < 7) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (tagName.startsWith("J")) {
            if (isBatchModel) {
                sb.append("4");
                sb.append(tagName.substring(1, 5));
                sb.append(" ");
                return sb.toString();
            }
            sb.append("3AA200DE5");
            sb.append(tagName.substring(1, 5));
            return sb.toString();
        }
        if (tagName.startsWith("I") && tagName.substring(1, 3).trim().length() > 0) {
            String y = "";
            char lastIndex = tagName.charAt(tagName.length() - 1);
            if (lastIndex == 'L') {
                y = "1";
            } else if (lastIndex == 'R') {
                y = "2";
            } else if (lastIndex == 'M') {
                y = "3";
            }
            if (isBatchModel) {
                sb.append("4");
                sb.append(tagName.substring(1, tagName.length() - 1));
                sb.append(y);
                return sb.toString();
            }
            sb.append("3AA200DE ");
            sb.append(ref);
            sb.append(y);
            sb.append(tagName.substring(1, 5));
            return sb.toString();
        }
        if (tagName.startsWith("N")) {
            sb.append("9");
            sb.append(tagName.substring(1, 3));
            sb.append("0");
            if (tagName.length() == 5 || tagName.length() == 8) {
                sb.append(tagName.substring(3, 5));
            } else {
                sb.append("  ");
            }
            sb.append("A*");
            if (tagName.length() == 8) {
                sb.append(tagName.substring(5));
            } else if (tagName.length() == 6) {
                sb.append(tagName.substring(3));
            }
            return sb.toString();
        }
        if (ref != null && ref.equals("FILESEC")) {
            sb.append(tagName.substring(0, 5));
            sb.append("  0");
            return sb.toString();
        }
        sb.append(tagName);
        int i = sb.length();
        while (i < 8) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }
}

