/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.snippets;

import com.ibm.etools.webtools.flatui.FlatEditor;
import com.ibm.pdp.mdl.pacbase.editor.MacroFlatEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.ui.DefaultSnippetInsertion;

public class SnippetInsertion
extends DefaultSnippetInsertion {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ISnippetItem item;
    boolean isNewLineNeeded = true;

    public void insert(IEditorPart editorPart) {
        if (editorPart instanceof FlatEditor) {
            editorPart = this.searchEditorPart(editorPart);
        }
        super.insert(editorPart);
    }

    public void dragSetData(DragSourceEvent event, ISnippetItem item) {
        super.dragSetData(event, item);
        if (event.data.equals(" ")) {
            event.data = null;
        }
        if (event.data != null) {
            IEditorReference[] refs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int i = 0;
            while (i < refs.length) {
                IEditorReference ref = refs[i];
                this.searchEditorPart(ref.getEditor(false));
                ++i;
            }
            event.data = this.formatLine(event.data.toString(), item);
        }
    }

    protected String formatLine(String data, ISnippetItem item) {
        if (this.isNewLineNeeded) {
            data = String.valueOf(System.getProperty("line.separator")) + data;
        }
        return data;
    }

    protected String getInsertString(Shell host) {
        String text = super.getInsertString(host);
        return text.trim().length() > 0 ? this.formatLine(text, this.item) : "";
    }

    public void setItem(ISnippetItem item) {
        super.setItem(item);
        this.item = item;
    }

    private IEditorPart searchEditorPart(IEditorPart editorPart) {
        IEditorPart[] parts;
        ISelectionProvider selectionP;
        this.isNewLineNeeded = true;
        if (editorPart.getClass().getName().equals(MacroFlatEditor._EDITOR_ID) && (selectionP = ((ITextEditor)(editorPart = (parts = ((FlatEditor)editorPart).findEditors(editorPart.getEditorInput()))[0])).getSelectionProvider()) != null && selectionP.getSelection() instanceof ITextSelection && ((ITextSelection)selectionP.getSelection()).getOffset() == 0) {
            this.isNewLineNeeded = false;
        }
        return editorPart;
    }
}

