/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.server.view;

import com.ibm.pdp.explorer.designpath.PTDesignPath;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.service.IPTReference;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.model.tool.PTProjectScope;
import com.ibm.pdp.explorer.plugin.IPTPreferences;
import com.ibm.pdp.explorer.view.IPTSerializableView;
import com.ibm.pdp.explorer.view.IPTStructuredViewer;
import com.ibm.pdp.explorer.view.IPTTypeFilteredView;
import com.ibm.pdp.explorer.view.PTView;
import com.ibm.pdp.explorer.view.action.PTExportQueryAction;
import com.ibm.pdp.explorer.view.actiongroup.PTDisplayActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTReferenceFilterActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTSearchRefActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTSortActionGroup;
import com.ibm.pdp.explorer.view.service.IPTView;
import com.ibm.pdp.explorer.view.tool.IPTVisionListener;
import com.ibm.pdp.explorer.view.tool.PTAttributeItem;
import com.ibm.pdp.explorer.view.tool.PTSerializerConfiguration;
import com.ibm.pdp.explorer.view.tool.PTViewerComparator;
import com.ibm.pdp.explorer.view.tool.PTVisionGroup;
import com.ibm.pdp.macro.pacbase.nls.PdpMacroPacbaseLabels;
import com.ibm.pdp.macro.pacbase.server.action.ServerCrossReferenceAction;
import com.ibm.pdp.macro.pacbase.server.action.ServerPacHistoryDropdownAction;
import com.ibm.pdp.macro.pacbase.server.action.ServerPacReplayAction;
import com.ibm.pdp.macro.pacbase.server.nls.ServerPdpMacroPacbaseLabels;
import com.ibm.pdp.macro.pacbase.server.outline.OutlineServerCrossRefTableContentProvider;
import com.ibm.pdp.macro.pacbase.server.outline.OutlineServerCrossRefTableLabelProvider;
import com.ibm.pdp.macro.pacbase.server.view.PTServerCrossReferenceTreeViewer;
import com.ibm.pdp.macro.pacbase.server.view.ServerReferencedEntity;
import com.ibm.pdp.macro.pacbase.view.PTCrossReferenceTreeViewer;
import com.ibm.pdp.macro.pacbase.view.PTCrossReferenceView;
import com.ibm.pdp.macro.pacbase.view.ReferencedEntity;
import com.ibm.pdp.macro.pacbase.view.tool.IMacroXRefFieldConstants;
import com.ibm.pdp.macro.pacbase.view.tool.MacroXRefSerializableItem;
import com.ibm.pdp.macro.pacbase.view.tool.MacroXRefSerializer;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.pac.explorer.model.PacCrossRefManager;
import com.ibm.pdp.server.model.PTServerArtifact;
import com.ibm.pdp.server.model.reference.PTServerReferenceItem;
import com.ibm.pdp.server.plugin.PTServerContributor;
import com.ibm.pdp.server.result.PTServerSearchRefResult;
import com.ibm.pdp.server.service.IPTServerReference;
import com.ibm.pdp.server.view.action.PTServerOpenAction;
import com.ibm.pdp.server.view.actiongroup.PTServerOpenActionGroup;
import com.ibm.pdp.util.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class PTServerCrossReferenceView
extends PTView
implements IPTSerializableView,
IPTTypeFilteredView,
IPTVisionListener,
IMacroXRefFieldConstants,
IPTPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTSortActionGroup _sortActionGroup;
    private PTDisplayActionGroup _displayActionGroup;
    private PTReferenceFilterActionGroup _filterActionGroup;
    private PTServerOpenActionGroup _openActionGroup;
    private PTSearchRefActionGroup _searchRefActionGroup;
    private ServerPacReplayAction _replayAction;
    private ServerPacHistoryDropdownAction _historyAction;
    private Set<String> _excludedTypes;
    private String _context = "";
    private int _vision = 3;
    private PTVisionGroup _grpVision;
    private PTServerSearchRefResult _inputResult = null;
    private List<ReferencedEntity> paramsTable;
    private Map<IPTServerReference, InputStream> inputStreamsMap;
    private Document _macroDocument;
    private String _streamID;
    private String _componentID;
    public static final String _VIEW_ID = String.valueOf(PTServerCrossReferenceView.class.getName()) + "_ID";
    private PTExportQueryAction _exportQueryAction;
    private String CONTEXT_ID_FOR_HELP = "Macro_x_server";
    private PTDesignPath _designPath;

    public static boolean IsModificationAuthorized(List<IPTReference> entitiesList) {
        return false;
    }

    public static List<ReferencedEntity> SearchMacroParameterFor(RadicalEntity re, IPTServerReference iptServerReference, String nameOfMacroRef) {
        Iterator cpLinesIterator = PTCrossReferenceView.SearchCPLinesFrom((RadicalEntity)re);
        ArrayList<ReferencedEntity> params = new ArrayList<ReferencedEntity>();
        if (cpLinesIterator != null) {
            while (cpLinesIterator.hasNext()) {
                PacCPLine cpLine;
                String nameOfMacro;
                Object obj = cpLinesIterator.next();
                if (!(obj instanceof PacCPLine) || !nameOfMacroRef.equals(nameOfMacro = (cpLine = (PacCPLine)obj).getMacro().getProxyName())) continue;
                params.add(new ServerReferencedEntity(re, iptServerReference, cpLine));
            }
        }
        return params;
    }

    public void createPartControl(Composite parent) {
        String[] excludedTypes;
        super.createPartControl(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.verticalSpacing = 1;
        gridLayout.horizontalSpacing = 1;
        parent.setLayout((Layout)gridLayout);
        this._sortMode = 1;
        this._displayMode = 5;
        this._sortMode = this._prefs.getInt("_PREF_REFERENCE_VIEW_SORT", this._sortMode);
        this._displayMode = this._prefs.getInt("_PREF_REFERENCE_VIEW_DISPLAY", this._displayMode);
        String[] stringArray = excludedTypes = this._prefs.get("_PREF_REFERENCE_VIEW_EXCLUDED_TYPES", "").split(",");
        int n = excludedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String excludedType = stringArray[n2];
            if (excludedType.trim().length() > 0) {
                this.getExcludedTypes().add(excludedType);
            }
            ++n2;
        }
        this._grpVision = new PTVisionGroup(parent, 0);
        this._grpVision.setContext(this._context);
        this._grpVision.setVision(this._vision);
        this._grpVision.addListener((IPTVisionListener)this);
        this._trvViewer = new PTServerCrossReferenceTreeViewer(parent, 67588);
        this._trvViewer.setContentProvider((IContentProvider)new OutlineServerCrossRefTableContentProvider(this.getExcludedTypes()));
        this._trvViewer.setLabelProvider((IBaseLabelProvider)new OutlineServerCrossRefTableLabelProvider(this._displayMode));
        this._trvViewer.setComparator((ViewerComparator)new PTViewerComparator(this._sortMode));
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        data.minimumHeight = 50;
        data.minimumWidth = 50;
        data.widthHint = 300;
        data.heightHint = 300;
        this._trvViewer.getTree().setLayoutData((Object)data);
        int[] sortModes = new int[]{1, 3};
        this._sortActionGroup = new PTSortActionGroup((IPTStructuredViewer)this, sortModes);
        int[] displayModes = new int[]{4};
        this._displayActionGroup = new PTDisplayActionGroup((IPTStructuredViewer)this, displayModes);
        this._filterActionGroup = new PTReferenceFilterActionGroup((IPTView)this);
        this._replayAction = new ServerPacReplayAction((IPTView)this);
        this._historyAction = new ServerPacHistoryDropdownAction((IPTView)this);
        this._exportQueryAction = new PTExportQueryAction((IPTSerializableView)this);
        this._openActionGroup = new PTServerOpenActionGroup((IPTView)this);
        this._searchRefActionGroup = new PTSearchRefActionGroup((IPTView)this);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.fillToolBarMenu(toolBarManager);
        IMenuManager barMenuMgr = this.getViewSite().getActionBars().getMenuManager();
        barMenuMgr.setRemoveAllWhenShown(true);
        this.fillActionBarMenu(barMenuMgr);
        barMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PTServerCrossReferenceView.this.fillActionBarMenu(menu);
            }
        });
        this._trvViewer.getControl().addListener(12, this._tooltipListener);
        this._trvViewer.getControl().addListener(1, this._tooltipListener);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PTServerCrossReferenceView.this.fillContextMenu(menu);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this._trvViewer.getTree());
        this._trvViewer.getTree().setMenu(menu);
        this.setupData();
        this.setHelp(parent);
        this._trvViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object object = selection.getFirstElement();
                if (object instanceof ReferencedEntity) {
                    PTServerOpenAction openAction = new PTServerOpenAction((IPTView)PTServerCrossReferenceView.this);
                    openAction.run();
                }
            }
        });
    }

    public void setFocus() {
    }

    private void setHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.pdp.doc.cshelp." + this.CONTEXT_ID_FOR_HELP);
    }

    public void setInput(Document macroDocument, Map<IPTServerReference, InputStream> inputObject, final String streamID, String componentID) {
        this.inputStreamsMap = inputObject;
        this._macroDocument = macroDocument;
        this._streamID = streamID;
        this._componentID = componentID;
        this.paramsTable = new ArrayList<ReferencedEntity>();
        for (Map.Entry<IPTServerReference, InputStream> entry : inputObject.entrySet()) {
            String sourceId = entry.getKey().getSourceId();
            InputStream inputStream = entry.getValue();
            RadicalEntity re = PTModelService.getResource((InputStream)inputStream);
            re.setProject(MetadataService.getProject((String)sourceId));
            this.paramsTable.addAll(PTServerCrossReferenceView.SearchMacroParameterFor(re, entry.getKey(), this._macroDocument.getName()));
        }
        this._trvViewer.setInput(this.paramsTable);
        int i = 0;
        while (i < this._trvViewer.getTree().getColumnCount()) {
            this._trvViewer.getTree().getColumn(i).pack();
            ++i;
        }
        this._context = ReferencedEntity.getContext((Document)this._macroDocument);
        final PTServerContributor serverContributor = new PTServerContributor();
        Job internJob = new Job("PTServerCrossReferenceView#setInput Job..."){

            protected IStatus run(IProgressMonitor monitor) {
                PTServerCrossReferenceView.this._designPath = serverContributor.getDiagram(streamID, PTServerCrossReferenceView.this._context, 1, monitor);
                if (PTServerCrossReferenceView.this._designPath == null) {
                    PTServerCrossReferenceView.this._designPath = new PTDesignPath("");
                }
                return Status.OK_STATUS;
            }
        };
        internJob.setUser(false);
        internJob.schedule();
        try {
            internJob.join();
        }
        catch (InterruptedException ie) {
            throw Util.rethrow((Throwable)ie);
        }
        PTProjectScope projectScope = new PTProjectScope(streamID, this._designPath.getLocation(), this._designPath.getElementaryPaths());
        projectScope.setContext(this._context);
        projectScope.setVision(3);
        this._grpVision.setContext(this._context);
        TreeSet projects = new TreeSet();
        projects.addAll(projectScope.getRetainedProjects(streamID, this._designPath.getLocation()));
        this._grpVision.setList(projects);
        this.setPartName(this.getTitle());
        this.setTitleToolTip(this.getPartName());
    }

    public void setModification(boolean modificationAuthorized) {
        ((PTCrossReferenceTreeViewer)this._trvViewer).setModificationAuthorized(modificationAuthorized);
    }

    public String getTitle() {
        StringBuilder buffer = new StringBuilder(ServerPdpMacroPacbaseLabels._SERVER_CROSSREF_TITLE);
        if (this._macroDocument != null) {
            buffer.append(": ").append(this._macroDocument.getName()).append("  [").append(this._macroDocument.getProject());
            if (this._macroDocument.getPackage().length() > 0) {
                buffer.append("/").append(this._macroDocument.getPackage());
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    public List<ReferencedEntity> getParamsTable() {
        return this.paramsTable;
    }

    public String getMacroName() {
        return this._macroDocument.getName();
    }

    private void fillToolBarMenu(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this._replayAction);
        toolBarManager.add((IAction)this._historyAction);
        toolBarManager.add((IAction)this._exportQueryAction);
    }

    public PTSerializerConfiguration getSerializerConfiguration() {
        PTAttributeItem[] allAttributes = new PTAttributeItem[]{new PTAttributeItem("Project"), new PTAttributeItem("Package"), new PTAttributeItem("Name"), new PTAttributeItem("Class"), new PTAttributeItem("LineNumber", PdpMacroPacbaseLabels._LINE_NUMBER), new PTAttributeItem("Comment", PdpMacroPacbaseLabels._COMMENT), new PTAttributeItem(_PARAM_KEYS[0], _PARAM_KEYS[0]), new PTAttributeItem(_PARAM_KEYS[1], _PARAM_KEYS[1]), new PTAttributeItem(_PARAM_KEYS[2], _PARAM_KEYS[2]), new PTAttributeItem(_PARAM_KEYS[3], _PARAM_KEYS[3]), new PTAttributeItem(_PARAM_KEYS[4], _PARAM_KEYS[4]), new PTAttributeItem(_PARAM_KEYS[5], _PARAM_KEYS[5]), new PTAttributeItem(_PARAM_KEYS[6], _PARAM_KEYS[6]), new PTAttributeItem(_PARAM_KEYS[7], _PARAM_KEYS[7]), new PTAttributeItem(_PARAM_KEYS[8], _PARAM_KEYS[8]), new PTAttributeItem(_PARAM_KEYS[9], _PARAM_KEYS[9]), new PTAttributeItem(_PARAM_KEYS[10], _PARAM_KEYS[10]), new PTAttributeItem(_PARAM_KEYS[11], _PARAM_KEYS[11]), new PTAttributeItem(_PARAM_KEYS[12], _PARAM_KEYS[12]), new PTAttributeItem(_PARAM_KEYS[13], _PARAM_KEYS[13]), new PTAttributeItem(_PARAM_KEYS[14], _PARAM_KEYS[14]), new PTAttributeItem(_PARAM_KEYS[15], _PARAM_KEYS[15]), new PTAttributeItem(_PARAM_KEYS[16], _PARAM_KEYS[16]), new PTAttributeItem(_PARAM_KEYS[17], _PARAM_KEYS[17]), new PTAttributeItem(_PARAM_KEYS[18], _PARAM_KEYS[18]), new PTAttributeItem(_PARAM_KEYS[19], _PARAM_KEYS[19])};
        String[] defAttributeIds = new String[]{"Project", "Class", "Name", "LineNumber", "Comment", _PARAM_KEYS[0], _PARAM_KEYS[1], _PARAM_KEYS[2], _PARAM_KEYS[3], _PARAM_KEYS[4], _PARAM_KEYS[5], _PARAM_KEYS[6], _PARAM_KEYS[7], _PARAM_KEYS[8], _PARAM_KEYS[9], _PARAM_KEYS[10], _PARAM_KEYS[11], _PARAM_KEYS[12], _PARAM_KEYS[13], _PARAM_KEYS[14], _PARAM_KEYS[15], _PARAM_KEYS[16], _PARAM_KEYS[17], _PARAM_KEYS[18], _PARAM_KEYS[19]};
        String prefKey = _VIEW_ID;
        return new PTSerializerConfiguration(allAttributes, defAttributeIds, prefKey);
    }

    public void serialize(List<PTAttributeItem> preferredAttributes, String outputFile) {
        if (this.paramsTable == null) {
            return;
        }
        ArrayList<MacroXRefSerializableItem> serializables = new ArrayList<MacroXRefSerializableItem>();
        for (ReferencedEntity macroXRef : this.paramsTable) {
            MacroXRefSerializableItem serializable = new MacroXRefSerializableItem(macroXRef);
            serializables.add(serializable);
        }
        MacroXRefSerializer.processSerialization(serializables, preferredAttributes, (String)outputFile);
    }

    public void setInput(Object object) {
        if (object instanceof PTServerSearchRefResult) {
            PTServerSearchRefResult searchResult = (PTServerSearchRefResult)object;
            PTServerReferenceItem selectedMacro = searchResult.getServerReferenceItem();
            Document macroH = selectedMacro.getDocument();
            String streamId = selectedMacro.getStreamID();
            String componentID = selectedMacro.getComponentID();
            ServerCrossReferenceAction crossAction = new ServerCrossReferenceAction(this, streamId, componentID, macroH);
            crossAction.run();
        }
    }

    public void refresh() {
        this._trvViewer.refresh();
    }

    protected String getContextId() {
        return this.CONTEXT_ID_FOR_HELP;
    }

    public void locationSelected(PTLocation location) {
    }

    public void resourceChanged(IResourceDelta deltaEvent) {
    }

    public void handleContextFocusGained() {
    }

    public void handleVisionChange(String context, int vision) {
        this._context = context;
        this._vision = vision;
        if (this.paramsTable == null || this.paramsTable.size() == 0) {
            return;
        }
        this.getShell().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        ArrayList<ReferencedEntity> entities = new ArrayList<ReferencedEntity>();
        PTServerArtifact artifact = (PTServerArtifact)((ServerReferencedEntity)this.paramsTable.get(0)).getAdapter(PTServerArtifact.class);
        String streamId = artifact.getStreamID();
        PTProjectScope projectScope = new PTProjectScope(streamId, this._designPath.getLocation(), this._designPath.getElementaryPaths());
        projectScope.setVision(this._vision);
        projectScope.setContext(this._context);
        Set projects = projectScope.getRetainedProjects(streamId, this._designPath.getLocation());
        for (ReferencedEntity referencedEntity : this.paramsTable) {
            if (!projects.contains(referencedEntity.getContext())) continue;
            entities.add(referencedEntity);
        }
        this._trvViewer.setInput(entities);
        this.refresh();
        this.getShell().setCursor(null);
    }

    public Set<String> getExcludedTypes() {
        if (this._excludedTypes == null) {
            this._excludedTypes = new HashSet<String>();
        }
        return this._excludedTypes;
    }

    private void fillActionBarMenu(IMenuManager menu) {
        this._sortActionGroup.fillMenu(menu);
        this._displayActionGroup.fillMenu(menu);
        menu.add((IContributionItem)new Separator());
        this._filterActionGroup.fillMenu(menu, this.getExcludedTypes());
    }

    private void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.size() > 0) {
            Object firstSelected = selection.getFirstElement();
            if (firstSelected instanceof ReferencedEntity) {
                menu.add((IContributionItem)new Separator(PTServerOpenActionGroup._SEPARATOR));
                this._openActionGroup.activateOpenWith();
                this._openActionGroup.fillContextMenu(menu);
            }
            menu.add((IContributionItem)new Separator(PTSearchRefActionGroup._SEPARATOR));
            this._searchRefActionGroup.fillContextMenu(menu);
            menu.add((IContributionItem)new Separator("rpp.additions"));
            menu.add((IContributionItem)new Separator("rpp.additions.end"));
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void setupData() {
        this._sortActionGroup.check(this._sortMode);
        this._displayActionGroup.check(this._displayMode);
        this.refresh();
    }

    public void setDisplayMode(int displayMode) {
        this._displayMode = displayMode;
        IBaseLabelProvider subProvider = this._trvViewer.getLabelProvider();
        ((OutlineServerCrossRefTableLabelProvider)subProvider).setDisplayMode(this._displayMode);
    }

    public List<?> getHistoryEntries() {
        return PacCrossRefManager.getServerSearchCrossRefResults();
    }

    public Document getDocument() {
        return this._macroDocument;
    }

    public String getStreamID() {
        return this._streamID;
    }

    public String getComponentID() {
        return this._componentID;
    }
}

