/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.server.action;

import com.ibm.pdp.explorer.associate.IPTDocumentWrapper;
import com.ibm.pdp.explorer.model.PTResourceManager;
import com.ibm.pdp.explorer.model.reference.PTReferenceItem;
import com.ibm.pdp.explorer.plugin.IPTMenuContributor;
import com.ibm.pdp.explorer.view.actiongroup.PTSearchRefActionGroup;
import com.ibm.pdp.macro.pacbase.server.action.ServerCrossReferenceAction;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.server.model.PTServerArtifact;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class ServerMenuCrossReferenceAction
implements IPTMenuContributor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015,2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _SEPARATOR = String.valueOf(ServerMenuCrossReferenceAction.class.getName()) + "_SEPARATOR";

    public void menuAboutToShow(String viewId, Viewer viewer, IMenuManager menuMgr) {
        Document metaDocument;
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object selectedObject = selection.getFirstElement();
        PTServerArtifact artifact = null;
        if (selectedObject instanceof IAdaptable && ((IAdaptable)selectedObject).getAdapter(PTServerArtifact.class) instanceof PTServerArtifact) {
            artifact = (PTServerArtifact)((IAdaptable)selectedObject).getAdapter(PTServerArtifact.class);
            if (artifact.getDocument().getType().equals("pacmacro")) {
                IMenuManager mgr = (IMenuManager)menuMgr.find(PTSearchRefActionGroup._ID);
                ServerCrossReferenceAction serverCrossrefAction = new ServerCrossReferenceAction(artifact.getStreamID(), artifact.getComponentID(), artifact.getDocument());
                mgr.add((IAction)serverCrossrefAction);
                boolean enabled = this.isEnabled(selectedObject);
                serverCrossrefAction.setEnabled(enabled);
            }
        } else if (selectedObject instanceof IPTDocumentWrapper && (metaDocument = ((IPTDocumentWrapper)selectedObject).getDocument()).getType().equals("pacmacro")) {
            IMenuManager mgr = (IMenuManager)menuMgr.find(PTSearchRefActionGroup._ID);
            IPath path = PTResourceManager.getPath((Document)metaDocument);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null) {
                Map properties = PTRepositoryManager.getServerProperties((IResource)resource);
                UUID streamUUID = (UUID)properties.get("_PROPS_STREAM_ID");
                UUID componentUUID = (UUID)properties.get("_PROPS_COMPONENT_ID");
                ServerCrossReferenceAction serverCrossrefAction = null;
                if (streamUUID != null && componentUUID != null) {
                    serverCrossrefAction = new ServerCrossReferenceAction(streamUUID.getUuidValue(), componentUUID.getUuidValue(), metaDocument);
                    mgr.add((IAction)serverCrossrefAction);
                } else {
                    serverCrossrefAction = new ServerCrossReferenceAction(null, null, metaDocument);
                    mgr.add((IAction)serverCrossrefAction);
                }
                boolean enabled = this.isEnabled(selectedObject);
                serverCrossrefAction.setEnabled(enabled);
            }
        }
    }

    private boolean isEnabled(Object selectedObject) {
        boolean enabled = false;
        if (!(selectedObject instanceof IPTDocumentWrapper)) {
            return false;
        }
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository();
        if (teamRepository == null) {
            return false;
        }
        if (selectedObject instanceof IAdaptable && ((IAdaptable)selectedObject).getAdapter(PTServerArtifact.class) instanceof PTServerArtifact) {
            enabled = true;
        } else if (selectedObject instanceof IPTDocumentWrapper) {
            IProject project;
            IFile file;
            PTReferenceItem referenceItem;
            Document metaDocument = ((IPTDocumentWrapper)selectedObject).getDocument();
            String projectName = metaDocument.getProject();
            if (selectedObject instanceof PTReferenceItem && !(referenceItem = (PTReferenceItem)selectedObject).isResolved()) {
                projectName = referenceItem.getContext();
            }
            if (projectName.length() > 0 && projectName.charAt(0) == '%') {
                projectName = projectName.substring(1);
            }
            if ((file = (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).getFile(".pdppath")) != null && file.exists()) {
                try {
                    IShareable target = (IShareable)file.getAdapter(IShareable.class);
                    IShare share = target.getShare((IProgressMonitor)new NullProgressMonitor());
                    ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                    if (sharingDescriptor.getRepositoryId().equals((Object)teamRepository.getId())) {
                        enabled = true;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return enabled;
    }
}

