/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.server.action;

import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.macro.pacbase.nls.PdpMacroPacbaseLabels;
import com.ibm.pdp.macro.pacbase.server.view.PTServerCrossReferenceView;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.editor.page.extension.IPTFlatPageActionContribution;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.pac.explorer.model.PacCrossRefManager;
import com.ibm.pdp.server.editor.PTRemoteEditorInput;
import com.ibm.pdp.server.model.reference.PTServerReferenceItem;
import com.ibm.pdp.server.model.tool.PTRemoteArtifact;
import com.ibm.pdp.server.page.PTServerJob;
import com.ibm.pdp.server.page.PTServerPageLabel;
import com.ibm.pdp.server.query.PTServerSearchRefQuery;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.pdp.server.result.PTServerSearchRefResult;
import com.ibm.pdp.server.service.IPTServerReference;
import com.ibm.pdp.server.service.PTServerService;
import com.ibm.pdp.util.Util;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class MacroServerCrossReferenceAction
implements IPTFlatPageActionContribution {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(MacroServerCrossReferenceAction.class.getName()) + "_ID";
    private PTServerCrossReferenceView _crossReferenceView;
    private String _streamID;
    private String _componentID;
    private Document _metaDocument;
    private String _name;

    public void run() {
        if (!PTModelManager.checkLicense()) {
            return;
        }
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository();
        if (!PTRepositoryManager.checkQueryCompatibility((ITeamRepository)teamRepository, (boolean)true)) {
            return;
        }
        final HashMap inputStreamsMap = new HashMap();
        Job[] jobs = Job.getJobManager().find((Object)"RPP_FAMILY");
        if (jobs.length > 0) {
            PTMessageManager.handleWarning((String)PTServerPageLabel.getString((String)PTServerPageLabel._SERVER_TASK_IN_PROGRESS));
            return;
        }
        PTServerJob searchJob = new PTServerJob(PdpMacroPacbaseLabels.CROSSREF_TASK){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(NLS.bind((String)PdpMacroPacbaseLabels.READ_CROSSREF, (Object)MacroServerCrossReferenceAction.this._metaDocument.getName()), -1);
                try {
                    List superReferences = PTServerService.getReferences((String)MacroServerCrossReferenceAction.this._streamID, (String)MacroServerCrossReferenceAction.this._componentID, (String)MacroServerCrossReferenceAction.this._metaDocument.getId(), (int)1, (IProgressMonitor)monitor);
                    monitor.beginTask(NLS.bind((String)PdpMacroPacbaseLabels.READ_CROSSREF, (Object)MacroServerCrossReferenceAction.this._metaDocument.getName()), superReferences.size());
                    for (IPTServerReference reference : superReferences) {
                        String[] tokens;
                        if (!inputStreamsMap.containsKey(reference.getSourceId()) && ((tokens = MetadataService.getTokens((String)reference.getSourceId()))[4].equals(PacProgram.class.getSimpleName().toLowerCase()) || tokens[4].equals(PacScreen.class.getSimpleName().toLowerCase()) || tokens[4].equals(PacDialog.class.getSimpleName().toLowerCase()) || tokens[4].equals(PacCommunicationMonitor.class.getSimpleName().toLowerCase()) || tokens[4].equals(PacDialogCommunicationMonitor.class.getSimpleName().toLowerCase()) || tokens[4].equals(PacFolder.class.getSimpleName().toLowerCase()) || tokens[4].equals(PacDialogFolder.class.getSimpleName().toLowerCase()) || tokens[4].equals(PacServer.class.getSimpleName().toLowerCase()) || tokens[4].equals(PacDialogServer.class.getSimpleName().toLowerCase()))) {
                            monitor.subTask(NLS.bind((String)PdpMacroPacbaseLabels.READ_CROSSREF_CONTENT, (Object)reference.getSourceId()));
                            byte[] contents = PTServerService.retrieveFileContents((String)reference.getStreamID(), (String)reference.getSourceComponentID(), (String)reference.getSourceId(), (IProgressMonitor)monitor);
                            ByteArrayInputStream baos = new ByteArrayInputStream(contents);
                            inputStreamsMap.put(reference, baos);
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) {
                            continue;
                        }
                        break;
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {}
                if (!monitor.isCanceled()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage page = PTExplorerPlugin.getActiveWorkbenchWindow().getActivePage();
                            try {
                                page.showView(PTServerCrossReferenceView._VIEW_ID);
                            }
                            catch (PartInitException e) {
                                throw Util.rethrow((Throwable)e);
                            }
                            PTServerCrossReferenceView crossReferenceView = MacroServerCrossReferenceAction.this._crossReferenceView;
                            if (crossReferenceView == null) {
                                crossReferenceView = (PTServerCrossReferenceView)page.findView(PTServerCrossReferenceView._VIEW_ID);
                            }
                            PTServerSearchRefQuery searchQuery = new PTServerSearchRefQuery(MacroServerCrossReferenceAction.this._streamID, MacroServerCrossReferenceAction.this._componentID, MacroServerCrossReferenceAction.this._metaDocument);
                            List results = PacCrossRefManager.getServerSearchCrossRefResults();
                            int i = 0;
                            while (i < results.size()) {
                                PTServerReferenceItem result = ((PTServerSearchRefResult)results.get(i)).getServerReferenceItem();
                                if (result.getDocument().getId().equals(MacroServerCrossReferenceAction.this._metaDocument.getId())) {
                                    PacCrossRefManager.getServerSearchCrossRefResults().remove(i);
                                    break;
                                }
                                ++i;
                            }
                            results.add(0, searchQuery.getSearchResult());
                            crossReferenceView.setInput(MacroServerCrossReferenceAction.this._metaDocument, inputStreamsMap, MacroServerCrossReferenceAction.this._streamID, MacroServerCrossReferenceAction.this._componentID);
                            crossReferenceView.setModification(false);
                        }
                    });
                }
                monitor.done();
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        searchJob.setPriority(10);
        searchJob.setUser(true);
        searchJob.schedule();
    }

    public boolean isValidFor(RadicalEntity currentEntity) {
        return true;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void initialize(IEditorInput editorInput, String id) {
        PTRemoteEditorInput remoteEditorInput;
        PTRemoteArtifact remoteArtifact;
        if (editorInput instanceof PTRemoteEditorInput && (remoteArtifact = (PTRemoteArtifact)(remoteEditorInput = (PTRemoteEditorInput)editorInput).getDependencyArtifacts().get(id)) != null) {
            this._streamID = remoteArtifact.getStreamID();
            this._metaDocument = remoteArtifact.getDocument();
            this._componentID = remoteArtifact.getComponentID();
        }
    }

    public void initialize(RadicalEntity re) {
    }
}

