/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.views;

import com.ibm.pdp.macro.common.ActionManager;
import com.ibm.pdp.macro.common.EditorLink;
import com.ibm.pdp.macro.common.Trace;
import com.ibm.pdp.macro.common.action.SkeletonAction;
import com.ibm.pdp.macro.common.action.TextReorderingAction;
import com.ibm.pdp.macro.common.interfaces.IControler;
import com.ibm.pdp.macro.common.interfaces.IEditor;
import com.ibm.pdp.macro.common.interfaces.ISkeleton;
import com.ibm.pdp.macro.common.interfaces.ITagsTreeViewAction;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.common.merge.NodeTree;
import com.ibm.pdp.macro.common.nls.MacroLabels;
import com.ibm.pdp.macro.common.outline.OutlineTreeContentProvider;
import com.ibm.pdp.macro.common.outline.OutlineTreeLabelProvider;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.ViewPart;

public class TagsTreeView
extends ViewPart
implements ISelectionChangedListener,
ISelectionProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TreeViewer _viewer;
    private NodeTree _nodeTree;
    private IControler _controler;
    private ISelection _currentSelection;
    private IEditor _associatedEditor;
    private TreeMap<String, SkeletonAction> skeletonActions = new TreeMap();
    private TreeMap<String, IAction> actions = new TreeMap();
    private List<ISelectionChangedListener> _selectionChangeListeners = new ArrayList<ISelectionChangedListener>();
    public static final String ID = "com.ibm.pdp.macro.common.views.TagsTreeView";
    private boolean changingSelection = false;
    private TextReorderingAction _textReorderingAction;
    private String CONTEXT_ID_FOR_HELP = "macrocode_view";

    public void createPartControl(Composite parent) {
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filteredTree = new FilteredTree(parent, 2818, patternFilter, true);
        this.contributeToActionBars();
        this._viewer = filteredTree.getViewer();
        Tree tree = this._viewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumn column1 = new TreeColumn(tree, 16384);
        tree.setHeaderVisible(true);
        column1.setText(MacroLabels.NODES);
        column1.setWidth(220);
        TreeColumn column2 = new TreeColumn(tree, 16388);
        column2.setWidth(260);
        this._viewer.setContentProvider((IContentProvider)new OutlineTreeContentProvider(this._nodeTree));
        this._viewer.setLabelProvider((IBaseLabelProvider)new OutlineTreeLabelProvider());
        this._viewer.setInput((Object)this.getViewSite());
        this._viewer.expandAll();
        this._viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setInputAtCreation();
        this.createContextMenu();
        this.setHelp(parent);
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TagsTreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this._viewer.getControl());
        this._viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._viewer);
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        HashMap<ITagsTreeViewAction, IConfigurationElement> implementors = ActionManager.getTagsTreeViewActionImplementors();
        for (ITagsTreeViewAction action : implementors.keySet()) {
            IConfigurationElement element = implementors.get(action);
            action.initialize(this._associatedEditor, element.getAttribute("name"), this._currentSelection == null ? null : (NodeTag)((IStructuredSelection)this._currentSelection).getFirstElement());
            this.actions.put(element.getAttribute("order"), (IAction)action);
        }
        Iterator<IAction> it = this.actions.values().iterator();
        while (it.hasNext()) {
            menuMgr.add(it.next());
        }
    }

    private void contributeToActionBars() {
        IMenuManager barMenuMgr = this.getViewSite().getActionBars().getMenuManager();
        MenuManager menu = new MenuManager(MacroLabels.SKELETON);
        HashMap<ISkeleton, IConfigurationElement> skelImplementors = ActionManager.getSkeletonImplementors();
        for (ISkeleton skeleton : skelImplementors.keySet()) {
            SkeletonAction action = new SkeletonAction(skeleton);
            IConfigurationElement element = skelImplementors.get(skeleton);
            action.setText(element.getAttribute("name"));
            this.skeletonActions.put(element.getAttribute("order"), action);
            if (element.getAttribute("isDefault") == null || !element.getAttribute("isDefault").equals("true")) continue;
            action.setEnabled(false);
        }
        Iterator<SkeletonAction> itActions = this.skeletonActions.values().iterator();
        while (itActions.hasNext()) {
            menu.add((IAction)itActions.next());
        }
        barMenuMgr.add((IContributionItem)menu);
        barMenuMgr.add((IContributionItem)new Separator());
        this._textReorderingAction = new TextReorderingAction(this._associatedEditor);
        this._textReorderingAction.setEnabled(false);
        barMenuMgr.add((IAction)this._textReorderingAction);
    }

    private void configureEnabledItems() {
        String model = this.getControler().getSelectedModel();
        for (SkeletonAction action : this.skeletonActions.values()) {
            if (model == null) {
                if (action.getSkeleton().getModel() == null) {
                    action.setEnabled(false);
                    continue;
                }
                action.setEnabled(true);
                continue;
            }
            if (action.getSkeleton().getModel() != null && action.getSkeleton().getModel().equals(model)) {
                action.setEnabled(false);
                continue;
            }
            action.setEnabled(true);
        }
    }

    private void disableAllActions() {
        for (SkeletonAction action : this.skeletonActions.values()) {
            action.setEnabled(false);
        }
    }

    public void dispose() {
        if (this.getAssociatedEditor() != null) {
            this.getAssociatedEditor().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.getControler() != null && this.getControler().getEditorLink() != null) {
            this.removeSelectionChangedListener(this.getControler().getEditorLink());
            ((EditorLink)this.getControler().getEditorLink()).tagsTreeViewDisposed();
        }
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.changingSelection) {
            return;
        }
        this.changingSelection = true;
        try {
            ISelection selection = event.getSelection();
            NodeTag node = null;
            if (selection instanceof IStructuredSelection) {
                if (!this.getSynchronizedAction().isEnabled()) {
                    this._currentSelection = selection;
                    int i = 0;
                    while (i < this._selectionChangeListeners.size()) {
                        ISelectionChangedListener l = this._selectionChangeListeners.get(i);
                        l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                        ++i;
                    }
                }
            } else if (selection instanceof TextSelection) {
                ITextSelection sel = (ITextSelection)selection;
                StructuredSelection convertedSelection = StructuredSelection.EMPTY;
                if (!sel.isEmpty() && this._nodeTree != null) {
                    int start = sel.getOffset();
                    int stop = start + sel.getLength();
                    ArrayList<NodeText> nodeTexts = this._nodeTree.getRootTag().getNodeTexts(true);
                    int i = 0;
                    while (i < nodeTexts.size()) {
                        NodeText nt = nodeTexts.get(i);
                        if (nt.getEndIndex() != -1 && nt.getBeginIndex() <= start && nt.getEndIndex() > stop) {
                            node = nt.getParentNode();
                            if (node.getProperty("technicTag") == null && !node.getName().startsWith("N")) break;
                            node = node.getParentNode();
                            break;
                        }
                        ++i;
                    }
                    if (node != null) {
                        convertedSelection = new StructuredSelection(node);
                        this._currentSelection = convertedSelection;
                    }
                }
                this.setSelection((ISelection)convertedSelection);
            }
        }
        catch (Exception e) {
            this.changingSelection = false;
            if (Trace.traceOn) {
                e.printStackTrace();
            }
            Util.rethrow((Throwable)e);
        }
        this.changingSelection = false;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._selectionChangeListeners.add(listener);
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp." + this.CONTEXT_ID_FOR_HELP;
    }

    public IControler getControler() {
        return this._controler;
    }

    public IEditor getAssociatedEditor() {
        return this._associatedEditor;
    }

    public ISelection getSelection() {
        return this._currentSelection;
    }

    public List<ISelectionChangedListener> getSelectionChangeListeners() {
        return new ArrayList<ISelectionChangedListener>(this._selectionChangeListeners);
    }

    public TextReorderingAction getSynchronizedAction() {
        return this._textReorderingAction;
    }

    public TreeViewer getTreeViewer() {
        return this._viewer;
    }

    private void setInputAtCreation() {
        IEditor editor;
        IControler controler;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && page.getActiveEditor() != null && page.getActiveEditor() instanceof MultiPageEditorPart && ((MultiPageEditorPart)page.getActiveEditor()).getSelectedPage() instanceof IEditor && (controler = (editor = (IEditor)((MultiPageEditorPart)page.getActiveEditor()).getSelectedPage()).getControler()) != null) {
            this.setControler(controler, editor, true);
            this.update();
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._selectionChangeListeners.remove(listener);
    }

    public void setControler(IControler aControler, IEditor editor, boolean isTakingFocus) {
        if (isTakingFocus) {
            if (this._controler != null) {
                this.removeSelectionChangedListener(this._controler.getEditorLink());
                if (this._associatedEditor.getSelectionProvider() != null) {
                    this._associatedEditor.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
            this._controler = aControler;
            this._associatedEditor = editor;
            this.addSelectionChangedListener(this._controler.getEditorLink());
            editor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
            this._nodeTree = this._controler.getNodeTree();
            this.configureEnabledItems();
            this._textReorderingAction.setEnabled(this.getControler().getEditorLink().isEditorDesynchronized());
        } else if (this._associatedEditor == editor) {
            this.removeSelectionChangedListener(this._controler.getEditorLink());
            this._associatedEditor.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            this._controler = null;
            this._associatedEditor = null;
            this._nodeTree = null;
            this._textReorderingAction.setEnabled(false);
        }
        this._textReorderingAction.setEditor(this._associatedEditor);
        this.update();
    }

    public void setFocus() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        boolean isEditorOK = false;
        if (page != null && page.getActiveEditor() != null && page.getActiveEditor() instanceof MultiPageEditorPart && ((MultiPageEditorPart)page.getActiveEditor()).getSelectedPage() == this._associatedEditor && page.getActiveEditor().getEditorInput() instanceof IFileEditorInput) {
            this._viewer.getControl().setEnabled(true);
            this.configureEnabledItems();
            isEditorOK = true;
            if (this._viewer.getTree().getItems().length > 0) {
                this._viewer.getTree().setFocus();
            }
        }
        if (!isEditorOK) {
            this.disableAllActions();
        }
    }

    public void setHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getContextId());
    }

    public void setNodeTree(NodeTree nt) {
        this._nodeTree = nt;
    }

    public void setSelection(ISelection selection) {
        if (this._viewer != null) {
            this._viewer.setSelection(selection);
        }
    }

    public void update() {
        if (this._viewer != null && !this._viewer.getControl().isDisposed()) {
            Control control;
            IContentProvider cp = this._viewer.getContentProvider();
            if (this._controler != null) {
                this._viewer.setLabelProvider((IBaseLabelProvider)this._controler.getEditorLink().getLabelProvider());
                if (cp instanceof OutlineTreeContentProvider) {
                    ((OutlineTreeContentProvider)cp).setNodeTree(this._nodeTree);
                }
            }
            if ((control = this._viewer.getControl()) != null && !control.isDisposed()) {
                control.setRedraw(false);
                this._viewer.setInput((Object)this._nodeTree);
                if (this.getControler() == null || this.getControler().getSkeleton() == null) {
                    this._viewer.expandToLevel(2);
                }
                control.setRedraw(true);
            }
            this._viewer.getControl().setEnabled(true);
        }
    }
}

