/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.outline;

import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeTree;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class OutlineTreeContentProvider
implements ITreeContentProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private NodeTree nodeTree;

    public OutlineTreeContentProvider() {
    }

    public OutlineTreeContentProvider(NodeTree nodeTree) {
        this.setNodeTree(nodeTree);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Node> nodeTags = new ArrayList<Node>();
        nodeTags = this.getSelectedchildren(parentElement, nodeTags);
        return nodeTags.toArray();
    }

    private ArrayList<Node> getSelectedchildren(Object parentElement, ArrayList<Node> nodeTags) {
        ArrayList<Object> nodes = new ArrayList();
        if (parentElement instanceof NodeTree) {
            nodes = this.nodeTree.getRootTag().getChildren();
        } else if (parentElement instanceof NodeTag) {
            nodes = ((NodeTag)parentElement).getChildren();
        }
        if (!nodes.isEmpty()) {
            int i = 0;
            while (i < nodes.size()) {
                if (nodes.get(i) instanceof NodeTag) {
                    NodeTag nt = (NodeTag)nodes.get(i);
                    if (nt.getProperty("technicTag") == null && !nt.getName().startsWith("N")) {
                        nodeTags.add((Node)nodes.get(i));
                    } else {
                        Object[] tNodes = this.getChildren(nt);
                        int j = 0;
                        while (j < tNodes.length) {
                            if (tNodes[j] instanceof NodeTag) {
                                NodeTag nt1 = (NodeTag)tNodes[j];
                                nodeTags.add(nt1);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return nodeTags;
    }

    public Object getParent(Object element) {
        if (element instanceof NodeTree) {
            return ((NodeTree)element).getRootTag();
        }
        return ((NodeTag)element).getParentNode();
    }

    public boolean hasChildren(Object element) {
        Object[] ob = this.getChildren(element);
        if (ob != null) {
            return ob.length != 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof NodeTree) {
            this.setNodeTree((NodeTree)newInput);
        }
    }

    public void setNodeTree(NodeTree nodeTree) {
        this.nodeTree = nodeTree;
    }
}

