/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.merge;

import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeRootTag;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.common.merge.NodeTree;
import com.ibm.pdp.macro.common.merge.NodeTreeVisitor;
import java.util.Map;

public class NodeTreePublication
extends NodeTreeVisitor {
    protected StringBuilder result = new StringBuilder();
    protected static final char[] specials = new char[]{'<', '>', '&', '\"'};
    protected static final String[] replacements = new String[]{"&lt;", "&gt;", "&amp;", "&quot;"};
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public boolean isTrueTag(NodeTag nt) {
        return true;
    }

    public void visit(NodeTree nodeTree) {
        this.result.append("<GeneratedInfo");
        if (nodeTree.getGeneratedInfoProperties() != null) {
            for (Map.Entry<Object, Object> entry : nodeTree.getGeneratedInfoProperties().entrySet()) {
                this.result.append(' ');
                this.result.append((String)entry.getKey());
                this.result.append("=\"");
                this.result.append((String)entry.getValue());
                this.result.append('\"');
            }
        }
        this.result.append(">");
        this.result.append("<Text>");
        nodeTree.getRootTag().accept(this);
        this.result.append("</Text></GeneratedInfo>");
    }

    @Override
    public void visit(NodeTag node) {
        if (this.isTrueTag(node)) {
            this.result.append("<");
            this.result.append(this.calculateProperties(node));
            this.result.append(">");
        }
        for (Node n : node.getChildren()) {
            n.accept(this);
        }
        if (this.isTrueTag(node)) {
            this.result.append("</tag name=\"");
            this.result.append(node.getName());
            this.result.append("\">");
        }
    }

    @Override
    public void visit(NodeRootTag node) {
        this.visit((NodeTag)node);
    }

    @Override
    public void visit(NodeText node) {
        this.result.append((CharSequence)this.writeText(node.getContent()));
    }

    protected String calculateProperties(NodeTag node) {
        StringBuilder tagName = new StringBuilder();
        tagName.append("tag name=\"");
        tagName.append(node.getName());
        tagName.append("\"");
        if (node.getProperties() != null) {
            for (Map.Entry<Object, Object> entry : node.getProperties().entrySet()) {
                tagName.append(' ');
                tagName.append((String)entry.getKey());
                tagName.append("=\"");
                tagName.append((String)entry.getValue());
                tagName.append('\"');
            }
        }
        return tagName.toString();
    }

    public String getText() {
        return this.result.toString();
    }

    protected StringBuilder writeText(String text) {
        int len = text.length();
        StringBuilder bu = new StringBuilder();
        int i = 0;
        while (i < len) {
            block3: {
                char c = text.charAt(i);
                int s = specials.length - 1;
                while (s >= 0) {
                    if (c == specials[s]) {
                        bu.append(replacements[s]);
                        break block3;
                    }
                    --s;
                }
                bu.append(c);
            }
            ++i;
        }
        return bu;
    }
}

