/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.merge;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.turbo.impl.GenInfoFactory;
import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeRootTag;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.common.merge.NodeTree;
import com.ibm.pdp.macro.common.merge.NodeTreeVisitor;
import java.util.Map;

public class NodeTreeConverter
extends NodeTreeVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected IGeneratedInfoFactory genInfofactory = new GenInfoFactory();
    protected IGeneratedInfo genInfoResult;

    public boolean isTrueTag(NodeTag nt) {
        return true;
    }

    public void visit(NodeTree nodeTree) {
        if (nodeTree.getGeneratedInfoProperties() != null) {
            for (Map.Entry<Object, Object> entry : nodeTree.getGeneratedInfoProperties().entrySet()) {
                this.genInfofactory.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        nodeTree.getRootTag().accept(this);
    }

    @Override
    public void visit(NodeTag node) {
        if (this.isTrueTag(node)) {
            this.genInfofactory.beginTag(node.getName());
            if (node.getProperties() != null) {
                this.calculateProperties(node);
                for (Map.Entry<Object, Object> entry : node.getProperties().entrySet()) {
                    this.genInfofactory.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        for (Node n : node.getChildren()) {
            n.accept(this);
        }
        if (this.isTrueTag(node)) {
            this.genInfofactory.endTag();
        }
    }

    @Override
    public void visit(NodeRootTag node) {
        this.visit((NodeTag)node);
    }

    @Override
    public void visit(NodeText node) {
        this.genInfofactory.appendText((CharSequence)node.getContent());
    }

    public IGeneratedInfo getGeneratedInfo() {
        if (this.genInfoResult == null) {
            this.genInfoResult = this.genInfofactory.createGeneratedInfo();
        }
        return this.genInfoResult;
    }

    public void calculateProperties(NodeTag node) {
    }
}

