/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.merge;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.macro.common.merge.GenericComparator;
import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeRootTag;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.common.merge.NodeTreeConverter;
import com.ibm.pdp.macro.common.merge.NodeTreePublication;
import com.ibm.pdp.macro.common.merge.SpecialNodeText;
import com.ibm.pdp.util.FilterPredicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class NodeTree {
    public static final int MSP_ALL_NODES = 0;
    public static final int MSP_ONLY_WITHOUT_MODEL = 1;
    public static final int MSP_ALL_NODES_EXCEPT_SKELETON = 2;
    GenericComparator comp = null;
    int nbTag = 0;
    private ArrayList<Node> treeNodesWithParam = new ArrayList();
    NodeRootTag nrt = null;
    NodeTag currentNode;
    int currentIndex = 0;
    protected Properties genInfoProperties = null;
    protected boolean isDirty = false;
    private boolean merge = false;
    public static final FilterPredicate<Node> NodeTextNotSpecialFromMspFilter = new FilterPredicate<Node>(){

        public boolean accept(Node node) {
            if (!(node instanceof NodeText) || node instanceof SpecialNodeText) {
                return false;
            }
            NodeTag parent = node.getParentNode();
            if (parent.getMSPName() == null) {
                return false;
            }
            String supp = parent.getProperty("action");
            return supp == null || !supp.equals("R");
        }
    };
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public NodeTree(IGeneratedInfo genInfo) {
        this.genInfoProperties = NodeTree.TagGenInfoProperties(genInfo);
        this.visit(genInfo.getRootTag(), genInfo.getText().toString());
    }

    public NodeTree() {
        this.nrt = this.instanciateNodeRootTag();
    }

    public void clean(boolean onlyNodeTextFromMacro) {
    }

    public void cleanWithoutSNT() {
    }

    private boolean doUpdateAccordingConstant(NodeTag read_Node, NodeTag insert_node, int cste, boolean endOfLoop) {
        NodeTag parent_node = read_Node.getParentNode();
        switch (cste) {
            case 1: {
                return true;
            }
            case 2: {
                NodeTag ntag = parent_node;
                Boolean isBrother = false;
                while (!isBrother.booleanValue() && ntag != null) {
                    if (this.getComparator().isBrotherOfNode(insert_node, ntag)) {
                        ntag.getParentNode().addSonAfter(insert_node, ntag);
                        isBrother = true;
                        continue;
                    }
                    ntag = ntag.getParentNode();
                }
                ArrayList<NodeTag> toRemove = new ArrayList<NodeTag>();
                ArrayList<NodeTag> toUpdate = new ArrayList<NodeTag>();
                if (ntag != null) {
                    this.searchNodesToReplace(insert_node, ntag, toRemove, toUpdate);
                    int i = 0;
                    while (i < toUpdate.size()) {
                        this.updateNode(ntag.getParentNode(), toUpdate.get(i), false);
                        ++i;
                    }
                }
                return true;
            }
            case 3: {
                parent_node.addSonBefore(insert_node, read_Node);
                return true;
            }
            case 4: {
                parent_node.addSonAfter(insert_node, read_Node);
                return true;
            }
            case 5: {
                Node savePrev = read_Node.getPreviousSiblingWithoutSNT();
                Node saveNext = read_Node.getNextSiblingWithoutSNT();
                ArrayList<NodeTag> toRemove = new ArrayList<NodeTag>();
                this.processNodeAndHisBrothers(insert_node, read_Node, toRemove);
                if (savePrev != null) {
                    parent_node.addSonAfter(insert_node, savePrev);
                } else if (saveNext != null) {
                    parent_node.addSonBefore(insert_node, saveNext);
                } else {
                    parent_node.addSon(insert_node);
                }
                parent_node.getChildren().removeAll(toRemove);
                return true;
            }
            case 6: {
                ArrayList<NodeTag> toRemove = new ArrayList<NodeTag>();
                this.processNodeAndHisBrothers(insert_node, read_Node, toRemove);
                NodeTag ntag = parent_node;
                Boolean isBrother = false;
                while (!isBrother.booleanValue() && ntag != null) {
                    if (this.getComparator().isBrotherOfNode(insert_node, ntag)) {
                        ntag.getParentNode().addSonAfter(insert_node, ntag);
                        isBrother = true;
                    }
                    ntag = ntag.getParentNode();
                }
                parent_node.getChildren().removeAll(toRemove);
                return true;
            }
            case 7: {
                if (endOfLoop) {
                    this.updateNode(read_Node, insert_node, false);
                } else {
                    NodeTag nt = (NodeTag)read_Node.getPreviousSiblingWithoutSNT();
                    ArrayList<NodeTag> toRemove = new ArrayList<NodeTag>();
                    ArrayList<NodeTag> aln = this.getComparator().childsOfPrevious(insert_node, read_Node, nt);
                    this.processNodeAndHisBrothers(insert_node, read_Node, toRemove);
                    this.updateNode(nt, insert_node, false);
                    parent_node.getChildren().removeAll(toRemove);
                    if (toRemove.size() > 0 && aln != null) {
                        int j = 0;
                        while (j < aln.size()) {
                            this.updateNode(nt, aln.get(j), false);
                            parent_node.getChildren().remove(aln.get(j));
                            ++j;
                        }
                    }
                }
                return true;
            }
            case 8: {
                return false;
            }
        }
        return false;
    }

    public StringBuilder getAllText() {
        StringBuilder builder = new StringBuilder();
        Iterator<NodeText> nodeTexts = this.getRootTag().allSubNodeTexts();
        while (nodeTexts.hasNext()) {
            builder.append(nodeTexts.next());
        }
        return builder;
    }

    public GenericComparator getComparator() {
        return this.comp;
    }

    public Properties getGeneratedInfoProperties() {
        return this.genInfoProperties;
    }

    public String getMSPName() {
        HashSet<String> result = new HashSet<String>();
        this.nrt.mspName(result, true);
        if (result.size() > 0) {
            return result.iterator().next();
        }
        return null;
    }

    public int getNbTag() {
        return this.nbTag;
    }

    public HashSet<String> getMSPnames() {
        HashSet<String> result = new HashSet<String>();
        this.nrt.mspName(result, false);
        return result;
    }

    public NodeRootTag getRootTag() {
        return this.nrt;
    }

    public ArrayList<Node> getTreeNodesWithParam() {
        return this.treeNodesWithParam;
    }

    public void initializeArrays() {
        this.treeNodesWithParam = new ArrayList();
        this.initializeNodes(this.getRootTag().getChildren());
    }

    private void initializeNodes(ArrayList<Node> nodes) {
        for (Node node : nodes) {
            if (!node.isNodeTag()) continue;
            NodeTag nodeTag = (NodeTag)node;
            this.initializeNodes(nodeTag.getChildren());
            this.terminateTag(nodeTag);
        }
    }

    protected NodeRootTag instanciateNodeRootTag() {
        return new NodeRootTag(this);
    }

    public NodeTag instanciateNodeTag() {
        return new NodeTag();
    }

    protected NodeText instanciateCarriageReturn(String carriageReturn) {
        return new SpecialNodeText();
    }

    public boolean isGroupingPossibleFor(NodeTag node) {
        return true;
    }

    protected boolean isMerge() {
        return this.merge;
    }

    protected void setMerge(boolean b) {
        this.merge = b;
    }

    public String publish(NodeTreePublication ntp) {
        ntp.visit(this);
        return ntp.getText();
    }

    public IGeneratedInfo convertToGeneratedInfo(NodeTreeConverter ntc) {
        ntc.visit(this);
        return ntc.getGeneratedInfo();
    }

    private void processNodeAndHisBrothers(NodeTag insert_node, NodeTag read_node, ArrayList<NodeTag> toRemove) {
        if (!insert_node.getName().equals(read_node.getName())) {
            NodeTag parent_node = read_node.getParentNode();
            int i = parent_node.getChildren().indexOf(read_node);
            while (i < parent_node.getChildren().size()) {
                NodeTag nt;
                if (parent_node.getChildren().get(i).isNodeTag() && !(nt = (NodeTag)parent_node.getChildren().get(i)).isFixedTag()) {
                    if (!this.getComparator().isChildOfNode(insert_node, nt)) break;
                    this.updateNode(insert_node, nt, false);
                    toRemove.add(nt);
                }
                ++i;
            }
        }
    }

    private void searchNodesToReplace(NodeTag insert_node, NodeTag parent_node, ArrayList<NodeTag> toRemovea, ArrayList<NodeTag> toUpdate) {
        ArrayList<NodeTag> toRemove = new ArrayList<NodeTag>();
        ArrayList<Node> nodes = parent_node.getChildren();
        int i = 1;
        while (i < nodes.size()) {
            if (nodes.get(i).isNodeTag()) {
                NodeTag nt = (NodeTag)nodes.get(i);
                if (!nt.isFixedTag() && this.getComparator().isAReplacedNode(insert_node, nt)) {
                    toUpdate.add(nt);
                    toRemove.add(nt);
                } else {
                    this.searchNodesToReplace(insert_node, nt, toRemove, toUpdate);
                }
            }
            ++i;
        }
        parent_node.getChildren().removeAll(toRemove);
    }

    public NodeTag searchNodeInTree(NodeTag parent_node, NodeTag node_Ref) {
        Iterator<Node> it = parent_node.getChildren().iterator();
        int cste = 0;
        boolean searchOK = false;
        NodeTag read_Node = null;
        while (it.hasNext() && !searchOK) {
            Node node = it.next();
            if (!node.isNodeTag()) continue;
            read_Node = (NodeTag)node;
            NodeTag previousNode = (NodeTag)read_Node.getPreviousSiblingWithoutSNT();
            cste = previousNode == null || previousNode.isNodeText() ? this.getComparator().compare(null, read_Node, node_Ref) : this.getComparator().compare(previousNode, read_Node, node_Ref);
            if (cste == 7) {
                return this.searchNodeInTree(previousNode, node_Ref);
            }
            if (cste == 8) continue;
            return previousNode;
        }
        if (!searchOK) {
            if (read_Node != null) {
                return this.searchNodeInTree(read_Node, node_Ref);
            }
            return null;
        }
        return null;
    }

    public void updateNode(NodeTag parent_node, NodeTag insert_node, boolean insertAfter) {
        if (insertAfter) {
            parent_node.getParentNode().addSonAfter(insert_node, parent_node);
        } else {
            boolean endOfLoop = false;
            Iterator<Node> it = parent_node.getChildren().iterator();
            int cste = 0;
            NodeTag read_Node = null;
            boolean update = false;
            while (it.hasNext() && !update) {
                Node node = it.next();
                if (!node.isNodeTag()) continue;
                read_Node = (NodeTag)node;
                Node previousNode = read_Node.getPreviousSiblingWithoutSNT();
                cste = previousNode == null || previousNode.isNodeText() ? this.getComparator().compare(null, read_Node, insert_node) : this.getComparator().compare((NodeTag)previousNode, read_Node, insert_node);
                update = this.doUpdateAccordingConstant(read_Node, insert_node, cste, endOfLoop);
            }
            if (!update) {
                if (parent_node.getChildren().isEmpty() || read_Node == null) {
                    parent_node.addSon(insert_node);
                } else {
                    endOfLoop = true;
                    cste = this.getComparator().compare(read_Node, null, insert_node);
                    this.doUpdateAccordingConstant(read_Node, insert_node, cste, endOfLoop);
                }
            }
        }
    }

    public void regroupTag(ArrayList<NodeTag> nts) {
    }

    public void removeNodeTagAndHisChildrenInEdition(ArrayList<NodeTag> alNT) {
        int indice = 0;
        int i = 0;
        while (i < alNT.size()) {
            if (alNT.get(i).getParentNode().removeNodeTagAndHisChildren(alNT.get(i))) {
                ++indice;
            }
            ++i;
        }
        if (indice > 0) {
            this.clean(false);
        }
    }

    public void removeNodeTagAndHisChildrenInEdition(NodeTag node) {
        if (node.getParentNode().removeNodeTagAndHisChildren(node)) {
            this.clean(false);
        }
    }

    public void removeNodeTagOnlyInEdition(NodeTag node) {
        if (node.getParentNode().removeNodeTagOnly(node)) {
            this.clean(false);
        }
    }

    public void setComparator(GenericComparator comparator) {
        this.comp = comparator;
    }

    protected void terminateTag(NodeTag node) {
    }

    public void setRootTag(NodeRootTag node) {
        this.nrt = node;
    }

    public void verifyIndices() {
        this.isDirty = false;
        Iterator<NodeText> nodeTexts = this.getRootTag().allSubNodeTexts();
        int index = 0;
        while (nodeTexts.hasNext()) {
            NodeText nt = nodeTexts.next();
            if (nt.getBeginIndex() != index) {
                nt.setBeginIndex(index);
            }
            index += nt.getContent().length();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void visit(IGeneratedTag tag, String allText) {
        block8: {
            nodeAtBeginning = this.currentNode;
            if (this.nrt == null) {
                this.nrt = this.instanciateNodeRootTag();
                this.currentNode = this.nrt;
            } else {
                this.currentNode = this.instanciateNodeTag();
                this.currentNode.setFixedTag(false);
                nodeAtBeginning.addSon(this.currentNode);
            }
            this.currentNode.setProperties(NodeTree.TagProperties(tag));
            this.currentNode.setName(tag.getName());
            this.currentIndex = tag.getBeginIndex();
            it = tag.sons();
            if (it.hasNext()) ** GOTO lbl33
            if (this.currentNode instanceof NodeRootTag) break block8;
            text = new NodeText();
            ++this.nbTag;
            if (tag.getGeneratedInfo().getText().toString().trim().length() <= 0) break block8;
            text.setInitContent(tag.getGeneratedInfo().getText().subSequence(tag.getBeginIndex(), tag.getEndIndex()).toString());
            text.setBeginIndex(this.currentIndex);
            this.currentIndex = tag.getEndIndex();
            this.currentNode.addSon(text);
            break block8;
lbl-1000:
            // 1 sources

            {
                childTag = (IGeneratedTag)it.next();
                if (this.currentIndex < childTag.getBeginIndex()) {
                    tmpContent = allText.substring(this.currentIndex, childTag.getBeginIndex());
                    text = "\r\n".equals(tmpContent) != false || "\n".equals(tmpContent) != false || "\r".equals(tmpContent) != false ? this.instanciateCarriageReturn(tmpContent) : new NodeText();
                    text.setInitContent(tmpContent);
                    text.setBeginIndex(this.currentIndex);
                    this.currentNode.addSon(text);
                    this.currentIndex = childTag.getBeginIndex();
                }
                this.visit(childTag, allText);
                this.currentIndex = childTag.getEndIndex();
lbl33:
                // 2 sources

                ** while (it.hasNext())
            }
lbl34:
            // 1 sources

            if (this.currentIndex < tag.getEndIndex()) {
                tmpContent = allText.substring(this.currentIndex, tag.getEndIndex());
                text = "\r\n".equals(tmpContent) != false || "\n".equals(tmpContent) != false || "\r".equals(tmpContent) != false ? this.instanciateCarriageReturn(tmpContent) : new NodeText();
                text.setInitContent(tmpContent);
                text.setBeginIndex(this.currentIndex);
                this.currentIndex = tag.getEndIndex();
                this.currentNode.addSon(text);
            }
        }
        this.terminateTag(this.currentNode);
        this.currentNode = nodeAtBeginning;
    }

    private static Properties TagProperties(IGeneratedTag tag) {
        Iterator names = tag.propertyNames();
        Properties p = new Properties();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (name.equals("msp")) {
                p.put(name, tag.getProperty(name).trim());
                continue;
            }
            p.put(name, tag.getProperty(name));
        }
        return p;
    }

    private static Properties TagGenInfoProperties(IGeneratedInfo genInfo) {
        Iterator names = genInfo.propertyNames();
        Properties p = new Properties();
        while (names.hasNext()) {
            String name = (String)names.next();
            p.put(name, genInfo.getProperty(name));
        }
        return p;
    }
}

