/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.merge;

import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeTreeVisitor;
import com.ibm.pdp.macro.common.merge.SpecialNodeText;

public class NodeText
extends Node {
    private String content;
    private int beginIndex;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public void accept(NodeTreeVisitor ntVisitor) {
        ntVisitor.visit(this);
    }

    public void append(String text) {
        this.setInitContent(this.getContent() + text);
        if (text.length() != 0) {
            this.propagateIndexModifications(text.length());
        }
    }

    @Override
    public boolean containsTag(String sort, String name) {
        Node tmpNode = this.getNextSibling();
        if (tmpNode != null) {
            return tmpNode.containsTag(sort, name);
        }
        return false;
    }

    @Override
    public NodeTag findTag(String sort, String name) {
        Node tmpNode = this.getNextSibling();
        if (tmpNode != null) {
            return tmpNode.findTag(sort, name);
        }
        return null;
    }

    public int getBeginIndex() {
        if (this.parentNode != null && this.parentNode.getNodeTree().isDirty && !this.parentNode.getNodeTree().isMerge()) {
            this.getNodeTree().verifyIndices();
        }
        return this.beginIndex;
    }

    public String getContent() {
        return this.content;
    }

    public int getEndIndex() {
        if (this.parentNode != null && this.parentNode.getNodeTree().isDirty && !this.parentNode.getNodeTree().isMerge()) {
            this.getNodeTree().verifyIndices();
        }
        return this.beginIndex + this.content.length();
    }

    public NodeText getPreviousNodeText() {
        NodeText node = this.previousNodeText();
        while (node != null) {
            if (!(node instanceof SpecialNodeText) && node.getParentNode().getMSPName() != null) {
                return node;
            }
            node = node.previousNodeText();
        }
        return null;
    }

    @Override
    public boolean isNodeTag() {
        return false;
    }

    @Override
    public boolean isNodeText() {
        return true;
    }

    @Override
    public void lineFeedManagement() {
        Node next;
        String s = this.getContent();
        int startOffset = 0;
        int stopOffset = s.length();
        int winShift = "\r\n".length();
        int unixShift = "\n".length();
        while (s.startsWith("\r\n", startOffset)) {
            startOffset += winShift;
        }
        while (s.startsWith("\n", startOffset)) {
            startOffset += unixShift;
        }
        while (s.startsWith("\r\n", stopOffset - winShift)) {
            stopOffset -= winShift;
        }
        while (s.startsWith("\n", stopOffset - unixShift)) {
            stopOffset -= unixShift;
        }
        if ((startOffset > 0 || stopOffset < this.content.length()) && startOffset <= stopOffset) {
            this.content = s.substring(startOffset, stopOffset);
        }
        if ((next = this.getNextSibling()) != null) {
            next.lineFeedManagement();
        }
    }

    @Override
    public void lineFeedManagementWithoutSNT() {
        Node next;
        if (this.getContent().length() > 0 && !this.getContent().endsWith("\r\n")) {
            NodeText nodeText = this.nextNodeText();
            while (nodeText != null) {
                if (nodeText.getContent().trim().length() > 0) {
                    this.setInitContent(this.getContent() + "\r\n");
                    break;
                }
                nodeText = nodeText.nextNodeText();
            }
        }
        if ((next = this.getNextSibling()) != null) {
            next.lineFeedManagementWithoutSNT();
        }
    }

    protected void propagateIndexModifications(int indexModification) {
        if (!this.parentNode.getNodeTree().isMerge()) {
            this.getNodeTree().isDirty = true;
        } else {
            NodeText nodeText = this.nextNodeText();
            while (nodeText != null) {
                nodeText.setBeginIndex(nodeText.getBeginIndex() + indexModification);
                nodeText = nodeText.nextNodeText();
            }
        }
    }

    @Override
    public boolean removeNodeTagAndHisChildren(Node node) {
        Node tmpNode = this.getNextSibling();
        if (tmpNode != null) {
            return tmpNode.removeNodeTagAndHisChildren(node);
        }
        return false;
    }

    @Override
    public boolean removeNodeTagOnly(Node node) {
        Node tmpNode = this.getNextSibling();
        if (tmpNode != null) {
            return tmpNode.removeNodeTagOnly(node);
        }
        return false;
    }

    public void setBeginIndex(int beginIndex) {
        this.beginIndex = beginIndex;
    }

    public void setInitContent(String newContent) {
        this.content = newContent;
    }

    public void setModifyContent(String newContent) {
        int contentLengthBefore = this.getContent().length();
        this.content = newContent;
        if (newContent.length() - contentLengthBefore != 0) {
            this.propagateIndexModifications(newContent.length() - contentLengthBefore);
        }
    }

    public String toString() {
        return this.getContent();
    }
}

