/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.merge;

import com.ibm.pdp.macro.common.merge.FilteredSubNodeIter;
import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeList;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.common.merge.NodeTreeCollect;
import com.ibm.pdp.macro.common.merge.NodeTreeVisitor;
import com.ibm.pdp.macro.common.merge.SpecialNodeText;
import com.ibm.pdp.util.FilterPredicate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class NodeTag
extends Node
implements Cloneable {
    private ArrayList<Node> children = this.newChildrenList(2);
    private String name;
    private Properties properties;
    private boolean fixedTag;
    public static final FilterPredicate<Node> NodeTextOnlyFilter = new FilterPredicate<Node>(){

        public boolean accept(Node node) {
            return node instanceof NodeText;
        }
    };
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public NodeTag() {
    }

    public NodeTag(String content) {
        NodeText nt = new NodeText();
        nt.setInitContent(content);
        this.addSon(nt);
    }

    protected ArrayList<Node> newChildrenList(int initialCapacity) {
        return new NodeList(initialCapacity);
    }

    @Override
    public void accept(NodeTreeVisitor ntVisitor) {
        ntVisitor.visit(this);
    }

    private void addAllNodeTexts(Node node, ArrayList<NodeText> al) {
        if (node.isNodeText()) {
            al.add((NodeText)node);
        } else {
            NodeTag nt = (NodeTag)node;
            int i = 0;
            while (i < nt.getChildren().size()) {
                this.addAllNodeTexts(nt.getChildren().get(i), al);
                ++i;
            }
        }
    }

    private void addNodeText(Node node, ArrayList<NodeText> al, boolean onlyNodeTextFromMacro) {
        block4: {
            block2: {
                block3: {
                    if (!node.isNodeText()) break block2;
                    if (node instanceof SpecialNodeText || !onlyNodeTextFromMacro && ((NodeText)node).getContent().length() == 0) {
                        return;
                    }
                    if (onlyNodeTextFromMacro) break block3;
                    al.add((NodeText)node);
                    break block4;
                }
                if (node.getParentNode().getMSPName() == null) break block4;
                al.add((NodeText)node);
                break block4;
            }
            NodeTag nt = (NodeTag)node;
            int i = 0;
            while (i < nt.getChildren().size()) {
                this.addNodeText(nt.getChildren().get(i), al, onlyNodeTextFromMacro);
                ++i;
            }
        }
    }

    public void addSon(Node son) {
        son.setParentNode(this);
        this.getChildren().add(son);
    }

    public void addSonAfter(Node insert_son, Node son) {
        if (this.children.isEmpty()) {
            this.addSon(insert_son);
        } else {
            insert_son.setParentNode(this);
            this.children.add(this.children.indexOf(son) + 1, insert_son);
        }
    }

    public void addSonBefore(Node insert_son, Node son) {
        if (this.children.isEmpty()) {
            this.addSon(insert_son);
        } else {
            insert_son.setParentNode(this);
            this.children.add(this.children.indexOf(son), insert_son);
        }
    }

    @Override
    public Object clone() {
        NodeTag clone = null;
        clone = (NodeTag)super.clone();
        ArrayList<Node> cloneAR = this.newChildrenList(this.getChildren().size());
        clone.setChildren(cloneAR);
        if (this.properties != null) {
            this.setProperties((Properties)this.properties.clone());
        }
        Iterator<Node> it = this.getChildren().iterator();
        while (it.hasNext()) {
            Node n = (Node)it.next().clone();
            n.setParentNode(clone);
            cloneAR.add(n);
        }
        return clone;
    }

    @Override
    public boolean containsTag(String sort, String name) {
        for (Node node : this.getChildren()) {
            NodeTag nodetag;
            String currentProp;
            if (!(node instanceof NodeTag) || (currentProp = (nodetag = (NodeTag)node).getProperty("sort")) == null || !sort.equals(currentProp)) continue;
            if (name != null) {
                if (!name.equals(nodetag.getName())) continue;
                return true;
            }
            return true;
        }
        Node currentNode = this.getFirstNode();
        if (currentNode != null && currentNode.containsTag(sort, name)) {
            return true;
        }
        currentNode = this.getNextSibling();
        return currentNode != null && currentNode.containsTag(sort, name);
    }

    public boolean containsText() {
        Iterator<NodeText> it = this.getNodeTexts(false).iterator();
        boolean noText = true;
        while (noText && it.hasNext()) {
            boolean bl = noText = it.next().getContent().length() == 0;
        }
        return !noText;
    }

    @Override
    public NodeTag findTag(String sort, String name) {
        NodeTag nt;
        for (Node node : this.getChildren()) {
            String currentProp;
            if (!(node instanceof NodeTag) || (currentProp = ((NodeTag)node).getProperty("sort")) == null || !sort.equals(currentProp)) continue;
            return (NodeTag)node;
        }
        Node currentNode = this.getFirstNode();
        if (currentNode != null && (nt = currentNode.findTag(sort, name)) != null) {
            return nt;
        }
        currentNode = this.getNextSibling();
        if (currentNode != null && (nt = currentNode.findTag(sort, name)) != null) {
            return nt;
        }
        return null;
    }

    public ArrayList<Node> getChildren() {
        return this.children;
    }

    public ArrayList<Node> getChildren(int selectedNodes) {
        NodeTreeCollect ntc = new NodeTreeCollect(selectedNodes);
        this.accept(ntc);
        return ntc.getChildrenSelected();
    }

    void mspName(Set<String> allNames, boolean firstOccurrenceOnly) {
        if (this.getMSPName() != null) {
            allNames.add(this.getMSPName());
            if (firstOccurrenceOnly) {
                return;
            }
        }
        Node n = this.getNextSibling();
        while (n != null && !(n instanceof NodeTag)) {
            n = n.getNextSibling();
        }
        if (n != null) {
            ((NodeTag)n).mspName(allNames, firstOccurrenceOnly);
        }
        if ((n = this.getFirstNodeTag()) != null) {
            ((NodeTag)n).mspName(allNames, firstOccurrenceOnly);
        }
    }

    public String getMSPName() {
        return this.getProperty("msp");
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<NodeText> getAllNodeTexts() {
        ArrayList<NodeText> nodeTexts = new ArrayList<NodeText>();
        int i = 0;
        while (i < this.getChildren().size()) {
            this.addAllNodeTexts(this.getChildren().get(i), nodeTexts);
            ++i;
        }
        return nodeTexts;
    }

    public Iterator<NodeText> allSubNodeTexts() {
        return new FilteredSubNodeIter<Node>(this, false, NodeTextOnlyFilter);
    }

    public Iterator<Node> allSubNodes(FilterPredicate<? super Node> filter) {
        return new FilteredSubNodeIter<Node>(this, false, filter);
    }

    public ArrayList<NodeText> getNodeTexts(boolean onlyNodeTextFromMacro) {
        ArrayList<NodeText> nodeTexts = new ArrayList<NodeText>();
        int i = 0;
        while (i < this.getChildren().size()) {
            this.addNodeText(this.getChildren().get(i), nodeTexts, onlyNodeTextFromMacro);
            ++i;
        }
        return nodeTexts;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String property) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties.getProperty(property);
    }

    public Node getFirstNode() {
        if (this.getChildren().isEmpty()) {
            return null;
        }
        Node node = this.getChildren().get(0);
        return node;
    }

    public NodeTag getFirstNodeTag() {
        int i = 0;
        while (i < this.getChildren().size()) {
            Node node = this.getChildren().get(i);
            if (node.isNodeTag()) {
                return (NodeTag)node;
            }
            ++i;
        }
        return null;
    }

    public NodeText getFirstNodeText() {
        int i = 0;
        if (i < this.getChildren().size()) {
            Node node = this.getChildren().get(i);
            if (node.isNodeText()) {
                return (NodeText)node;
            }
            return ((NodeTag)node).getFirstNodeText();
        }
        return null;
    }

    public Node getLastNode() {
        if (this.getChildren().isEmpty()) {
            return this;
        }
        Node node = this.getChildren().get(this.getChildren().size() - 1);
        if (node.isNodeText()) {
            return (NodeText)node;
        }
        return ((NodeTag)node).getLastNode();
    }

    public NodeTag getLastNodeTag() {
        int i = this.getChildren().size() - 1;
        if (i >= 0) {
            Node node = this.getChildren().get(i);
            if (node.isNodeText()) {
                return this;
            }
            return ((NodeTag)node).getLastNodeTag();
        }
        return null;
    }

    public NodeText getLastNodeText() {
        int i = this.getChildren().size() - 1;
        if (i >= 0) {
            Node node = this.getChildren().get(i);
            if (node.isNodeText()) {
                return (NodeText)node;
            }
            return ((NodeTag)node).getLastNodeText();
        }
        return null;
    }

    public NodeText getNodeText() {
        if (this.getChildren().isEmpty()) {
            return null;
        }
        if (this.getChildren().get(0).isNodeText()) {
            return (NodeText)this.getChildren().get(0);
        }
        return null;
    }

    public boolean hasChildrenNodeTag() {
        int i = 0;
        while (i < this.getChildren().size()) {
            Node node = this.getChildren().get(i);
            if (node.isNodeTag()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isNodeTag() {
        return true;
    }

    @Override
    public boolean isNodeText() {
        return false;
    }

    public boolean isFixedTag() {
        return this.fixedTag;
    }

    @Override
    public void lineFeedManagement() {
        Node next = this.getFirstNode();
        if (next != null) {
            next.lineFeedManagement();
        }
        if ((next = this.getNextSibling()) != null) {
            next.lineFeedManagement();
        }
    }

    @Override
    public void lineFeedManagementWithoutSNT() {
        Node next = this.getFirstNode();
        if (next != null) {
            next.lineFeedManagementWithoutSNT();
        }
        if ((next = this.getNextSibling()) != null) {
            next.lineFeedManagementWithoutSNT();
        }
    }

    @Override
    public boolean removeNodeTagAndHisChildren(Node node) {
        if (this.getChildren().remove(node)) {
            node.setParentNode(null);
            if (this.getNodeTree() != null) {
                this.getNodeTree().verifyIndices();
            }
            return true;
        }
        Node currentNode = this.getFirstNode();
        if (currentNode != null && currentNode.removeNodeTagAndHisChildren(node)) {
            return true;
        }
        currentNode = this.getNextSibling();
        return currentNode != null && currentNode.removeNodeTagAndHisChildren(node);
    }

    @Override
    public boolean removeNodeTagOnly(Node node) {
        if (this.getChildren().contains(node)) {
            if (node instanceof NodeText) {
                this.getChildren().remove(node);
            } else {
                ArrayList<Node> childrenOfNode = ((NodeTag)node).getChildren();
                int index = this.getChildren().indexOf(node);
                this.getChildren().remove(node);
                Iterator<Node> itNodes = childrenOfNode.iterator();
                while (itNodes.hasNext()) {
                    itNodes.next().setParentNode(this);
                }
                this.getChildren().addAll(index, childrenOfNode);
            }
            node.setParentNode(null);
            if (this.getNodeTree() != null) {
                this.getNodeTree().verifyIndices();
            }
            return true;
        }
        Node currentNode = this.getFirstNode();
        if (currentNode != null && currentNode.removeNodeTagOnly(node)) {
            return true;
        }
        currentNode = this.getNextSibling();
        return currentNode != null && currentNode.removeNodeTagOnly(node);
    }

    @Deprecated
    public void removeTagWithHisChildren() {
        this.getParentNode().removeNodeTagAndHisChildren(this);
    }

    public void setChildren(ArrayList<Node> children) {
        this.children = children;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setFixedTag(boolean b) {
        this.fixedTag = b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<");
        StringBuilder tagName = new StringBuilder("tag name=\"");
        tagName.append(this.getName() + "\"");
        sb.append((CharSequence)tagName);
        if (this.properties != null) {
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                sb.append(' ');
                sb.append(entry.getKey());
                sb.append("=\"");
                sb.append(entry.getValue());
                sb.append('\"');
            }
        }
        sb.append("\">");
        for (Node n : this.getChildren()) {
            sb.append(n.toString());
        }
        sb.append("</");
        sb.append((CharSequence)tagName);
        sb.append("\">");
        return sb.toString();
    }

    public Node firstSubNode() {
        return this.children.isEmpty() ? null : this.children.get(0);
    }

    public NodeText firstSubNodeText() {
        int i = 0;
        int size = this.children.size();
        while (i < size) {
            Node child = this.children.get(i);
            if (child instanceof NodeText) {
                return (NodeText)child;
            }
            NodeText firstSubText = ((NodeTag)child).firstSubNodeText();
            if (firstSubText != null) {
                return firstSubText;
            }
            ++i;
        }
        return null;
    }

    public Node lastSubNode() {
        Node lastSubNode;
        if (this.children.isEmpty()) {
            return null;
        }
        Node lastChild = this.children.get(this.children.size() - 1);
        if (lastChild instanceof NodeTag && (lastSubNode = ((NodeTag)lastChild).lastSubNode()) != null) {
            return lastSubNode;
        }
        return lastChild;
    }

    public NodeText lastSubNodeText() {
        int i = this.children.size() - 1;
        while (i >= 0) {
            Node child = this.children.get(i);
            if (child instanceof NodeText) {
                return (NodeText)child;
            }
            NodeText lastTextChild = ((NodeTag)child).lastSubNodeText();
            if (lastTextChild != null) {
                return lastTextChild;
            }
            --i;
        }
        return null;
    }

    @Override
    public Node nextNode() {
        Node firstSubNode = this.firstSubNode();
        return firstSubNode != null ? firstSubNode : super.nextNode();
    }

    @Override
    public NodeText nextNodeText() {
        NodeText firstSubNodeText = this.firstSubNodeText();
        return firstSubNodeText != null ? firstSubNodeText : super.nextNodeText();
    }
}

