/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.merge;

import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeTag;
import java.util.ArrayList;
import java.util.Collection;

public class NodeList
extends ArrayList<Node> {
    private static final long serialVersionUID = 1L;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp.2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public NodeList() {
    }

    public NodeList(int initialCapacity) {
        super(initialCapacity);
    }

    protected void refreshRanksFrom(int startIdx) {
        int i = this.size() - 1;
        while (i >= startIdx) {
            Node node = (Node)this.get(i);
            if (node.getParentNode().getChildren() == this) {
                node.rank = i;
            }
            --i;
        }
    }

    @Override
    public void add(int location, Node node) {
        node.rank = location;
        super.add(location, node);
        this.refreshRanksFrom(location + 1);
    }

    @Override
    public boolean add(Node node) {
        node.rank = this.size();
        return super.add(node);
    }

    @Override
    public boolean addAll(int location, Collection<? extends Node> collection) {
        if (!super.addAll(location, collection)) {
            return false;
        }
        this.refreshRanksFrom(location);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Node> collection) {
        int oldSize = this.size();
        boolean toReturn = super.addAll(collection);
        this.refreshRanksFrom(oldSize);
        return toReturn;
    }

    @Override
    public boolean contains(Object object) {
        NodeTag parent = ((Node)object).getParentNode();
        if (parent != null && parent.getChildren() == this) {
            return true;
        }
        return super.contains(object);
    }

    @Override
    public int indexOf(Object object) {
        Node node = (Node)object;
        if (node.getParentNode().getChildren() == this) {
            return node.rank;
        }
        return super.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public Node remove(int location) {
        Node removed = (Node)super.remove(location);
        this.refreshRanksFrom(location);
        return removed;
    }

    @Override
    protected void removeRange(int start, int end) {
        super.removeRange(start, end);
        this.refreshRanksFrom(start);
    }

    @Override
    public Node set(int location, Node node) {
        node.rank = location;
        return super.set(location, node);
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int shift = 0;
        int size = this.size();
        int i = 0;
        while (i < size) {
            Node n = (Node)this.get(i);
            if (c.contains(n)) {
                ++shift;
            } else if (shift > 0) {
                this.set(i - shift, n);
            }
            ++i;
        }
        if (shift == 0) {
            return false;
        }
        super.removeRange(size - shift, size);
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int shift = 0;
        int size = this.size();
        int i = 0;
        while (i < size) {
            Node n = (Node)this.get(i);
            if (!c.contains(n)) {
                ++shift;
            } else if (shift > 0) {
                this.set(i - shift, n);
            }
            ++i;
        }
        if (shift == 0) {
            return false;
        }
        super.removeRange(size - shift, size);
        return true;
    }
}

