/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.merge;

import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.common.merge.NodeTree;
import com.ibm.pdp.macro.common.merge.NodeTreeVisitor;
import com.ibm.pdp.macro.common.merge.SpecialNodeText;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;

public abstract class Node
implements Cloneable {
    protected NodeTag parentNode;
    protected int rank = -1;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void accept(NodeTreeVisitor ntVisitor) {
        ntVisitor.visit(this);
    }

    public Object clone() {
        Node clone = null;
        try {
            clone = (Node)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            Util.rethrow((Throwable)cnse);
        }
        return clone;
    }

    public abstract boolean containsTag(String var1, String var2);

    public abstract NodeTag findTag(String var1, String var2);

    public Node getNextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        ArrayList<Node> siblings = this.parentNode.getChildren();
        int nextRank = siblings.indexOf(this) + 1;
        return nextRank < siblings.size() ? (Node)siblings.get(nextRank) : null;
    }

    public Node getNextSiblingWithoutSNT() {
        Node nextSibling = this.getNextSibling();
        while (nextSibling instanceof SpecialNodeText) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }

    public NodeTree getNodeTree() {
        return this.parentNode != null ? this.parentNode.getNodeTree() : null;
    }

    public NodeTag getParentNode() {
        return this.parentNode;
    }

    public Node getPreviousSibling() {
        if (this.parentNode == null) {
            return null;
        }
        ArrayList<Node> siblings = this.parentNode.getChildren();
        int previousRank = siblings.indexOf(this) - 1;
        return previousRank >= 0 ? (Node)siblings.get(previousRank) : null;
    }

    public Node getPreviousSiblingWithoutSNT() {
        Node previousSibling = this.getPreviousSibling();
        while (previousSibling instanceof SpecialNodeText) {
            previousSibling = previousSibling.getPreviousSibling();
        }
        return previousSibling;
    }

    public abstract boolean isNodeTag();

    public abstract boolean isNodeText();

    public abstract void lineFeedManagement();

    public abstract void lineFeedManagementWithoutSNT();

    public abstract boolean removeNodeTagAndHisChildren(Node var1);

    public abstract boolean removeNodeTagOnly(Node var1);

    public void setParentNode(NodeTag parentNode) {
        this.parentNode = parentNode;
    }

    public Node nextNode() {
        Node node = this;
        NodeTag parent = this.parentNode;
        while (parent != null) {
            ArrayList<Node> siblings = parent.getChildren();
            int nextRank = siblings.indexOf(node) + 1;
            if (nextRank < siblings.size()) {
                return (Node)siblings.get(nextRank);
            }
            node = parent;
            parent = parent.getParentNode();
        }
        return null;
    }

    public NodeText nextNodeText() {
        Node node = this;
        NodeTag parent = this.parentNode;
        while (parent != null) {
            ArrayList<Node> siblings = parent.getChildren();
            int i = siblings.indexOf(node) + 1;
            int size = siblings.size();
            while (i < size) {
                Node foundNode = (Node)siblings.get(i);
                if (foundNode instanceof NodeText) {
                    return (NodeText)foundNode;
                }
                NodeText foundNodeText = ((NodeTag)foundNode).firstSubNodeText();
                if (foundNodeText != null) {
                    return foundNodeText;
                }
                ++i;
            }
            node = parent;
            parent = parent.getParentNode();
        }
        return null;
    }

    public Node previousNode() {
        Node previousSibling = this.getPreviousSibling();
        if (previousSibling == null) {
            return this.parentNode;
        }
        if (previousSibling instanceof NodeTag) {
            return ((NodeTag)previousSibling).lastSubNode();
        }
        return previousSibling;
    }

    public NodeText previousNodeText() {
        Node node = this;
        NodeTag parent = this.parentNode;
        while (parent != null) {
            ArrayList<Node> siblings = parent.getChildren();
            int i = siblings.indexOf(node) - 1;
            while (i >= 0) {
                Node previousSibling = (Node)siblings.get(i);
                if (previousSibling instanceof NodeText) {
                    return (NodeText)previousSibling;
                }
                NodeText previousSubNodeText = ((NodeTag)previousSibling).lastSubNodeText();
                if (previousSubNodeText != null) {
                    return previousSubNodeText;
                }
                --i;
            }
            node = parent;
            parent = parent.getParentNode();
        }
        return null;
    }
}

