/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common.action;

import com.ibm.pdp.macro.common.MacroTool;
import com.ibm.pdp.macro.common.interfaces.IMerge;
import com.ibm.pdp.macro.common.interfaces.ISkeleton;
import com.ibm.pdp.macro.common.merge.NodeTree;
import com.ibm.pdp.macro.common.views.TagsTreeView;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IViewPart;

public class SkeletonAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ISkeleton _skeleton;

    public SkeletonAction(ISkeleton skeleton) {
        this._skeleton = skeleton;
    }

    public ISkeleton getSkeleton() {
        return this._skeleton;
    }

    public static void mergeNodeTrees(ISkeleton skeleton) {
        ArrayList<NodeTree> nTrees = new ArrayList<NodeTree>();
        NodeTree macroTree = skeleton.getMacroNodeTree(SkeletonAction.getView().getAssociatedEditor().getDocument().get(), SkeletonAction.getView().getControler().getResourceName());
        NodeTree skeletonTree = skeleton.getModelSkeleton();
        SkeletonAction.getView().getControler().setSkeleton(skeletonTree);
        SkeletonAction.getView().getControler().setSelectedModel(skeleton.getModel());
        if (skeletonTree != null) {
            Properties properties = new Properties();
            properties.setProperty("model", "skeleton");
            skeletonTree.getRootTag().setProperties(properties);
            skeletonTree.setComparator(skeleton.getComparator());
            macroTree.setComparator(skeleton.getComparator());
            nTrees.add(macroTree);
            IMerge merge = skeleton.getMerge();
            macroTree = merge.mergeFromTrees(skeletonTree, nTrees);
            if (macroTree.getAllText().toString().trim().equals(SkeletonAction.getView().getAssociatedEditor().getDocument().get().trim())) {
                SkeletonAction.getView().getControler().getEditorLink().setEditorDesynchronized(false);
            } else {
                SkeletonAction.getView().getControler().getEditorLink().setEditorDesynchronized(true);
            }
        }
        SkeletonAction.getView().getControler().setNodeTree(macroTree);
        SkeletonAction.getView().setNodeTree(macroTree);
        SkeletonAction.getView().update();
    }

    private static TagsTreeView getView() {
        TagsTreeView view = null;
        IViewPart viewPart = MacroTool.findView("com.ibm.pdp.macro.common.views.TagsTreeView");
        if (viewPart instanceof TagsTreeView) {
            view = (TagsTreeView)viewPart;
        }
        return view;
    }

    public void run() {
        SkeletonAction.mergeNodeTrees(this._skeleton);
        this.setEnabled(false);
        this.configureEnabledItems();
    }

    private void configureEnabledItems() {
        IMenuManager barMenuMgr = SkeletonAction.getView().getViewSite().getActionBars().getMenuManager();
        IContributionItem[] items = barMenuMgr.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof MenuManager) {
                IContributionItem[] skeletonItems = ((MenuManager)items[i]).getItems();
                int j = 0;
                while (j < skeletonItems.length) {
                    SkeletonAction skelAction;
                    IAction action;
                    if (skeletonItems[j] instanceof ActionContributionItem && (action = ((ActionContributionItem)skeletonItems[j]).getAction()) instanceof SkeletonAction && !((Object)((Object)(skelAction = (SkeletonAction)action))).equals((Object)this)) {
                        skelAction.setEnabled(true);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (SkeletonAction.getView() != null) {
            SkeletonAction.getView().getControler().setSelectedModel(this._skeleton.getModel());
        }
    }
}

