/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common;

import com.ibm.pdp.macro.common.Controler;
import com.ibm.pdp.macro.common.ControlerFactory;
import com.ibm.pdp.macro.common.MacroTool;
import com.ibm.pdp.macro.common.interfaces.IControler;
import com.ibm.pdp.macro.common.interfaces.IEditor;
import com.ibm.pdp.macro.common.interfaces.IEditorLink;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.common.merge.NodeTree;
import com.ibm.pdp.macro.common.views.TagsTreeView;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class EditorLink
implements IEditorLink,
IDocumentListener {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Controler _controler;
    private List<IEditor> _editors;
    private IEditor _editor;
    private TagsTreeView _structureView;
    private ILabelProvider _labelProvider;
    private boolean _listensToDocumentEvent = true;
    private boolean _isEditorDesynchronized = false;
    private NodeTree nodeTree;

    public EditorLink(Controler aControler) {
        this._controler = aControler;
        this._editors = new ArrayList<IEditor>();
    }

    public void documentAboutToBeChanged(DocumentEvent arg0) {
    }

    public void documentChanged(DocumentEvent event) {
        if (!this._listensToDocumentEvent) {
            return;
        }
        if (this._editor != null) {
            this._editor.updateNodeTree(event);
            if (this._structureView != null && !this._structureView.getTreeViewer().getControl().isDisposed()) {
                this._structureView.setNodeTree(this.getControler().getNodeTree());
                this._structureView.update();
            }
        }
    }

    @Override
    public IControler getControler() {
        return this._controler;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this._labelProvider;
    }

    @Override
    public NodeTree getNewNodeTree() {
        return this.nodeTree;
    }

    @Override
    public TagsTreeView getStructuredView() {
        return this._structureView;
    }

    @Override
    public boolean isEditorDesynchronized() {
        return this._isEditorDesynchronized;
    }

    @Override
    public void addEditor(IEditor editor) {
        if (this._editors.size() == 0) {
            editor.getDocument().addDocumentListener((IDocumentListener)this);
        }
        this._editors.add(editor);
        this.tryToOpenTagsTreeView();
    }

    @Override
    public void removeEditor(IEditor editor) {
        try {
            this._editors.remove(editor);
            if (this._editors.size() == 0) {
                editor.getDocument().removeDocumentListener((IDocumentListener)this);
                if (this._structureView != null) {
                    this._structureView.setControler(this._controler, editor, false);
                }
            }
        }
        catch (Exception e) {
            ControlerFactory.getInstance().dispose(this._controler);
            Util.rethrow((Throwable)e);
        }
        if (this._editors.size() == 0) {
            ControlerFactory.getInstance().dispose(this._controler);
        }
    }

    @Override
    public void editorIsTakingFocus(IEditor editor) {
        this._editor = editor;
        this.findTagsTreeView();
        if (this._structureView == null) {
            return;
        }
        if (this._structureView.getControler() != this._controler && editor != this._structureView.getAssociatedEditor()) {
            this._structureView.setControler(this._controler, editor, true);
        }
        this._structureView.update();
    }

    @Override
    public int numberOfIEditorOpened() {
        return 0;
    }

    private void findTagsTreeView() {
        IViewPart viewPart = MacroTool.findView("com.ibm.pdp.macro.common.views.TagsTreeView");
        if (viewPart instanceof TagsTreeView) {
            this._structureView = (TagsTreeView)viewPart;
        }
    }

    private void tryToOpenTagsTreeView() {
        this.findTagsTreeView();
        if (this._structureView != null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            this._structureView = null;
            return;
        }
        try {
            IViewPart viewPart = page.showView("com.ibm.pdp.macro.common.views.TagsTreeView", null, 2);
            if (viewPart == null || !(viewPart instanceof ViewPart)) {
                MacroTool.error(PlatformUI.getWorkbench().getDisplay().getActiveShell(), "Pattern Driven Programming", "Problem : Tags Tree View could not be opened");
            } else {
                this._structureView = (TagsTreeView)viewPart;
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        NodeTag firstNodeTag = null;
        NodeTag node2 = null;
        if (!sel.isEmpty()) {
            ArrayList<NodeText> nodesT;
            for (NodeTag node2 : sel) {
                if (firstNodeTag != null) continue;
                firstNodeTag = node2;
            }
            NodeTag lastNodeTag = node2;
            int start = 0;
            int stop = 0;
            NodeText nodeT = firstNodeTag.getFirstNodeText();
            if (nodeT != null) {
                start = nodeT.getBeginIndex();
            }
            if ((nodesT = lastNodeTag.getAllNodeTexts()).size() > 0) {
                nodeT = nodesT.get(nodesT.size() - 1);
            }
            if (nodeT != null) {
                stop = nodeT.getEndIndex();
                if (event.getSource() instanceof TagsTreeView) {
                    TagsTreeView ttv = (TagsTreeView)((Object)event.getSource());
                    IEditor editor = ttv.getAssociatedEditor();
                    editor.getSelectionProvider().setSelection((ISelection)new TextSelection(start, stop - start));
                }
            }
        }
    }

    @Override
    public void setLabelProvider(ILabelProvider labelProvider) {
        this._labelProvider = labelProvider;
    }

    @Override
    public void setNewNodeTree(NodeTree nodeTree) {
        this.nodeTree = nodeTree;
    }

    @Override
    public void setEditorDesynchronized(boolean isDesynchronized) {
        this._isEditorDesynchronized = isDesynchronized;
        if (this._structureView != null) {
            this._structureView.getSynchronizedAction().setEnabled(isDesynchronized);
        }
    }

    @Override
    public void setEnableListener(boolean b) {
        this._listensToDocumentEvent = b;
    }

    public void tagsTreeViewDisposed() {
        this._structureView = null;
    }
}

