/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common;

import com.ibm.pdp.macro.common.Controler;
import com.ibm.pdp.macro.common.interfaces.IControler;
import com.ibm.pdp.macro.common.interfaces.IControlerFactory;
import java.util.HashMap;
import java.util.Map;

public class ControlerFactory
implements IControlerFactory {
    private Map<String, IControler> controlers;
    private static ControlerFactory controlerFactoryUniqueInstance;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private ControlerFactory() {
    }

    public static synchronized ControlerFactory getInstance() {
        if (controlerFactoryUniqueInstance == null) {
            controlerFactoryUniqueInstance = new ControlerFactory();
            ControlerFactory.controlerFactoryUniqueInstance.controlers = new HashMap<String, IControler>();
        }
        return controlerFactoryUniqueInstance;
    }

    @Override
    public IControler getControler(String resourceName) {
        IControler c = this.controlers.get(resourceName);
        if (c == null) {
            c = new Controler(resourceName);
            this.controlers.put(resourceName, c);
        }
        return c;
    }

    void dispose(IControler controler) {
        if (this.controlers.size() == 0) {
            return;
        }
        this.controlers.remove(controler.getResourceName());
    }
}

