/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.common;

import com.ibm.pdp.macro.common.interfaces.ISkeleton;
import com.ibm.pdp.macro.common.interfaces.ITagsTreeViewAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ActionManager {
    private static final String _SKELETON_EXTENSION_POINT = "skeleton";
    private static final String _TAGSTREEVIEW_EXTENSION_POINT = "tagsTreeViewAction";
    private HashMap<ISkeleton, IConfigurationElement> _skeletonImplementors = new HashMap();
    private HashMap<ITagsTreeViewAction, IConfigurationElement> _tagsTreeViewImplementors = new HashMap();
    ArrayList<IConfigurationElement> ttvElement = new ArrayList();
    private static ActionManager _instance = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static synchronized ActionManager getInstance() {
        if (_instance == null) {
            _instance = new ActionManager();
            _instance.loadExtensionPoints(_SKELETON_EXTENSION_POINT);
            _instance.loadExtensionPoints(_TAGSTREEVIEW_EXTENSION_POINT);
        }
        return _instance;
    }

    public static HashMap<ISkeleton, IConfigurationElement> getSkeletonImplementors() {
        return ActionManager.getInstance()._skeletonImplementors;
    }

    public static HashMap<ITagsTreeViewAction, IConfigurationElement> getTagsTreeViewActionImplementors() {
        ActionManager.getInstance()._tagsTreeViewImplementors = new HashMap();
        for (IConfigurationElement element : ActionManager.getInstance().ttvElement) {
            try {
                ITagsTreeViewAction ttvActionImplementor = (ITagsTreeViewAction)element.createExecutableExtension("class");
                ActionManager.getInstance()._tagsTreeViewImplementors.put(ttvActionImplementor, element);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return ActionManager.getInstance()._tagsTreeViewImplementors;
    }

    private void loadExtensionPoints(String extensionPoint) {
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extRegistry.getExtensionPoint("com.ibm.pdp.macro.common", extensionPoint);
        if (extPoint != null) {
            IExtension[] extensions = extPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    if (configElement.getName().equals(extensionPoint)) {
                        this.processConfigElement(configElement);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void processConfigElement(IConfigurationElement element) {
        try {
            if (element.getName().equals(_SKELETON_EXTENSION_POINT)) {
                ISkeleton skeletonImplementor = (ISkeleton)element.createExecutableExtension("class");
                this._skeletonImplementors.put(skeletonImplementor, element);
            }
            if (element.getName().equals(_TAGSTREEVIEW_EXTENSION_POINT)) {
                this.ttvElement.add(element);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

