/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.util.tree;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.util.tree.ITextNodeFilter;
import com.ibm.pdp.util.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class EditTreeFilter {
    protected ITextNodeFilter filter;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public EditTreeFilter() {
    }

    public EditTreeFilter(ITextNodeFilter nodesFilter) {
        this.filter = nodesFilter;
    }

    public ITextNodeFilter getNodeFilter() {
        return this.filter;
    }

    public void setNodeFilter(ITextNodeFilter newFilter) {
        this.filter = newFilter;
    }

    public int nbOfRoots(IEditTree tree) {
        Iterator<ITextNode> roots = tree.rootNodes();
        if (!roots.hasNext()) {
            return 0;
        }
        int count = 0;
        roots = this.newFilterIterator(roots, this.filter);
        while (roots.hasNext()) {
            ++count;
            roots.next();
        }
        return count;
    }

    public Iterator<ITextNode> rootNodes(IEditTree tree) {
        Iterator<ITextNode> roots = tree.rootNodes();
        return roots.hasNext() ? this.newFilterIterator(roots, this.filter) : roots;
    }

    public int nbOfSons(ITextNode node) {
        Iterator<ITextNode> sons = node.sons();
        if (!sons.hasNext() || this.filter.skipSubNodes(node)) {
            return 0;
        }
        int count = 0;
        sons = this.newFilterIterator(sons, this.filter);
        while (sons.hasNext()) {
            ++count;
            sons.next();
        }
        return count;
    }

    public Iterator<ITextNode> sons(ITextNode node) {
        Iterator sons = node.sons();
        if (!sons.hasNext() || this.filter.skipSubNodes(node)) {
            return Iterators.emptyIterator();
        }
        return this.newFilterIterator(sons, this.filter);
    }

    public ITextNode parentNode(ITextNode node) {
        return (node = node.parentNode()) != null ? this.visibleNode(node) : null;
    }

    public boolean isVisible(ITextNode node) {
        if (this.filter.skipNode(node)) {
            return false;
        }
        node = node.parentNode();
        while (node != null) {
            if (this.filter.skipSubNodes(node)) {
                return false;
            }
            node = node.parentNode();
        }
        return true;
    }

    public ITextNode visibleNode(ITextNode node) {
        while (this.filter.skipNode(node)) {
            if ((node = node.parentNode()) != null) continue;
            return null;
        }
        ITextNode parent = node.parentNode();
        while (parent != null) {
            if (this.filter.skipSubNodes(parent)) {
                while (this.filter.skipNode(parent)) {
                    if ((parent = parent.parentNode()) != null) continue;
                    return null;
                }
                node = parent;
            }
            parent = parent.parentNode();
        }
        return node;
    }

    public ITextNode includingNode(IEditTree tree, int beginIdx, int endIdx) {
        ITextNode node = tree.includingNode(beginIdx, endIdx);
        return node != null ? this.visibleNode(node) : null;
    }

    public ITextNode nodeFromTagName(IEditTree tree, String tagName) {
        ITextNode node = tree.nodeFromTagName(tagName);
        return node != null && this.isVisible(node) ? node : null;
    }

    protected Iterator<ITextNode> newFilterIterator(Iterator<ITextNode> nodes, ITextNodeFilter filter) {
        return new FilterIterator(nodes, filter);
    }

    protected static class FilterIterator
    implements Iterator<ITextNode> {
        protected int depth;
        protected ITextNode nextOne;
        protected ITextNodeFilter filter;
        protected Iterator<ITextNode> nodes;
        protected List<Iterator<ITextNode>> stack;

        protected FilterIterator(Iterator<ITextNode> roots, ITextNodeFilter nodesFilter) {
            this.filter = nodesFilter;
            this.nodes = roots;
        }

        @Override
        public boolean hasNext() {
            return this.nextOne != null || this.findNextOne();
        }

        @Override
        public ITextNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Text node filter iterator : no next node");
            }
            ITextNode toReturn = this.nextOne;
            this.nextOne = null;
            return toReturn;
        }

        protected boolean findNextOne() {
            ITextNode candidate;
            Iterator topNodes = this.nodes;
            while (topNodes.hasNext()) {
                candidate = topNodes.next();
                if (!this.filter.skipNode(candidate)) {
                    this.nextOne = candidate;
                    this.nodes = topNodes;
                    return true;
                }
                if (this.filter.skipSubNodes(candidate)) continue;
                if (topNodes.hasNext()) {
                    if (this.stack == null) {
                        this.stack = new ArrayList<Iterator<ITextNode>>();
                    }
                    this.stack.add(topNodes);
                    ++this.depth;
                }
                topNodes = candidate.sons();
            }
            while (this.depth > 0) {
                topNodes = this.stack.remove(--this.depth);
                do {
                    if (!this.filter.skipNode(candidate = topNodes.next())) {
                        this.nextOne = candidate;
                        this.nodes = topNodes;
                        return true;
                    }
                    if (this.filter.skipSubNodes(candidate)) continue;
                    if (topNodes.hasNext()) {
                        this.stack.add(topNodes);
                        ++this.depth;
                    }
                    topNodes = candidate.sons();
                } while (topNodes.hasNext());
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Text node filter iterator : remove");
        }
    }
}

