/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.util.geninfo;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.util.geninfo.TagConversionMode;
import java.util.Iterator;

public class GeneratedInfoConverter {
    protected IGeneratedInfoFactory factory;
    protected CharSequence text;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp.2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public GeneratedInfoConverter() {
    }

    public GeneratedInfoConverter(IGeneratedInfoFactory factory) {
        this.factory = factory;
    }

    public IGeneratedInfo convert(IGeneratedInfo generatedInfoToConvert) {
        if (!this.toConvert(generatedInfoToConvert)) {
            return generatedInfoToConvert;
        }
        this.initializeConversion(generatedInfoToConvert);
        this.convertGeneratedInfo(generatedInfoToConvert);
        return this.createNewGeneratedInfo(generatedInfoToConvert);
    }

    protected void initializeConversion(IGeneratedInfo generatedInfoToConvert) {
        this.text = generatedInfoToConvert.getText();
    }

    protected void convertGeneratedInfo(IGeneratedInfo generatedInfoToConvert) {
        this.convertProperties(generatedInfoToConvert);
        this.convertTag(generatedInfoToConvert.getRootTag());
    }

    protected IGeneratedInfo createNewGeneratedInfo(IGeneratedInfo generatedInfoToConvert) {
        return this.factory.createGeneratedInfo();
    }

    protected void convertProperties(IGeneratedInfo generatedInfo) {
        Iterator names = generatedInfo.propertyNames();
        while (names.hasNext()) {
            String name = this.convertPropertyName((String)names.next());
            if (name == null) continue;
            this.factory.setProperty(name, this.convertPropertyValue(name, generatedInfo.getProperty(name)));
        }
    }

    protected String convertPropertyName(String name) {
        return name;
    }

    protected String convertPropertyValue(String name, String value) {
        return value;
    }

    protected void convertTag(IGeneratedTag tag) {
        switch (this.tagConversionMode(tag)) {
            case Convert: {
                this.convertRegularTag(tag);
                return;
            }
            case SkipTag: {
                this.convertSkipTag(tag);
                return;
            }
            case SkipTagAndText: {
                this.convertSkipTagAndText(tag);
                return;
            }
            case SkipTagTree: {
                this.convertSkipTagTree(tag);
                return;
            }
            case SkipTagTreeAndText: {
                this.convertSkipTagTreeAndText(tag);
                return;
            }
            case CopyTag: {
                this.convertCopyTag(tag);
                return;
            }
            case CopyTagAndText: {
                this.convertCopyTagAndText(tag);
                return;
            }
            case CopyTagTree: {
                this.convertCopyTagTree(tag);
                return;
            }
            case CopyTagTreeAndText: {
                this.convertCopyTagTreeAndText(tag);
            }
        }
    }

    protected void convertRegularTag(IGeneratedTag tag) {
        String tagName = this.convertTagName(tag);
        this.beginTag(tagName);
        this.convertProperties(tag);
        int previousIdx = tag.getBeginIndex();
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            this.convertText(previousIdx, son.getBeginIndex());
            this.convertTag(son);
            previousIdx = son.getEndIndex();
        }
        this.convertText(previousIdx, tag.getEndIndex());
        this.endTag(tagName);
    }

    protected void convertSkipTag(IGeneratedTag tag) {
        int previousIdx = tag.getBeginIndex();
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            this.convertText(previousIdx, son.getBeginIndex());
            this.convertTag(son);
            previousIdx = son.getEndIndex();
        }
        this.convertText(previousIdx, tag.getEndIndex());
    }

    protected void convertSkipTagAndText(IGeneratedTag tag) {
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            this.convertTag(son);
        }
    }

    protected void convertSkipTagTree(IGeneratedTag tag) {
        this.convertText(tag.getBeginIndex(), tag.getEndIndex());
    }

    protected void convertSkipTagTreeAndText(IGeneratedTag tag) {
    }

    protected void convertCopyTag(IGeneratedTag tag) {
        this.beginTag(tag.getName());
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.factory.setProperty(name, tag.getProperty(name));
        }
        int previousIdx = tag.getBeginIndex();
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            this.convertText(previousIdx, son.getBeginIndex());
            this.convertTag(son);
            previousIdx = son.getEndIndex();
        }
        this.convertText(previousIdx, tag.getEndIndex());
        this.endTag(tag.getName());
    }

    protected void convertCopyTagAndText(IGeneratedTag tag) {
        this.beginTag(tag.getName());
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.factory.setProperty(name, tag.getProperty(name));
        }
        int previousIdx = tag.getBeginIndex();
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            this.factory.appendTextInterval(previousIdx, son.getBeginIndex(), this.text);
            this.convertTag(son);
            previousIdx = son.getEndIndex();
        }
        this.factory.appendTextInterval(previousIdx, tag.getEndIndex(), this.text);
        this.endTag(tag.getName());
    }

    protected void convertCopyTagTree(IGeneratedTag tag) {
        this.beginTag(tag.getName());
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.factory.setProperty(name, tag.getProperty(name));
        }
        int previousIdx = tag.getBeginIndex();
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            this.convertText(previousIdx, son.getBeginIndex());
            this.convertCopyTagTree(son);
            previousIdx = son.getEndIndex();
        }
        this.convertText(previousIdx, tag.getEndIndex());
        this.endTag(tag.getName());
    }

    protected void convertCopyTagTreeAndText(IGeneratedTag tag) {
        this.factory.appendTagAndText(tag);
    }

    protected void beginTag(String tagName) {
        this.factory.beginTag(tagName);
    }

    protected void endTag(String tagName) {
        this.factory.endTag();
    }

    protected TagConversionMode tagConversionMode(IGeneratedTag tag) {
        return TagConversionMode.Convert;
    }

    protected void convertProperties(IGeneratedTag tag) {
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = this.convertPropertyName((String)names.next());
            if (name == null) continue;
            this.factory.setProperty(name, this.convertPropertyValue(name, tag.getProperty(name)));
        }
    }

    protected String convertTagName(IGeneratedTag tag) {
        return tag.getName();
    }

    protected void convertText(int beginIdx, int endIdx) {
        if (beginIdx < endIdx) {
            this.factory.appendTextInterval(beginIdx, endIdx, this.text);
        }
    }

    protected boolean toConvert(IGeneratedInfo generatedInfo) {
        return false;
    }
}

