/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.EditTree;
import com.ibm.pdp.engine.turbo.tree.SegmentNode;
import com.ibm.pdp.util.Iterators;
import java.util.Iterator;

public class SecondaryDetailNode
extends SegmentNode {
    protected int diffRank;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SecondaryDetailNode(Segment segment, int differenceRank) {
        super(segment);
        this.diffRank = differenceRank;
    }

    protected IDetailedChanges details() {
        IDetailedChanges details = this.segment.detailedChanges();
        return details != null && details.textNode(this.segment, this.diffRank) == this ? details : null;
    }

    @Override
    protected CharSequence buildLabel() {
        if (this.details() == null) {
            return "(Dead)";
        }
        ISubTextPartition partition = this.segment.getChangeSet().textPartition().subTextPartition(this.beginIndex(), this.endIndex());
        ISubTextPartition genPartition = this.segment.getChangeSet().generatedTextPartition().subTextPartition(this.generatedBeginIndex(), this.generatedEndIndex());
        return this.buildModifiedPartLabel(partition, genPartition);
    }

    @Override
    public ITextNode parentNode() {
        return EditTree.visibleNode(this.segment);
    }

    @Override
    public int nbOfSons() {
        return 0;
    }

    @Override
    public Iterator<ITextNode> sons() {
        return Iterators.emptyIterator();
    }

    @Override
    public boolean includeChangedText() {
        return true;
    }

    @Override
    public boolean includeUserSubNode() {
        return false;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public TextStatus getTextStatus() {
        IDetailedChanges details = this.details();
        if (details == null) {
            return EditTree.textStatusFromChangeNature(this.segment.getChangeNature());
        }
        return details.getTextStatus(this.diffRank);
    }

    @Override
    public int beginIndex() {
        IDetailedChanges details = this.details();
        if (details == null) {
            return this.segment.beginIndex();
        }
        return this.segment.beginIndex() + details.getModifiedBeginIndex(this.diffRank);
    }

    @Override
    public int endIndex() {
        IDetailedChanges details = this.details();
        if (details == null) {
            return this.segment.endIndex();
        }
        return this.segment.beginIndex() + details.getModifiedEndIndex(this.diffRank);
    }

    @Override
    public int length() {
        IDetailedChanges details = this.details();
        if (details == null) {
            return this.segment.length();
        }
        return details.getModifiedEndIndex(this.diffRank) - details.getModifiedBeginIndex(this.diffRank);
    }

    @Override
    public int generatedBeginIndex() {
        IDetailedChanges details = this.details();
        if (details == null) {
            return this.segment.generatedBeginIndex();
        }
        return this.segment.generatedBeginIndex() + details.getReferenceBeginIndex(this.diffRank);
    }

    @Override
    public int generatedEndIndex() {
        IDetailedChanges details = this.details();
        if (details == null) {
            return this.segment.generatedEndIndex();
        }
        return this.segment.generatedBeginIndex() + details.getReferenceEndIndex(this.diffRank);
    }

    @Override
    public int generatedLength() {
        IDetailedChanges details = this.details();
        if (details == null) {
            return this.segment.generatedLength();
        }
        return details.getReferenceEndIndex(this.diffRank) - details.getReferenceBeginIndex(this.diffRank);
    }
}

