/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.LightEditTree;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LightSubNodeIterator
implements Iterator<ITextNode> {
    protected LightEditTree tree;
    protected ITextNode parentNode;
    protected Segment[] segments;
    protected int segmentIdx;
    protected int endSegmentIdx;
    protected Segment segment;
    protected int diffRank;
    protected ITextNode nextOne;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected LightSubNodeIterator(LightEditTree tree, ITextNode parentNode, Segment parent) {
        this.tree = tree;
        this.parentNode = parentNode;
        if (!parent.isAtomic()) {
            this.segments = parent.sons();
            this.endSegmentIdx = this.segments.length;
        } else if (parent.detailedChanges() != null) {
            this.segment = parent;
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextOne != null || this.findNextOne();
    }

    @Override
    public ITextNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("TextNodeIterator");
        }
        ITextNode toReturn = this.nextOne;
        this.nextOne = null;
        return toReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("LightSubNodeIterator.remove");
    }

    /*
     * Unable to fully structure code
     */
    protected boolean findNextOne() {
        if (this.segment == null || !this.nextDetailNode(this.segment)) ** GOTO lbl8
        return true;
lbl-1000:
        // 1 sources

        {
            if ((nextSegment = this.segments[this.segmentIdx++]).isTagged()) {
                this.nextOne = this.tree.newSegmentNode(this.parentNode, nextSegment);
                return true;
            }
            if (!this.nextDetailNode(nextSegment)) continue;
            return true;
lbl8:
            // 2 sources

            ** while (this.segmentIdx < this.endSegmentIdx)
        }
lbl9:
        // 1 sources

        return false;
    }

    protected boolean nextDetailNode(Segment nextSegment) {
        IDetailedChanges details = nextSegment.detailedChanges();
        if (details == null) {
            this.diffRank = 0;
            return false;
        }
        int nbOfChanges = details.getNbOfDifferences();
        if (this.diffRank >= nbOfChanges) {
            this.diffRank = 0;
            return false;
        }
        this.nextOne = this.tree.newDetailNode(this.parentNode, nextSegment, this.diffRank);
        if (++this.diffRank >= nbOfChanges) {
            this.segment = null;
            this.diffRank = 0;
        } else {
            this.segment = nextSegment;
        }
        return true;
    }
}

