/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.internal.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.EditTree;
import com.ibm.pdp.engine.turbo.tree.LightEditTree;
import com.ibm.pdp.engine.turbo.tree.LightSubNodeIterator;
import com.ibm.pdp.util.Iterators;
import java.util.Iterator;

public class LightSegmentNode
implements ITextNode {
    protected LightEditTree editTree;
    protected com.ibm.pdp.engine.tree.ITextNode parent;
    protected Segment segment;
    protected CharSequence label;
    protected com.ibm.pdp.engine.tree.ITextNode[] sons;
    protected static final int MaxLabelLength = 48;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public LightSegmentNode(LightEditTree tree, com.ibm.pdp.engine.tree.ITextNode parentNode, Segment segment) {
        this.editTree = tree;
        this.parent = parentNode;
        this.segment = segment;
    }

    public IEditTree getEditTree() {
        return this.editTree;
    }

    public ITagProperties getProperties() {
        return this.segment.getTagProperties();
    }

    public TextStatus getTextStatus() {
        return EditTree.textStatusFromChangeNature(this.segment.getChangeNature());
    }

    public boolean includeChangedText() {
        return this.segment.getTreeChangeNature() != ChangeNature.Unchanged;
    }

    public boolean includeUserSubNode() {
        if (this.segment.isAtomic()) {
            return this.segment.detailedChanges() != null;
        }
        return this.segment.getTreeChangeNature().isUserCode();
    }

    public CharSequence getLabel() {
        if (this.label == null) {
            this.label = this.buildLabel();
        }
        return this.label;
    }

    public void setLabel(CharSequence newLabel) {
        this.label = newLabel;
    }

    public com.ibm.pdp.engine.tree.ITextNode parentNode() {
        return this.parent;
    }

    public int nbOfSons() {
        if (this.sons == null) {
            this.sons = this.computeSons();
        }
        return this.sons.length;
    }

    public Iterator<com.ibm.pdp.engine.tree.ITextNode> sons() {
        if (this.sons == null) {
            this.sons = this.computeSons();
        }
        return Iterators.iterator((Object[])this.sons);
    }

    protected com.ibm.pdp.engine.tree.ITextNode[] computeSons() {
        return (com.ibm.pdp.engine.tree.ITextNode[])Iterators.toArray((Iterator)new LightSubNodeIterator(this.editTree, (com.ibm.pdp.engine.tree.ITextNode)this, this.segment), com.ibm.pdp.engine.tree.ITextNode.class);
    }

    public int length() {
        return this.endIndex() - this.beginIndex();
    }

    public int beginIndex() {
        return this.segment.beginIndex();
    }

    public int endIndex() {
        return this.segment.endIndex();
    }

    public CharSequence text() {
        return this.segment.getChangeSet().textPartition().getTextInterval(this.beginIndex(), this.endIndex());
    }

    public char charAt(int index) {
        return this.segment.getChangeSet().textPartition().charAt(index + this.beginIndex());
    }

    public CharSequence subSequence(int beginIdx, int endIdx) {
        int shift = this.beginIndex();
        return this.segment.getChangeSet().textPartition().getTextInterval(shift + beginIdx, shift + endIdx);
    }

    public boolean isTagged() {
        return this.segment.isTagged();
    }

    public boolean isSyntacticTag() {
        return this.segment.isTagged() && this.segment.isSyntactic();
    }

    public boolean isGeneratedTag() {
        return this.isTagged() && !this.segment.isSyntactic();
    }

    public String enclosingTagName() {
        return this.segment.enclosingTagName();
    }

    public IGeneratedTag enclosingGeneratedTag() {
        return this.segment.enclosingTag();
    }

    public int generatedBeginIndex() {
        return this.segment.generatedBeginIndex();
    }

    public int generatedEndIndex() {
        return this.segment.generatedEndIndex();
    }

    public int generatedLength() {
        return this.generatedEndIndex() - this.generatedBeginIndex();
    }

    public CharSequence generatedText() {
        return this.segment.getChangeSet().generatedText().subSequence(this.generatedBeginIndex(), this.generatedEndIndex());
    }

    protected int firstWordBeginIndex(ITextPartition partition, int begin, int end) {
        if (begin == end) {
            return begin;
        }
        int wordRank = partition.wordRankFromIndex(begin);
        if (wordRank >= 0) {
            return begin;
        }
        int index = partition.wordBeginIndex(~wordRank);
        return index <= end ? index : end;
    }

    protected int lastWordEndIndex(ITextPartition partition, int begin, int end) {
        if (begin == end) {
            return begin;
        }
        int wordRank = partition.wordRankFromIndex(end - 1);
        if (wordRank >= 0) {
            return end;
        }
        int index = partition.wordEndIndex(~wordRank - 1);
        return index > begin ? index : end;
    }

    protected CharSequence buildLabel() {
        if (this.segment.isTagged()) {
            return this.segment.enclosingTagName();
        }
        if (this.segment.getChangeNature().isGeneratedCode()) {
            return this.buildGeneratedPartLabel(this.segment);
        }
        ISubTextPartition partition = this.segment.getChangeSet().textPartition().subTextPartition(this.segment.beginIndex(), this.segment.endIndex());
        ISubTextPartition genPartition = this.segment.getChangeSet().generatedTextPartition().subTextPartition(this.segment.generatedBeginIndex(), this.segment.generatedEndIndex());
        return this.buildModifiedPartLabel(partition, genPartition);
    }

    protected CharSequence buildGeneratedPartLabel(Segment segment) {
        IGeneratedTag fromTag = segment.fromTag();
        IGeneratedTag toTag = segment.toTag();
        if (fromTag == null) {
            return ".." + toTag.getName();
        }
        if (toTag == null) {
            return String.valueOf(fromTag.getName()) + "..";
        }
        return String.valueOf(fromTag.getName()) + ".." + toTag.getName();
    }

    protected CharSequence buildModifiedPartLabel(ITextPartition partition, ITextPartition genPartition) {
        int trimmedLength = this.trimmedCharsCount(partition);
        int genTrimmedLength = this.trimmedCharsCount(genPartition);
        if (trimmedLength == 0) {
            return this.compactLabel(genPartition, genTrimmedLength);
        }
        return this.compactLabel(partition, trimmedLength);
    }

    protected int trimmedCharsCount(ITextPartition partition) {
        int nbWord = partition.getWordsCount();
        if (nbWord == 0) {
            return 0;
        }
        int count = this.trimmedWordLength(partition, 0);
        int idx = partition.wordEndIndex(0);
        int wordRank = 1;
        while (wordRank < nbWord) {
            int wordLength = this.trimmedWordLength(partition, wordRank);
            if ((count += partition.wordBeginIndex(wordRank) > idx ? wordLength + 1 : wordLength) > 48) {
                return count;
            }
            idx = partition.wordEndIndex(wordRank);
            ++wordRank;
        }
        return count;
    }

    protected int trimmedWordLength(ITextPartition partition, int wordRank) {
        int count = 0;
        int idx = partition.wordBeginIndex(wordRank);
        int stop = partition.wordEndIndex(wordRank);
        boolean foundVisibleChar = false;
        while (idx < stop) {
            if (Character.isWhitespace(partition.charAt(idx++))) {
                if (foundVisibleChar) {
                    ++count;
                }
                foundVisibleChar = false;
                continue;
            }
            ++count;
            foundVisibleChar = true;
        }
        return count;
    }

    protected CharSequence compactLabel(ITextPartition partition, int trimmedLength) {
        if (trimmedLength <= 48) {
            StringBuilder builder = new StringBuilder(trimmedLength);
            this.trimmedLabel(partition, builder);
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder(48);
        this.cutLabel(partition, trimmedLength, 48, builder);
        return builder.toString();
    }

    protected CharSequence compactDualLabel(ITextPartition left, int leftTrimmedLength, ITextPartition right, int rightTrimmedLength) {
        if (leftTrimmedLength + rightTrimmedLength + 2 <= 48) {
            StringBuilder builder = new StringBuilder(leftTrimmedLength + rightTrimmedLength + 2);
            this.trimmedLabel(left, builder);
            builder.append('(');
            this.trimmedLabel(right, builder);
            builder.append(')');
            return builder.toString();
        }
        int halfLength = 24;
        StringBuilder builder = new StringBuilder(48);
        if (leftTrimmedLength <= halfLength) {
            this.trimmedLabel(left, builder);
            builder.append('(');
            this.cutLabel(right, rightTrimmedLength, 48 - leftTrimmedLength - 2, builder);
            builder.append(')');
            return builder.toString();
        }
        if (rightTrimmedLength <= halfLength - 2) {
            this.cutLabel(left, leftTrimmedLength, 48 - rightTrimmedLength - 2, builder);
            builder.append('(');
            this.trimmedLabel(right, builder);
            builder.append(')');
            return builder.toString();
        }
        this.cutLabel(left, leftTrimmedLength, halfLength, builder);
        builder.append('(');
        this.cutLabel(right, rightTrimmedLength, halfLength - 2, builder);
        builder.append(')');
        return builder.toString();
    }

    protected void trimmedLabel(ITextPartition partition, StringBuilder builder) {
        int nbWord = partition.getWordsCount();
        if (nbWord == 0) {
            return;
        }
        this.trimmedWord(partition, 0, builder);
        int endIdx = partition.wordEndIndex(0);
        int wordRank = 1;
        while (wordRank < nbWord) {
            if (partition.wordBeginIndex(wordRank) > endIdx) {
                builder.append(' ');
            }
            this.trimmedWord(partition, wordRank, builder);
            endIdx = partition.wordEndIndex(wordRank);
            ++wordRank;
        }
    }

    protected void trimmedWord(ITextPartition partition, int wordRank, StringBuilder builder) {
        int idx = partition.wordBeginIndex(wordRank);
        int stop = partition.wordEndIndex(wordRank);
        boolean foundVisibleChar = false;
        while (idx < stop) {
            char c;
            if (Character.isWhitespace(c = partition.charAt(idx++))) {
                if (foundVisibleChar) {
                    builder.append(' ');
                }
                foundVisibleChar = false;
                continue;
            }
            builder.append(c);
            foundVisibleChar = true;
        }
    }

    protected void cutLabel(ITextPartition partition, int trimmedLength, int cutLength, StringBuilder builder) {
        cutLength -= 2;
        int nbWord = partition.getWordsCount();
        if (nbWord == 0) {
            builder.append("..");
            return;
        }
        int wordLength = this.trimmedWordLength(partition, 0);
        if (wordLength > cutLength) {
            this.cutWord(partition, 0, builder, cutLength);
            builder.append("..");
            return;
        }
        this.trimmedWord(partition, 0, builder);
        cutLength -= wordLength;
        int endIdx = partition.wordEndIndex(0);
        int wordRank = 1;
        while (wordRank < nbWord && cutLength > 0) {
            if (partition.wordBeginIndex(wordRank) > endIdx) {
                builder.append(' ');
                --cutLength;
            }
            if ((wordLength = this.trimmedWordLength(partition, wordRank)) > cutLength) {
                this.cutWord(partition, wordRank, builder, cutLength);
                builder.append("..");
                return;
            }
            this.trimmedWord(partition, wordRank, builder);
            cutLength -= wordLength;
            endIdx = partition.wordEndIndex(wordRank);
            ++wordRank;
        }
        builder.append("..");
    }

    protected void cutWord(ITextPartition partition, int wordRank, StringBuilder builder, int cutLength) {
        int initialLength = builder.length();
        int idx = partition.wordBeginIndex(wordRank);
        int stop = partition.wordEndIndex(wordRank);
        boolean foundVisibleChar = false;
        while (idx < stop && cutLength > 0) {
            char c;
            if (Character.isWhitespace(c = partition.charAt(idx++))) {
                if (foundVisibleChar) {
                    builder.append(c);
                    --cutLength;
                }
                foundVisibleChar = false;
                continue;
            }
            builder.append(c);
            --cutLength;
            foundVisibleChar = true;
        }
        if (!foundVisibleChar && builder.length() > initialLength) {
            builder.setLength(builder.length() - 1);
        }
    }

    public void restoreGeneratedCode() {
        this.segment.getChangeSet().replaceText(this.beginIndex(), this.endIndex(), this.generatedText());
    }
}

