/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.match.IMatcher;
import com.ibm.pdp.engine.turbo.tree.LightDetailNode;
import com.ibm.pdp.engine.turbo.tree.LightSegmentNode;
import com.ibm.pdp.util.Iterators;
import java.util.Iterator;

public class LightEditTree
implements IEditTree {
    protected UserChangeSet changeSet;
    protected IMatcher matcher;
    protected ITextNode[] rootNodes;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public LightEditTree(UserChangeSet ucs) {
        this.changeSet = ucs;
    }

    public UserChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void setChangeSet(UserChangeSet newChangeSet) {
        this.changeSet = newChangeSet;
    }

    public IMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(IMatcher newMatcher) {
        this.matcher = newMatcher;
    }

    public ITagProperties getProperties() {
        return this.changeSet.getGeneratedProperties();
    }

    public ITextProcessor getTextProcessor() {
        return this.changeSet.getTextProcessor();
    }

    public boolean includeChangedText() {
        return this.changeSet.getChangeNature() != ChangeNature.Unchanged;
    }

    public boolean includeUserNode() {
        return this.changeSet.getChangeNature().isUserCode();
    }

    public int nbOfRoots() {
        int count = 0;
        Iterator<ITextNode> iter = this.rootNodes();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    public Iterator<ITextNode> rootNodes() {
        if (this.rootNodes == null) {
            this.matchAllIfNecessary();
            Segment[] roots = this.changeSet.rootSegments();
            this.rootNodes = roots[0].getChangeNature().isUserCode() ? (roots[2].getChangeNature().isUserCode() ? new ITextNode[]{this.newSegmentNode(null, roots[0]), this.newSegmentNode(null, roots[1]), this.newSegmentNode(null, roots[2])} : new ITextNode[]{this.newSegmentNode(null, roots[1]), this.newSegmentNode(null, roots[2])}) : (roots[2].getChangeNature().isUserCode() ? new ITextNode[]{this.newSegmentNode(null, roots[1]), this.newSegmentNode(null, roots[2])} : new ITextNode[]{this.newSegmentNode(null, roots[1])});
        }
        return Iterators.iterator((Object[])this.rootNodes);
    }

    protected void matchAllIfNecessary() {
        if (this.matcher != null && this.changeSet.getChangeNature() == ChangeNature.Dirty) {
            this.matcher.match();
        }
    }

    public ITextNode includingNode(int beginIndex, int endIndex) {
        this.matchAllIfNecessary();
        return this.includingNode(this.rootNodes(), beginIndex, endIndex);
    }

    protected ITextNode includingNode(Iterator<ITextNode> nodes, int beginIndex, int endIndex) {
        while (nodes.hasNext()) {
            ITextNode node = nodes.next();
            if (node.beginIndex() > beginIndex) {
                return null;
            }
            if (node.endIndex() < endIndex) continue;
            ITextNode subNode = this.includingNode(node.sons(), beginIndex, endIndex);
            return subNode == null ? node : subNode;
        }
        return null;
    }

    public ITextNode nodeFromTagName(String tagName) {
        ITextNode includingNode;
        Segment segment = this.changeSet.segmentFromTagName(tagName, 0);
        if (segment == null) {
            return null;
        }
        if (this.matcher != null && segment.getChangeNature() == ChangeNature.Dirty) {
            this.matcher.match(segment);
        }
        if ((includingNode = this.includingNode(segment.beginIndex(), segment.endIndex())) == null || !includingNode.isTagged() || !includingNode.enclosingTagName().equals(tagName)) {
            return null;
        }
        return includingNode;
    }

    protected ITextNode newSegmentNode(ITextNode parent, Segment segment) {
        return new LightSegmentNode(this, parent, segment);
    }

    protected ITextNode newDetailNode(ITextNode parent, Segment segment, int differenceRank) {
        return new LightDetailNode(this, parent, segment, differenceRank);
    }

    protected static TextStatus textStatusFromChangeNature(ChangeNature nature) {
        switch (nature) {
            case Unchanged: {
                return TextStatus.Unchanged;
            }
            case Reformated: 
            case Modified: {
                return TextStatus.Reformated;
            }
            case Deleted: {
                return TextStatus.Deleted;
            }
            case Inserted: {
                return TextStatus.Inserted;
            }
            case Replaced: {
                return TextStatus.Modified;
            }
        }
        return TextStatus.Modified;
    }
}

