/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.match.IMatcher;
import com.ibm.pdp.engine.turbo.tree.SegmentNode;
import com.ibm.pdp.engine.turbo.tree.SubNodeIterator;
import com.ibm.pdp.util.Iterators;
import java.util.Iterator;

public class EditTree
implements IEditTree {
    protected UserChangeSet changeSet;
    protected IMatcher matcher;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public EditTree(UserChangeSet ucs) {
        this.changeSet = ucs;
    }

    public UserChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void setChangeSet(UserChangeSet newChangeSet) {
        this.changeSet = newChangeSet;
    }

    public IMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(IMatcher newMatcher) {
        this.matcher = newMatcher;
    }

    public ITagProperties getProperties() {
        return this.changeSet.getGeneratedProperties();
    }

    public ITextProcessor getTextProcessor() {
        return this.changeSet.getTextProcessor();
    }

    public boolean includeChangedText() {
        return this.changeSet.getChangeNature() != ChangeNature.Unchanged;
    }

    public boolean includeUserNode() {
        return this.changeSet.getChangeNature().isUserCode();
    }

    public int nbOfRoots() {
        int count = 0;
        Iterator<ITextNode> iter = this.rootNodes();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    public Iterator<ITextNode> rootNodes() {
        this.matchAllIfNecessary();
        Segment top = this.changeSet.topSegment();
        if (top.isLeaf()) {
            return Iterators.singletonIterator((Object)EditTree.linkedNode(top));
        }
        return new SubNodeIterator(top);
    }

    protected void matchAllIfNecessary() {
        if (this.matcher != null && this.changeSet.getChangeNature() == ChangeNature.Dirty) {
            this.matcher.match();
        }
    }

    public ITextNode includingNode(int beginIndex, int endIndex) {
        this.matchAllIfNecessary();
        return this.includingNode(this.rootNodes(), beginIndex, endIndex);
    }

    protected ITextNode includingNode(Iterator<ITextNode> nodes, int beginIndex, int endIndex) {
        while (nodes.hasNext()) {
            ITextNode node = nodes.next();
            if (node.beginIndex() > beginIndex) {
                return null;
            }
            if (node.endIndex() < endIndex) continue;
            ITextNode subNode = this.includingNode(node.sons(), beginIndex, endIndex);
            return subNode == null ? node : subNode;
        }
        return null;
    }

    public ITextNode nodeFromTagName(String tagName) {
        Segment segment = EditTree.visibleSegment(this.changeSet.findSegmentFromTagName(tagName, 0));
        if (segment != null && this.matcher != null && segment.getChangeNature() == ChangeNature.Dirty) {
            this.matcher.match(segment);
        }
        return EditTree.linkedNode(segment);
    }

    protected static ITextNode linkedNode(Segment segment) {
        if (segment == null) {
            return null;
        }
        Object node = segment.getTextNode();
        if (node == null) {
            node = new SegmentNode(segment);
            segment.setTextNode((ITextNode)node);
        }
        return node;
    }

    protected static Segment visibleSegment(Segment segment) {
        if (segment == null) {
            return null;
        }
        if (segment.isTagged()) {
            return segment;
        }
        if (segment.isTop()) {
            return segment.isLeaf() ? segment : null;
        }
        Segment enclosingSegment = segment.enclosingSegment();
        if (!enclosingSegment.isSyntactic() && segment.getChangeNature().isUserCode() && segment.detailedChanges() == null) {
            return segment;
        }
        return enclosingSegment;
    }

    protected static ITextNode visibleNode(Segment segment) {
        if (segment == null) {
            return null;
        }
        if (segment.isTagged()) {
            return EditTree.linkedNode(segment);
        }
        if (segment.isTop()) {
            return segment.isLeaf() ? EditTree.linkedNode(segment) : null;
        }
        Segment enclosingSegment = segment.enclosingSegment();
        if (!enclosingSegment.isSyntactic() && segment.getChangeNature().isUserCode() && segment.detailedChanges() == null) {
            return EditTree.linkedNode(segment);
        }
        return EditTree.linkedNode(enclosingSegment);
    }

    protected static TextStatus textStatusFromChangeNature(ChangeNature nature) {
        switch (nature) {
            case Unchanged: {
                return TextStatus.Unchanged;
            }
            case Reformated: 
            case Modified: {
                return TextStatus.Reformated;
            }
            case Deleted: {
                return TextStatus.Deleted;
            }
            case Inserted: {
                return TextStatus.Inserted;
            }
            case Replaced: {
                return TextStatus.Modified;
            }
        }
        return TextStatus.Modified;
    }
}

