/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.EditTree;
import com.ibm.pdp.engine.turbo.tree.SecondaryDetailNode;
import com.ibm.pdp.engine.turbo.tree.SegmentNode;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.util.Iterator;

public class DetailNodesBits8
extends SegmentNode
implements IDetailedChanges {
    protected int[] details;
    protected ITextNode[] secondaryNodes;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DetailNodesBits8(Segment segment, int[] detailedChanges) {
        super(segment);
        this.details = detailedChanges;
        this.buildSecondaryNodes();
    }

    protected void buildSecondaryNodes() {
        int nbOfSecondaryNodes = this.getNbOfDifferences() - 1;
        this.secondaryNodes = new ITextNode[nbOfSecondaryNodes];
        int i = 0;
        while (i < nbOfSecondaryNodes) {
            this.secondaryNodes[i] = new SecondaryDetailNode(this.segment, i + 1);
            ++i;
        }
    }

    protected boolean invalid() {
        return this.segment.detailedChanges() != this;
    }

    @Override
    protected CharSequence buildLabel() {
        if (this.invalid()) {
            return "(Dead)";
        }
        ISubTextPartition partition = this.segment.getChangeSet().textPartition().subTextPartition(this.beginIndex(), this.endIndex());
        ISubTextPartition genPartition = this.segment.getChangeSet().generatedTextPartition().subTextPartition(this.generatedBeginIndex(), this.generatedEndIndex());
        return this.buildModifiedPartLabel(partition, genPartition);
    }

    @Override
    public ITextNode parentNode() {
        return EditTree.visibleNode(this.segment);
    }

    @Override
    public int nbOfSons() {
        return 0;
    }

    @Override
    public Iterator<ITextNode> sons() {
        return Iterators.emptyIterator();
    }

    @Override
    public boolean includeChangedText() {
        return true;
    }

    @Override
    public boolean includeUserSubNode() {
        return false;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public TextStatus getTextStatus() {
        if (this.invalid()) {
            return EditTree.textStatusFromChangeNature(this.segment.getChangeNature());
        }
        return this.getTextStatus(0);
    }

    @Override
    public int beginIndex() {
        if (this.invalid()) {
            return this.segment.beginIndex();
        }
        return this.segment.beginIndex() + this.getModifiedBeginIndex(0);
    }

    @Override
    public int endIndex() {
        if (this.invalid()) {
            return this.segment.endIndex();
        }
        return this.segment.beginIndex() + this.getModifiedEndIndex(0);
    }

    @Override
    public int length() {
        if (this.invalid()) {
            return this.segment.length();
        }
        return this.getModifiedEndIndex(0) - this.getModifiedBeginIndex(0);
    }

    @Override
    public int generatedBeginIndex() {
        if (this.invalid()) {
            return this.segment.generatedBeginIndex();
        }
        return this.segment.generatedBeginIndex() + this.getReferenceBeginIndex(0);
    }

    @Override
    public int generatedEndIndex() {
        if (this.invalid()) {
            return this.segment.generatedEndIndex();
        }
        return this.segment.generatedBeginIndex() + this.getReferenceEndIndex(0);
    }

    @Override
    public int generatedLength() {
        if (this.invalid()) {
            return this.segment.generatedLength();
        }
        return this.getReferenceEndIndex(0) - this.getReferenceBeginIndex(0);
    }

    @Override
    public int getNbOfDifferences() {
        return this.getByteAt(0);
    }

    protected void setNbOfDifferences(int nbOfDifferences) {
        this.setByteAt(0, nbOfDifferences);
    }

    @Override
    public int getModifiedBeginIndex(int diffRank) {
        return this.getByteAt(1 + (diffRank << 2));
    }

    @Override
    public void setModifiedBeginIndex(int diffRank, int modifiedBeginIndex) {
        this.setByteAt(1 + (diffRank << 2), modifiedBeginIndex);
    }

    @Override
    public int getModifiedEndIndex(int diffRank) {
        return this.getByteAt(2 + (diffRank << 2));
    }

    @Override
    public void setModifiedEndIndex(int diffRank, int modifiedEndIndex) {
        this.setByteAt(2 + (diffRank << 2), modifiedEndIndex);
    }

    @Override
    public int getReferenceBeginIndex(int diffRank) {
        return this.getByteAt(3 + (diffRank << 2));
    }

    @Override
    public void setReferenceBeginIndex(int diffRank, int referenceBeginIndex) {
        this.setByteAt(3 + (diffRank << 2), referenceBeginIndex);
    }

    @Override
    public int getReferenceEndIndex(int diffRank) {
        return this.getByteAt(4 + (diffRank << 2));
    }

    @Override
    public void setReferenceEndIndex(int diffRank, int referenceEndIndex) {
        this.setByteAt(4 + (diffRank << 2), referenceEndIndex);
    }

    @Override
    public DifferenceNature getDifferenceNature(int diffRank) {
        return Segment.differenceNatureFromDifference(this.getDifference(diffRank));
    }

    @Override
    public void setDifferenceNature(int diffRank, DifferenceNature diffNature) {
        this.setDifference(diffRank, diffNature.ordinal());
    }

    @Override
    public ChangeNature getChangeNature(int diffRank) {
        return Segment.changeNatureFromDifference(this.getDifference(diffRank));
    }

    @Override
    public TextStatus getTextStatus(int diffRank) {
        return Segment.textStatusFromDifference(this.getDifference(diffRank));
    }

    protected int[] newIntArray(int nbOfChanges) {
        int nbOfBitPairs = 4 + (nbOfChanges << 4) + nbOfChanges;
        return new int[15 + nbOfBitPairs >> 4];
    }

    protected int getByteAt(int byteRank) {
        return this.details[byteRank >> 2] >> (byteRank % 4 << 3) & 0xFF;
    }

    protected void setByteAt(int byteRank, int byteValue) {
        int idx = byteRank >> 2;
        int shift = byteRank % 4 << 3;
        int mask = ~(255 << shift);
        this.details[idx] = this.details[idx] & mask | byteValue << shift;
    }

    protected int getDifference(int diffRank) {
        int nbOfDifferences = this.getNbOfDifferences();
        return this.getBitPairAt(diffRank + (nbOfDifferences << 4) + 4);
    }

    protected void setDifference(int diffRank, int difference) {
        int nbOfDifferences = this.getNbOfDifferences();
        this.setBitPairAt(diffRank + (nbOfDifferences << 4) + 4, difference);
    }

    protected int getBitPairAt(int bitPairRank) {
        return this.details[bitPairRank >> 4] >> (bitPairRank % 16 << 1) & 3;
    }

    protected void setBitPairAt(int bitPairRank, int bitPairValue) {
        int idx = bitPairRank >> 4;
        int shift = bitPairRank % 16 << 1;
        int mask = ~(3 << shift);
        this.details[idx] = this.details[idx] & mask | bitPairValue << shift;
    }

    @Override
    public ITextNode textNode(Segment segment, int diffRank) {
        return diffRank == 0 ? this : this.secondaryNodes[diffRank - 1];
    }
}

