/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.EditTree;
import com.ibm.pdp.engine.turbo.tree.SecondaryDetailNode;
import com.ibm.pdp.engine.turbo.tree.SegmentNode;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.util.Iterator;

public class DetailNodes3Bits2
extends SegmentNode
implements IDetailedChanges {
    protected int details;
    protected ITextNode secondNode;
    protected ITextNode thirdNode;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DetailNodes3Bits2(Segment segment, int details) {
        super(segment);
        this.details = details;
        this.secondNode = new SecondaryDetailNode(segment, 1);
        this.thirdNode = new SecondaryDetailNode(segment, 2);
    }

    protected boolean invalid() {
        return this.segment.detailedChanges() != this;
    }

    @Override
    protected CharSequence buildLabel() {
        if (this.invalid()) {
            return "(Dead)";
        }
        ISubTextPartition partition = this.segment.getChangeSet().textPartition().subTextPartition(this.beginIndex(), this.endIndex());
        ISubTextPartition genPartition = this.segment.getChangeSet().generatedTextPartition().subTextPartition(this.generatedBeginIndex(), this.generatedEndIndex());
        return this.buildModifiedPartLabel(partition, genPartition);
    }

    @Override
    public ITextNode parentNode() {
        return EditTree.visibleNode(this.segment);
    }

    @Override
    public int nbOfSons() {
        return 0;
    }

    @Override
    public Iterator<ITextNode> sons() {
        return Iterators.emptyIterator();
    }

    @Override
    public boolean includeChangedText() {
        return true;
    }

    @Override
    public boolean includeUserSubNode() {
        return false;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public TextStatus getTextStatus() {
        if (this.invalid()) {
            return EditTree.textStatusFromChangeNature(this.segment.getChangeNature());
        }
        return this.getTextStatus(0);
    }

    @Override
    public int beginIndex() {
        if (this.invalid()) {
            return this.segment.beginIndex();
        }
        return this.segment.beginIndex() + this.getModifiedBeginIndex(0);
    }

    @Override
    public int endIndex() {
        if (this.invalid()) {
            return this.segment.endIndex();
        }
        return this.segment.beginIndex() + this.getModifiedEndIndex(0);
    }

    @Override
    public int length() {
        if (this.invalid()) {
            return this.segment.length();
        }
        return this.getModifiedEndIndex(0) - this.getModifiedBeginIndex(0);
    }

    @Override
    public int generatedBeginIndex() {
        if (this.invalid()) {
            return this.segment.generatedBeginIndex();
        }
        return this.segment.generatedBeginIndex() + this.getReferenceBeginIndex(0);
    }

    @Override
    public int generatedEndIndex() {
        if (this.invalid()) {
            return this.segment.generatedEndIndex();
        }
        return this.segment.generatedBeginIndex() + this.getReferenceEndIndex(0);
    }

    @Override
    public int generatedLength() {
        if (this.invalid()) {
            return this.segment.generatedLength();
        }
        return this.getReferenceEndIndex(0) - this.getReferenceBeginIndex(0);
    }

    @Override
    public int getNbOfDifferences() {
        return 3;
    }

    @Override
    public int getModifiedBeginIndex(int diffRank) {
        return this.getBitPairAt(diffRank << 2);
    }

    @Override
    public void setModifiedBeginIndex(int diffRank, int modifiedBeginIndex) {
        this.setBitPairAt(diffRank << 2, modifiedBeginIndex);
    }

    @Override
    public int getModifiedEndIndex(int diffRank) {
        return this.getBitPairAt(1 + (diffRank << 2));
    }

    @Override
    public void setModifiedEndIndex(int diffRank, int modifiedEndIndex) {
        this.setBitPairAt(1 + (diffRank << 2), modifiedEndIndex);
    }

    @Override
    public int getReferenceBeginIndex(int diffRank) {
        return this.getBitPairAt(2 + (diffRank << 2));
    }

    @Override
    public void setReferenceBeginIndex(int diffRank, int referenceBeginIndex) {
        this.setBitPairAt(2 + (diffRank << 2), referenceBeginIndex);
    }

    @Override
    public int getReferenceEndIndex(int diffRank) {
        return this.getBitPairAt(3 + (diffRank << 2));
    }

    @Override
    public void setReferenceEndIndex(int diffRank, int referenceEndIndex) {
        this.setBitPairAt(3 + (diffRank << 2), referenceEndIndex);
    }

    @Override
    public DifferenceNature getDifferenceNature(int diffRank) {
        return Segment.differenceNatureFromDifference(this.getDifferenceKind(diffRank));
    }

    @Override
    public void setDifferenceNature(int diffRank, DifferenceNature diffNature) {
        this.setDifferenceKind(diffRank, diffNature.ordinal());
    }

    @Override
    public ChangeNature getChangeNature(int diffRank) {
        return Segment.changeNatureFromDifference(this.getDifferenceKind(diffRank));
    }

    @Override
    public TextStatus getTextStatus(int diffRank) {
        return Segment.textStatusFromDifference(this.getDifferenceKind(diffRank));
    }

    protected int getDifferenceKind(int diffRank) {
        int shift = 24 + (diffRank << 1);
        return this.details >> shift & 3;
    }

    protected void setDifferenceKind(int diffRank, int difference) {
        int shift = 24 + (diffRank << 1);
        int mask = ~(3 << shift);
        this.details = this.details & mask | difference << shift;
    }

    protected int getBitPairAt(int bitPairRank) {
        return this.details >> (bitPairRank << 1) & 3;
    }

    protected void setBitPairAt(int bitPairRank, int bitPairValue) {
        int shift = bitPairRank << 1;
        int currentValue = this.details & ~(3 << shift);
        this.details = currentValue | bitPairValue << shift;
    }

    @Override
    public ITextNode textNode(Segment segment, int diffRank) {
        return diffRank == 0 ? this : (diffRank == 1 ? this.secondNode : this.thirdNode);
    }
}

