/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.EditTree;
import com.ibm.pdp.engine.turbo.tree.SegmentNode;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.util.Iterator;

public class DetailNodeBits32
extends SegmentNode
implements IDetailedChanges {
    protected int modBeginIdx;
    protected int modEndIdx;
    protected int refBeginIdx;
    protected int refEndIdx;
    protected DifferenceNature nature;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DetailNodeBits32(Segment segment, int modifiedBeginIdx, int modifiedEndIdx, int referenceBeginIdx, int referenceEndIdx, DifferenceNature diffNature) {
        super(segment);
        this.modBeginIdx = modifiedBeginIdx;
        this.modEndIdx = modifiedEndIdx;
        this.refBeginIdx = referenceBeginIdx;
        this.refEndIdx = referenceEndIdx;
        this.nature = diffNature;
    }

    protected boolean invalid() {
        return this.segment.detailedChanges() != this;
    }

    @Override
    protected CharSequence buildLabel() {
        if (this.invalid()) {
            return "(Dead)";
        }
        ISubTextPartition partition = this.segment.getChangeSet().textPartition().subTextPartition(this.beginIndex(), this.endIndex());
        ISubTextPartition genPartition = this.segment.getChangeSet().generatedTextPartition().subTextPartition(this.generatedBeginIndex(), this.generatedEndIndex());
        return this.buildModifiedPartLabel(partition, genPartition);
    }

    @Override
    public ITextNode parentNode() {
        return EditTree.visibleNode(this.segment);
    }

    @Override
    public int nbOfSons() {
        return 0;
    }

    @Override
    public Iterator<ITextNode> sons() {
        return Iterators.emptyIterator();
    }

    @Override
    public boolean includeChangedText() {
        return true;
    }

    @Override
    public boolean includeUserSubNode() {
        return false;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public TextStatus getTextStatus() {
        if (this.invalid()) {
            return EditTree.textStatusFromChangeNature(this.segment.getChangeNature());
        }
        return Segment.textStatusFromDifference(this.nature.ordinal());
    }

    @Override
    public int beginIndex() {
        if (this.invalid()) {
            return this.segment.beginIndex();
        }
        return this.segment.beginIndex() + this.modBeginIdx;
    }

    @Override
    public int endIndex() {
        if (this.invalid()) {
            return this.segment.endIndex();
        }
        return this.segment.beginIndex() + this.modEndIdx;
    }

    @Override
    public int length() {
        if (this.invalid()) {
            return this.segment.length();
        }
        return this.modEndIdx - this.modBeginIdx;
    }

    @Override
    public int generatedBeginIndex() {
        if (this.invalid()) {
            return this.segment.generatedBeginIndex();
        }
        return this.segment.generatedBeginIndex() + this.refBeginIdx;
    }

    @Override
    public int generatedEndIndex() {
        if (this.invalid()) {
            return this.segment.generatedEndIndex();
        }
        return this.segment.generatedBeginIndex() + this.refEndIdx;
    }

    @Override
    public int generatedLength() {
        if (this.invalid()) {
            return this.segment.generatedLength();
        }
        return this.refEndIdx - this.refEndIdx;
    }

    @Override
    public int getNbOfDifferences() {
        return 1;
    }

    @Override
    public int getModifiedBeginIndex(int diffRank) {
        return this.modBeginIdx;
    }

    @Override
    public void setModifiedBeginIndex(int diffRank, int modifiedBeginIndex) {
        this.modBeginIdx = modifiedBeginIndex;
    }

    @Override
    public int getModifiedEndIndex(int diffRank) {
        return this.modEndIdx;
    }

    @Override
    public void setModifiedEndIndex(int diffRank, int modifiedEndIndex) {
        this.modEndIdx = modifiedEndIndex;
    }

    @Override
    public int getReferenceBeginIndex(int diffRank) {
        return this.refBeginIdx;
    }

    @Override
    public void setReferenceBeginIndex(int diffRank, int referenceBeginIndex) {
        this.refBeginIdx = referenceBeginIndex;
    }

    @Override
    public int getReferenceEndIndex(int diffRank) {
        return this.refEndIdx;
    }

    @Override
    public void setReferenceEndIndex(int diffRank, int referenceEndIndex) {
        this.refEndIdx = referenceEndIndex;
    }

    @Override
    public DifferenceNature getDifferenceNature(int diffRank) {
        return this.nature;
    }

    @Override
    public void setDifferenceNature(int diffRank, DifferenceNature diffNature) {
        this.nature = diffNature;
    }

    @Override
    public ChangeNature getChangeNature(int diffRank) {
        return Segment.changeNatureFromDifference(this.nature.ordinal());
    }

    @Override
    public TextStatus getTextStatus(int diffRank) {
        return Segment.textStatusFromDifference(this.nature.ordinal());
    }

    @Override
    public ITextNode textNode(Segment segment, int diffRank) {
        return this;
    }
}

