/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.tree.EditTree;
import com.ibm.pdp.engine.turbo.tree.SegmentNode;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.util.Iterator;

public class DetailNodeBits16
extends SegmentNode
implements IDetailedChanges {
    protected static final int LowMask = 65535;
    protected static final int HighMask = -65536;
    protected int modified;
    protected int reference;
    protected DifferenceNature nature;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DetailNodeBits16(Segment segment, int modifiedIndexes, int referenceIndexes, DifferenceNature diffNature) {
        super(segment);
        this.modified = modifiedIndexes;
        this.reference = referenceIndexes;
        this.nature = diffNature;
    }

    protected boolean invalid() {
        return this.segment.detailedChanges() != this;
    }

    @Override
    protected CharSequence buildLabel() {
        if (this.invalid()) {
            return "(Dead)";
        }
        ISubTextPartition partition = this.segment.getChangeSet().textPartition().subTextPartition(this.beginIndex(), this.endIndex());
        ISubTextPartition genPartition = this.segment.getChangeSet().generatedTextPartition().subTextPartition(this.generatedBeginIndex(), this.generatedEndIndex());
        return this.buildModifiedPartLabel(partition, genPartition);
    }

    @Override
    public ITextNode parentNode() {
        return EditTree.visibleNode(this.segment);
    }

    @Override
    public int nbOfSons() {
        return 0;
    }

    @Override
    public Iterator<ITextNode> sons() {
        return Iterators.emptyIterator();
    }

    @Override
    public boolean includeChangedText() {
        return true;
    }

    @Override
    public boolean includeUserSubNode() {
        return false;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public TextStatus getTextStatus() {
        if (this.invalid()) {
            return EditTree.textStatusFromChangeNature(this.segment.getChangeNature());
        }
        return Segment.textStatusFromDifference(this.nature.ordinal());
    }

    @Override
    public int beginIndex() {
        if (this.invalid()) {
            return this.segment.beginIndex();
        }
        return this.segment.beginIndex() + (this.modified & 0xFFFF);
    }

    @Override
    public int endIndex() {
        if (this.invalid()) {
            return this.segment.endIndex();
        }
        return this.segment.beginIndex() + (this.modified >>> 16);
    }

    @Override
    public int length() {
        if (this.invalid()) {
            return this.segment.length();
        }
        return (this.modified >>> 16) - (this.modified & 0xFFFF);
    }

    @Override
    public int generatedBeginIndex() {
        if (this.invalid()) {
            return this.segment.generatedBeginIndex();
        }
        return this.segment.generatedBeginIndex() + (this.reference & 0xFFFF);
    }

    @Override
    public int generatedEndIndex() {
        if (this.invalid()) {
            return this.segment.generatedEndIndex();
        }
        return this.segment.generatedBeginIndex() + (this.reference >>> 16);
    }

    @Override
    public int generatedLength() {
        if (this.invalid()) {
            return this.segment.generatedLength();
        }
        return (this.reference >>> 16) - (this.reference & 0xFFFF);
    }

    @Override
    public int getNbOfDifferences() {
        return 1;
    }

    @Override
    public int getModifiedBeginIndex(int diffRank) {
        return this.modified & 0xFFFF;
    }

    @Override
    public void setModifiedBeginIndex(int diffRank, int modifiedBeginIndex) {
        this.modified = this.modified & 0xFFFF0000 | modifiedBeginIndex;
    }

    @Override
    public int getModifiedEndIndex(int diffRank) {
        return this.modified >>> 16;
    }

    @Override
    public void setModifiedEndIndex(int diffRank, int modifiedEndIndex) {
        this.modified = this.modified & 0xFFFF | modifiedEndIndex << 16;
    }

    @Override
    public int getReferenceBeginIndex(int diffRank) {
        return this.reference & 0xFFFF;
    }

    @Override
    public void setReferenceBeginIndex(int diffRank, int referenceBeginIndex) {
        this.reference = this.reference & 0xFFFF0000 | referenceBeginIndex;
    }

    @Override
    public int getReferenceEndIndex(int diffRank) {
        return this.reference >>> 16;
    }

    @Override
    public void setReferenceEndIndex(int diffRank, int referenceEndIndex) {
        this.reference = this.reference & 0xFFFF | referenceEndIndex << 16;
    }

    @Override
    public DifferenceNature getDifferenceNature(int diffRank) {
        return this.nature;
    }

    @Override
    public void setDifferenceNature(int diffRank, DifferenceNature diffNature) {
        this.nature = diffNature;
    }

    @Override
    public ChangeNature getChangeNature(int diffRank) {
        return Segment.changeNatureFromDifference(this.nature.ordinal());
    }

    @Override
    public TextStatus getTextStatus(int diffRank) {
        return Segment.textStatusFromDifference(this.nature.ordinal());
    }

    @Override
    public ITextNode textNode(Segment segment, int diffRank) {
        return this;
    }
}

