/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.tree;

import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.tree.EditTree;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DetailAndSyntacticNodeIterator
implements Iterator<ITextNode> {
    protected SyntacticInfo syntacticInfo;
    protected ITextNode parentNode;
    protected Iterator<SyntacticTag> subtags;
    protected Segment segment;
    protected int diffRank;
    protected ITextNode nextSyntacticNode;
    protected ITextNode nextDetailNode;
    protected ITextNode nextOne;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected DetailAndSyntacticNodeIterator() {
    }

    protected DetailAndSyntacticNodeIterator(Segment parent) {
        this.syntacticInfo = parent.getChangeSet().getSyntacticInfo();
        this.parentNode = EditTree.visibleNode(parent);
        this.subtags = this.syntacticInfo.subTags(parent.beginIndex(), parent.endIndex());
        if (parent.detailedChanges() != null || this.subtags.hasNext()) {
            this.segment = parent;
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextOne != null || this.findNextOne();
    }

    @Override
    public ITextNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("TextNodeIterator");
        }
        ITextNode toReturn = this.nextOne;
        this.nextOne = null;
        return toReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("TextNodeIterator.remove");
    }

    protected boolean findNextOne() {
        if (this.segment == null) {
            return false;
        }
        if (this.nextDetailNode == null) {
            this.nextDetailNode = this.nextDetailNode();
        }
        if (this.nextSyntacticNode == null) {
            this.nextSyntacticNode = this.nextSyntacticNode();
        }
        if (this.nextDetailNode == null) {
            if (this.nextSyntacticNode == null) {
                return false;
            }
            this.nextOne = this.nextSyntacticNode;
            this.nextSyntacticNode = null;
            return true;
        }
        if (this.nextSyntacticNode == null) {
            this.nextOne = this.nextDetailNode;
            this.nextDetailNode = null;
            return true;
        }
        return true;
    }

    protected ITextNode nextDetailNode() {
        IDetailedChanges details = this.segment.detailedChanges();
        if (details == null) {
            return null;
        }
        int nbOfChanges = details.getNbOfDifferences();
        if (this.diffRank >= nbOfChanges) {
            return null;
        }
        return details.textNode(this.segment, this.diffRank++);
    }

    protected ITextNode nextSyntacticNode() {
        while (this.subtags.hasNext()) {
            SyntacticTag candidate = this.subtags.next();
            candidate.isToInsertInEditTree();
        }
        return null;
    }

    protected boolean checkSyntacticNodeLevel(int beginAtomRank, int endAtomRank) {
        return beginAtomRank == endAtomRank && beginAtomRank == this.segment.minRank();
    }
}

