/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.serialize;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.impl.GenericProblem;
import com.ibm.pdp.engine.turbo.impl.MicroPatternGenerationProblem;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import com.ibm.pdp.engine.turbo.reconcile.IReconciler;
import com.ibm.pdp.engine.turbo.reconcile.IReconcilerState;
import com.ibm.pdp.engine.turbo.serialize.ITextProcessorSerializer;
import com.ibm.pdp.engine.turbo.serialize.SerializationTool;
import com.ibm.pdp.util.Util;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class TextProcessorSerializerV0
implements ITextProcessorSerializer {
    public static final String VERSION = "0";
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010,2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public void serialize(ITextProcessor processor, XMLStreamWriter xmlWriter) {
        try {
            this.processGeneratedInfo(processor, xmlWriter);
            this.processGenericProblems(processor, xmlWriter);
            this.processProblems(processor, xmlWriter);
            this.processExtensions(processor, xmlWriter);
            xmlWriter.flush();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void writeTagProperties(IGeneratedTag tag, XMLStreamWriter xmlWriter) {
        try {
            Iterator names = tag.propertyNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                xmlWriter.writeAttribute(name, tag.getProperty(name));
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void writeTag(IGeneratedTag tag, CharSequence text, XMLStreamWriter xmlWriter) {
        try {
            xmlWriter.writeStartElement("Tag");
            xmlWriter.writeAttribute("name", tag.getName());
            this.writeTagProperties(tag, xmlWriter);
            int index = tag.getBeginIndex();
            Iterator subTags = tag.sons();
            while (subTags.hasNext()) {
                IGeneratedTag subTag = (IGeneratedTag)subTags.next();
                CharSequence s = text.subSequence(index, subTag.getBeginIndex());
                xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)s));
                this.writeTag(subTag, text, xmlWriter);
                index = subTag.getEndIndex();
            }
            CharSequence s = text.subSequence(index, tag.getEndIndex());
            xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)s));
            xmlWriter.writeEndElement();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void writeTagsAndText(IGeneratedInfo generatedInfo, XMLStreamWriter xmlWriter) {
        try {
            xmlWriter.writeStartElement("Text");
            this.writeTag(generatedInfo.getRootTag(), generatedInfo.getText(), xmlWriter);
            xmlWriter.writeEndElement();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void writeGenInfoProperties(IGeneratedInfo genInfo, XMLStreamWriter xmlWriter) {
        Iterator propNames = genInfo.propertyNames();
        try {
            while (propNames.hasNext()) {
                String propName = (String)propNames.next();
                String propValue = genInfo.getProperty(propName);
                if (propName.startsWith("Transcient")) continue;
                xmlWriter.writeAttribute(propName, propValue);
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void processGeneratedInfo(ITextProcessor processor, XMLStreamWriter xmlWriter) {
        try {
            xmlWriter.writeStartElement("GeneratedInfo");
            IGeneratedInfo genInfo = processor.getGeneratedInfo();
            this.writeGenInfoProperties(genInfo, xmlWriter);
            this.writeTagsAndText(genInfo, xmlWriter);
            xmlWriter.writeEndElement();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void writeSegment(Segment aSegment, XMLStreamWriter xmlWriter) {
        if (!aSegment.isAtomic()) {
            return;
        }
        String status = null;
        ChangeNature cn = aSegment.getChangeNature();
        if (cn == ChangeNature.Deleted || cn == ChangeNature.Reformated || cn == ChangeNature.Inserted || cn == ChangeNature.Modified || cn == ChangeNature.Replaced || cn == ChangeNature.Dirty) {
            status = cn.name();
        } else if (cn != ChangeNature.Unchanged) {
            System.err.println("Segment nature unknonwn. " + cn.toString());
        }
        if (status == null) {
            return;
        }
        String[] coordinates = SerializationTool.getRelativePositionOfSegment(aSegment);
        String logicalPosition = coordinates[0];
        String tagName = coordinates[1];
        try {
            xmlWriter.writeStartElement(status);
            xmlWriter.writeAttribute(logicalPosition, tagName);
            xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)aSegment.getText()));
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void processChanges(ITextProcessor processor, XMLStreamWriter xmlWriter) {
        UserChangeSet ucs = null;
        if (!(processor instanceof TextProcessor)) {
            throw new RuntimeException("TextProcessor not supported : " + processor.getClass().getName());
        }
        ucs = ((TextProcessor)processor).getChangeSet();
        if (ucs.getChangeNature() == ChangeNature.Unchanged) {
            return;
        }
        boolean globalTextStorage = SerializationTool.isModifiedTextBiggerThanTotalText(ucs);
        try {
            xmlWriter.writeStartElement("Text");
            if (globalTextStorage) {
                String s = SerializationTool.encode((CharSequence)processor.getText());
                xmlWriter.writeCharacters(s);
            } else {
                Iterator<Segment> segments = ucs.segments(null);
                Segment aSegment = null;
                while (segments.hasNext()) {
                    aSegment = segments.next();
                    if (!aSegment.isAtomic()) continue;
                    this.writeSegment(aSegment, xmlWriter);
                }
            }
            xmlWriter.writeEndElement();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void processGenericProblems(ITextProcessor processor, XMLStreamWriter xmlWriter) {
        try {
            TextProcessor tp = (TextProcessor)processor;
            if (tp.getGenericProblems().size() != 0) {
                xmlWriter.writeStartElement("GenericProblems");
                for (GenericProblem genericProblem : tp.getGenericProblems()) {
                    genericProblem.write(xmlWriter);
                }
                xmlWriter.writeEndElement();
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void processProblems(ITextProcessor processor, XMLStreamWriter xmlWriter) {
        IReconcilerState reconcileState = ((TextProcessor)processor).getReconcileState();
        IReconciler reconciler = ((TextProcessor)processor).getNewReconciler();
        reconciler.writeState(reconcileState, xmlWriter);
        try {
            TextProcessor tp = (TextProcessor)processor;
            if (tp.getMpGenerationProblems().size() != 0) {
                xmlWriter.writeStartElement("MicroPatterns");
                for (MicroPatternGenerationProblem microPatternGenerationProblem : tp.getMpGenerationProblems()) {
                    microPatternGenerationProblem.write(xmlWriter);
                }
                xmlWriter.writeEndElement();
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void processExtensions(ITextProcessor processor, XMLStreamWriter xmlWriter) {
    }
}

