/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.serialize;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.turbo.EngineFactory;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.impl.GenericProblem;
import com.ibm.pdp.engine.turbo.impl.MicroPatternGenerationProblem;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import com.ibm.pdp.engine.turbo.reconcile.IReconciler;
import com.ibm.pdp.engine.turbo.reconcile.IReconcilerState;
import com.ibm.pdp.engine.turbo.serialize.ITextProcessorDeserializer;
import com.ibm.pdp.engine.turbo.serialize.SerializationTool;
import com.ibm.pdp.util.Util;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TextProcessorDeserializerV0
implements ITextProcessorDeserializer {
    public static final String VERSION = "0";
    Properties genInfoAttributes;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010,2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private Properties getAttributes(XMLStreamReader xmlReader) throws XMLStreamException {
        Properties prop = new Properties();
        int nbOfAtt = xmlReader.getAttributeCount();
        int i = 0;
        while (i < nbOfAtt) {
            String name = xmlReader.getAttributeLocalName(i);
            String value = xmlReader.getAttributeValue(i);
            prop.put(name, value);
            ++i;
        }
        return prop;
    }

    @Override
    public void deserialize(ITextProcessor processor, XMLStreamReader xmlReader) {
        String localName = "";
        boolean finished = false;
        try {
            while (xmlReader.hasNext() && !finished) {
                int eventType = xmlReader.next();
                if (eventType == 1) {
                    localName = xmlReader.getLocalName();
                    if (localName.equalsIgnoreCase("GeneratedInfo")) {
                        this.genInfoAttributes = this.getAttributes(xmlReader);
                        this.processGeneratedInfo(processor, xmlReader);
                        continue;
                    }
                    if (localName.equalsIgnoreCase("Text")) continue;
                    if (localName.equalsIgnoreCase("Reconciler")) {
                        this.processProblems(processor, xmlReader);
                        continue;
                    }
                    if (localName.equalsIgnoreCase("GenericProblems")) {
                        this.processGenericProblems(processor, xmlReader);
                        continue;
                    }
                    if (!localName.equalsIgnoreCase("MicroPatterns")) continue;
                    this.processMicroPattern(processor, xmlReader);
                    continue;
                }
                if (eventType == 2) {
                    String qname = xmlReader.getName().getLocalPart();
                    if (!qname.equalsIgnoreCase("TextProcessor")) continue;
                    finished = true;
                    continue;
                }
                if (eventType == 5 || eventType == 4 || eventType == 12 || eventType == 8) continue;
                System.err.println("Don't know what to do. Event Type = " + eventType);
            }
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void processGeneratedInfo(ITextProcessor processor, XMLStreamReader xmlReader) throws XMLStreamException {
        EngineFactory ief = new EngineFactory();
        IGeneratedInfoFactory factory = ief.newGeneratedInfoFactory();
        factory.setProperties(this.genInfoAttributes);
        String localName = "";
        boolean finished = false;
        Properties prop = null;
        while (xmlReader.hasNext() && !finished) {
            int eventType = xmlReader.next();
            if (eventType == 1) {
                localName = xmlReader.getLocalName();
                if (!localName.equalsIgnoreCase("Tag")) continue;
                prop = new Properties();
                String tagName = "";
                int nbOfAtt = xmlReader.getAttributeCount();
                int i = 0;
                while (i < nbOfAtt) {
                    String name = xmlReader.getAttributeLocalName(i);
                    String value = xmlReader.getAttributeValue(i);
                    if (name.equalsIgnoreCase("name")) {
                        tagName = value;
                    } else {
                        prop.put(name, value);
                    }
                    ++i;
                }
                factory.beginTag(tagName, prop);
                continue;
            }
            if (eventType == 2) {
                String qname = xmlReader.getName().getLocalPart();
                if (qname.equalsIgnoreCase("GeneratedInfo")) {
                    finished = true;
                    continue;
                }
                if (!qname.equalsIgnoreCase("Tag")) continue;
                factory.endTag();
                continue;
            }
            if (eventType == 5) continue;
            if (eventType == 4) {
                String text = SerializationTool.decode((String)xmlReader.getText());
                factory.appendText((CharSequence)text);
                continue;
            }
            if (eventType == 12 || eventType == 8) continue;
            System.err.println("Don't know what to do. Event Type = " + eventType);
        }
        IGeneratedInfo genInfo = factory.createGeneratedInfo();
        processor.initialize(genInfo);
    }

    private void processChanges(ITextProcessor processor, XMLStreamReader xmlReader) throws XMLStreamException {
        UserChangeSet ucs = null;
        if (!(processor instanceof TextProcessor)) {
            throw new RuntimeException("TextProcessor not supported : " + processor.getClass().getName());
        }
        ucs = ((TextProcessor)processor).getChangeSet();
        String status = "";
        boolean finished = false;
        Segment segment = null;
        boolean globalTextStorage = true;
        StringBuilder totalText = new StringBuilder();
        while (xmlReader.hasNext() && !finished) {
            String text;
            int eventType = xmlReader.next();
            if (eventType == 1) {
                status = xmlReader.getLocalName();
                globalTextStorage = false;
                Properties properties = this.getAttributes(xmlReader);
                Iterator<Object> keys = properties.keySet().iterator();
                String logicalPosition = "";
                String tagName = "";
                while (keys.hasNext()) {
                    logicalPosition = (String)keys.next();
                    tagName = properties.getProperty(logicalPosition);
                }
                int shift = 0;
                if (logicalPosition.equalsIgnoreCase("before")) {
                    shift = -1;
                } else if (logicalPosition.equalsIgnoreCase("after")) {
                    shift = 1;
                }
                segment = ucs.segmentFromTagName(tagName, shift);
                totalText = new StringBuilder();
                continue;
            }
            if (eventType == 2) {
                String qname = xmlReader.getName().getLocalPart();
                if (qname.equalsIgnoreCase("Text")) {
                    if (globalTextStorage) {
                        processor.setText((CharSequence)totalText);
                    }
                    finished = true;
                    continue;
                }
                if (globalTextStorage) continue;
                segment.setText(totalText);
                segment.setChangeNature(ChangeNature.valueOf(status));
                continue;
            }
            if (eventType == 5) continue;
            if (eventType == 4) {
                text = SerializationTool.decode((String)xmlReader.getText());
                if (globalTextStorage) {
                    totalText.append(text);
                    continue;
                }
                totalText.append(text);
                continue;
            }
            if (eventType == 12) {
                text = SerializationTool.decode((String)xmlReader.getText());
                if (globalTextStorage) {
                    processor.setText((CharSequence)text);
                    continue;
                }
                segment.setText(text);
                segment.setChangeNature(ChangeNature.valueOf(status));
                continue;
            }
            if (eventType == 8) continue;
            System.err.println("Don't know what to do. Event Type = " + eventType);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processGenericProblems(ITextProcessor processor, XMLStreamReader xmlReader) {
        block4: {
            if (!(processor instanceof TextProcessor)) break block4;
            genericProblems = ((TextProcessor)processor).getGenericProblems();
            genericProblems.clear();
            if (true) ** GOTO lbl18
        }
        throw new RuntimeException("TextProcessor not supported : " + processor.getClass().getName());
        {
            do {
                if ((eventType = xmlReader.next()) == 1) {
                    localName = xmlReader.getLocalName();
                    if (!localName.equalsIgnoreCase("Problem")) continue;
                    genericProblem = new GenericProblem();
                    genericProblem.read(xmlReader);
                    genericProblems.add(genericProblem);
                    continue;
                }
                if (eventType != 2 || !(qname = xmlReader.getName().getLocalPart()).equalsIgnoreCase("GenericProblems")) continue;
                return;
lbl18:
                // 4 sources

            } while (xmlReader.hasNext());
        }
    }

    private void processProblems(ITextProcessor processor, XMLStreamReader xmlReader) {
        IReconciler reconciler = null;
        UserChangeSet changeSet = null;
        if (!(processor instanceof TextProcessor)) {
            throw new RuntimeException("TextProcessor not supported : " + processor.getClass().getName());
        }
        reconciler = ((TextProcessor)processor).getNewReconciler();
        changeSet = ((TextProcessor)processor).getChangeSet();
        IReconcilerState reconcileState = reconciler.newReconcilerState(changeSet);
        reconciler.readState(reconcileState, xmlReader);
        ((TextProcessor)processor).setReconcileState(reconcileState);
    }

    /*
     * Unable to fully structure code
     */
    private void processMicroPattern(ITextProcessor processor, XMLStreamReader xmlReader) {
        block4: {
            if (!(processor instanceof TextProcessor)) break block4;
            mpProblems = ((TextProcessor)processor).getMpGenerationProblems();
            mpProblems.clear();
            if (true) ** GOTO lbl18
        }
        throw new RuntimeException("TextProcessor not supported : " + processor.getClass().getName());
        {
            do {
                if ((eventType = xmlReader.next()) == 1) {
                    localName = xmlReader.getLocalName();
                    if (!localName.equalsIgnoreCase("Problem")) continue;
                    mpProblem = new MicroPatternGenerationProblem();
                    mpProblem.read(xmlReader);
                    mpProblems.add(mpProblem);
                    continue;
                }
                if (eventType != 2 || !(qname = xmlReader.getName().getLocalPart()).equalsIgnoreCase("MicroPatterns")) continue;
                return;
lbl18:
                // 4 sources

            } while (xmlReader.hasNext());
        }
    }
}

