/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.serialize;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.util.XmlSerializationTool;
import java.util.Iterator;

public class SerializationTool
extends XmlSerializationTool {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean isModifiedTextBiggerThanTotalText(UserChangeSet ucs) {
        int staticWeight = 9;
        int totalLength = ucs.length();
        Iterator<Segment> segments = ucs.segments(null);
        Segment aSegment = null;
        ChangeNature chgNature = null;
        int nbOfCharsInSpecificText = 0;
        int nbOfDirtySegments = 0;
        int nbOfSegments = 0;
        while (segments.hasNext()) {
            aSegment = segments.next();
            if (!aSegment.isAtomic()) continue;
            ++nbOfSegments;
            chgNature = aSegment.getChangeNature();
            if (chgNature == ChangeNature.Unchanged) continue;
            if (chgNature == ChangeNature.Dirty) {
                ++nbOfDirtySegments;
            }
            String[] coordinates = SerializationTool.getRelativePositionOfSegment(aSegment);
            String logicalPosition = coordinates[0];
            String tagName = coordinates[1];
            int segmentTextlength = aSegment.getText().length();
            if ((nbOfCharsInSpecificText = nbOfCharsInSpecificText + segmentTextlength + chgNature.name().length() * 2 + logicalPosition.length() + tagName.length() + staticWeight) <= totalLength) continue;
            return true;
        }
        int ratioDirtyOverTotal = nbOfDirtySegments / nbOfSegments * 100;
        return ratioDirtyOverTotal > 75;
    }

    public static String[] getRelativePositionOfSegment(Segment aSegment) {
        IGeneratedTag next = aSegment.toTag();
        IGeneratedTag previous = aSegment.fromTag();
        IGeneratedTag includingTag = aSegment.enclosingTag();
        String logicalPosition = null;
        String tagName = null;
        if (next == includingTag) {
            if (includingTag == previous) {
                logicalPosition = "at";
                tagName = includingTag.getName();
            } else {
                logicalPosition = "after";
                tagName = previous.getName();
            }
        } else {
            logicalPosition = "before";
            tagName = next.getName();
        }
        String[] result = new String[]{logicalPosition, tagName};
        return result;
    }
}

