/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.reconcile.TextReconcileProblem;
import com.ibm.pdp.engine.turbo.reconcile.TextReconciler;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.diff.Diff3Cursor;
import com.ibm.pdp.util.diff.DifferenceLocation;
import com.ibm.pdp.util.ints.IntSequence;
import com.ibm.pdp.util.sort.CharSequenceComparator;

public class TextReconcilerCursor {
    private int startIndex;
    private int stopIndex;
    private int textOrigine;
    private static int MODIFIED_TEXT = 0;
    private static int NEW_GENERATED_TEXT = 1;
    private Diff3Cursor diff3Cursor;
    private int currentDiff3ReferenceCharIndex;
    private boolean lastWasDifference;
    private TextReconciler textReconciler;
    private boolean lastCursorPositionReached;
    private boolean hasFoundSegment;
    private ITextPartition oldGeneratedText;
    private ITextPartition modifiedText;
    private ITextPartition newGeneratedText;
    private IntSequence oldGeneratedWords;
    private IntSequence modifiedWords;
    private IntSequence newGeneratedWords;
    private int currentReconcilationTextIndex;
    private IProblem problem = null;
    private int oldGeneratedBeginIndex;
    private int oldGeneratedEndIndex;
    private int modifiedBeginIndex;
    private int modifiedEndIndex;
    private int newGeneratedBeginIndex;
    private int newGeneratedEndIndex;
    private SavedState savedState;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static int getWordBeginIndex(int wordBeforeRank, ITextPartition textPartition, boolean withBeforeSpace) {
        return TextReconcilerCursor.getWordBeginIndex(wordBeforeRank, textPartition, withBeforeSpace, true);
    }

    public static int getWordEndIndex(int wordAfterRank, ITextPartition textPartition, boolean withAfterSpace) {
        return TextReconcilerCursor.getWordBeginIndex(wordAfterRank, textPartition, withAfterSpace, false);
    }

    private static int getWordBeginIndex(int wordRank, ITextPartition textPartition, boolean withSpace, boolean begin) {
        int wordsCount = textPartition.getWordsCount();
        if (wordRank > wordsCount) {
            throw new RuntimeException("TextReconcilerCursor: bad call of getWordBeginIndex");
        }
        if (wordRank < wordsCount) {
            int wordBeginIndex = textPartition.wordBeginIndex(wordRank);
            if (begin && withSpace || !begin && !withSpace) {
                wordBeginIndex -= textPartition.spaceBeforeWord(wordRank);
            }
            return wordBeginIndex;
        }
        if (wordRank == 0) {
            return 0;
        }
        int wordBeginIndex = textPartition.wordBeginIndex(wordRank - 1) + textPartition.wordLength(wordRank - 1);
        if (begin && !withSpace || !begin && withSpace) {
            wordBeginIndex += textPartition.spaceAfterWord(wordRank - 1);
        }
        return wordBeginIndex;
    }

    TextReconcilerCursor(ITextPartition oldGeneratedText, ITextPartition modifiedText, ITextPartition newGeneratedText, TextReconciler textReconciler) {
        this.oldGeneratedText = oldGeneratedText;
        this.modifiedText = modifiedText;
        this.newGeneratedText = newGeneratedText;
        this.textReconciler = textReconciler;
    }

    public int startIndex() {
        return this.startIndex;
    }

    public int stopIndex() {
        return this.stopIndex;
    }

    public CharSequence getText() {
        return this.getOrigin().getTextInterval(this.startIndex, this.stopIndex);
    }

    public ITextPartition getOrigin() {
        if (this.textOrigine == MODIFIED_TEXT) {
            return this.modifiedText;
        }
        return this.newGeneratedText;
    }

    private void wordsAndDiff3Init() {
        this.oldGeneratedWords = this.oldGeneratedText.getWords();
        this.modifiedWords = this.modifiedText.getWords();
        this.newGeneratedWords = this.newGeneratedText.getWords();
        this.diff3Cursor = Ints.newDiff3Cursor((IntSequence)this.oldGeneratedWords, (IntSequence)this.modifiedWords, (IntSequence)this.newGeneratedWords);
        this.diff3Cursor.searchNextDifference();
    }

    public boolean hasFoundSegment() {
        return this.hasFoundSegment;
    }

    public boolean searchNextSegment() {
        this.problem = null;
        if (this.diff3Cursor == null) {
            this.wordsAndDiff3Init();
        }
        if (this.lastCursorPositionReached) {
            this.hasFoundSegment = false;
            return this.hasFoundSegment;
        }
        if (!this.diff3Cursor.hasFoundDifference()) {
            this.lastCursorPositionReached = true;
            this.manageEquality(0, this.oldGeneratedText.getTextLength(), 0, this.modifiedText.getTextLength(), 0, this.newGeneratedText.getTextLength());
            this.oldGeneratedBeginIndex = 0;
            this.oldGeneratedEndIndex = this.oldGeneratedText.getTextLength();
            this.modifiedBeginIndex = 0;
            this.modifiedEndIndex = this.modifiedText.getTextLength();
            this.newGeneratedBeginIndex = 0;
            this.newGeneratedEndIndex = this.newGeneratedText.getTextLength();
            this.hasFoundSegment = true;
            return this.hasFoundSegment;
        }
        if (this.lastWasDifference && !this.diff3Cursor.searchNextDifference()) {
            int refenceStartIndex = TextReconcilerCursor.getWordBeginIndex(this.savedState.wordReferenceEndIndex, this.oldGeneratedText, false);
            int modifyStartIndex = TextReconcilerCursor.getWordBeginIndex(this.savedState.wordModif1EndIndex, this.modifiedText, false);
            int newGenratedStartIndex = TextReconcilerCursor.getWordBeginIndex(this.savedState.wordModif2EndIndex, this.newGeneratedText, false);
            this.manageEquality(refenceStartIndex, this.oldGeneratedText.getTextLength(), modifyStartIndex, this.modifiedText.getTextLength(), newGenratedStartIndex, this.newGeneratedText.getTextLength());
            this.oldGeneratedBeginIndex = TextReconcilerCursor.getWordBeginIndex(this.savedState.wordReferenceEndIndex, this.oldGeneratedText, true);
            this.oldGeneratedEndIndex = this.oldGeneratedText.getTextLength();
            this.modifiedBeginIndex = modifyStartIndex;
            this.modifiedEndIndex = this.modifiedText.getTextLength();
            this.newGeneratedBeginIndex = newGenratedStartIndex;
            this.newGeneratedEndIndex = this.newGeneratedText.getTextLength();
            this.lastCursorPositionReached = true;
            this.hasFoundSegment = true;
            return this.hasFoundSegment;
        }
        if (this.diff3Cursor.getReferenceBeginIndex() > this.currentDiff3ReferenceCharIndex) {
            int referenceStartIndex = 0;
            int modifiedStartIndex = 0;
            int newGeneratedStartIndex = 0;
            if (this.savedState != null) {
                referenceStartIndex = TextReconcilerCursor.getWordBeginIndex(this.savedState.wordReferenceEndIndex, this.oldGeneratedText, false);
                modifiedStartIndex = TextReconcilerCursor.getWordBeginIndex(this.savedState.wordModif1EndIndex, this.modifiedText, false);
                newGeneratedStartIndex = TextReconcilerCursor.getWordBeginIndex(this.savedState.wordModif2EndIndex, this.newGeneratedText, false);
            }
            int referenceEndIndex = TextReconcilerCursor.getWordEndIndex(this.diff3Cursor.getReferenceBeginIndex(), this.oldGeneratedText, false);
            int modifiedEndIndex = TextReconcilerCursor.getWordEndIndex(this.diff3Cursor.getModified1BeginIndex(), this.modifiedText, false);
            int newGeneratedEndIndex = TextReconcilerCursor.getWordEndIndex(this.diff3Cursor.getModified2BeginIndex(), this.newGeneratedText, false);
            this.manageEquality(referenceStartIndex, referenceEndIndex, modifiedStartIndex, modifiedEndIndex, newGeneratedStartIndex, newGeneratedEndIndex);
            this.oldGeneratedBeginIndex = referenceStartIndex;
            if (this.savedState != null) {
                this.oldGeneratedBeginIndex = TextReconcilerCursor.getWordBeginIndex(this.savedState.wordReferenceEndIndex, this.oldGeneratedText, true);
            }
            this.oldGeneratedEndIndex = referenceEndIndex;
            this.modifiedBeginIndex = modifiedStartIndex;
            this.modifiedEndIndex = modifiedEndIndex;
            this.newGeneratedBeginIndex = newGeneratedStartIndex;
            this.newGeneratedEndIndex = newGeneratedEndIndex;
            this.currentDiff3ReferenceCharIndex = this.diff3Cursor.getReferenceBeginIndex();
            this.lastWasDifference = false;
        } else {
            int wordModif1BeginIndex = this.diff3Cursor.getModified1BeginIndex();
            int wordModif1EndIndex = this.diff3Cursor.getModified1EndIndex();
            int wordModif2BeginIndex = this.diff3Cursor.getModified2BeginIndex();
            int wordModif2EndIndex = this.diff3Cursor.getModified2EndIndex();
            if (this.diff3Cursor.getDifferenceLocation() == DifferenceLocation.Reference || this.diff3Cursor.getDifferenceLocation() == DifferenceLocation.Modified1) {
                this.startIndex = TextReconcilerCursor.getWordBeginIndex(wordModif1BeginIndex, this.modifiedText, !this.lastWasDifference);
                this.stopIndex = TextReconcilerCursor.getWordEndIndex(wordModif1EndIndex, this.modifiedText, true);
                this.textOrigine = MODIFIED_TEXT;
            }
            if (this.diff3Cursor.getDifferenceLocation() == DifferenceLocation.Modified2) {
                this.startIndex = TextReconcilerCursor.getWordBeginIndex(wordModif2BeginIndex, this.newGeneratedText, !this.lastWasDifference);
                this.stopIndex = TextReconcilerCursor.getWordEndIndex(wordModif2EndIndex, this.newGeneratedText, true);
                this.textOrigine = NEW_GENERATED_TEXT;
            }
            if (this.diff3Cursor.getDifferenceLocation() == DifferenceLocation.All) {
                this.startIndex = TextReconcilerCursor.getWordBeginIndex(wordModif1BeginIndex, this.modifiedText, !this.lastWasDifference);
                this.stopIndex = TextReconcilerCursor.getWordEndIndex(wordModif1EndIndex, this.modifiedText, true);
                this.textOrigine = MODIFIED_TEXT;
                int startIndex2 = TextReconcilerCursor.getWordBeginIndex(wordModif2BeginIndex, this.newGeneratedText, !this.lastWasDifference);
                int stopIndex2 = TextReconcilerCursor.getWordEndIndex(wordModif2EndIndex, this.newGeneratedText, true);
                int generatedStartIndex = TextReconcilerCursor.getWordBeginIndex(this.diff3Cursor.getReferenceBeginIndex(), this.oldGeneratedText, !this.lastWasDifference);
                int generatedEndIndex = TextReconcilerCursor.getWordBeginIndex(this.diff3Cursor.getReferenceEndIndex(), this.oldGeneratedText, true);
                TextReconcileProblem problem = new TextReconcileProblem(generatedStartIndex, generatedEndIndex, this.startIndex, this.stopIndex, startIndex2, stopIndex2, this.currentReconcilationTextIndex, this.currentReconcilationTextIndex + this.stopIndex - this.startIndex, true, "CONFLICT");
                this.textReconciler.addProblem(problem);
                this.problem = problem;
            }
            this.oldGeneratedBeginIndex = TextReconcilerCursor.getWordBeginIndex(this.diff3Cursor.getReferenceBeginIndex(), this.oldGeneratedText, true);
            this.oldGeneratedEndIndex = TextReconcilerCursor.getWordBeginIndex(this.diff3Cursor.getReferenceEndIndex(), this.oldGeneratedText, true);
            this.modifiedBeginIndex = TextReconcilerCursor.getWordBeginIndex(wordModif1BeginIndex, this.modifiedText, !this.lastWasDifference);
            this.modifiedEndIndex = TextReconcilerCursor.getWordEndIndex(wordModif1EndIndex, this.modifiedText, true);
            this.newGeneratedBeginIndex = TextReconcilerCursor.getWordBeginIndex(wordModif2BeginIndex, this.newGeneratedText, !this.lastWasDifference);
            this.newGeneratedEndIndex = TextReconcilerCursor.getWordEndIndex(wordModif2EndIndex, this.newGeneratedText, true);
            this.currentReconcilationTextIndex = this.currentReconcilationTextIndex + this.stopIndex - this.startIndex;
            this.currentDiff3ReferenceCharIndex = this.diff3Cursor.getReferenceEndIndex();
            this.saveDiff3state();
            this.lastWasDifference = true;
        }
        this.hasFoundSegment = true;
        return this.hasFoundSegment;
    }

    private void saveDiff3state() {
        if (this.savedState == null) {
            this.savedState = new SavedState();
        }
        this.savedState.differenceLocation = this.diff3Cursor.getDifferenceLocation();
        this.savedState.wordReferenceEndIndex = this.diff3Cursor.getReferenceEndIndex();
        this.savedState.wordModif1EndIndex = this.diff3Cursor.getModified1EndIndex();
        this.savedState.wordModif2EndIndex = this.diff3Cursor.getModified2EndIndex();
    }

    private void manageEquality(int referenceStartIndex, int referenceEndIndex, int modifiedstartIndex, int modifiedEndIndex, int newGeneratedStartIndex, int newGeneratedEndIndex) {
        int mod1RefDiff;
        int mod1Mod2Diff;
        CharSequence referenceText = this.oldGeneratedText.getTextInterval(referenceStartIndex, referenceEndIndex);
        CharSequence modified1Text = this.modifiedText.getTextInterval(modifiedstartIndex, modifiedEndIndex);
        CharSequence modified2Text = this.newGeneratedText.getTextInterval(newGeneratedStartIndex, newGeneratedEndIndex);
        int mod2RefDiff = CharSequenceComparator.DEFAULT_COMPARATOR.compare(modified2Text, referenceText);
        if (mod2RefDiff != 0 && (mod1Mod2Diff = CharSequenceComparator.DEFAULT_COMPARATOR.compare(modified1Text, modified2Text)) != 0 && (mod1RefDiff = CharSequenceComparator.DEFAULT_COMPARATOR.compare(modified1Text, referenceText)) == 0) {
            this.startIndex = newGeneratedStartIndex;
            this.stopIndex = newGeneratedEndIndex;
            this.textOrigine = NEW_GENERATED_TEXT;
            return;
        }
        this.startIndex = modifiedstartIndex;
        this.stopIndex = modifiedEndIndex;
        this.textOrigine = MODIFIED_TEXT;
    }

    public IProblem getProblem() {
        return this.problem;
    }

    public int getOldGeneratedBeginIndex() {
        return this.oldGeneratedBeginIndex;
    }

    public int getOldGeneratedEndIndex() {
        return this.oldGeneratedEndIndex;
    }

    public int getModifiedBeginIndex() {
        return this.modifiedBeginIndex;
    }

    public int getModifiedEndIndex() {
        return this.modifiedEndIndex;
    }

    public int getNewGeneratedBeginIndex() {
        return this.newGeneratedBeginIndex;
    }

    public int getNewGeneratedEndIndex() {
        return this.newGeneratedEndIndex;
    }

    private class SavedState {
        private DifferenceLocation differenceLocation;
        private int wordReferenceEndIndex;
        private int wordModif1EndIndex;
        private int wordModif2EndIndex;

        private SavedState() {
        }

        DifferenceLocation getDifferenceLocation() {
            return this.differenceLocation;
        }
    }
}

