/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.pdp.engine.ITextInterval;
import com.ibm.pdp.engine.extension.IReconcileExtension;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.ReconcileCoincidence;
import com.ibm.pdp.engine.turbo.properties.ReconcileCoincidenceDeletion;
import com.ibm.pdp.engine.turbo.properties.ReconcileConflict;
import com.ibm.pdp.engine.turbo.properties.ReconcilePriority;
import com.ibm.pdp.engine.turbo.properties.TagProperties;
import com.ibm.pdp.engine.turbo.reconcile.IReconciler;
import com.ibm.pdp.engine.turbo.reconcile.IReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.TagReconcilerState;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class TagReconciler
implements IReconciler {
    protected TagReconcilerState oldState;
    protected TagReconcilerState newState;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public IReconcilerState newReconcilerState(UserChangeSet changeSet) {
        return new TagReconcilerState(changeSet);
    }

    @Override
    public IReconcilerState reconcile(IReconcilerState state, UserChangeSet newUserChangeSet) {
        this.oldState = (TagReconcilerState)state;
        this.newState = new TagReconcilerState(newUserChangeSet);
        return null;
    }

    @Override
    public int translateIndex(int index, IReconcilerState oldState, IReconcilerState newState) {
        return 0;
    }

    @Override
    public ITextInterval translateInterval(int beginIdx, int endIdx, IReconcilerState oldState, IReconcilerState newState) {
        return null;
    }

    protected void reconcileSegment(Segment oldSegment, Segment newSegment) {
        switch (oldSegment.getChangeNature()) {
            case Reformated: {
                this.reconcileReformatedSegment(oldSegment, newSegment);
                return;
            }
            case Modified: {
                this.reconcileModifiedSegment(oldSegment, newSegment);
                return;
            }
            case Deleted: {
                this.reconcileDeletedSegment(oldSegment, newSegment);
                return;
            }
            case Inserted: {
                this.reconcileInsertedSegment(oldSegment, newSegment);
                return;
            }
            case Replaced: 
            case Dirty: {
                this.reconcileReplacedSegment(oldSegment, newSegment);
                return;
            }
        }
    }

    protected void reconcileReformatedSegment(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileModifiedSegment(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileDeletedSegment(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileInsertedSegment(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileReplacedSegment(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileReformatedAtom(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileModifiedAtom(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileDeletedAtom(Segment oldSegment, Segment newSegment) {
        TagProperties properties = oldSegment.getTagProperties();
        switch (properties.getReconcileMode()) {
            case TagReconcile: {
                this.tagReconcileDeletedAtom(oldSegment, newSegment);
                return;
            }
            case FineReconcile: {
                this.fineReconcileDeletedAtom(oldSegment, newSegment);
                return;
            }
        }
    }

    protected void tagReconcileDeletedAtom(Segment oldSegment, Segment newSegment) {
        if (newSegment.isGeneratedBlank()) {
            this.tagReconcileAtomCoincidenceDeletion(oldSegment, newSegment);
            return;
        }
        if (this.sameGeneratedWords(oldSegment, newSegment)) {
            newSegment.setText(oldSegment.getText());
            return;
        }
        TagProperties properties = oldSegment.getTagProperties();
        if (properties.getReconcilePriority() != ReconcilePriority.GeneratedChanges) {
            newSegment.setText(oldSegment.getText());
        }
        if (properties.getReconcileConflict() != ReconcileConflict.Silent) {
            this.conflictDeletionAgainstGeneratedCodeChange(oldSegment, newSegment);
        }
    }

    protected void conflictDeletionAgainstGeneratedCodeChange(Segment oldSegment, Segment newSegment) {
    }

    protected void tagReconcileAtomCoincidenceDeletion(Segment oldSegment, Segment newSegment) {
        TagProperties properties = oldSegment.getTagProperties();
        if (properties.getReconcilePriority() == ReconcilePriority.UserChanges) {
            newSegment.setText(oldSegment.getText());
        }
        if (this.silentCoincidenceDeletion(properties)) {
            return;
        }
    }

    protected boolean silentCoincidenceDeletion(TagProperties properties) {
        ReconcileCoincidenceDeletion rcd = properties.getReconcileCoincidenceDeletion();
        if (rcd != null) {
            return rcd == ReconcileCoincidenceDeletion.Silent;
        }
        return properties.getReconcileCoincidence() == ReconcileCoincidence.Silent;
    }

    protected void fineReconcileDeletedAtom(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileInsertedAtom(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileReplacedAtom(Segment oldSegment, Segment newSegment) {
    }

    protected void reconcileSegmentInterval(Segment firstOldSegment, Segment lastOldSegment, Segment firstNewSegment, Segment lastNewSegment) {
    }

    protected boolean sameGeneratedWords(Segment left, Segment right) {
        return false;
    }

    @Override
    public void readState(IReconcilerState state, XMLStreamReader stream) {
    }

    @Override
    public void writeState(IReconcilerState state, XMLStreamWriter stream) {
    }

    @Override
    public IReconcileExtension getReconcileExtension() {
        return null;
    }

    @Override
    public void setReconcileExtension(IReconcileExtension newReconcileExtension) {
    }
}

