/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.extension.IReconcileExtension;
import com.ibm.pdp.engine.extension.IReconcileLocationInterval;
import com.ibm.pdp.engine.extension.IReconcileTextInterval;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITracerDelegate;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileConstants;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileLocation;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileLocationInterval;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileProblem;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileTextInterval;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileUtil;
import com.ibm.pdp.engine.turbo.reconcile.ReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.SegmentReconciler;
import com.ibm.pdp.engine.turbo.reconcile.TextReconcileProblem;
import com.ibm.pdp.engine.turbo.reconcile.TextReconciler;
import com.ibm.pdp.engine.turbo.reconcile.TextReconcilerCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SegmentTextualReconciler
implements ReconcileConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private UserChangeSet _oldChangeSet;
    private UserChangeSet _newChangeSet;
    private IReconcileExtension _reconcileExtension;
    private ReconcilerState _reconcilerState;
    private ITextPartition _oldGeneratedTextPartition;
    private ITextPartition _oldModifiedTextPartition;
    private ITextPartition _newGeneratedTextPartition;

    public SegmentTextualReconciler(UserChangeSet oldChangeSet, UserChangeSet newChangeSet, IReconcileExtension reconcileExtension, ReconcilerState reconcilerState, ITextPartition oldGeneratedTextPartition, ITextPartition oldModifiedTextPartition, ITextPartition newGeneratedTextPartition) {
        this._oldChangeSet = oldChangeSet;
        this._newChangeSet = newChangeSet;
        this._reconcileExtension = reconcileExtension;
        this._reconcilerState = reconcilerState;
        this._newGeneratedTextPartition = newGeneratedTextPartition;
        this._oldGeneratedTextPartition = oldGeneratedTextPartition;
        this._oldModifiedTextPartition = oldModifiedTextPartition;
    }

    private List<TextReconcilerInterval> getTextReconcilerIntervals() {
        ArrayList<TextReconcilerInterval> textReconcilerIntervals = new ArrayList<TextReconcilerInterval>();
        TextReconciler tr = new TextReconciler(this._oldGeneratedTextPartition, this._oldModifiedTextPartition, this._newGeneratedTextPartition);
        TextReconcilerCursor trc = tr.getCursor();
        TextReconcilerInterval last = null;
        while (trc.searchNextSegment()) {
            TextReconcilerInterval interval = new TextReconcilerInterval();
            interval.oldGeneratedBeginIndex = trc.getOldGeneratedBeginIndex();
            interval.oldGeneratedEndIndex = trc.getOldGeneratedEndIndex();
            interval.modifiedBeginIndex = trc.getModifiedBeginIndex();
            interval.modifiedEndIndex = trc.getModifiedEndIndex();
            interval.newGeneratedBeginIndex = trc.getNewGeneratedBeginIndex();
            interval.newGeneratedEndIndex = trc.getNewGeneratedEndIndex();
            interval.origin = trc.getOrigin();
            interval.problem = (TextReconcileProblem)trc.getProblem();
            if (interval.origin == this._newGeneratedTextPartition) {
                interval.isNewGeneratedCode = true;
            }
            if (interval.oldGeneratedBeginIndex == interval.oldGeneratedEndIndex && interval.modifiedBeginIndex == interval.modifiedEndIndex && interval.newGeneratedBeginIndex == interval.newGeneratedEndIndex) continue;
            if (last != null && last.problem == null && last.origin == interval.origin && interval.problem == null && last.oldGeneratedEndIndex == interval.oldGeneratedBeginIndex && last.newGeneratedEndIndex == interval.newGeneratedBeginIndex && last.modifiedEndIndex == interval.modifiedBeginIndex) {
                last.modifiedEndIndex = interval.modifiedEndIndex;
                last.oldGeneratedEndIndex = interval.oldGeneratedEndIndex;
                last.newGeneratedEndIndex = interval.newGeneratedEndIndex;
                continue;
            }
            textReconcilerIntervals.add(interval);
            last = interval;
        }
        return textReconcilerIntervals;
    }

    public List<IReconcileLocationInterval> reconcileTextualArea(int oldModifiedOffset, int newGeneratedOffset, SegmentReconciler.SegmentsArea area, List<SegmentReconciler.ProtectedSegmentArea> oldModifiedProtectedSegmentAreas, List<SegmentReconciler.ProtectedSegmentArea> newGeneratedProtectedSegmentAreas, List<SegmentReconciler.ProtectedSegmentArea> oldModifiedRemovedSegmentAreas, List<IProblem> textualProblems, List<IProblem> conflicProblems, ITracerDelegate tracer) {
        if (tracer.isDebugModeEnabled()) {
            tracer.debug((Object)this, "reconcileTextualArea", "#####\nOld Generated\n" + this._oldGeneratedTextPartition.getText());
            tracer.debug((Object)this, "reconcileTextualArea", "\nOld Modified\n" + this._oldModifiedTextPartition.getText());
            tracer.debug((Object)this, "reconcileTextualArea", "\nNew Generated\n" + this._newGeneratedTextPartition.getText());
        }
        List<TextReconcilerInterval> textReconcilerIntervals = this.getTextReconcilerIntervals();
        ArrayList<IReconcileLocationInterval> reconcileLocationAreas = new ArrayList<IReconcileLocationInterval>();
        Segment startSegment = area.newArea[0];
        ReconcileLocationInterval currentRecLocationArea = new ReconcileLocationInterval();
        boolean dispachedFlag = false;
        for (TextReconcilerInterval textReconcilerInterval : textReconcilerIntervals) {
            int stopRemovedIndex;
            int startRemovedIndex;
            int stopProtectedIndex;
            int startProtectedIndex;
            int currentPartitionIdx;
            int stopIndex;
            int startIndex;
            dispachedFlag = false;
            if (textReconcilerInterval.origin == this._newGeneratedTextPartition) {
                startIndex = textReconcilerInterval.newGeneratedBeginIndex;
                stopIndex = textReconcilerInterval.newGeneratedEndIndex;
                currentPartitionIdx = startIndex;
                boolean flag = false;
                for (SegmentReconciler.ProtectedSegmentArea segmentArea : newGeneratedProtectedSegmentAreas) {
                    startProtectedIndex = segmentArea.beginIndex;
                    stopProtectedIndex = segmentArea.endIndex;
                    if (startProtectedIndex < startIndex || stopProtectedIndex > stopIndex) continue;
                    if (currentRecLocationArea.getStartReconcileLocation() == null && !flag) {
                        flag = true;
                        currentRecLocationArea.setStartEndSegments(startSegment, startSegment);
                        reconcileLocationAreas.add(currentRecLocationArea);
                        currentRecLocationArea = new ReconcileLocationInterval();
                    }
                    int i = 0;
                    while (i < area.newArea.length) {
                        if (area.newArea[i].generatedBeginIndex() - newGeneratedOffset == startProtectedIndex && area.newArea[i].generatedEndIndex() - newGeneratedOffset == stopProtectedIndex && i < area.newArea.length - 1) {
                            startSegment = area.newArea[i + 1];
                            break;
                        }
                        ++i;
                    }
                    currentPartitionIdx = stopProtectedIndex;
                }
                if (currentPartitionIdx < stopIndex) {
                    currentRecLocationArea.addReconcileArea(currentPartitionIdx, stopIndex, newGeneratedOffset, !this.isProtectedWordArea(startSegment.generatedBeginIndex() - newGeneratedOffset, startSegment.generatedEndIndex() - newGeneratedOffset, newGeneratedProtectedSegmentAreas), true, this._newChangeSet);
                }
                for (SegmentReconciler.ProtectedSegmentArea segmentArea : oldModifiedRemovedSegmentAreas) {
                    Segment removedSegment;
                    startRemovedIndex = segmentArea.beginIndex;
                    stopRemovedIndex = segmentArea.endIndex;
                    if (startRemovedIndex < textReconcilerInterval.modifiedBeginIndex || stopRemovedIndex > textReconcilerInterval.modifiedEndIndex) continue;
                    Segment removedBlockSegment = removedSegment = segmentArea.segment;
                    if (startRemovedIndex != stopRemovedIndex) {
                        removedBlockSegment = this.getRemovedBlockSegment(area.oldArea, startRemovedIndex + oldModifiedOffset, stopRemovedIndex + oldModifiedOffset);
                    }
                    currentRecLocationArea.addRemovedReconcileArea(removedBlockSegment, removedSegment);
                }
                continue;
            }
            startIndex = textReconcilerInterval.modifiedBeginIndex;
            stopIndex = textReconcilerInterval.modifiedEndIndex;
            currentPartitionIdx = startIndex;
            boolean removedFlag = false;
            block4: for (SegmentReconciler.ProtectedSegmentArea segmentArea : oldModifiedRemovedSegmentAreas) {
                Segment removedSegment;
                startRemovedIndex = segmentArea.beginIndex;
                stopRemovedIndex = segmentArea.endIndex;
                if (startRemovedIndex < startIndex || stopRemovedIndex > stopIndex) continue;
                currentPartitionIdx = stopRemovedIndex;
                Segment removedBlockSegment = removedSegment = segmentArea.segment;
                if (startRemovedIndex != stopRemovedIndex) {
                    removedBlockSegment = this.getRemovedBlockSegment(area.oldArea, startRemovedIndex + oldModifiedOffset, stopRemovedIndex + oldModifiedOffset);
                    currentRecLocationArea.addRemovedReconcileArea(removedBlockSegment, removedSegment);
                    int offset = removedBlockSegment.endIndex() - removedSegment.endIndex();
                    if (offset <= 0) continue;
                    currentPartitionIdx += offset;
                    continue;
                }
                if (textReconcilerInterval.problem != null) {
                    removedFlag = true;
                    ReconcileLocationInterval removedRecLocationArea = new ReconcileLocationInterval();
                    removedRecLocationArea.addRemovedReconcileArea(removedBlockSegment, removedSegment);
                    int i = 0;
                    while (i < area.newArea.length) {
                        if (area.newArea[i].generatedBeginIndex() - newGeneratedOffset == textReconcilerInterval.newGeneratedBeginIndex && area.newArea[i].generatedEndIndex() - newGeneratedOffset == textReconcilerInterval.newGeneratedEndIndex) {
                            startSegment = area.newArea[i];
                            removedRecLocationArea.setStartEndSegments(startSegment, startSegment);
                            reconcileLocationAreas.add(removedRecLocationArea);
                            if (i >= area.newArea.length - 1) continue block4;
                            startSegment = area.newArea[i + 1];
                            continue block4;
                        }
                        ++i;
                    }
                    continue;
                }
                if (!segmentArea.isTreated) {
                    currentRecLocationArea.addRemovedReconcileArea(removedBlockSegment, removedSegment);
                }
                segmentArea.isTreated = true;
            }
            for (SegmentReconciler.ProtectedSegmentArea segmentArea : oldModifiedProtectedSegmentAreas) {
                startProtectedIndex = segmentArea.beginIndex;
                stopProtectedIndex = segmentArea.endIndex;
                if (startProtectedIndex < startIndex || stopProtectedIndex > stopIndex || currentPartitionIdx > startProtectedIndex) continue;
                currentRecLocationArea.addReconcileArea(currentPartitionIdx, startProtectedIndex, oldModifiedOffset, !this.isProtectedWordArea(startSegment.generatedBeginIndex() - newGeneratedOffset, startSegment.generatedEndIndex() - newGeneratedOffset, newGeneratedProtectedSegmentAreas), false, this._oldChangeSet);
                currentPartitionIdx = stopProtectedIndex;
                if (currentPartitionIdx != stopIndex) continue;
                dispachedFlag = true;
            }
            if (currentPartitionIdx < stopIndex || currentPartitionIdx == stopIndex && startSegment.getText().length() != 0) {
                currentRecLocationArea.addReconcileArea(currentPartitionIdx, stopIndex, oldModifiedOffset, !this.isProtectedWordArea(startSegment.generatedBeginIndex() - newGeneratedOffset, startSegment.generatedEndIndex() - newGeneratedOffset, newGeneratedProtectedSegmentAreas), false, this._oldChangeSet);
            }
            if (textReconcilerInterval.problem == null || removedFlag || dispachedFlag) continue;
            TextReconcileProblem problem = textReconcilerInterval.problem;
            ArrayList<IReconcileLocationInterval> dispachedLocationAreas = new ArrayList<IReconcileLocationInterval>();
            int pbNewStartIndex = problem.getNewGeneratedBeginIndex();
            int pbNewStopIndex = problem.getNewGeneratedEndIndex();
            block7: for (SegmentReconciler.ProtectedSegmentArea segmentArea : newGeneratedProtectedSegmentAreas) {
                Segment fromSegment;
                int startProtectedIndex2 = segmentArea.beginIndex;
                int stopProtectedIndex2 = segmentArea.endIndex;
                if (startProtectedIndex2 < pbNewStartIndex || stopProtectedIndex2 > pbNewStopIndex) continue;
                Segment toSegment = fromSegment = startSegment;
                currentRecLocationArea.setStartEndSegments(fromSegment, toSegment);
                dispachedLocationAreas.add(currentRecLocationArea);
                currentRecLocationArea = new ReconcileLocationInterval();
                int i = 0;
                while (i < area.newArea.length) {
                    if (area.newArea[i].generatedBeginIndex() - newGeneratedOffset == startProtectedIndex2 && area.newArea[i].generatedEndIndex() - newGeneratedOffset == stopProtectedIndex2 && i < area.newArea.length - 1) {
                        startSegment = area.newArea[i + 1];
                        continue block7;
                    }
                    ++i;
                }
            }
            if (dispachedLocationAreas.size() == 0) {
                ReconcileProblem iProblem;
                ReconcileLocationInterval conflictInterval = currentRecLocationArea;
                if (startIndex >= stopIndex) continue;
                int idx = conflictInterval.getReconcileAreas().size();
                ReconcileTextInterval lastReconcileTextInterval = null;
                if (idx > 0) {
                    lastReconcileTextInterval = (ReconcileTextInterval)conflictInterval.getReconcileAreas().get(idx - 1);
                }
                if (lastReconcileTextInterval != null && lastReconcileTextInterval.getModifiedReconcileLocations().size() != 0 || (iProblem = this.convertProblems(problem, startSegment, startIndex, stopIndex)) == null) continue;
                textualProblems.add(iProblem);
                if (lastReconcileTextInterval == null) continue;
                lastReconcileTextInterval.getProblems().add(iProblem);
                continue;
            }
            currentRecLocationArea.setStartEndSegments(startSegment, startSegment);
            dispachedLocationAreas.add(currentRecLocationArea);
            currentRecLocationArea = new ReconcileLocationInterval();
            if (this._reconcileExtension != null) {
                ArrayList reconcileAreas = new ArrayList();
                reconcileAreas.addAll(((IReconcileLocationInterval)dispachedLocationAreas.get(0)).getReconcileAreas());
                ((IReconcileLocationInterval)dispachedLocationAreas.get(0)).getReconcileAreas().clear();
                ITextAnalyzer textAnalyzer = this._oldChangeSet.getTextProcessor() != null && this._oldChangeSet.getTextProcessor().getEditTreeExtension() != null ? this._oldChangeSet.getTextProcessor().getEditTreeExtension().newTextAnalyzer() : null;
                List rejectedIntervals = Collections.emptyList();
                rejectedIntervals = this._reconcileExtension instanceof com.ibm.pdp.engine.internal.IReconcileExtension ? ((com.ibm.pdp.engine.internal.IReconcileExtension)this._reconcileExtension).dispatchReconcileTextIntervals(dispachedLocationAreas, reconcileAreas, conflicProblems, textAnalyzer, (Object)this._newChangeSet) : this._reconcileExtension.dispatchReconcileTextIntervals(dispachedLocationAreas, reconcileAreas, conflicProblems, textAnalyzer);
                if (rejectedIntervals != null && rejectedIntervals.size() > 0) {
                    ((IReconcileLocationInterval)dispachedLocationAreas.get(0)).getReconcileAreas().addAll(rejectedIntervals);
                    conflicProblems.add(this.getConflicLocationProblem(dispachedLocationAreas, rejectedIntervals));
                }
                reconcileLocationAreas.addAll(dispachedLocationAreas);
                continue;
            }
            conflicProblems.add(this.getConflicLocationProblem(dispachedLocationAreas, ((IReconcileLocationInterval)dispachedLocationAreas.get(0)).getReconcileAreas()));
            reconcileLocationAreas.addAll(dispachedLocationAreas);
        }
        if (!currentRecLocationArea.getReconcileAreas().isEmpty() || !currentRecLocationArea.getRemovedReconcileAreas().isEmpty()) {
            if (currentRecLocationArea.getStartReconcileLocation() == null) {
                Segment stopSegment = startSegment;
                if (!dispachedFlag && !this.isStartSegmentMustMatchWithOldGenerated(startSegment, area)) {
                    int index = 0;
                    index = 0;
                    while (index < area.newArea.length) {
                        if (area.newArea[index] == startSegment) break;
                        ++index;
                    }
                    boolean protectedFound = false;
                    for (SegmentReconciler.ProtectedSegmentArea segmentArea : newGeneratedProtectedSegmentAreas) {
                        int startProtectedIndex = segmentArea.beginIndex + newGeneratedOffset;
                        int i = index;
                        while (i < area.newArea.length) {
                            if (area.newArea[i].generatedBeginIndex() >= startProtectedIndex) {
                                protectedFound = true;
                                break;
                            }
                            stopSegment = area.newArea[i];
                            ++i;
                        }
                        if (protectedFound) break;
                    }
                    stopSegment = !protectedFound ? area.newArea[area.newArea.length - 1] : (startSegment = area.newArea[area.newArea.length - 1]);
                }
                currentRecLocationArea.setStartEndSegments(startSegment, stopSegment);
            }
            reconcileLocationAreas.add(currentRecLocationArea);
        }
        return reconcileLocationAreas;
    }

    private boolean isStartSegmentMustMatchWithOldGenerated(Segment startSegment, SegmentReconciler.SegmentsArea area) {
        if (startSegment.enclosingTagName() != null && startSegment.enclosingTagName().equals(area.oldArea[0].enclosingTagName())) {
            Segment seg = area.oldArea[0];
            if (startSegment.fromTagName().equals(area.oldArea[0].fromTagName())) {
                String startGeneratedText = startSegment.generatedText().toString();
                String oldGeneratedText = seg.generatedText().toString();
                if (startGeneratedText.length() > 0 || oldGeneratedText.length() > 0) {
                    return startGeneratedText.startsWith(oldGeneratedText);
                }
            }
        }
        return false;
    }

    private boolean isProtectedWordArea(int beginIndex, int endIndex, List<SegmentReconciler.ProtectedSegmentArea> newGeneratedProtectedSegmentAreas) {
        if (newGeneratedProtectedSegmentAreas != null) {
            for (SegmentReconciler.ProtectedSegmentArea segmentArea : newGeneratedProtectedSegmentAreas) {
                if (segmentArea == null || beginIndex != segmentArea.beginIndex || endIndex != segmentArea.endIndex) continue;
                return true;
            }
        }
        return false;
    }

    private ReconcileProblem convertProblems(TextReconcileProblem problem, Segment startSegment, int startIndex, int stopIndex) {
        int oldStopIdx;
        Segment oldSegment = ReconcileUtil.findSegmentOfSameLogicalPosition(startSegment, this._oldChangeSet);
        int oldStartIdx = problem.getOldGeneratedBeginIndex();
        int n = oldStopIdx = problem.getOldGeneratedEndIndex() > problem.getOldGeneratedBeginIndex() ? problem.getOldGeneratedEndIndex() : problem.getOldGeneratedBeginIndex();
        if (oldStopIdx > this._oldGeneratedTextPartition.getTextLength()) {
            oldStopIdx = this._oldGeneratedTextPartition.getTextLength();
        }
        CharSequence oldGeneratedText = oldSegment != null ? oldSegment.generatedText() : this._oldGeneratedTextPartition.getTextInterval(oldStartIdx, oldStopIdx);
        CharSequence oldModifiedCode = oldSegment != null ? oldSegment.getText() : this._oldModifiedTextPartition.getTextInterval(problem.getModifiedBeginIndex(), problem.getModifiedEndIndex());
        CharSequence newGeneratedText = this._newGeneratedTextPartition.getTextInterval(problem.getNewGeneratedBeginIndex(), problem.getNewGeneratedEndIndex());
        ReconcileLocation location = new ReconcileLocation(startSegment.getChangeSet(), startSegment.enclosingTagName(), startSegment.fromTagName(), startSegment.toTagName());
        ReconcileProblem rProblem = new ReconcileProblem(this._reconcilerState, oldGeneratedText, oldModifiedCode, newGeneratedText, this._oldGeneratedTextPartition.getTextInterval(oldStartIdx, oldStopIdx), this._oldModifiedTextPartition.getTextInterval(problem.getModifiedBeginIndex(), problem.getModifiedEndIndex()), location, location, null, null, ReconcileConstants.ProblemType.CONFLICT, ReconcileConstants.Severity.WARNING, null);
        return rProblem;
    }

    private Segment getRemovedBlockSegment(Segment[] oldArea, int beginIndex, int endIndex) {
        Segment[] segmentArray = oldArea;
        int n = oldArea.length;
        int n2 = 0;
        while (n2 < n) {
            Segment segment = segmentArray[n2];
            if (beginIndex >= segment.beginIndex() && endIndex <= segment.endIndex()) {
                return segment;
            }
            ++n2;
        }
        return null;
    }

    private IProblem getConflicLocationProblem(List<IReconcileLocationInterval> conflictLocationAreas, List<IReconcileTextInterval> rejectedIntervals) {
        Segment start;
        Segment stop = start = ReconcileUtil.getSegmentFromReconcileLocation(conflictLocationAreas.get(0).getStartReconcileLocation(), this._newChangeSet);
        StringBuilder modifiedText = new StringBuilder();
        for (IReconcileTextInterval locationTextInterval : rejectedIntervals) {
            modifiedText.append(locationTextInterval.getText());
        }
        ReconcileProblem conflicProblem = new ReconcileProblem(this._reconcilerState, null, modifiedText, this._newChangeSet.generatedTextPartition().getTextInterval(start.generatedBeginIndex(), stop.generatedEndIndex()), null, null, conflictLocationAreas.get(0).getStartReconcileLocation(), conflictLocationAreas.get(0).getStartReconcileLocation(), conflictLocationAreas, null, ReconcileConstants.ProblemType.CHOICE, ReconcileConstants.Severity.WARNING, null);
        return conflicProblem;
    }

    private class TextReconcilerInterval {
        public boolean isNewGeneratedCode = false;
        public int oldGeneratedBeginIndex;
        public int oldGeneratedEndIndex;
        public int modifiedBeginIndex;
        public int modifiedEndIndex;
        public int newGeneratedBeginIndex;
        public int newGeneratedEndIndex;
        public ITextPartition origin;
        public TextReconcileProblem problem;

        private TextReconcilerInterval() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.isNewGeneratedCode) {
                builder.append("Current is new generated\n");
                builder.append(this.origin.getTextInterval(this.newGeneratedBeginIndex, this.newGeneratedEndIndex));
                builder.append("\nOld modified\n");
                builder.append(SegmentTextualReconciler.this._oldModifiedTextPartition.getTextInterval(this.modifiedBeginIndex, this.modifiedEndIndex));
                builder.append("\nOld generated\n");
                builder.append(SegmentTextualReconciler.this._oldGeneratedTextPartition.getTextInterval(this.oldGeneratedBeginIndex, this.oldGeneratedEndIndex));
            } else {
                builder.append("Current is old modified\n");
                builder.append(this.origin.getTextInterval(this.modifiedBeginIndex, this.modifiedEndIndex));
                builder.append("\nOld generated\n");
                builder.append(SegmentTextualReconciler.this._oldGeneratedTextPartition.getTextInterval(this.oldGeneratedBeginIndex, this.oldGeneratedEndIndex).toString());
                builder.append("\nNew generated\n");
                builder.append(SegmentTextualReconciler.this._newGeneratedTextPartition.getTextInterval(this.newGeneratedBeginIndex, this.newGeneratedEndIndex));
            }
            if (this.problem != null) {
                builder.append("\nFound problems");
            }
            return builder.toString();
        }
    }
}

