/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.ITextInterval;
import com.ibm.pdp.engine.extension.IReconcileLocationInterval;
import com.ibm.pdp.engine.extension.IReconcileTextInterval;
import com.ibm.pdp.engine.extension.ITracerDelegate;
import com.ibm.pdp.engine.internal.IReconcileExtension;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.EditableTextPartition;
import com.ibm.pdp.engine.turbo.core.HierarchicSegment;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SyntacticTagSegment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.ReconcileMode;
import com.ibm.pdp.engine.turbo.reconcile.IReconciler;
import com.ibm.pdp.engine.turbo.reconcile.IReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileConstants;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileProblem;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileTextInterval;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileUtil;
import com.ibm.pdp.engine.turbo.reconcile.ReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.SegmentTextualReconciler;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.ints.IntSequence;
import com.ibm.pdp.util.performance.PerformanceManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SegmentReconciler
implements IReconciler,
ReconcileConstants {
    private static boolean VALIDATE_MODE = "true".equals(System.getProperty("reconcilerValidate"));
    private static final String RECONCILE_TOTAL_TIME = "RECONCILE_TOTAL_TIME";
    private static String EOL = System.getProperty("line.separator");
    private PerformanceManager performanceManager = PerformanceManager.getInstance();
    private UserChangeSet oldChangeSet;
    private UserChangeSet newChangeSet;
    private com.ibm.pdp.engine.extension.IReconcileExtension reconcileExtension;
    private ReconcilerState reconcilerState;
    private ProtectedSegmentArea currentSegmentRank;
    private List<Segment> modifiedSegments;
    private List<Segment> oldAlreadyReconcile;
    private List<Segment> newAlreadyReconcile;
    private List<Segment> enclosingSegments;
    private List<Segment> removedEnclosingSegments;
    private List<Segment> nextSentencesSegments;
    private ITracerDelegate tracer = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ITracerDelegate getTracer() {
        return this.tracer;
    }

    @Override
    public IReconcilerState newReconcilerState(UserChangeSet changeSet) {
        return new ReconcilerState(changeSet);
    }

    public SegmentReconciler() {
        if (this.tracer == null) {
            this.tracer = this.getTracerDelegate();
        }
    }

    private ITracerDelegate getTracerDelegate() {
        return new ITracerDelegate(){

            public boolean isDebugModeEnabled() {
                return PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.framework.reconciler") > 0;
            }

            public void info(Object sourceObject, String methodName, String message) {
                PTTraceManager.getInstance().trace(sourceObject == null ? SegmentReconciler.this.getClass() : sourceObject.getClass(), "com.ibm.pdp.framework.reconciler", 1, String.valueOf(methodName) + "() " + message);
            }

            public void debug(Object sourceObject, String methodName, String message) {
                PTTraceManager.getInstance().trace(sourceObject == null ? SegmentReconciler.this.getClass() : sourceObject.getClass(), "com.ibm.pdp.framework.reconciler", 3, String.valueOf(methodName) + "() " + message);
            }
        };
    }

    @Override
    public IReconcilerState reconcile(IReconcilerState state, UserChangeSet newUserChangeSet) {
        return this.reconcile(state, newUserChangeSet, 1);
    }

    public IReconcilerState reconcile(IReconcilerState state, UserChangeSet newUserChangeSet, int step) {
        ReconcileProblem reconcileProblem;
        List<IProblem> oldProblems;
        boolean isFirstReconciliation;
        long start = 0L;
        this.oldChangeSet = state.getChangeSet();
        this.newChangeSet = newUserChangeSet;
        if (this.getReconcileExtension() instanceof IReconcileExtension) {
            ((IReconcileExtension)this.getReconcileExtension()).start((Object)this.newChangeSet, (Object)this.oldChangeSet, step);
        }
        if (this.oldChangeSet != null && this.oldChangeSet.topSegment() != null && this.oldChangeSet.topSegment().getTagProperties() != null && this.oldChangeSet.topSegment().getTagProperties().getReconcileMode() == ReconcileMode.NoReconcile) {
            return new ReconcilerState(this.newChangeSet);
        }
        boolean bl = isFirstReconciliation = step == 1;
        if (this.performanceManager.isEnabled()) {
            start = System.currentTimeMillis();
        }
        if (this.getTracer().isDebugModeEnabled()) {
            this.tracer.debug((Object)this, "reconcile", "OLD Generated Info");
            this.tracer.debug((Object)this, "reconcile", "\n" + ReconcileUtil.dumpGeneratedInfo(state.getChangeSet().getGeneratedInfo(), "geninfo.old.xml", isFirstReconciliation));
            this.tracer.debug((Object)this, "reconcile", "Modified Text");
            this.tracer.debug((Object)this, "reconcile", "\n" + ReconcileUtil.dumpToTmpFile(state.getChangeSet().getText().toString(), "old.txt", isFirstReconciliation));
            this.tracer.debug((Object)this, "reconcile", "NEW Generated Info");
            this.tracer.debug((Object)this, "reconcile", "\n" + ReconcileUtil.dumpGeneratedInfo(newUserChangeSet.getGeneratedInfo(), "geninfo.new.xml", isFirstReconciliation));
            String xmlContents = ReconcileUtil.dumpGeneratedInfoTree(state.getChangeSet().getGeneratedInfo(), true, false);
            this.tracer.debug((Object)this, "OLD Generated Info Tree", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "geninfo.old.tree.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpGeneratedInfoTree(newUserChangeSet.getGeneratedInfo(), true, false);
            this.tracer.debug((Object)this, "New Generated Info Tree", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "geninfo.new.tree.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpGeneratedInfoTree(state.getChangeSet().getGeneratedInfo(), true, true);
            this.tracer.debug((Object)this, "OLD Generated Info Tree", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "geninfo.old.tree.with.specific.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpGeneratedInfoTree(newUserChangeSet.getGeneratedInfo(), true, true);
            this.tracer.debug((Object)this, "New Generated Info Tree", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "geninfo.new.tree.with.specific.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpGeneratedInfoTree(state.getChangeSet().getGeneratedInfo(), false, false);
            this.tracer.debug((Object)this, "OLD Generated Info Tree Without MP", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "geninfo.old.tree.without.mp.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpGeneratedInfoTree(newUserChangeSet.getGeneratedInfo(), false, false);
            this.tracer.debug((Object)this, "New Generated Info Tree Without MP", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "geninfo.new.tree.without.mp.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpGeneratedInfoTree(state.getChangeSet().getGeneratedInfo(), false, true);
            this.tracer.debug((Object)this, "OLD Generated Info Tree Without MP", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "geninfo.old.tree.without.mp.with.specific.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpGeneratedInfoTree(newUserChangeSet.getGeneratedInfo(), false, true);
            this.tracer.debug((Object)this, "New Generated Info Tree Without MP", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "geninfo.new.tree.without.mp.with.specific.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpTopSegmentTree(state.getChangeSet().topSegment(), true, true, true);
            this.tracer.debug((Object)this, "OLD Segments Tree", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.old.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpTopSegmentTree(newUserChangeSet.topSegment(), true, true, true);
            this.tracer.debug((Object)this, "New Segments Tree", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.new.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpTopSegmentTree(state.getChangeSet().topSegment(), true, true, false);
            this.tracer.debug((Object)this, "OLD Segments Tree", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.old.tree.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpTopSegmentTree(newUserChangeSet.topSegment(), true, true, false);
            this.tracer.debug((Object)this, "New Segments Tree", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.new.tree.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpTopSegmentTree(state.getChangeSet().topSegment(), false, true, false);
            this.tracer.debug((Object)this, "OLD Segments Tree Without MP", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.old.tree.without.mp.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpTopSegmentTree(newUserChangeSet.topSegment(), false, true, false);
            this.tracer.debug((Object)this, "New Segments Tree Tree Without MP", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.new.tree.without.mp.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpTopSegmentTree(state.getChangeSet().topSegment(), false, false, false);
            this.tracer.debug((Object)this, "OLD Segments Tree Without MP And Attributes", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.old.tree.without.mp_att.xml", isFirstReconciliation));
            xmlContents = ReconcileUtil.dumpTopSegmentTree(newUserChangeSet.topSegment(), false, false, false);
            this.tracer.debug((Object)this, "New Segments Tree Tree Without MP", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.new.tree.without.mp_att.xml", isFirstReconciliation));
        }
        if ((oldProblems = ((ReconcilerState)state).problems) != null) {
            for (IProblem problem : oldProblems) {
                reconcileProblem = (ReconcileProblem)problem;
                reconcileProblem.checkReversibility(newUserChangeSet);
            }
        }
        this.reconcilerState = new ReconcilerState(this.newChangeSet, oldProblems);
        if (oldProblems != null) {
            for (IProblem problem : oldProblems) {
                reconcileProblem = (ReconcileProblem)problem;
                reconcileProblem.setReconcilerState(this.reconcilerState);
            }
        }
        this.reconcileUserChanges(step);
        if (this.getReconcileExtension() instanceof IReconcileExtension) {
            ((IReconcileExtension)this.getReconcileExtension()).end((Object)this.reconcilerState, (Object)this.newChangeSet, (Object)this.oldChangeSet, step);
        }
        if (this.getTracer().isDebugModeEnabled()) {
            this.tracer.debug((Object)this, "reconcile", "New Text before reversibility");
            this.tracer.debug((Object)this, "reconcile", "\n" + ReconcileUtil.dumpToTmpFile(newUserChangeSet.getText().toString(), "new.before.reversibility.txt", isFirstReconciliation));
        }
        this.reconcilerState.mergeWithOldProblems();
        this.cleanup();
        if (this.getTracer().isDebugModeEnabled()) {
            this.tracer.debug((Object)this, "reconcile", "\n" + ReconcileUtil.dumpToTmpFile(newUserChangeSet.getText().toString(), "new.txt", isFirstReconciliation));
        }
        if (this.performanceManager.isEnabled()) {
            this.performanceManager.addTotalTimeMillis(RECONCILE_TOTAL_TIME, System.currentTimeMillis() - start);
        }
        return this.reconcilerState;
    }

    @Override
    public int translateIndex(int index, IReconcilerState oldState, IReconcilerState newState) {
        return 0;
    }

    @Override
    public ITextInterval translateInterval(int beginIdx, int endIdx, IReconcilerState oldState, IReconcilerState newState) {
        return null;
    }

    @Override
    public void writeState(IReconcilerState state, XMLStreamWriter xmlWriter) {
        try {
            xmlWriter.writeStartElement("Reconciler");
            if (state != null) {
                Iterator<IProblem> iterator = state.problems();
                while (iterator.hasNext()) {
                    ReconcileProblem problem = (ReconcileProblem)iterator.next();
                    problem.write(xmlWriter);
                }
            }
            xmlWriter.writeEndElement();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    @Override
    public void readState(IReconcilerState state, XMLStreamReader xmlReader) {
        this.reconcilerState = (ReconcilerState)state;
        boolean finished = false;
        try {
            while (xmlReader.hasNext() && !finished) {
                String qname;
                int eventType = xmlReader.next();
                if (eventType == 1) {
                    String localName = xmlReader.getLocalName();
                    if (!localName.equalsIgnoreCase("Problem")) continue;
                    ReconcileProblem problem = new ReconcileProblem(state);
                    problem.read(xmlReader);
                    if (((ReconcilerState)state).problems == null) {
                        ((ReconcilerState)state).problems = new ArrayList<IProblem>();
                    }
                    ((ReconcilerState)state).addProblem(problem, false);
                    continue;
                }
                if (eventType != 2 || !(qname = xmlReader.getName().getLocalPart()).equalsIgnoreCase("Reconciler")) continue;
                finished = true;
            }
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
    }

    @Override
    public void setReconcileExtension(com.ibm.pdp.engine.extension.IReconcileExtension newReconcileExtension) {
        this.reconcileExtension = newReconcileExtension;
    }

    @Override
    public com.ibm.pdp.engine.extension.IReconcileExtension getReconcileExtension() {
        return this.reconcileExtension;
    }

    private Iterator<Segment> getModifiedSegments() {
        this.modifiedSegments = new ArrayList<Segment>();
        this.findModifiedSegments(this.oldChangeSet.topSegment(), this.modifiedSegments);
        return this.modifiedSegments.iterator();
    }

    private void findModifiedSegments(Segment segment, List<Segment> modifiedSegments) {
        boolean isModifiedSegment;
        boolean bl = isModifiedSegment = segment.getChangeNature().isUserCode() || segment.getChangeNature() == ChangeNature.Reformated;
        if (segment.subSegments().length == 0 && isModifiedSegment) {
            modifiedSegments.add(segment);
        }
        Segment[] segmentArray = segment.subSegments();
        int n = segmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Segment son = segmentArray[n2];
            this.findModifiedSegments(son, modifiedSegments);
            ++n2;
        }
    }

    private void reconcileUserChanges(int step) {
        Iterator<Segment> modifiedIter = this.getModifiedSegments();
        this.oldAlreadyReconcile = new ArrayList<Segment>();
        this.newAlreadyReconcile = new ArrayList<Segment>();
        this.enclosingSegments = new ArrayList<Segment>();
        this.removedEnclosingSegments = new ArrayList<Segment>();
        this.nextSentencesSegments = new ArrayList<Segment>();
        while (modifiedIter.hasNext()) {
            Segment modifiedSegment = modifiedIter.next();
            if (this.getTracer().isDebugModeEnabled()) {
                this.tracer.debug((Object)this, "reconcileUserChanges", "\r\nGenerated Text(Indexes : " + modifiedSegment.generatedBeginIndex() + "/" + modifiedSegment.generatedEndIndex() + ")\r\n" + modifiedSegment.generatedText());
                this.tracer.debug((Object)this, "reconcileUserChanges", "\r\nModified Text (Indexes : " + modifiedSegment.beginIndex() + "/" + modifiedSegment.endIndex() + " Tags (enclosing/from/to) : " + modifiedSegment.enclosingTagName() + "/" + modifiedSegment.fromTagName() + "/" + modifiedSegment.toTagName() + ")\r\n" + modifiedSegment.getText());
            }
            Segment newSegment = null;
            newSegment = modifiedSegment.isSyntactic() ? ReconcileUtil.findSegmentOfSameLogicalPositionForSyntactic(modifiedSegment, this.newChangeSet) : ReconcileUtil.findSegmentOfSameLogicalPosition(modifiedSegment, this.newChangeSet);
            if (newSegment != null) {
                if (newSegment.isAtomic()) {
                    this.treatSegments(modifiedSegment, step);
                    this.reconcileSegments(modifiedSegment, newSegment, step);
                    continue;
                }
                if (this.enclosingSegments.contains(modifiedSegment)) continue;
                this.enclosingSegments.add(modifiedSegment);
                continue;
            }
            Segment segment = newSegment = modifiedSegment.enclosingTagName() == null ? null : this.newChangeSet.findSegmentFromTagName(modifiedSegment.enclosingTagName(), 0);
            if (newSegment == null) {
                Segment oldParent;
                Segment firstLevelRemoved = ReconcileUtil.findFirstLevelRemovedSegmentFromParentTree(modifiedSegment, this.newChangeSet);
                Segment segment2 = oldParent = firstLevelRemoved.enclosingSegment() != null ? firstLevelRemoved.enclosingSegment() : null;
                if (modifiedSegment.getChangeNature().isGeneratedCode()) continue;
                if (!this.removedEnclosingSegments.contains(modifiedSegment)) {
                    this.removedEnclosingSegments.add(modifiedSegment);
                }
                if (this.enclosingSegments.contains(oldParent)) continue;
                this.enclosingSegments.add(oldParent);
                continue;
            }
            if (!this.enclosingSegments.contains(modifiedSegment.enclosingSegment())) {
                this.enclosingSegments.add(modifiedSegment.enclosingSegment());
            }
            if (modifiedSegment.beginIndex() != modifiedSegment.endIndex() || modifiedSegment.generatedBeginIndex() == modifiedSegment.generatedEndIndex() || newSegment.generatedBeginIndex() != newSegment.generatedEndIndex() || this.removedEnclosingSegments.contains(modifiedSegment)) continue;
            this.removedEnclosingSegments.add(modifiedSegment);
        }
        this.treatSegments(null, step);
        for (Segment newSegment : this.nextSentencesSegments) {
            this.treatNextSentencesSegments(newSegment, step);
        }
        if (VALIDATE_MODE) {
            this.validate();
        }
    }

    private void treatSegments(Segment oldSegment, int step) {
        ArrayList<Segment> _enclosingSegments = new ArrayList<Segment>();
        _enclosingSegments.addAll(this.enclosingSegments);
        for (Segment segment : _enclosingSegments) {
            if (oldSegment == null) {
                this.enclosingSegments.remove(segment);
                this.reconcileSegmentTree(segment, this.removedEnclosingSegments, step);
                continue;
            }
            if (segment == null || this.isSameBranch(segment, oldSegment)) continue;
            this.enclosingSegments.remove(segment);
            this.reconcileSegmentTree(segment, this.removedEnclosingSegments, step);
        }
    }

    private boolean isSameBranch(Segment segment1, Segment segment2) {
        Segment segment = segment1;
        while (segment != null) {
            if (segment == segment2) {
                return true;
            }
            segment = segment.enclosingSegment();
        }
        segment = segment2;
        while (segment != null) {
            if (segment == segment1) {
                return true;
            }
            segment = segment.enclosingSegment();
        }
        return false;
    }

    private void reconcileSegments(Segment modifiedSegment, Segment newSegment, int step) {
        if (!newSegment.isAtomic()) {
            throw new RuntimeException("old and new segment must have the same type!!!");
        }
        this.newAlreadyReconcile.add(newSegment);
        this.oldAlreadyReconcile.add(modifiedSegment);
        if (this.reconcileExtension instanceof IReconcileExtension && ((IReconcileExtension)this.reconcileExtension).reconcileCommonParents((Object)newSegment, (Object)modifiedSegment, (Object)this.reconcilerState, true, step)) {
            return;
        }
        SegmentsArea area = new SegmentsArea();
        area.newArea = new Segment[]{newSegment};
        area.oldArea = new Segment[]{modifiedSegment};
        this.reconcileArea(area, true, step);
    }

    private void reconcileSegmentTree(Segment oldCommonParentSegment, List<Segment> removedEnclosingSegments, int step) {
        Segment newCommonParentSegment;
        if (this.oldAlreadyReconcile.contains(oldCommonParentSegment)) {
            throw new RuntimeException("Old segment must not be reconciled twice!!!");
        }
        Segment segment = newCommonParentSegment = oldCommonParentSegment == null ? null : this.newChangeSet.findSegmentFromTagName(oldCommonParentSegment.enclosingTagName(), 0);
        if (this.reconcileExtension instanceof IReconcileExtension && ((IReconcileExtension)this.reconcileExtension).reconcileCommonParents((Object)newCommonParentSegment, (Object)oldCommonParentSegment, (Object)this.reconcilerState, false, step)) {
            this.oldAlreadyReconcile.add(oldCommonParentSegment);
            this.newAlreadyReconcile.add(newCommonParentSegment);
            return;
        }
        List<SegmentsArea> areas = this.buildAreas(newCommonParentSegment, removedEnclosingSegments);
        for (SegmentsArea area : areas) {
            this.reconcileArea(area, false, step);
        }
        this.oldAlreadyReconcile.add(oldCommonParentSegment);
        this.newAlreadyReconcile.add(newCommonParentSegment);
    }

    private ITextPartition protectTextPartition(ITextPartition textPartition, Segment segment, int startIndex, int endIndex, char wordId) {
        ITextPartition editableTextPartition = textPartition;
        if (!(editableTextPartition instanceof EditableTextPartition)) {
            editableTextPartition = new EditableTextPartition(textPartition);
        }
        if (startIndex == endIndex) {
            this.currentSegmentRank = new ProtectedSegmentArea();
            this.currentSegmentRank.beginIndex = startIndex;
            this.currentSegmentRank.endIndex = endIndex;
            this.currentSegmentRank.segment = segment;
            return textPartition;
        }
        ((EditableTextPartition)editableTextPartition).addWord(wordId, startIndex, endIndex);
        this.currentSegmentRank = new ProtectedSegmentArea();
        this.currentSegmentRank.beginIndex = startIndex;
        this.currentSegmentRank.endIndex = endIndex;
        this.currentSegmentRank.segment = segment;
        return editableTextPartition;
    }

    private void reconcileArea(SegmentsArea area, boolean isExactReconcileLocation, int step) {
        int oldGeneratedOffset = area.oldArea[0].generatedBeginIndex();
        int oldModifiedOffset = area.oldArea[0].beginIndex();
        int newGeneratedOffset = area.newArea[0].generatedBeginIndex();
        ArrayList<ProtectedSegmentArea> oldModifiedProtectedSegmentAreas = new ArrayList<ProtectedSegmentArea>();
        ArrayList<ProtectedSegmentArea> newGeneratedProtectedSegmentAreas = new ArrayList<ProtectedSegmentArea>();
        ArrayList<ProtectedSegmentArea> oldModifiedRemovedSegmentAreas = new ArrayList<ProtectedSegmentArea>();
        ITextPartition oldGeneratedTextPartition = this.oldChangeSet.generatedTextPartition().subTextPartition(area.oldArea[0].generatedBeginIndex(), area.oldArea[area.oldArea.length == 0 ? 0 : area.oldArea.length - 1].generatedEndIndex());
        ITextPartition oldModifiedTextPartition = this.oldChangeSet.textPartition().subTextPartition(area.oldArea[0].beginIndex(), area.oldArea[area.oldArea.length == 0 ? 0 : area.oldArea.length - 1].endIndex());
        ITextPartition newGeneratedTextPartition = this.newChangeSet.generatedTextPartition().subTextPartition(area.newArea[0].generatedBeginIndex(), area.newArea[area.newArea.length == 0 ? 0 : area.newArea.length - 1].generatedEndIndex());
        int maxWordId = Math.max(oldGeneratedTextPartition.maxWordId(), oldModifiedTextPartition.maxWordId());
        maxWordId = Math.max(maxWordId, newGeneratedTextPartition.maxWordId()) + 1;
        if (!isExactReconcileLocation) {
            int wordId;
            Segment[] segmentArray = area.newArea;
            int n = area.newArea.length;
            int n2 = 0;
            while (n2 < n) {
                Segment _segment = segmentArray[n2];
                if (!(this.reconcileExtension instanceof IReconcileExtension) || !((IReconcileExtension)this.reconcileExtension).canModifyNewSegment((Object)_segment, (Object)this.oldChangeSet)) {
                    for (Segment segment : this.newPreservedSegments(_segment, area)) {
                        newGeneratedTextPartition = this.protectTextPartition(newGeneratedTextPartition, segment, segment.generatedBeginIndex() - newGeneratedOffset, segment.generatedEndIndex() - newGeneratedOffset, (char)(++maxWordId));
                        if (this.currentSegmentRank == null) continue;
                        newGeneratedProtectedSegmentAreas.add(this.currentSegmentRank);
                    }
                }
                ++n2;
            }
            ArrayList<Segment> segmentsToPreserve = new ArrayList<Segment>();
            Segment[] segmentArray2 = area.oldArea;
            int n3 = area.oldArea.length;
            n = 0;
            while (n < n3) {
                Segment _segment = segmentArray2[n];
                if (!(this.reconcileExtension instanceof IReconcileExtension) || !((IReconcileExtension)this.reconcileExtension).canModifyOldSegment((Object)_segment, (Object)this.newChangeSet)) {
                    segmentsToPreserve.addAll(this.oldPreservedSegments(_segment, area.newArea));
                }
                ++n;
            }
            for (Segment segment3 : segmentsToPreserve) {
                wordId = ++maxWordId;
                oldModifiedTextPartition = this.protectTextPartition(oldModifiedTextPartition, segment3, segment3.beginIndex() - oldModifiedOffset, segment3.endIndex() - oldModifiedOffset, (char)wordId);
                if (this.currentSegmentRank != null) {
                    oldModifiedProtectedSegmentAreas.add(this.currentSegmentRank);
                }
                if (segment3.generatedBeginIndex() == segment3.generatedEndIndex()) continue;
                oldGeneratedTextPartition = this.protectTextPartition(oldGeneratedTextPartition, segment3, segment3.generatedBeginIndex() - oldGeneratedOffset, segment3.generatedEndIndex() - oldGeneratedOffset, (char)wordId);
            }
            if (area.removedArea != null) {
                Segment[] segmentArray3 = area.removedArea;
                wordId = area.removedArea.length;
                int n4 = 0;
                while (n4 < wordId) {
                    Segment segment4 = segmentArray3[n4];
                    char wordId2 = (char)(++maxWordId);
                    if (segment4.beginIndex() != segment4.endIndex()) {
                        oldModifiedTextPartition = this.protectTextPartition(oldModifiedTextPartition, segment4, segment4.beginIndex() - oldModifiedOffset, segment4.endIndex() - oldModifiedOffset, wordId2);
                        if (this.currentSegmentRank != null) {
                            oldModifiedRemovedSegmentAreas.add(this.currentSegmentRank);
                        }
                    } else {
                        ProtectedSegmentArea segmentArea = new ProtectedSegmentArea();
                        segmentArea.segment = segment4;
                        oldModifiedRemovedSegmentAreas.add(segmentArea);
                    }
                    if (segment4.generatedBeginIndex() != segment4.generatedEndIndex()) {
                        oldGeneratedTextPartition = this.protectTextPartition(oldGeneratedTextPartition, segment4, segment4.generatedBeginIndex() - oldGeneratedOffset, segment4.generatedEndIndex() - oldGeneratedOffset, wordId2);
                    }
                    ++n4;
                }
            }
        }
        ArrayList<IProblem> textualProblems = new ArrayList<IProblem>();
        ArrayList<IProblem> conflicProblems = new ArrayList<IProblem>();
        SegmentTextualReconciler textualReconciler = new SegmentTextualReconciler(this.oldChangeSet, this.newChangeSet, this.reconcileExtension, this.reconcilerState, oldGeneratedTextPartition, oldModifiedTextPartition, newGeneratedTextPartition);
        List<IReconcileLocationInterval> reconcileLocationAreas = textualReconciler.reconcileTextualArea(oldModifiedOffset, newGeneratedOffset, area, oldModifiedProtectedSegmentAreas, newGeneratedProtectedSegmentAreas, oldModifiedRemovedSegmentAreas, textualProblems, conflicProblems, this.getTracer());
        for (IReconcileLocationInterval iReconcileLocationInterval : reconcileLocationAreas) {
            this.replaceReconcileAreas(iReconcileLocationInterval, textualProblems, conflicProblems, step);
            if (iReconcileLocationInterval.getAlternatesReconcileLocation() == null) continue;
            for (IReconcileLocationInterval alternate : iReconcileLocationInterval.getAlternatesReconcileLocation()) {
                this.replaceReconcileAreas(alternate, textualProblems, conflicProblems, step);
            }
        }
        ArrayList<IProblem> arrayList = new ArrayList<IProblem>();
        arrayList.addAll(textualProblems);
        arrayList.addAll(conflicProblems);
        if (this.getReconcileExtension() != null) {
            this.reconcilerState.addProblems(this.getReconcileExtension().validateReconcileProblems(arrayList));
        } else {
            this.reconcilerState.addProblems(arrayList);
        }
        if (this.reconcileExtension != null && isExactReconcileLocation && area.newArea.length == 1) {
            boolean isNextSentenceTag;
            Segment newSegment = area.newArea[0];
            boolean bl = isNextSentenceTag = newSegment.getTagProperties() != null && newSegment.getTagProperties().getProperty("msp") != null && "true".equals(newSegment.getTagProperties().getProperty("nS"));
            if (isNextSentenceTag) {
                this.nextSentencesSegments.add(newSegment);
            }
        }
    }

    private void treatNextSentencesSegments(Segment newSegment, int step) {
        String newText;
        int beginIdx;
        String generatedLine;
        if (step != 1) {
            return;
        }
        String newGeneratedText = newSegment.generatedText().toString().replaceAll("\\s+$", "");
        int start = newGeneratedText.lastIndexOf(EOL);
        if (start >= 0 && newGeneratedText.indexOf("NEXT SENTENCE", start) != -1 && (generatedLine = newGeneratedText.substring(beginIdx = start + EOL.length())).length() > 72 && !(newText = newSegment.getText().toString()).contains(generatedLine)) {
            Segment nextSegment;
            int endIdx = beginIdx + 72;
            String cobolCodeLine = newGeneratedText.substring(beginIdx, endIdx).replaceAll("\\s+$", "");
            if ((beginIdx = newText.indexOf(cobolCodeLine)) >= 0) {
                endIdx = newText.indexOf(EOL, beginIdx);
                if (endIdx - beginIdx <= 72) {
                    newText = newText.replace(cobolCodeLine, generatedLine);
                    newSegment.setText(newText);
                }
            } else if (newSegment.nextAtom() != null && (beginIdx = (newText = (nextSegment = newSegment.nextAtom()).getText().toString()).indexOf(cobolCodeLine)) >= 0 && (endIdx = newText.indexOf(EOL, beginIdx)) - beginIdx <= 72) {
                newText = newText.replace(cobolCodeLine, generatedLine);
                nextSegment.setText(newText);
            }
        }
    }

    private void replaceReconcileAreas(IReconcileLocationInterval reconcileLocationArea, List<IProblem> textualProblems, List<IProblem> conflicProblems, int reconcileStep) {
        if (!reconcileLocationArea.getReconcileAreas().isEmpty()) {
            Segment start = ReconcileUtil.getSegmentFromReconcileLocation(reconcileLocationArea.getStartReconcileLocation(), this.newChangeSet);
            Segment stop = ReconcileUtil.getSegmentFromReconcileLocation(reconcileLocationArea.getEndReconcileLocation(), this.newChangeSet);
            StringBuilder text = new StringBuilder();
            StringBuilder fullText = new StringBuilder();
            boolean hasChanges = false;
            for (IReconcileTextInterval reconcileArea : reconcileLocationArea.getReconcileAreas()) {
                if (reconcileArea.isApplicable()) {
                    text.append(reconcileArea.getText());
                    hasChanges = true;
                }
                fullText.append(reconcileArea.getText());
            }
            boolean flag = false;
            if (this.reconcileExtension instanceof IReconcileExtension && (flag = ((IReconcileExtension)this.reconcileExtension).replaceText((Object)start, (Object)stop, (Object)this.oldChangeSet, fullText, hasChanges, textualProblems, conflicProblems, reconcileStep))) {
                textualProblems.clear();
                conflicProblems.clear();
            }
            if (!flag && hasChanges) {
                if (start == stop) {
                    if (this.getTracer().isDebugModeEnabled()) {
                        this.tracer.debug((Object)this, "replaceReconcileAreas", "#############################################\nREPLACE Segment text\n" + start.getText() + "\nWITH\n" + text);
                    }
                    start.setText(text);
                } else {
                    if (this.getTracer().isDebugModeEnabled()) {
                        this.tracer.debug((Object)this, "replaceReconcileAreas", "#############################################\nREPLACE interval\n" + this.newChangeSet.getText().subSequence(start.beginIndex(), stop.endIndex()) + "\nWITH\n" + text);
                    }
                    if (start.beginIndex() == stop.endIndex()) {
                        if (start.parent() instanceof HierarchicSegment) {
                            HierarchicSegment parent = (HierarchicSegment)start.parent();
                            if (parent.beginIndex() == start.beginIndex() && parent.endIndex() == start.beginIndex()) {
                                parent.setText(text);
                            } else {
                                start.setText(text);
                            }
                        } else {
                            start.setText(text);
                        }
                    } else {
                        this.newChangeSet.replaceText(start.beginIndex(), stop.endIndex(), text);
                    }
                }
            }
        }
        for (IReconcileTextInterval reconcileArea : reconcileLocationArea.getRemovedReconcileAreas()) {
            if (reconcileArea.isApplicable() || ((ReconcileTextInterval)reconcileArea).getModifiedReconcileLocations().size() <= 0) continue;
            Segment s = ReconcileUtil.getSegmentFromReconcileLocation(reconcileLocationArea.getStartReconcileLocation(), this.newChangeSet);
            Segment e = ReconcileUtil.getSegmentFromReconcileLocation(reconcileLocationArea.getEndReconcileLocation(), this.newChangeSet);
            boolean flag = false;
            if (this.reconcileExtension instanceof IReconcileExtension) {
                flag = ((IReconcileExtension)this.reconcileExtension).textRemoved(((ReconcileTextInterval)reconcileArea).getOldGeneratedText(), reconcileArea.getText(), this.newChangeSet.textPartition().getTextInterval(s.beginIndex(), e.endIndex()), reconcileLocationArea.getStartReconcileLocation(), ((ReconcileTextInterval)reconcileArea).getModifiedReconcileLocations(), ((ReconcileTextInterval)reconcileArea).removedTagName, reconcileStep);
            }
            if (flag) continue;
            ReconcileProblem problem = new ReconcileProblem(this.reconcilerState, ((ReconcileTextInterval)reconcileArea).getOldGeneratedText(), reconcileArea.getText(), this.newChangeSet.textPartition().getTextInterval(s.beginIndex(), e.endIndex()), null, null, reconcileLocationArea.getStartReconcileLocation(), reconcileLocationArea.getEndReconcileLocation(), null, ((ReconcileTextInterval)reconcileArea).getModifiedReconcileLocations(), ReconcileConstants.ProblemType.REMOVED, ReconcileConstants.Severity.WARNING, ((ReconcileTextInterval)reconcileArea).removedTagName);
            this.reconcilerState.addProblem(problem, true);
        }
    }

    private List<Segment> newPreservedSegments(Segment segment, SegmentsArea area) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        if (segment.beginIndex() == segment.endIndex()) {
            if (segment.isTagged() && !segment.isLeaf()) {
                Segment[] segmentArray = segment.sons();
                int n = segmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Segment son = segmentArray[n2];
                    if (this.newAlreadyReconcile.contains(son)) {
                        segments.add(segment);
                    }
                    ++n2;
                }
            }
            return segments;
        }
        Segment oldSegmentPos = ReconcileUtil.findSegmentOfSameLogicalPosition(segment, this.oldChangeSet);
        if (oldSegmentPos != null && oldSegmentPos.getChangeNature() == ChangeNature.Unchanged) {
            segments.add(segment);
        } else {
            String enclosingTagName = segment.enclosingTagName();
            if (enclosingTagName != null) {
                int length;
                Segment oldSeg = this.oldChangeSet.findSegmentFromTagName(enclosingTagName, 0);
                if (oldSeg == null) {
                    segments.add(segment);
                } else if (oldSegmentPos != null && (length = area.oldArea.length) > 0) {
                    int beginIndex = area.oldArea[0].beginIndex();
                    int endIndex = area.oldArea[length - 1].endIndex();
                    if (beginIndex != oldSeg.beginIndex() && endIndex != oldSeg.endIndex()) {
                        boolean flag = false;
                        Segment[] segmentArray = area.oldArea;
                        int n = area.oldArea.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Segment segment1 = segmentArray[n3];
                            if (ReconcileUtil.isAncestorOf(segment1, oldSeg)) {
                                flag = true;
                                break;
                            }
                            ++n3;
                        }
                        if (!flag) {
                            segments.add(segment);
                        }
                    }
                }
            }
        }
        return segments;
    }

    private List<Segment> oldPreservedSegments(Segment segment, Segment[] newArea) {
        int newStartIndex = newArea[0].beginIndex();
        int newEndIndex = newArea[newArea.length - 1].endIndex();
        ArrayList<Segment> segments = new ArrayList<Segment>();
        if (segment.beginIndex() == segment.endIndex()) {
            return segments;
        }
        Segment newSegment = ReconcileUtil.findSegmentOfSameLogicalPosition(segment, this.newChangeSet);
        if (newSegment != null && (newSegment.beginIndex() < newStartIndex || newSegment.endIndex() > newEndIndex)) {
            segments.add(segment);
            return segments;
        }
        if (newSegment != null && newSegment.subSegments().length == 0 && segment.subSegments().length == 0) {
            if (segment.getChangeNature() == ChangeNature.Unchanged) {
                segments.add(segment);
                return segments;
            }
            if (this.oldAlreadyReconcile.contains(segment)) {
                segments.add(segment);
                return segments;
            }
        }
        if (newSegment == null && segment.isLeaf() && segment.isTagged() && segment.getChangeNature() == ChangeNature.Unchanged) {
            segments.add(segment);
        } else if (segment.subSegments().length > 0) {
            for (Segment recSegment : this.oldAlreadyReconcile) {
                if (recSegment != segment) continue;
                segments.add(recSegment);
                return segments;
            }
            if (this.enclosingSegments.contains(segment)) {
                segments.add(segment);
            } else {
                Segment[] segmentArray = segment.subSegments();
                int n = segmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Segment subSegment = segmentArray[n2];
                    if (subSegment.isLeaf() && subSegment.getChangeNature() == ChangeNature.Unchanged) {
                        segments.add(subSegment);
                    }
                    for (Segment recSegment : this.oldAlreadyReconcile) {
                        if (recSegment == null || recSegment.beginIndex() < subSegment.beginIndex() || recSegment.endIndex() > subSegment.endIndex() || segments.contains(recSegment)) continue;
                        segments.add(recSegment);
                    }
                    ++n2;
                }
            }
        }
        if (segment instanceof SyntacticTagSegment && this.enclosingSegments.contains(segment)) {
            segments.add(segment);
        }
        return segments;
    }

    private boolean isOldRemovedProblemTag(String enclosingTagName) {
        for (IProblem oldProblem : this.reconcilerState.oldProblems) {
            ReconcileProblem reconcileProblem = (ReconcileProblem)oldProblem;
            if (reconcileProblem.getProblemType() != ReconcileConstants.ProblemType.REMOVED || !reconcileProblem.getRemovedTagName().equals(enclosingTagName)) continue;
            return true;
        }
        return false;
    }

    private List<SegmentsArea> buildAreas(Segment newCommonParentSegment, List<Segment> removedEnclosingSegments) {
        ArrayList<SegmentsArea> areas = new ArrayList<SegmentsArea>();
        if (newCommonParentSegment == null) {
            SegmentsArea area = new SegmentsArea();
            area.newArea = this.newChangeSet.topSegment().subSegments();
            area.oldArea = this.oldChangeSet.topSegment().subSegments();
            area.removedArea = this.getRemovedModifiedSegments(area.oldArea, removedEnclosingSegments);
            areas.add(area);
        } else if (newCommonParentSegment.subSegments() == null || newCommonParentSegment.subSegments().length == 0) {
            Segment oldCommonParentSegment = this.oldChangeSet.findSegmentFromTagName(newCommonParentSegment.enclosingTagName(), 0);
            SegmentsArea area = new SegmentsArea();
            area.newArea = new Segment[]{newCommonParentSegment};
            try {
                area.oldArea = oldCommonParentSegment.subSegments();
            }
            catch (Throwable throwable) {
                String errorMessage = "RPPSpecificLinesTopOfCobol";
                Util.rethrow((Throwable)new InterruptedException(errorMessage));
            }
            area.removedArea = this.getRemovedModifiedSegments(area.oldArea, removedEnclosingSegments);
            if (this.isModifiedSegmentArea(area)) {
                areas.add(area);
            }
        } else {
            String enclosingTagName;
            Segment oldCommonParentSegment = this.oldChangeSet.findSegmentFromTagName(newCommonParentSegment.enclosingTagName(), 0);
            Segment[] newSubSegments = newCommonParentSegment.subSegments();
            Segment[] oldSubSegments = oldCommonParentSegment.subSegments();
            if (oldSubSegments == null || oldSubSegments.length == 0) {
                SegmentsArea area = new SegmentsArea();
                area.newArea = newSubSegments;
                area.oldArea = new Segment[]{oldCommonParentSegment};
                area.removedArea = this.getRemovedModifiedSegments(area.oldArea, removedEnclosingSegments);
                if (this.isModifiedSegmentArea(area)) {
                    areas.add(area);
                }
                return areas;
            }
            Hashtable<String, Character> tagToCharMap = new Hashtable<String, Character>();
            StringBuilder sbOld = new StringBuilder();
            StringBuilder sbNew = new StringBuilder();
            ArrayList<Segment> oldList = new ArrayList<Segment>();
            ArrayList<Segment> newList = new ArrayList<Segment>();
            char currentChar = '\u0001';
            char sepChar = '\u0000';
            if (this.getTracer().isDebugModeEnabled()) {
                currentChar = 'A';
                sepChar = ' ';
            }
            int i = 0;
            while (i < oldSubSegments.length) {
                enclosingTagName = oldSubSegments[i].enclosingTagName();
                if (oldSubSegments[i].isTagged()) {
                    oldList.add(oldSubSegments[i]);
                    tagToCharMap.put(enclosingTagName, Character.valueOf(currentChar));
                    sbOld.append(currentChar);
                    currentChar = (char)(currentChar + '\u0001');
                }
                ++i;
            }
            i = 0;
            while (i < newSubSegments.length) {
                enclosingTagName = newSubSegments[i].enclosingTagName();
                if (newSubSegments[i].isTagged()) {
                    newList.add(newSubSegments[i]);
                    Character aChar = (Character)tagToCharMap.get(enclosingTagName);
                    if (aChar != null) {
                        sbNew.append(aChar);
                    } else {
                        tagToCharMap.put(enclosingTagName, Character.valueOf(currentChar));
                        sbNew.append(currentChar);
                        currentChar = (char)(currentChar + '\u0001');
                    }
                }
                ++i;
            }
            DiffCursor dC = Strings.newDiffCursor((CharSequence)sbOld, (CharSequence)sbNew);
            int oldOffset = 0;
            int newOffset = 0;
            while (dC.searchNextDifference()) {
                switch (dC.getDifferenceNature()) {
                    case Insertion: {
                        int insertIdx = dC.getReferenceBeginIndex();
                        int nbInsertion = dC.getModifiedEndIndex() - dC.getModifiedBeginIndex();
                        int i2 = 0;
                        while (i2 < nbInsertion) {
                            oldList.add(insertIdx + oldOffset, null);
                            sbOld.insert(insertIdx + oldOffset, sepChar);
                            ++i2;
                        }
                        oldOffset += nbInsertion;
                        break;
                    }
                    case Deletion: {
                        int insertIdx = dC.getModifiedBeginIndex();
                        int nbInsertion = dC.getReferenceEndIndex() - dC.getReferenceBeginIndex();
                        int i2 = 0;
                        while (i2 < nbInsertion) {
                            newList.add(insertIdx + newOffset, null);
                            sbNew.insert(insertIdx + newOffset, sepChar);
                            ++i2;
                        }
                        newOffset += nbInsertion;
                        break;
                    }
                    case Replacement: {
                        int oldListInsertIdx = dC.getReferenceEndIndex();
                        int oldNbInsertion = dC.getModifiedEndIndex() - dC.getModifiedBeginIndex();
                        int i3 = 0;
                        while (i3 < oldNbInsertion) {
                            oldList.add(oldListInsertIdx + oldOffset, null);
                            sbOld.insert(oldListInsertIdx + oldOffset, sepChar);
                            ++i3;
                        }
                        oldOffset += oldNbInsertion;
                        int newListInsertIdx = dC.getModifiedBeginIndex();
                        int newNbInsertion = dC.getReferenceEndIndex() - dC.getReferenceBeginIndex();
                        int i4 = 0;
                        while (i4 < newNbInsertion) {
                            newList.add(newListInsertIdx + newOffset, null);
                            sbNew.insert(newListInsertIdx + newOffset, sepChar);
                            ++i4;
                        }
                        newOffset += newNbInsertion;
                        break;
                    }
                    case Identical: {
                        break;
                    }
                }
            }
            if (oldList.size() != newList.size()) {
                throw new RuntimeException("Old list and new List must have the same size");
            }
            int lastMatchIndex = -1;
            int i5 = 0;
            while (i5 < sbOld.length()) {
                if (sbNew.charAt(i5) == sbOld.charAt(i5)) {
                    SegmentsArea area = new SegmentsArea();
                    if (lastMatchIndex == -1) {
                        area.oldArea = this.getSegmentsBetween(oldSubSegments, null, (Segment)oldList.get(i5));
                        area.newArea = this.getSegmentsBetween(newSubSegments, null, (Segment)newList.get(i5));
                        area.removedArea = this.getRemovedModifiedSegments(area.oldArea, removedEnclosingSegments);
                    } else {
                        area.oldArea = this.getSegmentsBetween(oldSubSegments, (Segment)oldList.get(lastMatchIndex), (Segment)oldList.get(i5));
                        area.newArea = this.getSegmentsBetween(newSubSegments, (Segment)newList.get(lastMatchIndex), (Segment)newList.get(i5));
                        area.removedArea = this.getRemovedModifiedSegments(area.oldArea, removedEnclosingSegments);
                    }
                    if (this.isModifiedSegmentArea(area)) {
                        areas.add(area);
                    }
                    lastMatchIndex = i5;
                }
                ++i5;
            }
            SegmentsArea area = new SegmentsArea();
            if (lastMatchIndex != -1) {
                area.oldArea = this.getSegmentsBetween(oldSubSegments, (Segment)oldList.get(lastMatchIndex), null);
                area.newArea = this.getSegmentsBetween(newSubSegments, (Segment)newList.get(lastMatchIndex), null);
                area.removedArea = this.getRemovedModifiedSegments(area.oldArea, removedEnclosingSegments);
            } else {
                area.oldArea = this.getSegmentsBetween(oldSubSegments, null, null);
                area.newArea = this.getSegmentsBetween(newSubSegments, null, null);
                area.removedArea = this.getRemovedModifiedSegments(area.oldArea, removedEnclosingSegments);
            }
            if (this.isModifiedSegmentArea(area)) {
                areas.add(area);
            }
        }
        return areas;
    }

    private boolean isModifiedSegmentArea(SegmentsArea area) {
        Segment[] segmentArray = area.oldArea;
        int n = area.oldArea.length;
        int n2 = 0;
        while (n2 < n) {
            Segment segment = segmentArray[n2];
            if (!this.oldAlreadyReconcile.contains(segment) && segment.subSegments().length == 0 && !segment.getChangeNature().isGeneratedCode()) {
                return true;
            }
            ++n2;
        }
        return area.removedArea != null && area.removedArea.length > 0;
    }

    private Segment[] getSegmentsBetween(Segment[] subSegments, Segment start, Segment stop) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        if (start == null && stop == null) {
            return subSegments;
        }
        int startIdx = 0;
        int stopIdx = subSegments.length - 1;
        int i = 0;
        while (i < subSegments.length) {
            if (start != null && subSegments[i] == start) {
                startIdx = i + 1;
            }
            if (stop != null && subSegments[i] == stop) {
                stopIdx = i - 1;
                break;
            }
            ++i;
        }
        i = startIdx;
        while (i <= stopIdx) {
            if (stop == null || subSegments[i].endIndex() <= stop.endIndex()) {
                segments.add(subSegments[i]);
            }
            ++i;
        }
        Segment[] result = new Segment[segments.size()];
        return segments.toArray(result);
    }

    private Segment[] getRemovedModifiedSegments(Segment[] oldSegments, List<Segment> removedEnclosingSegments) {
        ArrayList<Segment> list = new ArrayList<Segment>();
        Segment[] segmentArray = oldSegments;
        int n = oldSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment segment = segmentArray[n2];
            for (Segment rSegment : removedEnclosingSegments) {
                if (segment == rSegment || !segment.isSyntactic() && ReconcileUtil.isAncestorOf(segment, rSegment)) {
                    list.add(rSegment);
                    continue;
                }
                if (!segment.isSyntactic() || rSegment.beginIndex() < segment.beginIndex() || rSegment.endIndex() > segment.endIndex()) continue;
                list.add(rSegment);
            }
            ++n2;
        }
        removedEnclosingSegments.removeAll(list);
        Segment[] result = new Segment[list.size()];
        return list.toArray(result);
    }

    private void validate() {
        Iterator<Segment> modifiedIter = this.newChangeSet.changedAtomicSegments();
        while (modifiedIter.hasNext()) {
            this.validateSegment(modifiedIter.next());
        }
    }

    private void validateSegment(Segment newModifedSegment) {
        boolean unchangedSegment = Strings.sameCharSequences((CharSequence)newModifedSegment.getText(), (CharSequence)newModifedSegment.generatedText());
        if (unchangedSegment) {
            return;
        }
        boolean reformattedSegment = Ints.sameIntSequences((IntSequence)this.newChangeSet.textPartition().subTextPartition(newModifedSegment.beginIndex(), newModifedSegment.endIndex()).getWords(), (IntSequence)this.newChangeSet.generatedTextPartition().subTextPartition(newModifedSegment.generatedBeginIndex(), newModifedSegment.generatedEndIndex()).getWords());
        if (reformattedSegment) {
            return;
        }
        Segment oldSeg = ReconcileUtil.findSegmentOfSameLogicalPosition(newModifedSegment, this.oldChangeSet);
        if (oldSeg != null) {
            if (oldSeg.getChangeNature() == ChangeNature.Unchanged) {
                String message = "Unchanged segment in old code must not be changed in the new code if same logical location exists:\nold (" + (Object)((Object)oldSeg.getChangeNature()) + "):\n" + oldSeg.toString() + "\nnew (" + (Object)((Object)newModifedSegment.getChangeNature()) + "):\n" + newModifedSegment.toString();
                RuntimeException re = new RuntimeException(message);
                throw re;
            }
        } else {
            String enclosingTagName = newModifedSegment.enclosingTagName();
            if (enclosingTagName != null) {
                oldSeg = this.oldChangeSet.segmentFromTagName(enclosingTagName, 0);
                if (oldSeg == null) {
                    if (!this.isOldRemovedProblemTag(enclosingTagName)) {
                        String message = "The enclosing tag must be in the old code (syntactic included):\nold (null):\n\nnew (" + (Object)((Object)newModifedSegment.getChangeNature()) + "):\n" + newModifedSegment.toString();
                        RuntimeException re = new RuntimeException(message);
                        throw re;
                    }
                } else if (oldSeg.getChangeNature() == ChangeNature.Unchanged) {
                    String message = "The enclosing tag in the old code must have modifed segments:\nold (" + (Object)((Object)oldSeg.getChangeNature()) + "):\n" + oldSeg.toString() + "\nnew (" + (Object)((Object)newModifedSegment.getChangeNature()) + "):\n" + newModifedSegment.toString();
                    RuntimeException re = new RuntimeException(message);
                    throw re;
                }
            }
        }
    }

    private void cleanup() {
        if (this.enclosingSegments != null) {
            this.enclosingSegments.clear();
            this.enclosingSegments = null;
        }
        if (this.oldAlreadyReconcile != null) {
            this.oldAlreadyReconcile.clear();
            this.oldAlreadyReconcile = null;
        }
        if (this.newAlreadyReconcile != null) {
            this.newAlreadyReconcile.clear();
            this.newAlreadyReconcile = null;
        }
        if (this.removedEnclosingSegments != null) {
            this.removedEnclosingSegments.clear();
            this.removedEnclosingSegments = null;
        }
        this.oldChangeSet = null;
        this.newChangeSet = null;
    }

    public static class ProtectedSegmentArea {
        int beginIndex;
        int endIndex;
        Segment segment;
        boolean isTreated;
    }

    public static class SegmentsArea {
        Segment[] oldArea;
        Segment[] newArea;
        Segment[] removedArea;
    }
}

