/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.reconcile.IReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileConstants;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileProblem;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.iterators.FilterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReconcilerState
implements IReconcilerState {
    protected UserChangeSet changeSet = null;
    protected List<IProblem> problems = new ArrayList<IProblem>();
    protected List<IProblem> oldProblems = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ReconcilerState(UserChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    public ReconcilerState(UserChangeSet changeSet, List<IProblem> oldProblems) {
        this.changeSet = changeSet;
        this.oldProblems = oldProblems;
        this.problems = new ArrayList<IProblem>();
    }

    @Override
    public UserChangeSet getChangeSet() {
        return this.changeSet;
    }

    public int problemCount() {
        if (this.problems == null) {
            return 0;
        }
        return this.problems.size();
    }

    public void addProblem(ReconcileProblem problem, boolean checkWithOldProblems) {
        if (problem != null && this.checkWithOldProblems(problem)) {
            if (this.problems == null) {
                this.problems = new ArrayList<IProblem>();
            }
            this.problems.add(problem);
            problem.setReconcilerState(this);
            problem.refresh();
        }
    }

    public void addProblems(List<IProblem> problems) {
        for (IProblem problem : problems) {
            ReconcileProblem rp = (ReconcileProblem)problem;
            rp.setReconcilerState(this);
            this.addProblem(rp, true);
        }
    }

    @Override
    public Iterator<IProblem> problems() {
        if (this.problems == null) {
            return Iterators.emptyIterator();
        }
        this.refreshAll();
        return this.problems.iterator();
    }

    @Override
    public Iterator<IProblem> problems(final int beginIndex, final int endIndex) {
        ArrayList<IProblem> clonedList = new ArrayList<IProblem>();
        if (this.problems != null) {
            clonedList.addAll(this.problems);
        }
        return new FilterIterator<IProblem>(clonedList.iterator()){

            protected boolean accept(IProblem candidate) {
                int candidateIndex = candidate.beginIndex();
                return candidateIndex >= beginIndex && candidateIndex <= endIndex;
            }
        };
    }

    public List<IProblem> getProblems() {
        if (this.problems == null) {
            return new ArrayList<IProblem>();
        }
        this.refreshAll();
        return this.problems;
    }

    private void refreshAll() {
        for (IProblem problem : this.problems) {
            ReconcileProblem rp = (ReconcileProblem)problem;
            rp.refresh();
        }
    }

    private boolean checkWithOldProblems(ReconcileProblem problem) {
        boolean result = true;
        if (this.oldProblems != null) {
            IProblem toBeRemoved = null;
            for (IProblem oldProblem : this.oldProblems) {
                if (((ReconcileProblem)oldProblem).getProblemType() == ReconcileConstants.ProblemType.REMOVED || oldProblem.beginIndex() != problem.beginIndex() || oldProblem.endIndex() != problem.endIndex()) continue;
                if (((ReconcileProblem)oldProblem).isReversible()) {
                    result = false;
                }
                toBeRemoved = oldProblem;
                break;
            }
            if (toBeRemoved != null) {
                this.oldProblems.remove(toBeRemoved);
            }
        }
        return result;
    }

    public void mergeWithOldProblems() {
        if (this.oldProblems != null) {
            for (IProblem problem : this.oldProblems) {
                ReconcileProblem reconcileProblem = (ReconcileProblem)problem;
                reconcileProblem.setReconcilerState(this);
                if (reconcileProblem.isReversible()) {
                    reconcileProblem.reverse();
                    continue;
                }
                this.problems.add(reconcileProblem);
            }
            this.oldProblems.clear();
            this.oldProblems = null;
        }
    }

    public void duplicateFrom(ReconcilerState state) {
        Iterator<IProblem> iterator = state.problems();
        while (iterator.hasNext()) {
            ReconcileProblem problem = (ReconcileProblem)iterator.next();
            ReconcileProblem newProblem = new ReconcileProblem(this);
            newProblem.duplicateFrom(problem);
            if (this.problems == null) {
                this.problems = new ArrayList<IProblem>();
            }
            this.addProblem(newProblem, false);
        }
    }

    public List<IProblem> getOldProblems() {
        return this.oldProblems;
    }
}

