/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.extension.IReconcileLocation;
import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.turbo.EngineFactory;
import com.ibm.pdp.engine.turbo.core.BasicTextPartition;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentFilter;
import com.ibm.pdp.engine.turbo.core.SegmentSelectionParameter;
import com.ibm.pdp.engine.turbo.core.TopSegment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileConstants;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileProblem;
import com.ibm.pdp.engine.turbo.serialize.SerializationTool;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.ints.IntSequence;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ReconcileUtil
implements ReconcileConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012,2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    private static int DIFF_LIMITS = 10000;
    private static int level = 0;

    public static Segment findSegmentOfSameLogicalPosition(Segment segment, UserChangeSet userChangeSet) {
        Segment result = ReconcileUtil._findSegmentOfSameLogicalPositionSyntacticTag(segment, userChangeSet);
        return result;
    }

    private static Segment _findSegmentOfSameLogicalPositionSyntacticTag(Segment segment, UserChangeSet userChangeSet) {
        Segment candidate = null;
        String enclosingTagName = null;
        if (segment.enclosingTagName() != null) {
            enclosingTagName = segment.enclosingTagName().intern();
        }
        if (segment.isTagged()) {
            candidate = userChangeSet.findSegmentFromTagName(enclosingTagName, 0);
        } else {
            String fromTagName = null;
            if (segment.fromTagName() != null) {
                fromTagName = segment.fromTagName().intern();
            }
            String toTagName = null;
            if (segment.toTagName() != null) {
                toTagName = segment.toTagName().intern();
            }
            candidate = fromTagName == enclosingTagName ? userChangeSet.findSegmentFromTagName(toTagName, -1) : userChangeSet.findSegmentFromTagName(fromTagName, 1);
            candidate = candidate != null && ReconcileUtil.sameLogicalPositionSyntacticTag(segment, candidate) ? candidate : null;
        }
        return candidate;
    }

    public static Segment findSegmentOfSameLogicalPositionForSyntactic(Segment syntacticSegment, UserChangeSet userChangeSet) {
        Segment candidate = null;
        if (syntacticSegment != null) {
            if (syntacticSegment.isTagged()) {
                candidate = userChangeSet.findSegmentFromTagName(syntacticSegment.enclosingTagName(), 0);
            } else {
                String enclosingTag = syntacticSegment.enclosingTagName() == null ? null : syntacticSegment.enclosingTagName().intern();
                String fromTag = syntacticSegment.fromTagName() == null ? null : syntacticSegment.fromTagName().intern();
                String toTag = syntacticSegment.toTagName() == null ? null : syntacticSegment.toTagName().intern();
                Segment segment = candidate = fromTag == enclosingTag ? userChangeSet.findSegmentFromTagName(toTag, -1) : userChangeSet.findSegmentFromTagName(fromTag, 1);
                if (candidate != null) {
                    String toTag2;
                    String fromTag2;
                    String enclosingTag2;
                    boolean fullTag = syntacticSegment.isTagged();
                    if (candidate.isTagged() != fullTag) {
                        return null;
                    }
                    String enclosingTag1 = syntacticSegment.enclosingTagName() == null ? null : syntacticSegment.enclosingTagName().intern();
                    String string = enclosingTag2 = candidate.enclosingTagName() == null ? null : candidate.enclosingTagName().intern();
                    if (enclosingTag1 != enclosingTag2) {
                        return null;
                    }
                    if (fullTag) {
                        return candidate;
                    }
                    String fromTag1 = syntacticSegment.fromTagName() == null ? null : syntacticSegment.fromTagName().intern();
                    String string2 = fromTag2 = candidate.fromTagName() == null ? null : candidate.fromTagName().intern();
                    if (fromTag1 != fromTag2) {
                        return null;
                    }
                    String toTag1 = syntacticSegment.toTagName() == null ? null : syntacticSegment.toTagName().intern();
                    String string3 = toTag2 = candidate.toTagName() == null ? null : candidate.toTagName().intern();
                    if (toTag1 != toTag2) {
                        return null;
                    }
                }
            }
            return candidate;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Segment findFirstLevelRemovedSegmentFromParentTree(Segment oldSegment, UserChangeSet newUserChangeSet) {
        last = oldSegment;
        current = oldSegment.enclosingSegment();
        newSegment = null;
        if (!(current instanceof TopSegment)) ** GOTO lbl10
        return current;
lbl-1000:
        // 1 sources

        {
            newSegment = ReconcileUtil.findSegmentOfSameLogicalPosition(current, newUserChangeSet);
            if (newSegment != null) continue;
            last = current;
            current = current.enclosingSegment();
lbl10:
            // 3 sources

            ** while (current != null && newSegment == null)
        }
lbl11:
        // 1 sources

        return last;
    }

    private static boolean sameLogicalPositionSyntacticTag(Segment segment1, Segment segment2) {
        boolean fullTag = segment1.isTagged();
        if (segment2.isTagged() != fullTag) {
            return false;
        }
        if (!ReconcileUtil.sameTagId(segment1.enclosingTagName(), segment2.enclosingTagName())) {
            return false;
        }
        if (fullTag) {
            return true;
        }
        return ReconcileUtil.sameTagId(segment1.fromTagName(), segment2.fromTagName()) && ReconcileUtil.sameTagId(segment1.toTagName(), segment2.toTagName());
    }

    private static boolean sameTagId(String tag1, String tag2) {
        return tag1 == null || tag2 == null ? tag1 == tag2 : tag1.equals(tag2);
    }

    public static Segment getSegmentFromReconcileLocation(IReconcileLocation reconcileLocation, UserChangeSet userChangeSet) {
        if (reconcileLocation != null) {
            if (reconcileLocation.enclosingTagName() == reconcileLocation.fromTagName() && reconcileLocation.enclosingTagName() == reconcileLocation.toTagName()) {
                if (reconcileLocation.enclosingTagName() == null) {
                    return userChangeSet.firstAtom();
                }
                return userChangeSet.findSegmentFromTagName(reconcileLocation.enclosingTagName(), 0);
            }
            if (reconcileLocation.fromTagName() == null) {
                return userChangeSet.firstAtom();
            }
            Segment candidate = reconcileLocation.fromTagName() == reconcileLocation.enclosingTagName() ? userChangeSet.findSegmentFromTagName(reconcileLocation.toTagName(), -1) : userChangeSet.findSegmentFromTagName(reconcileLocation.fromTagName(), 1);
            return candidate;
        }
        return null;
    }

    public static Iterator<Segment> segments(UserChangeSet userChangeSet, Segment start, Segment stop, int beginIndex, int endIndex, boolean exactPosition) {
        SegmentSelectionParameter selectionParameter = userChangeSet.newSegmentSelection(true, start, true, stop, true, false);
        selectionParameter.setFilter(new IndexesSegmentFilter(beginIndex, endIndex, exactPosition));
        return userChangeSet.segments(selectionParameter);
    }

    public static void writeLocation(XMLStreamWriter xmlWriter, String elementName, ReconcileProblem.ReconcileLocation location) throws XMLStreamException {
        xmlWriter.writeStartElement(elementName);
        if (location.enclosingTagName != null) {
            xmlWriter.writeAttribute("enclosingTagName", location.enclosingTagName);
        }
        if (location.fromTagName != null) {
            xmlWriter.writeAttribute("fromTagName", location.fromTagName);
        }
        if (location.toTagName != null) {
            xmlWriter.writeAttribute("toTagName", location.toTagName);
        }
        if (location.generatedText != null) {
            xmlWriter.writeStartElement("GeneratedText");
            xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)location.generatedText));
            xmlWriter.writeEndElement();
        }
        if (location.text != null) {
            xmlWriter.writeStartElement("Text");
            xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)location.text));
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    public static void readLocation(XMLStreamReader xmlReader, String elementName, ReconcileProblem.ReconcileLocation location) throws XMLStreamException {
        boolean finished = false;
        Properties props = ReconcileUtil.getAttributes(xmlReader);
        location.enclosingTagName = props.getProperty("enclosingTagName");
        location.toTagName = props.getProperty("toTagName");
        location.fromTagName = props.getProperty("fromTagName");
        while (xmlReader.hasNext() && !finished) {
            String qname;
            int eventType = xmlReader.next();
            if (eventType == 1) {
                String localName = xmlReader.getLocalName();
                if (localName.equalsIgnoreCase("Text")) {
                    location.text = SerializationTool.decode((String)xmlReader.getElementText());
                    continue;
                }
                if (!localName.equalsIgnoreCase("GeneratedText")) continue;
                location.generatedText = SerializationTool.decode((String)xmlReader.getElementText());
                continue;
            }
            if (eventType != 2 || !(qname = xmlReader.getName().getLocalPart()).equalsIgnoreCase(elementName)) continue;
            finished = true;
        }
    }

    public static Properties getAttributes(XMLStreamReader xmlReader) throws XMLStreamException {
        Properties prop = new Properties();
        int nbOfAtt = xmlReader.getAttributeCount();
        int i = 0;
        while (i < nbOfAtt) {
            String name = xmlReader.getAttributeLocalName(i);
            String value = xmlReader.getAttributeValue(i);
            prop.put(name, value);
            ++i;
        }
        return prop;
    }

    public static String[] readParameters(XMLStreamReader xmlReader) {
        ArrayList<String> parameters = new ArrayList<String>();
        boolean finished = false;
        try {
            while (xmlReader.hasNext() && !finished) {
                String qname;
                int eventType = xmlReader.next();
                if (eventType == 1) {
                    String localName = xmlReader.getLocalName();
                    if (!localName.equalsIgnoreCase("Parameter")) continue;
                    parameters.add(SerializationTool.decode((String)xmlReader.getElementText()));
                    continue;
                }
                if (eventType != 2 || !(qname = xmlReader.getName().getLocalPart()).equalsIgnoreCase("Parameters")) continue;
                finished = true;
            }
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
        return parameters.toArray(new String[parameters.size()]);
    }

    public static Segment getSegmentFromReconcileLocation(UserChangeSet userChangeSet, ReconcileProblem.ReconcileLocation reconcileLocation) {
        Segment result = null;
        if (reconcileLocation != null) {
            Segment candidate;
            String fromTagName = reconcileLocation.fromTagName;
            String toTagName = reconcileLocation.toTagName;
            String enclosingTagName = reconcileLocation.enclosingTagName;
            result = fromTagName == null && toTagName == null && enclosingTagName == null ? userChangeSet.firstAtom() : (enclosingTagName != null && enclosingTagName.equals(fromTagName) && enclosingTagName.equals(toTagName) ? userChangeSet.findSegmentFromTagName(enclosingTagName, 0) : (fromTagName == null ? userChangeSet.firstAtom() : (candidate = fromTagName.equals(enclosingTagName) ? userChangeSet.findSegmentFromTagName(toTagName, -1) : userChangeSet.findSegmentFromTagName(fromTagName, 1))));
        }
        return result;
    }

    public static int findTextIndexInSegment(Segment segment, CharSequence text) {
        if (segment != null && text != null) {
            CharSequence ref;
            UserChangeSet changeSet = segment.getChangeSet();
            if (changeSet.getTextProcessor() == null) {
                return -2;
            }
            if (segment.endIndex() > changeSet.textPartition().getTextLength()) {
                return -1;
            }
            ISubTextPartition modPartition = changeSet.textPartition().subTextPartition(segment.beginIndex(), segment.endIndex());
            ITextPartitioner refPartitioner = changeSet.getTextProcessor().newTextPartitioner();
            BasicTextPartition refPartition = new BasicTextPartition(changeSet.getDictionary(), refPartitioner);
            refPartition.setText(text);
            if (modPartition.getWords().length() > DIFF_LIMITS || refPartition.getWords().length() > DIFF_LIMITS) {
                return -1;
            }
            DiffCursor dC = Ints.newDiffCursor((IntSequence)refPartition.getWords(), (IntSequence)modPartition.getWords());
            int start = 0;
            CharSequence gap = null;
            while (dC.searchNextDifference()) {
                switch (dC.getDifferenceNature()) {
                    // Empty switch
                }
                int current = modPartition.wordBeginIndex(dC.getModifiedBeginIndex());
                if (current > start) {
                    CharSequence ref2 = modPartition.getTextInterval(start, current);
                    if (gap != null) {
                        ref2 = String.valueOf(gap.toString()) + ref2.toString();
                        if (text.equals(ref2)) {
                            return start - gap.length();
                        }
                        gap = null;
                    } else {
                        if (text.equals(ref2)) {
                            return start;
                        }
                        gap = text.length() < ref2.length() || !text.subSequence(0, ref2.length()).equals(ref2) ? null : text.subSequence(0, ref2.length());
                    }
                    start = modPartition.wordBeginIndex(dC.getModifiedEndIndex());
                    continue;
                }
                start = modPartition.wordBeginIndex(dC.getModifiedEndIndex());
            }
            if (start < modPartition.getTextLength() && text.equals(ref = modPartition.getTextInterval(start, modPartition.getTextLength()))) {
                return start;
            }
        }
        return -1;
    }

    public static synchronized String dumpToTmpFile(String contents, String suffix, boolean isFirstReconciliation) {
        try {
            File dir = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/RppReconciler");
            dir.mkdirs();
            File temp = new File(String.valueOf(dir.getAbsolutePath()) + "/Reconciler." + simpleFormat.format(new Date()) + "." + (isFirstReconciliation ? "1." : "2.") + suffix);
            temp.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write(contents);
            out.close();
            return temp.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAncestorOf(Segment segment1, Segment segment2) {
        Segment segment = segment2;
        while (segment != null) {
            if (segment == segment1) {
                return true;
            }
            segment = segment.enclosingSegment();
        }
        return false;
    }

    public static String dumpTopSegmentTree(Segment top, boolean withMp, boolean withAtt, boolean withText) {
        level = 0;
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Root>\n";
        ReconcileUtil.indent();
        if (top != null) {
            result = String.valueOf(result) + ReconcileUtil.dumpSegmentTree(top, withMp, withAtt, withText);
        }
        ReconcileUtil.unindent();
        result = String.valueOf(result) + "</Root>\n";
        return result;
    }

    private static CharSequence dumpSegmentTree(Segment top, boolean withMp, boolean withAtt, boolean withText) {
        String result = "";
        Segment[] segments = top.subSegments();
        if (segments == null) {
            return result;
        }
        Segment[] segmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isMpTag;
            Segment son = segmentArray[n2];
            boolean bl = isMpTag = son.getTagProperties() != null && son.getTagProperties().getProperty("mp") != null;
            if (withMp || !isMpTag) {
                int i;
                ReconcileUtil.indent();
                if (son.isTagged()) {
                    i = 0;
                    while (i < level) {
                        result = String.valueOf(result) + " ";
                        ++i;
                    }
                    result = String.valueOf(result) + "<" + son.enclosingTagName();
                    if (withAtt) {
                        if (son.isSyntactic()) {
                            result = String.valueOf(result) + " specific='true'";
                        } else if ("true".equals(son.getTagProperties().getProperty("SpecificTag"))) {
                            result = String.valueOf(result) + " specific='true'";
                        } else if (withMp && isMpTag) {
                            result = String.valueOf(result) + " mp='true'";
                        }
                    }
                    if (withText && son.subSegments().length == 0) {
                        result = String.valueOf(result) + ">";
                        result = String.valueOf(result) + son.getText();
                    } else {
                        result = String.valueOf(result) + ">\n";
                    }
                } else if (withText && son.subSegments().length == 0) {
                    result = String.valueOf(result) + son.getText();
                }
                result = String.valueOf(result) + ReconcileUtil.dumpSegmentTree(son, withMp, withAtt, withText);
                if (son.isTagged()) {
                    i = 0;
                    while (i < level) {
                        result = String.valueOf(result) + " ";
                        ++i;
                    }
                    result = String.valueOf(result) + "</" + son.enclosingTagName() + ">\n";
                }
                ReconcileUtil.unindent();
            }
            ++n2;
        }
        return result;
    }

    public static String dumpGeneratedInfo(IGeneratedInfo generatedInfo, String suffix, boolean isFirstReconciliation) {
        EngineFactory engine = new EngineFactory();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        engine.writeGeneratedInfo(generatedInfo, outStream);
        return ReconcileUtil.dumpToTmpFile(new String(outStream.toByteArray()), suffix, isFirstReconciliation);
    }

    public static String dumpGeneratedInfoTree(IGeneratedInfo generatedInfo, boolean withMp, boolean withSpecific) {
        level = 0;
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Root>\n";
        result = String.valueOf(result) + " <" + generatedInfo.getRootTag().getName() + ">\n";
        ReconcileUtil.indent();
        result = String.valueOf(result) + ReconcileUtil.dumpGeneratedInfoTree(generatedInfo.getRootTag(), withMp, withSpecific);
        ReconcileUtil.unindent();
        result = String.valueOf(result) + " </" + generatedInfo.getRootTag().getName() + ">\n";
        result = String.valueOf(result) + "</Root>\n";
        return result;
    }

    private static CharSequence dumpGeneratedInfoTree(IGeneratedTag tag, boolean withMp, boolean withSpecific) {
        String result = "";
        Iterator nodes = tag.sons();
        while (nodes.hasNext()) {
            int i;
            boolean isMpTag;
            IGeneratedTag generatedTag = (IGeneratedTag)nodes.next();
            boolean isSpecificTag = "true".equals(generatedTag.getProperty("SpecificTag"));
            boolean bl = isMpTag = generatedTag.getProperty("mp") != null;
            if (!withMp && isMpTag) continue;
            if (withSpecific || !isSpecificTag) {
                ReconcileUtil.indent();
                i = 0;
                while (i < level) {
                    result = String.valueOf(result) + " ";
                    ++i;
                }
                if (isSpecificTag) {
                    result = String.valueOf(result) + "<" + generatedTag.getName() + " specific='true'>\n";
                }
                result = isMpTag ? String.valueOf(result) + "<" + generatedTag.getName() + " mp='true'>\n" : String.valueOf(result) + "<" + generatedTag.getName() + ">\n";
            }
            result = String.valueOf(result) + ReconcileUtil.dumpGeneratedInfoTree(generatedTag, withMp, withSpecific);
            if (!withSpecific && isSpecificTag) continue;
            i = 0;
            while (i < level) {
                result = String.valueOf(result) + " ";
                ++i;
            }
            result = String.valueOf(result) + "</" + generatedTag.getName() + ">\n";
            ReconcileUtil.unindent();
        }
        return result;
    }

    private static void indent() {
        ++level;
    }

    private static void unindent() {
        --level;
    }

    private static class IndexesSegmentFilter
    implements SegmentFilter {
        int _beginIndex = -1;
        int _endIndex = -1;
        boolean _exactPosition = true;

        public IndexesSegmentFilter(int beginIndex, int endIndex, boolean exactPosition) {
            this._beginIndex = beginIndex;
            this._endIndex = endIndex;
            this._exactPosition = exactPosition;
        }

        @Override
        public boolean skip(Segment segment) {
            if (segment == null) {
                return true;
            }
            if (this._exactPosition) {
                return segment.beginIndex() != this._beginIndex || segment.endIndex() != this._endIndex;
            }
            return segment.beginIndex() < this._beginIndex || segment.endIndex() > this._endIndex;
        }

        @Override
        public boolean skipSons(Segment segment) {
            return false;
        }
    }
}

