/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.extension.IReconcileLocation;
import com.ibm.pdp.engine.extension.IReconcileTextInterval;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import java.util.ArrayList;
import java.util.List;

public class ReconcileTextInterval
implements IReconcileTextInterval {
    ITextPartition textPartition;
    boolean isApplicable = true;
    CharSequence oldGeneratedText;
    CharSequence text;
    Segment segment;
    int beginIndex;
    int endIndex;
    boolean isNewGeneratedText;
    IGeneratedInfo generatedInfo;
    CharSequence fromTagName;
    CharSequence toTagName;
    CharSequence enclosingTagName;
    CharSequence removedTagName;
    List<IReconcileLocation> modifiedReconcileLocation = new ArrayList<IReconcileLocation>();
    List<IProblem> problems;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ReconcileTextInterval(ITextPartition textPartition, CharSequence oldGeneratedText, boolean isApplicable, int beginIndex, int endIndex, boolean isNewGeneratedText, String removedTagName) {
        if (textPartition == null) {
            throw new RuntimeException("Text partition text must not be null!!");
        }
        if (beginIndex > endIndex || textPartition.getTextLength() < endIndex) {
            throw new RuntimeException("Wrong text interval !!");
        }
        this.isNewGeneratedText = isNewGeneratedText;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.textPartition = textPartition;
        this.oldGeneratedText = oldGeneratedText;
        this.removedTagName = removedTagName;
        this.isApplicable = isApplicable;
    }

    public CharSequence getText() {
        if (this.text != null) {
            return this.text;
        }
        return this.textPartition.getTextInterval(this.beginIndex, this.endIndex);
    }

    public void setText(CharSequence newText) {
        this.text = newText;
    }

    public boolean isApplicable() {
        return this.isApplicable;
    }

    public void setApplicable(boolean isApplicable) {
        this.isApplicable = isApplicable;
    }

    public int beginIndex() {
        return this.beginIndex;
    }

    public int endIndex() {
        return this.endIndex;
    }

    public int length() {
        return this.getText().length();
    }

    public boolean isNewGeneratedText() {
        return this.isNewGeneratedText;
    }

    public IGeneratedInfo getGeneratedInfo() {
        return this.generatedInfo;
    }

    public CharSequence fromTagName() {
        return this.segment == null ? null : this.segment.fromTagName();
    }

    public CharSequence toTagName() {
        return this.segment == null ? null : this.segment.toTagName();
    }

    public CharSequence enclosingTagName() {
        return this.segment == null ? null : this.segment.enclosingTagName();
    }

    public CharSequence getOldGeneratedText() {
        return this.oldGeneratedText;
    }

    public List<IReconcileLocation> getModifiedReconcileLocations() {
        return this.modifiedReconcileLocation;
    }

    public List<IProblem> getProblems() {
        if (this.problems == null) {
            this.problems = new ArrayList<IProblem>();
        }
        return this.problems;
    }

    public String toString() {
        return this.getText().toString();
    }
}

