/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.icu.text.MessageFormat;
import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileConstants;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileMessages;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileProblem;
import java.util.MissingResourceException;

public class ReconcileQuickFixAction
implements IProblem.IQuickFixAction,
ReconcileConstants {
    String code;
    String message;
    int resolutionCode;
    String[] parameters;
    ReconcileProblem problem;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ReconcileQuickFixAction() {
    }

    public ReconcileQuickFixAction(int resolutionCode) {
        this.resolutionCode = resolutionCode;
    }

    public String code() {
        return this.code;
    }

    public String[] parameters() {
        return this.parameters;
    }

    public String message() {
        return this.nlsMessage();
    }

    public String nlsMessage() {
        String msg = null;
        if (this.code != null) {
            try {
                msg = ReconcileMessages.getString(this.code);
                MessageFormat msgFormat = new MessageFormat(msg);
                return msgFormat.format((Object[])this.parameters(), new StringBuffer(), null).toString();
            }
            catch (MissingResourceException missingResourceException) {
                return this.message;
            }
        }
        return this.message;
    }

    public boolean doIt() {
        boolean result = false;
        switch (this.resolutionCode) {
            case 0: {
                this.problem.remove();
                result = true;
                break;
            }
            case 4: {
                this.problem.restore();
                result = false;
                break;
            }
            case 5: {
                this.problem.replaceText(this.problem.problemType == ReconcileConstants.ProblemType.REMOVED ? this.problem.oldModifiedText : this.problem.oldModifiedFragmentText, ReconcileConstants.CurrentText.MODIFIED);
                result = false;
                break;
            }
            case 9: {
                this.problem.replaceText(this.problem.oldModifiedFragmentText, ReconcileConstants.CurrentText.MODIFIED_ONLY);
                result = false;
                break;
            }
            case 6: {
                this.problem.replaceText(this.problem.problemType == ReconcileConstants.ProblemType.REMOVED ? "" : this.problem.newGeneratedText, ReconcileConstants.CurrentText.GENERATED);
                result = false;
                break;
            }
            case 1: {
                String text = "";
                text = this.problem.problemType == ReconcileConstants.ProblemType.CONFLICT ? String.valueOf(text) + this.problem.oldModifiedFragmentText : String.valueOf(text) + this.problem.oldModifiedText;
                this.problem.replaceText(text, ReconcileConstants.CurrentText.MODIFIED);
                result = false;
                break;
            }
            case 2: {
                this.problem.replaceText(this.problem.newGeneratedText, ReconcileConstants.CurrentText.GENERATED);
                result = false;
                break;
            }
            case 3: {
                this.problem.replaceText(this.problem.oldGeneratedFramentText, ReconcileConstants.CurrentText.OLD_GENERATED);
                result = false;
                break;
            }
            case 7: {
                String text = "";
                text = this.problem.problemType == ReconcileConstants.ProblemType.CONFLICT ? String.valueOf(text) + this.problem.oldModifiedFragmentText : String.valueOf(text) + this.problem.oldModifiedText;
                text = String.valueOf(text) + this.problem.newGeneratedText.toString();
                this.problem.replaceText(text, ReconcileConstants.CurrentText.MODIFIED_GENERATED);
                result = false;
                break;
            }
            case 8: {
                String text = this.problem.newGeneratedText.toString();
                text = this.problem.problemType == ReconcileConstants.ProblemType.CONFLICT ? String.valueOf(text) + this.problem.oldModifiedFragmentText : String.valueOf(text) + this.problem.oldModifiedText;
                this.problem.replaceText(text, ReconcileConstants.CurrentText.GENERATED_MODIFIED);
                result = false;
            }
        }
        return result;
    }
}

