/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.icu.text.MessageFormat;
import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.ITextChangeEvent;
import com.ibm.pdp.engine.ITextChangeListener;
import com.ibm.pdp.engine.extension.IReconcileLocation;
import com.ibm.pdp.engine.extension.IReconcileLocationInterval;
import com.ibm.pdp.engine.internal.ITextProcessor;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.BasicTextPartition;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Dictionary;
import com.ibm.pdp.engine.turbo.core.HierarchicSegment;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.reconcile.IReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileConstants;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileMessages;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileQuickFixAction;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileUtil;
import com.ibm.pdp.engine.turbo.reconcile.ReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.TextReconciler;
import com.ibm.pdp.engine.turbo.reconcile.TextReconcilerCursor;
import com.ibm.pdp.engine.turbo.serialize.SerializationTool;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ReconcileProblem
implements IProblem,
ReconcileConstants,
ITextChangeListener {
    ReconcileConstants.ProblemType problemType;
    private String code;
    private String[] parameters;
    private ReconcileConstants.Severity severity;
    private ReconcileConstants.CurrentText currentTextOrigin = ReconcileConstants.CurrentText.MODIFIED;
    private ReconcileLocation startLocation;
    private ReconcileLocation endLocation;
    private List<ReconcileLocation> alternatesLocations = new ArrayList<ReconcileLocation>();
    private List<ReconcileLocation> modifiedLocations = new ArrayList<ReconcileLocation>();
    private CharSequence removedTagName;
    private String id;
    CharSequence oldModifiedFragmentText;
    CharSequence oldGeneratedFramentText;
    CharSequence newGeneratedText;
    CharSequence oldModifiedText;
    private CharSequence oldGeneratedText;
    private List<IProblem.IQuickFixAction> reconcileQuickFixActions = new ArrayList<IProblem.IQuickFixAction>();
    private IReconcilerState reconcilerState;
    private Segment newStartSegment;
    private Segment newEndSegment;
    private boolean isReversible = false;
    private StringBuilder reverseMergedText = null;
    private boolean isInResolution = false;
    private CharSequence nlsExtensionMessage;
    private String extensionCode;
    private boolean hasOnlyRemoveQuickFix;
    private int indexInSegment = Integer.MIN_VALUE;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ReconcileProblem(IReconcilerState reconcilerState) {
        this.reconcilerState = reconcilerState;
    }

    public ReconcileProblem(IReconcilerState reconcilerState, CharSequence oldGeneratedText, CharSequence oldModifiedText, CharSequence newGeneratedText, CharSequence oldGeneratedFramentText, CharSequence oldModifiedFragmentText, IReconcileLocation startLocation, IReconcileLocation endLocation, List<IReconcileLocationInterval> alternatesLocations, List<IReconcileLocation> modifiedLocations, ReconcileConstants.ProblemType problemType, ReconcileConstants.Severity severity, CharSequence removedTagName) {
        this(reconcilerState, oldGeneratedText, oldModifiedText, newGeneratedText, oldGeneratedFramentText, oldModifiedFragmentText, startLocation, endLocation, alternatesLocations, modifiedLocations, problemType, severity, removedTagName, null, null, false);
    }

    public ReconcileProblem(IReconcilerState reconcilerState, CharSequence oldGeneratedText, CharSequence oldModifiedText, CharSequence newGeneratedText, CharSequence oldGeneratedFramentText, CharSequence oldModifiedFragmentText, IReconcileLocation startLocation, IReconcileLocation endLocation, List<IReconcileLocationInterval> alternatesLocations, List<IReconcileLocation> modifiedLocations, ReconcileConstants.ProblemType problemType, ReconcileConstants.Severity severity, CharSequence removedTagName, String nlsExtensionMessage, String extensionCode, boolean hasOnlyRemoveQuickFix) {
        this.oldModifiedFragmentText = oldModifiedFragmentText;
        this.oldGeneratedFramentText = oldGeneratedFramentText;
        this.newGeneratedText = newGeneratedText;
        this.oldModifiedText = oldModifiedText;
        this.oldGeneratedText = oldGeneratedText;
        this.severity = severity;
        this.problemType = problemType;
        this.removedTagName = removedTagName;
        this.nlsExtensionMessage = nlsExtensionMessage;
        this.extensionCode = extensionCode;
        this.hasOnlyRemoveQuickFix = hasOnlyRemoveQuickFix;
        switch (problemType) {
            case CONFLICT: {
                this.code = "KEY_1003";
                break;
            }
            case CHOICE: {
                this.code = "KEY_1002";
                break;
            }
            case REMOVED: {
                this.code = "KEY_1001";
                break;
            }
            case EXTENSION: {
                this.code = "KEY_1005";
                break;
            }
        }
        if (startLocation != null) {
            this.startLocation = new ReconcileLocation();
            this.startLocation.enclosingTagName = startLocation.enclosingTagName();
            this.startLocation.fromTagName = startLocation.fromTagName();
            this.startLocation.toTagName = startLocation.toTagName();
        }
        if (endLocation != null) {
            this.endLocation = new ReconcileLocation();
            this.endLocation.enclosingTagName = endLocation.enclosingTagName();
            this.endLocation.fromTagName = endLocation.fromTagName();
            this.endLocation.toTagName = endLocation.toTagName();
        }
        if (alternatesLocations != null) {
            for (IReconcileLocationInterval reconcileLocationArea : alternatesLocations) {
                IReconcileLocation reconcileLocation = reconcileLocationArea.getStartReconcileLocation();
                ReconcileLocation alternateLocation = new ReconcileLocation();
                alternateLocation.enclosingTagName = reconcileLocation.enclosingTagName();
                alternateLocation.fromTagName = reconcileLocation.fromTagName();
                alternateLocation.toTagName = reconcileLocation.toTagName();
                this.alternatesLocations.add(alternateLocation);
            }
        }
        if (modifiedLocations != null) {
            for (IReconcileLocation reconcileLocation : modifiedLocations) {
                ReconcileLocation modifiedLocation = new ReconcileLocation();
                modifiedLocation.enclosingTagName = reconcileLocation.enclosingTagName();
                modifiedLocation.fromTagName = reconcileLocation.fromTagName();
                modifiedLocation.toTagName = reconcileLocation.toTagName();
                Segment oldSegment = ReconcileUtil.getSegmentFromReconcileLocation(((com.ibm.pdp.engine.turbo.reconcile.ReconcileLocation)reconcileLocation).changeSet(), modifiedLocation);
                if (oldSegment != null) {
                    modifiedLocation.text = oldSegment.getText();
                    modifiedLocation.generatedText = oldSegment.generatedText();
                    if (problemType == ReconcileConstants.ProblemType.REMOVED) {
                        String tmp = "";
                        try {
                            ITextNode node = oldSegment.getChangeSet().getTextProcessor().getEditTree().includingNode(oldSegment.beginIndex(), oldSegment.endIndex());
                            if (node.nbOfSons() == 0) {
                                tmp = String.valueOf(tmp) + node.text().toString();
                            } else {
                                Iterator iterator = node.sons();
                                while (iterator.hasNext()) {
                                    ITextNode son = (ITextNode)iterator.next();
                                    if (son.isGeneratedTag() || son.beginIndex() < oldSegment.beginIndex() || son.endIndex() > oldSegment.endIndex()) continue;
                                    tmp = String.valueOf(tmp) + son.text().toString();
                                }
                            }
                            this.oldModifiedFragmentText = tmp;
                        }
                        catch (Exception exception) {
                            this.oldModifiedFragmentText = "";
                        }
                    }
                }
                this.modifiedLocations.add(modifiedLocation);
            }
        }
        this.setReconcilerState(reconcilerState);
        if (problemType == ReconcileConstants.ProblemType.REMOVED) {
            this.currentTextOrigin = ReconcileConstants.CurrentText.GENERATED;
        }
        this.id = Long.toString(System.currentTimeMillis());
    }

    public Iterator<IProblem.IQuickFixAction> actions() {
        return this.reconcileQuickFixActions.iterator();
    }

    public String code() {
        return this.code;
    }

    public boolean isError() {
        return this.severity == ReconcileConstants.Severity.ERROR;
    }

    public boolean isWarning() {
        return this.severity == ReconcileConstants.Severity.WARNING;
    }

    public String message() {
        return this.nlsMessage().toString();
    }

    public String[] parameters() {
        return this.parameters;
    }

    public void remove() {
        this.removeTextChangeListener();
        ((ReconcilerState)this.reconcilerState).problems.remove(this);
    }

    public int length() {
        return this.newStartSegment.getChangeSet().textPartition().getTextLength();
    }

    public int beginIndex() {
        if (this.newStartSegment == null) {
            return 0;
        }
        if (this.problemType == ReconcileConstants.ProblemType.REMOVED) {
            if (this.currentTextOrigin == ReconcileConstants.CurrentText.MODIFIED || this.currentTextOrigin == ReconcileConstants.CurrentText.MODIFIED_ONLY) {
                int index = this.findTextIndexInSegment();
                if (index != -1) {
                    return index;
                }
                return 0;
            }
            return this.newStartSegment.beginIndex();
        }
        int index = this.findTextIndexInSegment();
        if (index == -1) {
            if (this.problemType == ReconcileConstants.ProblemType.EXTENSION && this.newStartSegment instanceof HierarchicSegment) {
                boolean isFirstTag = true;
                Segment[] segmentArray = ((HierarchicSegment)this.newEndSegment).sons();
                int n = segmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Segment son = segmentArray[n2];
                    if (son.isTagged()) {
                        if (isFirstTag) {
                            isFirstTag = false;
                        } else {
                            return son.beginIndex();
                        }
                    }
                    ++n2;
                }
            }
            return this.newStartSegment.beginIndex();
        }
        return index;
    }

    public int endIndex() {
        if (this.problemType == ReconcileConstants.ProblemType.REMOVED) {
            if (this.currentTextOrigin == ReconcileConstants.CurrentText.MODIFIED || this.currentTextOrigin == ReconcileConstants.CurrentText.MODIFIED_ONLY) {
                int index = this.findTextIndexInSegment();
                if (index != -1) {
                    return index + (this.currentTextOrigin == ReconcileConstants.CurrentText.MODIFIED ? this.oldModifiedText.length() : this.oldModifiedFragmentText.length());
                }
                return 0;
            }
            return this.newEndSegment == null ? (this.newStartSegment == null ? 0 : this.newStartSegment.beginIndex()) : this.newEndSegment.beginIndex();
        }
        if (this.problemType != ReconcileConstants.ProblemType.CHOICE) {
            CharSequence text = this.getCurrentTextFragment();
            return this.beginIndex() + (text == null ? 0 : text.length());
        }
        return this.newEndSegment == null ? (this.newStartSegment == null ? 0 : this.newStartSegment.endIndex()) : this.newEndSegment.endIndex();
    }

    public ReconcileConstants.ProblemType getProblemType() {
        return this.problemType;
    }

    public CharSequence getRemovedTagName() {
        return this.removedTagName;
    }

    public CharSequence getNewGeneratedText() {
        return this.newGeneratedText;
    }

    public CharSequence getOldModifiedText() {
        return this.oldModifiedText;
    }

    public CharSequence getOldGeneratedText() {
        return this.oldGeneratedText;
    }

    public CharSequence getEnclosingTagName() {
        return this.newStartSegment != null && this.newStartSegment == this.newEndSegment ? this.newStartSegment.enclosingTagName() : null;
    }

    public void write(XMLStreamWriter xmlWriter) {
        try {
            xmlWriter.writeStartElement("Problem");
            if (this.code != null) {
                xmlWriter.writeAttribute("code", this.code);
            }
            xmlWriter.writeAttribute("severity", this.severity.name());
            xmlWriter.writeAttribute("problemType", this.problemType.name());
            xmlWriter.writeAttribute("currentText", this.currentTextOrigin.name());
            xmlWriter.writeAttribute("Id", this.id);
            if (this.removedTagName != null) {
                xmlWriter.writeAttribute("removedTagName", this.removedTagName.toString());
            }
            if (this.startLocation != null) {
                ReconcileUtil.writeLocation(xmlWriter, "StartLocation", this.startLocation);
            }
            if (this.endLocation != null) {
                ReconcileUtil.writeLocation(xmlWriter, "EndLocation", this.endLocation);
            }
            if (!this.alternatesLocations.isEmpty()) {
                for (ReconcileLocation alternate : this.alternatesLocations) {
                    ReconcileUtil.writeLocation(xmlWriter, "AlternateLocation", alternate);
                }
            }
            if (!this.modifiedLocations.isEmpty()) {
                for (ReconcileLocation modifed : this.modifiedLocations) {
                    ReconcileUtil.writeLocation(xmlWriter, "ModifiedLocation", modifed);
                }
            }
            if (this.parameters != null) {
                xmlWriter.writeStartElement("Parameters");
                String[] stringArray = this.parameters;
                int n = this.parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameter = stringArray[n2];
                    xmlWriter.writeStartElement("Parameter");
                    xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)parameter));
                    xmlWriter.writeEndElement();
                    ++n2;
                }
                xmlWriter.writeEndElement();
            }
            if (this.oldModifiedFragmentText != null) {
                xmlWriter.writeStartElement("OldModifiedFragmentText");
                xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)this.oldModifiedFragmentText));
                xmlWriter.writeEndElement();
            }
            if (this.oldModifiedText != null) {
                xmlWriter.writeStartElement("OldModifiedText");
                xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)this.oldModifiedText));
                xmlWriter.writeEndElement();
            }
            if (this.newGeneratedText != null) {
                xmlWriter.writeStartElement("NewGeneratedText");
                xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)this.newGeneratedText));
                xmlWriter.writeEndElement();
            }
            if (this.oldGeneratedFramentText != null) {
                xmlWriter.writeStartElement("OldGeneratedFramentText");
                xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)this.oldGeneratedFramentText));
                xmlWriter.writeEndElement();
            }
            if (this.oldGeneratedText != null) {
                xmlWriter.writeStartElement("OldGeneratedText");
                xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)this.oldGeneratedText));
                xmlWriter.writeEndElement();
            }
            if (this.nlsExtensionMessage != null) {
                xmlWriter.writeStartElement("nlsExtMessage");
                xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)this.nlsExtensionMessage));
                xmlWriter.writeEndElement();
            }
            if (this.extensionCode != null) {
                xmlWriter.writeStartElement("extCode");
                xmlWriter.writeCharacters(SerializationTool.encode((CharSequence)this.extensionCode));
                xmlWriter.writeEndElement();
            }
            if (this.hasOnlyRemoveQuickFix) {
                xmlWriter.writeStartElement("hasOnlyRemoveQuickFix");
                xmlWriter.writeCharacters("true");
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    public void read(XMLStreamReader xmlReader) {
        boolean finished = false;
        try {
            Properties properties = ReconcileUtil.getAttributes(xmlReader);
            this.code = properties.getProperty("code");
            this.removedTagName = properties.getProperty("removedTagName");
            this.severity = ReconcileConstants.Severity.valueOf(properties.getProperty("severity"));
            this.problemType = ReconcileConstants.ProblemType.valueOf(properties.getProperty("problemType"));
            this.currentTextOrigin = ReconcileConstants.CurrentText.valueOf(properties.getProperty("currentText"));
            this.id = properties.getProperty("Id");
            while (xmlReader.hasNext() && !finished) {
                String qname;
                int eventType = xmlReader.next();
                if (eventType == 1) {
                    ReconcileLocation location;
                    String localName = xmlReader.getLocalName();
                    if (localName.equalsIgnoreCase("Parameters")) {
                        this.parameters = ReconcileUtil.readParameters(xmlReader);
                        continue;
                    }
                    if (localName.equalsIgnoreCase("OldModifiedText")) {
                        this.oldModifiedText = SerializationTool.decode((String)xmlReader.getElementText());
                        continue;
                    }
                    if (localName.equalsIgnoreCase("OldModifiedFragmentText")) {
                        this.oldModifiedFragmentText = SerializationTool.decode((String)xmlReader.getElementText());
                        continue;
                    }
                    if (localName.equalsIgnoreCase("NewGeneratedText")) {
                        this.newGeneratedText = SerializationTool.decode((String)xmlReader.getElementText());
                        continue;
                    }
                    if (localName.equalsIgnoreCase("OldGeneratedText")) {
                        this.oldGeneratedText = SerializationTool.decode((String)xmlReader.getElementText());
                        continue;
                    }
                    if (localName.equalsIgnoreCase("OldGeneratedFramentText")) {
                        this.oldGeneratedFramentText = SerializationTool.decode((String)xmlReader.getElementText());
                        continue;
                    }
                    if (localName.equalsIgnoreCase("nlsExtMessage")) {
                        this.nlsExtensionMessage = SerializationTool.decode((String)xmlReader.getElementText());
                        continue;
                    }
                    if (localName.equalsIgnoreCase("extCode")) {
                        this.extensionCode = SerializationTool.decode((String)xmlReader.getElementText());
                        continue;
                    }
                    if (localName.equalsIgnoreCase("hasOnlyRemoveQuickFix")) {
                        this.hasOnlyRemoveQuickFix = "true".equals(xmlReader.getElementText());
                        continue;
                    }
                    if (localName.equalsIgnoreCase("AlternateLocation")) {
                        location = new ReconcileLocation();
                        ReconcileUtil.readLocation(xmlReader, "AlternateLocation", location);
                        this.alternatesLocations.add(location);
                        continue;
                    }
                    if (localName.equalsIgnoreCase("ModifiedLocation")) {
                        location = new ReconcileLocation();
                        ReconcileUtil.readLocation(xmlReader, "ModifiedLocation", location);
                        this.modifiedLocations.add(location);
                        continue;
                    }
                    if (localName.equalsIgnoreCase("StartLocation")) {
                        this.startLocation = new ReconcileLocation();
                        ReconcileUtil.readLocation(xmlReader, "StartLocation", this.startLocation);
                        continue;
                    }
                    if (!localName.equalsIgnoreCase("EndLocation")) continue;
                    this.endLocation = new ReconcileLocation();
                    ReconcileUtil.readLocation(xmlReader, "EndLocation", this.endLocation);
                    continue;
                }
                if (eventType != 2 || !(qname = xmlReader.getName().getLocalPart()).equalsIgnoreCase("Problem")) continue;
                finished = true;
            }
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
    }

    public CharSequence fullText() {
        switch (this.currentTextOrigin) {
            case GENERATED: {
                return this.newGeneratedText;
            }
            case MODIFIED: {
                return this.oldModifiedFragmentText;
            }
            case OLD_GENERATED: {
                return this.oldGeneratedFramentText;
            }
        }
        return null;
    }

    public IProblem.IQuickFixAction actionAtIndex(int index) {
        return this.reconcileQuickFixActions.get(index);
    }

    public void setReconcilerState(IReconcilerState reconcilerState) {
        this.removeTextChangeListener();
        this.reconcilerState = reconcilerState;
        this.newStartSegment = ReconcileUtil.getSegmentFromReconcileLocation(reconcilerState.getChangeSet(), this.startLocation);
        this.newEndSegment = ReconcileUtil.getSegmentFromReconcileLocation(reconcilerState.getChangeSet(), this.endLocation);
        if (this.newEndSegment != null && this.newStartSegment != null && this.newEndSegment.beginIndex() < this.newStartSegment.beginIndex()) {
            this.newEndSegment = this.newStartSegment;
        }
        this.addTextChangeListener();
    }

    private void addTextChangeListener() {
        ITextProcessor textProcessor = this.getTextProcessor();
        if (textProcessor != null) {
            textProcessor.addTextChangeListener((ITextChangeListener)this);
        }
    }

    private void removeTextChangeListener() {
        ITextProcessor textProcessor = this.getTextProcessor();
        if (textProcessor != null) {
            textProcessor.removeTextChangeListener((ITextChangeListener)this);
        }
    }

    private ITextProcessor getTextProcessor() {
        if (this.reconcilerState != null && this.reconcilerState.getChangeSet() != null && this.reconcilerState.getChangeSet().getTextProcessor() != null) {
            return this.reconcilerState.getChangeSet().getTextProcessor();
        }
        return null;
    }

    public void textChanged(ITextChangeEvent event) {
        this.indexInSegment = Integer.MIN_VALUE;
    }

    public void refresh() {
        Iterator iterator;
        ReconcileQuickFixAction quickFix;
        if (this.reconcilerState != null) {
            this.setReconcilerState(this.reconcilerState);
        }
        this.reconcileQuickFixActions.clear();
        if (this.problemType == ReconcileConstants.ProblemType.EXTENSION) {
            quickFix = null;
            quickFix = new ReconcileQuickFixAction(0);
            quickFix.code = "KEY_2000";
            this.addIQuickFixAction(quickFix);
            if (!this.hasOnlyRemoveQuickFix) {
                if (this.currentTextOrigin != ReconcileConstants.CurrentText.MODIFIED) {
                    quickFix = new ReconcileQuickFixAction(1);
                    quickFix.code = "KEY_2004";
                    this.addIQuickFixAction(quickFix);
                }
                if (this.currentTextOrigin != ReconcileConstants.CurrentText.GENERATED) {
                    quickFix = new ReconcileQuickFixAction(2);
                    quickFix.code = "KEY_2005";
                    this.addIQuickFixAction(quickFix);
                }
            }
        } else if (!this.isSameContents() && !this.isInResolution) {
            quickFix = null;
            quickFix = new ReconcileQuickFixAction(0);
            quickFix.code = "KEY_2000";
            this.addIQuickFixAction(quickFix);
            if (this.problemType != ReconcileConstants.ProblemType.REMOVED) {
                quickFix = new ReconcileQuickFixAction(4);
                quickFix.code = "KEY_2001";
                this.addIQuickFixAction(quickFix);
            }
        } else if (this.problemType == ReconcileConstants.ProblemType.REMOVED) {
            quickFix = null;
            quickFix = new ReconcileQuickFixAction(0);
            quickFix.code = "KEY_2000";
            this.addIQuickFixAction(quickFix);
            if (this.currentTextOrigin == ReconcileConstants.CurrentText.GENERATED) {
                quickFix = new ReconcileQuickFixAction(5);
                quickFix.code = "KEY_2002";
                this.addIQuickFixAction(quickFix);
                quickFix = new ReconcileQuickFixAction(9);
                quickFix.code = "KEY_2009";
                this.addIQuickFixAction(quickFix);
            } else {
                quickFix = new ReconcileQuickFixAction(6);
                quickFix.code = "KEY_2003";
                this.addIQuickFixAction(quickFix);
            }
        } else if (this.problemType == ReconcileConstants.ProblemType.CONFLICT) {
            this.code = "KEY_1000";
            quickFix = null;
            quickFix = new ReconcileQuickFixAction(0);
            quickFix.code = "KEY_2000";
            this.addIQuickFixAction(quickFix);
            if (this.currentTextOrigin != ReconcileConstants.CurrentText.OLD_GENERATED) {
                quickFix = new ReconcileQuickFixAction(3);
                quickFix.code = "KEY_2006";
                this.addIQuickFixAction(quickFix);
            }
            if (this.currentTextOrigin != ReconcileConstants.CurrentText.MODIFIED) {
                quickFix = new ReconcileQuickFixAction(1);
                quickFix.code = "KEY_2004";
                this.addIQuickFixAction(quickFix);
            } else {
                this.code = "KEY_1003";
            }
            if (this.currentTextOrigin != ReconcileConstants.CurrentText.GENERATED) {
                quickFix = new ReconcileQuickFixAction(2);
                quickFix.code = "KEY_2005";
                this.addIQuickFixAction(quickFix);
            }
            if (this.currentTextOrigin != ReconcileConstants.CurrentText.MODIFIED_GENERATED) {
                quickFix = new ReconcileQuickFixAction(7);
                quickFix.code = "KEY_2007";
                this.addIQuickFixAction(quickFix);
            }
            if (this.currentTextOrigin != ReconcileConstants.CurrentText.GENERATED_MODIFIED) {
                quickFix = new ReconcileQuickFixAction(8);
                quickFix.code = "KEY_2008";
                this.addIQuickFixAction(quickFix);
            }
        } else if (this.problemType == ReconcileConstants.ProblemType.CHOICE) {
            quickFix = null;
            quickFix = new ReconcileQuickFixAction(0);
            quickFix.code = "KEY_2000";
            this.addIQuickFixAction(quickFix);
            if (this.currentTextOrigin != ReconcileConstants.CurrentText.MODIFIED) {
                quickFix = new ReconcileQuickFixAction(1);
                quickFix.code = "KEY_2004";
                this.addIQuickFixAction(quickFix);
            }
            if (this.currentTextOrigin != ReconcileConstants.CurrentText.GENERATED) {
                quickFix = new ReconcileQuickFixAction(2);
                quickFix.code = "KEY_2005";
                this.addIQuickFixAction(quickFix);
            }
        }
        if (this.reconcilerState.getChangeSet() != null && this.reconcilerState.getChangeSet().getTextProcessor() != null && this.reconcilerState.getChangeSet().getTextProcessor().getReconcileExtension() != null && (iterator = this.reconcilerState.getChangeSet().getTextProcessor().getReconcileExtension().actions((IProblem)this)) != null) {
            while (iterator.hasNext()) {
                this.reconcileQuickFixActions.add((IProblem.IQuickFixAction)iterator.next());
            }
        }
    }

    public boolean isReversible() {
        return this.isReversible;
    }

    public void checkReversibility(UserChangeSet newChangeSet) {
        ITextPartition textPartition;
        CharSequence newGenText = null;
        CharSequence oldGenText = null;
        CharSequence oldModText = null;
        if (this.problemType == ReconcileConstants.ProblemType.EXTENSION || this.problemType == ReconcileConstants.ProblemType.CHOICE) {
            this.isReversible = false;
            return;
        }
        if (this.problemType == ReconcileConstants.ProblemType.REMOVED) {
            ReconcileLocation location = this.modifiedLocations.get(0);
            Segment newSegment = ReconcileUtil.getSegmentFromReconcileLocation(newChangeSet, location);
            if (newSegment == null) {
                this.isReversible = false;
                return;
            }
            textPartition = newChangeSet.textPartition();
            newGenText = textPartition.getTextInterval(newSegment.beginIndex(), newSegment.endIndex());
            oldGenText = location.generatedText;
            oldModText = location.text;
        } else if (this.problemType == ReconcileConstants.ProblemType.CONFLICT || this.problemType == ReconcileConstants.ProblemType.CHOICE) {
            Segment newStartSegment;
            int beginIdx = -1;
            int endIdx = -1;
            oldGenText = this.oldGeneratedText == null ? "" : this.oldGeneratedText;
            oldModText = this.oldModifiedText;
            textPartition = newChangeSet.textPartition();
            if (this.problemType == ReconcileConstants.ProblemType.CONFLICT) {
                newStartSegment = ReconcileUtil.getSegmentFromReconcileLocation(newChangeSet, this.startLocation);
                if (newStartSegment == null) {
                    this.isReversible = false;
                    return;
                }
                newGenText = textPartition.getTextInterval(newStartSegment.beginIndex(), newStartSegment.endIndex());
            } else {
                newStartSegment = ReconcileUtil.getSegmentFromReconcileLocation(newChangeSet, this.startLocation);
                if (newStartSegment == null) {
                    this.isReversible = false;
                    return;
                }
                Segment newEndSegment = ReconcileUtil.getSegmentFromReconcileLocation(newChangeSet, this.startLocation);
                beginIdx = newStartSegment.beginIndex();
                int n = endIdx = newEndSegment == null ? 0 : newEndSegment.endIndex();
                if (textPartition.getTextLength() < endIdx && beginIdx > (endIdx = textPartition.getTextLength())) {
                    beginIdx = endIdx;
                }
                newGenText = textPartition.getTextInterval(beginIdx, endIdx);
            }
        }
        Dictionary dictionary = new Dictionary();
        BasicTextPartition oldGen = new BasicTextPartition(dictionary, newChangeSet.getTextProcessor().newTextPartitioner());
        oldGen.setText(oldGenText);
        BasicTextPartition oldMod = new BasicTextPartition(dictionary, newChangeSet.getTextProcessor().newTextPartitioner());
        oldMod.setText(oldModText);
        BasicTextPartition newGen = new BasicTextPartition(dictionary, newChangeSet.getTextProcessor().newTextPartitioner());
        newGen.setText(newGenText);
        if (oldGenText == null || oldModText == null || newGenText == null) {
            this.isReversible = false;
            return;
        }
        TextReconciler tr = new TextReconciler(oldGen, oldMod, newGen);
        TextReconcilerCursor trc = tr.getCursor();
        this.reverseMergedText = new StringBuilder();
        while (trc.searchNextSegment()) {
            this.reverseMergedText.append(trc.getText());
        }
        if (this.reverseMergedText.toString().equals(this.problemType == ReconcileConstants.ProblemType.CONFLICT ? this.oldModifiedFragmentText : oldModText)) {
            this.isReversible = true;
            if (tr.problems != null && !tr.problems.isEmpty()) {
                this.isReversible = this.problemType == ReconcileConstants.ProblemType.CONFLICT || this.reverseMergedText.length() == 0;
            }
        } else {
            this.isReversible = tr.problems == null || tr.problems.isEmpty();
        }
    }

    public boolean reverse() {
        int beginIdx = 0;
        int endIdx = 0;
        if (this.problemType == ReconcileConstants.ProblemType.REMOVED) {
            Segment newSegment = ReconcileUtil.getSegmentFromReconcileLocation(this.reconcilerState.getChangeSet(), this.modifiedLocations.get(0));
            boolean hasNext = this.reconcilerState.problems(newSegment.beginIndex(), newSegment.endIndex()).hasNext();
            if (!hasNext) {
                newSegment.setText(this.reverseMergedText);
                return true;
            }
            IProblem problem = this.reconcilerState.problems(newSegment.beginIndex(), newSegment.endIndex()).next();
            if (problem.beginIndex() == problem.endIndex() && problem.beginIndex() == newSegment.endIndex()) {
                newSegment.setText(this.reverseMergedText);
                return true;
            }
        } else {
            beginIdx = this.beginIndex();
            endIdx = this.endIndex();
            if (endIdx > this.reconcilerState.getChangeSet().length()) {
                endIdx = this.reconcilerState.getChangeSet().length();
            }
            if (endIdx < beginIdx) {
                beginIdx = endIdx;
            }
            CharSequence newText = this.newStartSegment.generatedText();
            if (this.problemType == ReconcileConstants.ProblemType.CONFLICT && this.newStartSegment.getChangeNature() != ChangeNature.Unchanged) {
                return false;
            }
            if (newText.equals(this.oldGeneratedText)) {
                if (endIdx > this.newStartSegment.endIndex()) {
                    this.reconcilerState.getChangeSet().replaceText(this.newStartSegment.endIndex(), endIdx, "");
                }
                this.newStartSegment.setText(this.reverseMergedText);
                return true;
            }
        }
        return false;
    }

    protected void replaceText(CharSequence text, ReconcileConstants.CurrentText currentText) {
        this.isInResolution = true;
        UserChangeSet changeSet = this.reconcilerState.getChangeSet();
        int beginIndex = this.beginIndex();
        int endIndex = this.endIndex();
        this.currentTextOrigin = currentText;
        changeSet.replaceText(beginIndex, endIndex, text);
        this.refresh();
        this.isInResolution = false;
    }

    protected void restore() {
        this.reconcilerState.getChangeSet().replaceText(this.newStartSegment.beginIndex(), this.newStartSegment.endIndex(), this.oldModifiedText);
    }

    private void addIQuickFixAction(IProblem.IQuickFixAction action) {
        ((ReconcileQuickFixAction)action).problem = this;
        this.reconcileQuickFixActions.add(action);
    }

    private boolean isSameContents() {
        if (this.problemType == ReconcileConstants.ProblemType.CHOICE || this.problemType == ReconcileConstants.ProblemType.EXTENSION || this.problemType == ReconcileConstants.ProblemType.REMOVED && this.currentTextOrigin != ReconcileConstants.CurrentText.MODIFIED) {
            return true;
        }
        int index = this.findTextIndexInSegment();
        return index != -1;
    }

    private CharSequence nlsMessage() {
        String msg = null;
        if ("KEY_1005".equals(this.code)) {
            if (this.nlsExtensionMessage == null) {
                try {
                    msg = ReconcileMessages.getString("KEY_1005");
                    MessageFormat msgFormat = new MessageFormat(msg);
                    return msgFormat.format((Object[])this.parameters(), new StringBuffer(), null).toString();
                }
                catch (MissingResourceException missingResourceException) {
                    return this.code;
                }
            }
            return this.nlsExtensionMessage;
        }
        if (!this.isSameContents()) {
            try {
                msg = ReconcileMessages.getString("KEY_1004");
                MessageFormat msgFormat = new MessageFormat(msg);
                return msgFormat.format((Object[])this.parameters(), new StringBuffer(), null).toString();
            }
            catch (MissingResourceException missingResourceException) {
                return "KEY_1004";
            }
        }
        if (this.code != null) {
            try {
                msg = ReconcileMessages.getString(this.code);
                MessageFormat msgFormat = new MessageFormat(msg);
                return msgFormat.format((Object[])this.parameters(), new StringBuffer(), null).toString();
            }
            catch (MissingResourceException missingResourceException) {
                return this.code;
            }
        }
        return "ERROR";
    }

    private CharSequence getCurrentTextFragment() {
        CharSequence text = null;
        switch (this.currentTextOrigin) {
            case GENERATED: {
                text = this.newGeneratedText;
                break;
            }
            case GENERATED_MODIFIED: {
                if (this.newGeneratedText == null) {
                    text = this.oldModifiedFragmentText;
                    break;
                }
                if (this.oldModifiedFragmentText == null) {
                    text = this.newGeneratedText;
                    break;
                }
                text = String.valueOf(this.newGeneratedText.toString()) + this.oldModifiedFragmentText.toString();
                break;
            }
            case MODIFIED: {
                text = this.problemType == ReconcileConstants.ProblemType.REMOVED || this.problemType == ReconcileConstants.ProblemType.EXTENSION ? this.oldModifiedText : this.oldModifiedFragmentText;
                break;
            }
            case MODIFIED_ONLY: {
                text = this.oldModifiedFragmentText;
                break;
            }
            case MODIFIED_GENERATED: {
                if (this.oldModifiedFragmentText == null) {
                    text = this.oldModifiedText + (this.newGeneratedText == null ? "" : this.newGeneratedText.toString());
                    break;
                }
                text = String.valueOf(this.oldModifiedFragmentText.toString()) + this.newGeneratedText.toString();
                break;
            }
            case OLD_GENERATED: {
                text = this.oldGeneratedFramentText;
            }
        }
        return text;
    }

    private int findTextIndexInSegment() {
        if (this.indexInSegment != Integer.MIN_VALUE) {
            return this.indexInSegment;
        }
        CharSequence text = this.getCurrentTextFragment();
        int index = ReconcileUtil.findTextIndexInSegment(this.newStartSegment, text);
        if (index != -1) {
            this.indexInSegment = this.newStartSegment.beginIndex() + index;
            return this.indexInSegment;
        }
        if (this.problemType == ReconcileConstants.ProblemType.CONFLICT || this.problemType == ReconcileConstants.ProblemType.REMOVED || this.problemType == ReconcileConstants.ProblemType.EXTENSION) {
            if (this.newStartSegment == null) {
                this.indexInSegment = -1;
                return this.indexInSegment;
            }
            int cmpt = 0;
            for (Segment parent = this.newStartSegment.enclosingSegment(); parent != null; parent = parent.enclosingSegment()) {
                index = ReconcileUtil.findTextIndexInSegment(parent, text);
                if (index == -1) continue;
                this.indexInSegment = parent.beginIndex() + index;
                return this.indexInSegment;
            }
        }
        this.indexInSegment = index;
        return this.indexInSegment;
    }

    public String id() {
        return this.id;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append((Object)this.problemType);
        buffer.append(" reversible : " + this.isReversible);
        if (this.problemType == ReconcileConstants.ProblemType.CONFLICT || this.problemType == ReconcileConstants.ProblemType.REMOVED) {
            buffer.append("\nOld Generated :\n" + this.oldGeneratedText);
            buffer.append("Old Modified :\n" + this.oldModifiedText);
            buffer.append("New Generated :\n" + this.newGeneratedText);
        }
        return buffer.toString();
    }

    void duplicateFrom(ReconcileProblem problem) {
        this.code = problem.code;
        this.severity = problem.severity;
        this.problemType = problem.problemType;
        this.currentTextOrigin = problem.currentTextOrigin;
        this.id = problem.id;
        if (problem.removedTagName != null) {
            this.removedTagName = problem.removedTagName.toString();
        }
        if (problem.startLocation != null) {
            this.startLocation = new ReconcileLocation();
            this.startLocation.duplicateFrom(problem.startLocation);
        }
        if (problem.endLocation != null) {
            this.endLocation = new ReconcileLocation();
            this.endLocation.duplicateFrom(problem.endLocation);
        }
        if (problem.alternatesLocations != null && !problem.alternatesLocations.isEmpty()) {
            for (ReconcileLocation alternate : problem.alternatesLocations) {
                ReconcileLocation alternateLocation = new ReconcileLocation();
                alternateLocation.duplicateFrom(alternate);
                this.alternatesLocations.add(alternateLocation);
            }
        }
        if (problem.modifiedLocations != null && !problem.modifiedLocations.isEmpty()) {
            for (ReconcileLocation alternate : problem.modifiedLocations) {
                ReconcileLocation modifiedlocation = new ReconcileLocation();
                modifiedlocation.duplicateFrom(alternate);
                this.modifiedLocations.add(modifiedlocation);
            }
        }
        if (problem.parameters != null) {
            this.parameters = new String[problem.parameters.length];
            System.arraycopy(problem.parameters, 0, this.parameters, 0, problem.parameters.length - 1);
        }
        if (problem.oldModifiedFragmentText != null) {
            this.oldModifiedFragmentText = problem.oldModifiedFragmentText.toString();
        }
        if (problem.oldModifiedText != null) {
            this.oldModifiedText = problem.oldModifiedText.toString();
        }
        if (problem.newGeneratedText != null) {
            this.newGeneratedText = problem.newGeneratedText.toString();
        }
        if (problem.oldGeneratedFramentText != null) {
            this.oldGeneratedFramentText = problem.oldGeneratedFramentText.toString();
        }
        if (problem.oldGeneratedText != null) {
            this.oldGeneratedText = problem.oldGeneratedText.toString();
        }
        if (problem.nlsExtensionMessage != null) {
            this.nlsExtensionMessage = problem.nlsExtensionMessage.toString();
        }
        if (problem.extensionCode != null) {
            this.extensionCode = problem.extensionCode.toString();
        }
        this.hasOnlyRemoveQuickFix = problem.hasOnlyRemoveQuickFix;
    }

    public Segment getNewStartSegment() {
        return this.newStartSegment;
    }

    public Segment getNewEndSegement() {
        return this.newEndSegment;
    }

    protected static class ReconcileLocation {
        String enclosingTagName;
        String fromTagName;
        String toTagName;
        CharSequence generatedText;
        CharSequence text;

        protected ReconcileLocation() {
        }

        void duplicateFrom(ReconcileLocation location) {
            this.enclosingTagName = location.enclosingTagName;
            this.fromTagName = location.fromTagName;
            if (location.generatedText != null) {
                this.generatedText = location.generatedText.toString();
            }
            if (location.text != null) {
                this.text = location.text.toString();
            }
            this.toTagName = location.toTagName;
        }
    }
}

