/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.reconcile;

import com.ibm.pdp.engine.extension.IReconcileLocation;
import com.ibm.pdp.engine.extension.IReconcileLocationInterval;
import com.ibm.pdp.engine.extension.IReconcileTextInterval;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileLocation;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileTextInterval;
import java.util.ArrayList;
import java.util.List;

public class ReconcileLocationInterval
implements IReconcileLocationInterval {
    private IReconcileLocation endReconcileLocation;
    private IReconcileLocation startReconcileLocation;
    private List<IReconcileLocationInterval> alternatesReconcileLocation = new ArrayList<IReconcileLocationInterval>();
    private List<IReconcileTextInterval> reconcileAreas = new ArrayList<IReconcileTextInterval>();
    private List<IReconcileTextInterval> removedReconcileAreas = new ArrayList<IReconcileTextInterval>();
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void setStartEndSegments(Segment newStartSegment, Segment newStopSegment) {
        if (newStartSegment.beginIndex() > newStopSegment.beginIndex()) {
            throw new RuntimeException("Wrong area end segment must be before start segment!!!");
        }
        this.startReconcileLocation = new ReconcileLocation(newStartSegment.getChangeSet(), newStartSegment.enclosingTagName(), newStartSegment.fromTagName(), newStartSegment.toTagName());
        this.endReconcileLocation = new ReconcileLocation(newStopSegment.getChangeSet(), newStopSegment.enclosingTagName(), newStopSegment.fromTagName(), newStopSegment.toTagName());
    }

    public IReconcileLocation getEndReconcileLocation() {
        return this.endReconcileLocation;
    }

    public IReconcileLocation getStartReconcileLocation() {
        return this.startReconcileLocation;
    }

    public List<IReconcileTextInterval> getReconcileAreas() {
        return this.reconcileAreas;
    }

    public List<IReconcileTextInterval> getRemovedReconcileAreas() {
        return this.removedReconcileAreas;
    }

    public List<IReconcileLocationInterval> getAlternatesReconcileLocation() {
        return this.alternatesReconcileLocation;
    }

    public int length() {
        if (this.reconcileAreas == null || this.reconcileAreas.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (IReconcileTextInterval area : this.reconcileAreas) {
            result += area.getText() == null ? 0 : area.getText().length();
        }
        return result;
    }

    public void addReconcileArea(int startIndex, int stopIndex, int offset, boolean isApplicable, boolean isNewGeneratedText, UserChangeSet changeSet) {
        if (this.reconcileAreas.size() <= 0 || startIndex != stopIndex) {
            ReconcileTextInterval reconcileArea = new ReconcileTextInterval(isNewGeneratedText ? changeSet.generatedTextPartition() : changeSet.textPartition(), null, isApplicable, startIndex + offset, stopIndex + offset, isNewGeneratedText, null);
            this.reconcileAreas.add(reconcileArea);
            if (this.reconcileAreas.size() > 1 && "".equals(this.reconcileAreas.get(0).getText())) {
                this.reconcileAreas.remove(0);
            }
        }
    }

    public void addRemovedReconcileArea(Segment blockSegment, Segment removedSegment) {
        ReconcileTextInterval reconcileArea = new ReconcileTextInterval(blockSegment.getChangeSet().textPartition(), blockSegment.generatedText(), false, blockSegment.beginIndex(), blockSegment.endIndex(), false, blockSegment.enclosingTagName());
        this.removedReconcileAreas.add(reconcileArea);
        if (this.reconcileAreas.size() > 1 && "".equals(this.reconcileAreas.get(0).getText())) {
            this.reconcileAreas.remove(0);
        }
        reconcileArea.getModifiedReconcileLocations().add(new ReconcileLocation(removedSegment.getChangeSet(), removedSegment.enclosingTagName(), removedSegment.fromTagName(), removedSegment.toTagName()));
    }
}

