/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.properties;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.properties.ChangeControl;
import com.ibm.pdp.engine.turbo.properties.FreeFormatting;
import com.ibm.pdp.engine.turbo.properties.FreeSonsOrder;
import com.ibm.pdp.engine.turbo.properties.Hidden;
import com.ibm.pdp.engine.turbo.properties.IgnoreCase;
import com.ibm.pdp.engine.turbo.properties.PropertiesIgnoreCase;
import com.ibm.pdp.engine.turbo.properties.PropertyAttributes;
import com.ibm.pdp.engine.turbo.properties.ReconcileCoincidence;
import com.ibm.pdp.engine.turbo.properties.ReconcileCoincidenceDeletion;
import com.ibm.pdp.engine.turbo.properties.ReconcileCoincidenceInsertion;
import com.ibm.pdp.engine.turbo.properties.ReconcileConflict;
import com.ibm.pdp.engine.turbo.properties.ReconcileLostChange;
import com.ibm.pdp.engine.turbo.properties.ReconcileMode;
import com.ibm.pdp.engine.turbo.properties.ReconcilePriority;
import com.ibm.pdp.engine.turbo.properties.ShowAsUserCode;
import com.ibm.pdp.engine.turbo.properties.TagProperty;
import java.util.Iterator;

public class TagProperties
extends PropertiesIgnoreCase
implements ITagProperties {
    protected Segment segment;
    protected Object[] computedValues;
    protected String[] args;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TagProperties() {
    }

    public TagProperties(Segment s) {
        this.segment = s;
    }

    public TagProperties(Segment s, IGeneratedInfo generatedInfo) {
        this.segment = s;
        this.copyPropertiesFromGeneratedInfo(generatedInfo);
    }

    protected void copyPropertiesFromGeneratedInfo(IGeneratedInfo genInfo) {
        Iterator names = genInfo.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.setProperty(name, genInfo.getProperty(name));
        }
    }

    public TagProperties(Segment s, IGeneratedTag tag) {
        this.segment = s;
        this.copyPropertiesFromGeneratedTag(tag);
    }

    protected void copyPropertiesFromGeneratedTag(IGeneratedTag tag) {
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.setProperty(name, tag.getProperty(name));
        }
    }

    public TagProperties(Segment s, SyntacticTag tag) {
        this.segment = s;
        this.copyPropertiesFromSyntacticTag(tag);
    }

    protected void copyPropertiesFromSyntacticTag(SyntacticTag tag) {
        Iterator<String> names = tag.propertyNames();
        while (names.hasNext()) {
            String name = names.next();
            this.setProperty(name, tag.getProperty(name));
        }
    }

    public String getTagName() {
        return this.segment.enclosingTagName();
    }

    public String getTagType() {
        return (String)this.getProperty(TagProperty.Type);
    }

    public boolean isGeneratedTag() {
        return !this.segment.isSyntactic();
    }

    public boolean isSyntacticTag() {
        return this.segment.isSyntactic();
    }

    public ITagProperties getEnclosingTagProperties() {
        return this.getParentProperties();
    }

    public TagProperties getParentProperties() {
        if (this.segment.isTop()) {
            return null;
        }
        return this.segment.enclosingSegment().getTagProperties();
    }

    public boolean isHidden() {
        return this.getProperty(TagProperty.Hidden) == Hidden.Yes;
    }

    public boolean showAsUserCode() {
        return this.getProperty(TagProperty.ShowAsUserCode) == ShowAsUserCode.Yes;
    }

    public boolean isFreeFormatting() {
        return this.getProperty(TagProperty.FreeFormatting) == FreeFormatting.Yes;
    }

    public boolean isCaseSensitive() {
        return this.getProperty(TagProperty.IgnoreCase) == IgnoreCase.Yes;
    }

    public boolean isFreeSonsOrder() {
        return this.getProperty(TagProperty.FreeSonsOrder) == FreeSonsOrder.Yes;
    }

    public ChangeControl getChangeControl() {
        return (ChangeControl)((Object)this.getProperty(TagProperty.ChangeControl));
    }

    public ReconcileMode getReconcileMode() {
        return (ReconcileMode)((Object)this.getProperty(TagProperty.ReconcileMode));
    }

    public ReconcileConflict getReconcileConflict() {
        return (ReconcileConflict)((Object)this.getProperty(TagProperty.ReconcileConflict));
    }

    public ReconcilePriority getReconcilePriority() {
        return (ReconcilePriority)((Object)this.getProperty(TagProperty.ReconcilePriority));
    }

    public ReconcileLostChange getReconcileLostChange() {
        return (ReconcileLostChange)((Object)this.getProperty(TagProperty.ReconcileLostChange));
    }

    public ReconcileCoincidence getReconcileCoincidence() {
        return (ReconcileCoincidence)((Object)this.getProperty(TagProperty.ReconcileCoincidence));
    }

    public ReconcileCoincidenceDeletion getReconcileCoincidenceDeletion() {
        return (ReconcileCoincidenceDeletion)((Object)this.getProperty(TagProperty.ReconcileCoincidenceDeletion));
    }

    public ReconcileCoincidenceInsertion getReconcileCoincidenceInsertion() {
        return (ReconcileCoincidenceInsertion)((Object)this.getProperty(TagProperty.ReconcileCoincidenceInsertion));
    }

    public String[] getArgs() {
        if (this.args == null) {
            this.initArgs();
        }
        return this.args;
    }

    protected void initArgs() {
        int minOrdinal;
        int argCount = 0;
        TagProperty[] values = TagProperty.values();
        int ordinal = minOrdinal = TagProperty.Arg0.ordinal();
        while (values[ordinal].name().equals("Arg" + argCount)) {
            ++argCount;
            ++ordinal;
        }
        this.args = new String[argCount];
        if (this.computedValues != null) {
            int i = 0;
            while (i < argCount) {
                this.args[i] = (String)this.computedValues[minOrdinal + i];
                ++i;
            }
        }
    }

    protected void refreshArgs(TagProperty property, String value) {
        int argRank = property.ordinal() - TagProperty.Arg0.ordinal();
        if (argRank >= 0 && argRank < this.args.length) {
            this.args[argRank] = value;
        }
    }

    public Iterator<String> ownPropertyNames() {
        return super.propertyNames();
    }

    public String getOwnProperty(String name) {
        return super.getProperty(name);
    }

    public Object getOwnProperty(TagProperty property) {
        return this.computedValues != null ? this.computedValues[property.ordinal()] : null;
    }

    @Override
    public String getProperty(String name) {
        String value = super.getProperty(name);
        if (value != null) {
            return value;
        }
        TagProperty property = TagProperty.attributes().getValueOf(name);
        if (property == null) {
            return null;
        }
        Object objectValue = this.getProperty(property);
        return objectValue != null ? objectValue.toString() : null;
    }

    public Object getProperty(TagProperty property) {
        Object value;
        int ordinal = property.ordinal();
        Object object = value = this.computedValues != null ? this.computedValues[ordinal] : null;
        if (value != null) {
            return value;
        }
        PropertyAttributes<?> attributes = property.allowedValueAttributes();
        if (attributes == null) {
            return null;
        }
        if (attributes.isInheritable()) {
            value = this.getInheritedValue(ordinal);
        }
        return value != null ? value : attributes.getDefaultValue();
    }

    protected Object getInheritedValue(int propertyOrdinal) {
        TagProperties ancestor = this.getParentProperties();
        while (ancestor != null) {
            Object value;
            Object[] values = ancestor.computedValues;
            if (values != null && (value = values[propertyOrdinal]) != null) {
                return value;
            }
            ancestor = ancestor.getParentProperties();
        }
        return null;
    }

    @Override
    public void setProperty(String name, String value) {
        TagProperty property = TagProperty.attributes().getValueOf(name);
        if (property != null) {
            this.setProperty(property, (Object)value);
            return;
        }
        super.setProperty(name, value);
    }

    public void setProperty(TagProperty property, Object value) {
        String controledValue;
        String stringValue;
        if (value == null) {
            this.removeProperty(property);
            return;
        }
        PropertyAttributes<?> att = property.allowedValueAttributes();
        String string = stringValue = value instanceof String ? (String)value : null;
        Object object = att == null ? stringValue : (stringValue != null ? att.getValueOf(stringValue) : (controledValue = att.acceptValue(value) ? value : null));
        if (controledValue == null) {
            throw new RuntimeException("Property " + property.name() + " not assignable with " + value);
        }
        if (this.computedValues == null) {
            this.computedValues = new Object[TagProperty.values().length];
        }
        this.computedValues[property.ordinal()] = controledValue;
        if (this.args != null && stringValue != null) {
            this.refreshArgs(property, stringValue);
        }
        super.setProperty(property.name(), controledValue.toString());
    }

    public void removeProperty(String name) {
        TagProperty property = TagProperty.attributes().getValueOf(name);
        if (property != null) {
            this.removeProperty(property);
            return;
        }
        super.setProperty(name, null);
    }

    public void removeProperty(TagProperty property) {
        super.setProperty(property.name(), null);
        if (this.computedValues != null) {
            this.computedValues[property.ordinal()] = null;
        }
        if (this.args != null) {
            this.refreshArgs(property, null);
        }
    }
}

