/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.properties;

import com.ibm.pdp.util.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Properties {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String[] EMPTY_DATA = new String[0];
    protected String[] data;

    public Properties() {
        this.data = EMPTY_DATA;
    }

    public Properties(String[] data) {
        this.data = data;
    }

    public Iterator<String> propertyNames() {
        if (this.data.length == 0) {
            return Iterators.emptyIterator();
        }
        return this.newNamesIter();
    }

    protected Iterator<String> newNamesIter() {
        return new NamesIter(this.data);
    }

    public String getProperty(String name) {
        int idx = this.indexOf(this.data, name);
        if (idx < 0) {
            return null;
        }
        return this.data[1 + (idx << 1)];
    }

    public void setProperty(String name, String value) {
        int idx = this.indexOf(this.data, name);
        if (idx >= 0) {
            this.data[1 + (idx << 1)] = value;
            return;
        }
        idx = ~idx << 1;
        this.grow(idx, 2);
        this.data[idx] = name;
        this.data[idx + 1] = value;
    }

    public Properties newProperties() {
        return new Properties(this.data);
    }

    protected int indexOf(String[] array, String name) {
        int begin = 0;
        int end = array.length >> 1;
        while (begin < end) {
            int middle = begin + end >> 1;
            int cmp = array[middle << 1].compareTo(name);
            if (cmp < 0) {
                begin = middle + 1;
                continue;
            }
            if (cmp > 0) {
                end = middle;
                continue;
            }
            return middle;
        }
        return ~begin;
    }

    protected void grow(int holeIdx, int holeSize) {
        String[] newData = new String[this.data.length + holeSize];
        if (holeIdx > 0) {
            System.arraycopy(this.data, 0, newData, 0, holeIdx);
        }
        if (holeIdx < this.data.length) {
            System.arraycopy(this.data, holeIdx, newData, holeIdx + holeSize, this.data.length - holeIdx);
        }
        this.data = newData;
    }

    public String toString() {
        if (this.data != null) {
            return Arrays.toString(this.data);
        }
        return super.toString();
    }

    protected static class NamesIter
    implements Iterator<String> {
        protected String[] data;
        protected int idx;

        public NamesIter(String[] data) {
            this.data = data;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.idx != this.data.length) ** GOTO lbl5
            return false;
lbl-1000:
            // 1 sources

            {
                if ((this.idx += 2) != this.data.length) continue;
                return false;
lbl5:
                // 2 sources

                ** while (this.data[this.idx + 1] == null)
            }
lbl6:
            // 1 sources

            return true;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next property name");
            }
            String name = this.data[this.idx];
            this.idx += 2;
            return name;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove property through iterator");
        }
    }
}

