/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.match;

import com.ibm.pdp.engine.turbo.core.EditableTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import com.ibm.pdp.util.ints.IntSequence;
import java.util.HashMap;
import java.util.Map;

public class TextPartitionDiffCursor
implements DiffCursor {
    protected ITextPartition reference;
    protected ITextPartition modified;
    protected DiffCursor wordsDiff;
    protected LocalDiffCursor localDiff;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected TextPartitionDiffCursor(ITextPartition referencePartition, ITextPartition modifiedPartition, DiffCursor wordsDiffCursor) {
        this.reference = referencePartition;
        this.modified = modifiedPartition;
        this.wordsDiff = wordsDiffCursor;
    }

    public ITextPartition getReferenceTextPartition() {
        return this.reference;
    }

    public ITextPartition getModifiedTextPartition() {
        return this.modified;
    }

    public CharSequence getModified() {
        return this.modified.getText();
    }

    public CharSequence getReference() {
        return this.reference.getText();
    }

    public boolean hasFoundDifference() {
        return this.localDiff != null && this.localDiff.getDifferenceNature() != DifferenceNature.Identical;
    }

    public boolean searchNextDifference() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean moveToReferenceIndex(int referenceIndex) {
        if (this.localDiff == null || !this.localDiff.includeReferenceIndex(referenceIndex)) {
            this.localDiff = this.createLocalDiffCursor(referenceIndex);
        }
        return this.localDiff.moveToReferenceIndex(referenceIndex);
    }

    public boolean moveToModifiedIndex(int modifiedIndex) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected LocalDiffCursor createLocalDiffCursor(int refIndex) {
        int refWordRank = this.reference.wordRankFromIndex(refIndex);
        if (refWordRank < 0) {
            refWordRank ^= 0xFFFFFFFF;
        }
        boolean foundWordDiff = this.wordsDiff.moveToReferenceIndex(refWordRank);
        if (refIndex > this.reference.wordBeginIndex(refWordRank) && this.wordsDiff.getReferenceEndIndex() <= refWordRank) {
            return this.createInsideWordLocalDiffCursor(refWordRank);
        }
        int refEndOfPrevWord = this.reference.wordEndIndex(this.wordsDiff.getReferenceBeginIndex() - 1);
        int refBeginOfNextWord = this.reference.wordBeginIndex(this.wordsDiff.getReferenceEndIndex());
        int modEndOfPrevWord = this.modified.wordEndIndex(this.wordsDiff.getModifiedBeginIndex() - 1);
        int modBeginOfNextWord = this.modified.wordBeginIndex(this.wordsDiff.getModifiedEndIndex());
        return foundWordDiff ? this.newMixedDiffCursor(refEndOfPrevWord, refBeginOfNextWord, modEndOfPrevWord, modBeginOfNextWord) : this.newCharsDiffCursor(refEndOfPrevWord, refBeginOfNextWord, modEndOfPrevWord, modBeginOfNextWord);
    }

    protected LocalDiffCursor createInsideWordLocalDiffCursor(int refWordRank) {
        int refWordBeginIdx = this.reference.wordBeginIndex(refWordRank);
        int refWordEndIdx = this.reference.wordEndIndex(refWordRank);
        int modWordRank = refWordRank - this.wordsDiff.getReferenceEndIndex() + this.wordsDiff.getModifiedEndIndex();
        int modWordBeginIdx = this.modified.wordBeginIndex(modWordRank);
        int modWordEndIdx = this.modified.wordEndIndex(modWordRank);
        return this.newIdenticalDiffCursor(refWordBeginIdx + 1, refWordEndIdx - 1, modWordBeginIdx + 1, modWordEndIdx - 1);
    }

    protected LocalDiffCursor newIdenticalDiffCursor(int refBeginIdx, int refEndIdx, int modBeginIdx, int modEndIdx) {
        return new IdenticalDiffCursor(refBeginIdx, refEndIdx, modBeginIdx, modEndIdx);
    }

    protected LocalDiffCursor newCharsDiffCursor(int refEndOfPrevWord, int refBeginOfNextWord, int modEndOfPrevWord, int modBeginOfNextWord) {
        if (refEndOfPrevWord == refBeginOfNextWord || modEndOfPrevWord == modBeginOfNextWord) {
            return new LocalDiffCursor(refEndOfPrevWord, refBeginOfNextWord, modEndOfPrevWord, modBeginOfNextWord);
        }
        return new CharsDiffCursor(this.reference.getTextInterval(refEndOfPrevWord, refBeginOfNextWord), refEndOfPrevWord, refBeginOfNextWord, this.modified.getTextInterval(modEndOfPrevWord, modBeginOfNextWord), modEndOfPrevWord, modBeginOfNextWord);
    }

    protected LocalDiffCursor newMixedDiffCursor(int refEndOfPreviousWord, int refBeginOfNextWord, int modEndOfPreviousWord, int modBeginOfNextWord) {
        if (refEndOfPreviousWord == refBeginOfNextWord || modEndOfPreviousWord == modBeginOfNextWord) {
            return new LocalDiffCursor(refEndOfPreviousWord, refBeginOfNextWord, modEndOfPreviousWord, modBeginOfNextWord);
        }
        WordsDictionary dic = new WordsDictionary();
        ITextPartition refMixedPartition = this.createMixedPartition(this.reference, refEndOfPreviousWord, refBeginOfNextWord, dic);
        ITextPartition modMixedPartition = this.createMixedPartition(this.modified, modEndOfPreviousWord, modBeginOfNextWord, dic);
        return new MixedDiffCursor(refMixedPartition, refEndOfPreviousWord, refBeginOfNextWord, modMixedPartition, modEndOfPreviousWord, modBeginOfNextWord);
    }

    protected ITextPartition createMixedPartition(ITextPartition partition, int beginIdx, int endIdx, WordsDictionary dic) {
        EditableTextPartition mixedPartition = new EditableTextPartition();
        mixedPartition.setText(partition.getTextInterval(beginIdx, endIdx));
        int nextWordId = dic.nextWordId;
        Map<Character, Integer> charsWords = dic.charsWords;
        Map<Integer, Integer> wordsWords = dic.wordsWords;
        int nextWordRank = partition.wordRankFromIndex(beginIdx);
        if (nextWordRank < 0) {
            nextWordRank ^= 0xFFFFFFFF;
        }
        int nextWordIdx = partition.wordBeginIndex(nextWordRank);
        int idx = beginIdx;
        while (idx < endIdx) {
            int wordEndIdx;
            Integer newWordId;
            Comparable<Character> chr;
            if (idx < nextWordIdx) {
                chr = Character.valueOf(partition.charAt(idx));
                newWordId = charsWords.get(chr);
                if (newWordId == null) {
                    newWordId = nextWordId++;
                    charsWords.put((Character)chr, newWordId);
                }
                wordEndIdx = idx + 1;
                mixedPartition.addWord(newWordId, idx - beginIdx, wordEndIdx - beginIdx);
                idx = wordEndIdx;
                continue;
            }
            chr = partition.wordIdAt(nextWordRank);
            newWordId = wordsWords.get(chr);
            if (newWordId == null) {
                newWordId = nextWordId++;
                wordsWords.put((Integer)chr, newWordId);
            }
            wordEndIdx = partition.wordEndIndex(nextWordRank);
            mixedPartition.addWord(newWordId, idx - beginIdx, wordEndIdx - beginIdx);
            nextWordIdx = partition.wordBeginIndex(++nextWordRank);
            idx = wordEndIdx;
        }
        dic.nextWordId = nextWordId;
        return mixedPartition;
    }

    public DifferenceNature getDifferenceNature() {
        return this.localDiff.getDifferenceNature();
    }

    public int getReferenceBeginIndex() {
        return this.localDiff.getReferenceBeginIndex();
    }

    public int getReferenceEndIndex() {
        return this.localDiff.getReferenceEndIndex();
    }

    public int getModifiedBeginIndex() {
        return this.localDiff.getModifiedBeginIndex();
    }

    public int getModifiedEndIndex() {
        return this.localDiff.getModifiedEndIndex();
    }

    protected static class CharsDiffCursor
    extends LocalDiffCursor {
        protected DiffCursor cursor;

        protected CharsDiffCursor(CharSequence reference, int refBeginIdx, int refEndIdx, CharSequence modified, int modBeginIdx, int modEndIdx) {
            super(refBeginIdx, refEndIdx, modBeginIdx, modEndIdx);
            this.cursor = Strings.newDiffCursor((CharSequence)reference, (CharSequence)modified);
        }

        @Override
        public boolean moveToReferenceIndex(int referenceIndex) {
            return this.cursor.moveToReferenceIndex(referenceIndex - this.referenceBeginIdx);
        }

        @Override
        public DifferenceNature getDifferenceNature() {
            return this.cursor.getDifferenceNature();
        }

        @Override
        public int getReferenceBeginIndex() {
            return this.referenceBeginIdx + this.cursor.getReferenceBeginIndex();
        }

        @Override
        public int getReferenceEndIndex() {
            return this.referenceBeginIdx + this.cursor.getReferenceEndIndex();
        }

        @Override
        public int getModifiedBeginIndex() {
            return this.modifiedBeginIdx + this.cursor.getModifiedBeginIndex();
        }

        @Override
        public int getModifiedEndIndex() {
            return this.modifiedBeginIdx + this.cursor.getModifiedEndIndex();
        }
    }

    protected static class IdenticalDiffCursor
    extends LocalDiffCursor {
        protected int refIdx;
        protected int modIdx;

        protected IdenticalDiffCursor(int refBeginIdx, int refEndIdx, int modBeginIdx, int modEndIdx) {
            super(refBeginIdx, refEndIdx, modBeginIdx, modEndIdx);
        }

        @Override
        public DifferenceNature getDifferenceNature() {
            return DifferenceNature.Identical;
        }

        @Override
        public boolean moveToReferenceIndex(int referenceIndex) {
            this.refIdx = referenceIndex;
            this.modIdx = referenceIndex - this.referenceBeginIdx + this.modifiedBeginIdx;
            if (this.modIdx > this.modifiedEndIdx) {
                this.modIdx = this.modifiedEndIdx;
            }
            return false;
        }

        @Override
        public int getReferenceBeginIndex() {
            return this.refIdx;
        }

        @Override
        public int getReferenceEndIndex() {
            return this.refIdx;
        }

        @Override
        public int getModifiedBeginIndex() {
            return this.modIdx;
        }

        @Override
        public int getModifiedEndIndex() {
            return this.modIdx;
        }
    }

    protected static class LocalDiffCursor {
        protected int referenceBeginIdx;
        protected int referenceEndIdx;
        protected int modifiedBeginIdx;
        protected int modifiedEndIdx;

        protected LocalDiffCursor(int refBeginIdx, int refEndIdx, int modBeginIdx, int modEndIdx) {
            this.referenceBeginIdx = refBeginIdx;
            this.referenceEndIdx = refEndIdx;
            this.modifiedBeginIdx = modBeginIdx;
            this.modifiedEndIdx = modEndIdx;
        }

        public boolean includeReferenceIndex(int refIdx) {
            return this.referenceBeginIdx <= refIdx && refIdx <= this.referenceEndIdx;
        }

        public boolean includeModifiedIndex(int modIdx) {
            return this.modifiedBeginIdx <= modIdx && modIdx <= this.modifiedEndIdx;
        }

        public boolean moveToReferenceIndex(int referenceIndex) {
            return this.getDifferenceNature() != DifferenceNature.Identical;
        }

        public DifferenceNature getDifferenceNature() {
            boolean nullModInterval;
            boolean nullRefInterval = this.referenceBeginIdx == this.referenceEndIdx;
            boolean bl = nullModInterval = this.modifiedBeginIdx == this.modifiedEndIdx;
            return nullRefInterval ? (nullModInterval ? DifferenceNature.Identical : DifferenceNature.Insertion) : (nullModInterval ? DifferenceNature.Deletion : DifferenceNature.Replacement);
        }

        public int getReferenceBeginIndex() {
            return this.referenceBeginIdx;
        }

        public int getReferenceEndIndex() {
            return this.referenceEndIdx;
        }

        public int getModifiedBeginIndex() {
            return this.modifiedBeginIdx;
        }

        public int getModifiedEndIndex() {
            return this.modifiedEndIdx;
        }
    }

    protected static class MixedDiffCursor
    extends LocalDiffCursor {
        protected ITextPartition reference;
        protected ITextPartition modified;
        protected DiffCursor cursor;

        protected MixedDiffCursor(ITextPartition reference, int refBeginIdx, int refEndIdx, ITextPartition modified, int modBeginIdx, int modEndIdx) {
            super(refBeginIdx, refEndIdx, modBeginIdx, modEndIdx);
            this.reference = reference;
            this.modified = modified;
            this.cursor = Ints.newDiffCursor((IntSequence)reference.getWords(), (IntSequence)modified.getWords());
        }

        @Override
        public boolean moveToReferenceIndex(int referenceIndex) {
            int refWordRank = this.reference.wordRankFromIndex(referenceIndex - this.referenceBeginIdx);
            return this.cursor.moveToReferenceIndex(refWordRank >= 0 ? refWordRank : ~refWordRank);
        }

        @Override
        public DifferenceNature getDifferenceNature() {
            return this.cursor.getDifferenceNature();
        }

        @Override
        public int getReferenceBeginIndex() {
            return this.referenceBeginIdx + this.reference.wordBeginIndex(this.cursor.getReferenceBeginIndex());
        }

        @Override
        public int getReferenceEndIndex() {
            return this.referenceBeginIdx + this.reference.wordBeginIndex(this.cursor.getReferenceEndIndex());
        }

        @Override
        public int getModifiedBeginIndex() {
            return this.modifiedBeginIdx + this.modified.wordBeginIndex(this.cursor.getModifiedBeginIndex());
        }

        @Override
        public int getModifiedEndIndex() {
            return this.modifiedBeginIdx + this.modified.wordBeginIndex(this.cursor.getModifiedEndIndex());
        }
    }

    protected static class WordsDictionary {
        protected int nextWordId;
        protected Map<Character, Integer> charsWords = new HashMap<Character, Integer>();
        protected Map<Integer, Integer> wordsWords = new HashMap<Integer, Integer>();
    }
}

